/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.util;

import com.ibm.fhir.cache.CacheManager;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.registry.FHIRRegistry;
import com.ibm.fhir.registry.resource.FHIRRegistryResource;
import com.ibm.fhir.term.config.FHIRTermConfig;
import com.ibm.fhir.term.service.FHIRTermService;
import com.ibm.fhir.term.util.CodeSystemSupport;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ValueSetSupport {
    public static final java.lang.String CODE_SET_MAP_CACHE_NAME = "com.ibm.fhir.term.util.ValueSetSupport.codeSetMapCache";
    public static final CacheManager.Configuration CODE_SET_MAP_CACHE_CONFIG = CacheManager.Configuration.of((int)1024);
    private static final Logger log = Logger.getLogger(ValueSetSupport.class.getName());
    private static final java.lang.String VERSION_UNKNOWN = "<version unknown>";

    private ValueSetSupport() {
    }

    public static ValueSet expand(ValueSet valueSet) {
        if (!ValueSetSupport.isExpanded(valueSet) && ValueSetSupport.isExpandable(valueSet)) {
            Set<Contains> result = ValueSetSupport.expand(valueSet.getCompose());
            return valueSet.toBuilder().expansion(ValueSet.Expansion.builder().total(Integer.of((java.lang.Integer)result.size())).timestamp(DateTime.now((ZoneOffset)ZoneOffset.UTC)).contains(ValueSetSupport.unwrap(result)).build()).build();
        }
        return valueSet;
    }

    public static Map<java.lang.String, Set<java.lang.String>> getCodeSetMap(ValueSet valueSet) {
        if (valueSet.getUrl() == null || valueSet.getVersion() == null || FHIRTermConfig.isCachingDisabled()) {
            return ValueSetSupport.computeCodeSetMap(valueSet);
        }
        java.lang.String url = valueSet.getUrl().getValue() + "|" + valueSet.getVersion().getValue();
        Map cacheAsMap = CacheManager.getCacheAsMap((java.lang.String)CODE_SET_MAP_CACHE_NAME, (CacheManager.Configuration)CODE_SET_MAP_CACHE_CONFIG);
        return cacheAsMap.computeIfAbsent(url, k -> ValueSetSupport.computeCodeSetMap(valueSet));
    }

    public static List<ValueSet.Expansion.Contains> getContains(ValueSet.Expansion expansion) {
        if (expansion == null) {
            return Collections.emptyList();
        }
        ArrayList<ValueSet.Expansion.Contains> result = expansion.getTotal() != null ? new ArrayList<ValueSet.Expansion.Contains>(expansion.getTotal().getValue()) : new ArrayList();
        for (ValueSet.Expansion.Contains contains : expansion.getContains()) {
            result.addAll(ValueSetSupport.getContains(contains));
        }
        return result;
    }

    public static ValueSet getValueSet(java.lang.String url) {
        return (ValueSet)FHIRRegistry.getInstance().getResource(url, ValueSet.class);
    }

    public static boolean isExpandable(ValueSet valueSet) {
        if (valueSet == null || valueSet.getCompose() == null) {
            return false;
        }
        ValueSet.Compose compose = valueSet.getCompose();
        ArrayList<ValueSet.Compose.Include> includesAndExcludes = new ArrayList<ValueSet.Compose.Include>(compose.getInclude());
        includesAndExcludes.addAll(compose.getExclude());
        for (java.lang.String codeSystemReference : ValueSetSupport.getCodeSystemReferences(includesAndExcludes)) {
            if (!ValueSetSupport.hasResource(codeSystemReference, CodeSystem.class)) {
                return false;
            }
            CodeSystem codeSystem = CodeSystemSupport.getCodeSystem(codeSystemReference);
            if (FHIRTermService.getInstance().isSupported(codeSystem)) continue;
            return false;
        }
        for (java.lang.String valueSetReference : ValueSetSupport.getValueSetReferences(includesAndExcludes)) {
            if (!ValueSetSupport.hasResource(valueSetReference, ValueSet.class)) {
                return false;
            }
            ValueSet vs = ValueSetSupport.getValueSet(valueSetReference);
            if (ValueSetSupport.isExpanded(vs) || ValueSetSupport.isExpandable(vs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isExpanded(ValueSet valueSet) {
        return valueSet != null && valueSet.getExpansion() != null;
    }

    public static boolean validateCode(ValueSet valueSet, Code code) {
        return ValueSetSupport.validateCode(ValueSetSupport.getCodeSetMap(valueSet), code);
    }

    public static boolean validateCode(ValueSet valueSet, Coding coding) {
        return ValueSetSupport.validateCode(ValueSetSupport.getCodeSetMap(valueSet), coding);
    }

    private static Contains buildContains(Uri system, String version, Code code, String display) {
        return ValueSetSupport.wrap(ValueSet.Expansion.Contains.builder().system(system).version(version).code(code).display(display).build());
    }

    private static Contains buildContains(Uri system, String version, CodeSystem.Concept concept) {
        Code code;
        Code code2 = code = concept.getCode() != null ? concept.getCode() : null;
        if (code != null) {
            return ValueSetSupport.buildContains(system, version, code, concept.getDisplay());
        }
        return null;
    }

    private static Map<java.lang.String, Set<java.lang.String>> computeCodeSetMap(ValueSet valueSet) {
        try {
            ValueSet expanded = ValueSetSupport.expand(valueSet);
            if (expanded == null || expanded.getExpansion() == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<java.lang.String, Set<java.lang.String>> codeSetMap = new LinkedHashMap<java.lang.String, Set<java.lang.String>>();
            ValueSet.Expansion expansion = expanded.getExpansion();
            for (ValueSet.Expansion.Contains contains : ValueSetSupport.getContains(expansion)) {
                java.lang.String url;
                java.lang.String code;
                java.lang.String system = contains.getSystem() != null ? contains.getSystem().getValue() : null;
                java.lang.String version = contains.getVersion() != null && contains.getVersion().getValue() != null ? contains.getVersion().getValue() : VERSION_UNKNOWN;
                java.lang.String string = code = contains.getCode() != null ? contains.getCode().getValue() : null;
                if (system == null || code == null) continue;
                java.lang.String string2 = url = !VERSION_UNKNOWN.equals(version) ? system + "|" + version : system;
                if (!CodeSystemSupport.isCaseSensitive(url)) {
                    code = CodeSystemSupport.normalize(code);
                }
                codeSetMap.computeIfAbsent(system + "|" + version, k -> new LinkedHashSet()).add(code);
            }
            return codeSetMap;
        }
        catch (Exception e) {
            java.lang.String url = valueSet.getUrl() != null ? valueSet.getUrl().getValue() : "<no url>";
            java.lang.String version = valueSet.getVersion() != null ? valueSet.getVersion().getValue() : "<no version>";
            log.log(Level.WARNING, java.lang.String.format("Unable to expand value set with url: %s and version: %s", url, version), e);
            return Collections.emptyMap();
        }
    }

    private static Set<Contains> expand(ValueSet.Compose compose) {
        if (compose == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Contains> result = new LinkedHashSet<Contains>();
        LinkedHashSet<Contains> included = new LinkedHashSet<Contains>();
        for (Object include : compose.getInclude()) {
            included.addAll(ValueSetSupport.expand((ValueSet.Compose.Include)include));
        }
        LinkedHashSet<Contains> excluded = new LinkedHashSet<Contains>();
        for (ValueSet.Compose.Include exclude : compose.getExclude()) {
            excluded.addAll(ValueSetSupport.expand(exclude));
        }
        LinkedHashSet difference = new LinkedHashSet(included);
        difference.removeAll(excluded);
        result.addAll(difference);
        return result;
    }

    private static Set<Contains> expand(ValueSet.Compose.Include includeOrExclude) {
        if (includeOrExclude == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Contains> codeSystemContains = new LinkedHashSet<Contains>();
        if (includeOrExclude.getSystem() != null) {
            String version;
            Uri system = includeOrExclude.getSystem();
            String string = version = includeOrExclude.getVersion() != null ? includeOrExclude.getVersion() : ValueSetSupport.getLatestVersion(system);
            if (!includeOrExclude.getConcept().isEmpty()) {
                for (ValueSet.Compose.Include.Concept concept : includeOrExclude.getConcept()) {
                    Code code = concept.getCode() != null ? concept.getCode() : null;
                    if (code == null) continue;
                    codeSystemContains.add(ValueSetSupport.buildContains(system, version, code, concept.getDisplay()));
                }
            } else {
                CodeSystem codeSystem;
                java.lang.String url = system.getValue();
                if (version != null) {
                    url = url + "|" + version.getValue();
                }
                if ((codeSystem = CodeSystemSupport.getCodeSystem(url)) != null) {
                    for (CodeSystem.Concept concept : FHIRTermService.getInstance().getConcepts(codeSystem, includeOrExclude.getFilter())) {
                        Contains contains = ValueSetSupport.buildContains(system, version, concept);
                        if (contains == null) continue;
                        codeSystemContains.add(contains);
                    }
                }
            }
        }
        LinkedHashSet<Contains> valueSetContains = new LinkedHashSet<Contains>();
        for (Canonical valueSet : includeOrExclude.getValueSet()) {
            java.lang.String url = valueSet.getValue();
            if (!ValueSetSupport.hasResource(url, ValueSet.class)) continue;
            valueSetContains.addAll(ValueSetSupport.wrap(ValueSetSupport.getContains(ValueSetSupport.expand(ValueSetSupport.getValueSet(url)).getExpansion())));
        }
        if (!codeSystemContains.isEmpty() && !valueSetContains.isEmpty()) {
            LinkedHashSet<Contains> intersection = new LinkedHashSet<Contains>(codeSystemContains);
            intersection.retainAll(valueSetContains);
            return intersection;
        }
        return !codeSystemContains.isEmpty() ? codeSystemContains : valueSetContains;
    }

    private static java.lang.String getCodeSystemReference(ValueSet.Compose.Include includeOrExclude) {
        if (includeOrExclude.getSystem() != null && includeOrExclude.getSystem().getValue() != null) {
            StringBuilder sb = new StringBuilder(includeOrExclude.getSystem().getValue());
            if (includeOrExclude.getVersion() != null && includeOrExclude.getVersion().getValue() != null) {
                sb.append("|").append(includeOrExclude.getVersion().getValue());
            }
            return sb.toString();
        }
        return null;
    }

    private static Set<java.lang.String> getCodeSystemReferences(List<ValueSet.Compose.Include> includesAndExcludes) {
        LinkedHashSet<java.lang.String> codeSystemReferences = new LinkedHashSet<java.lang.String>();
        for (ValueSet.Compose.Include includeOrExclude : includesAndExcludes) {
            java.lang.String codeSystemReference;
            if (!includeOrExclude.getConcept().isEmpty() || (codeSystemReference = ValueSetSupport.getCodeSystemReference(includeOrExclude)) == null) continue;
            codeSystemReferences.add(codeSystemReference);
        }
        return codeSystemReferences;
    }

    private static List<ValueSet.Expansion.Contains> getContains(ValueSet.Expansion.Contains contains) {
        if (contains == null) {
            return Collections.emptyList();
        }
        ArrayList<ValueSet.Expansion.Contains> result = new ArrayList<ValueSet.Expansion.Contains>();
        result.add(contains);
        for (ValueSet.Expansion.Contains c : contains.getContains()) {
            result.addAll(ValueSetSupport.getContains(c));
        }
        return result;
    }

    private static String getLatestVersion(Uri system) {
        java.lang.String version = FHIRRegistry.getInstance().getLatestVersion(system.getValue(), CodeSystem.class);
        return version != null && !FHIRRegistryResource.NO_VERSION.toString().equals(version) ? String.string((java.lang.String)version) : null;
    }

    private static Set<java.lang.String> getValueSetReferences(List<ValueSet.Compose.Include> includesAndExcludes) {
        LinkedHashSet<java.lang.String> valueSetReferences = new LinkedHashSet<java.lang.String>();
        for (ValueSet.Compose.Include includeOrExclude : includesAndExcludes) {
            for (Canonical canonical : includeOrExclude.getValueSet()) {
                if (canonical.getValue() == null) continue;
                valueSetReferences.add(canonical.getValue());
            }
        }
        return valueSetReferences;
    }

    private static boolean hasResource(java.lang.String url, Class<? extends Resource> resourceType) {
        return FHIRRegistry.getInstance().hasResource(url, resourceType);
    }

    private static List<ValueSet.Expansion.Contains> unwrap(Collection<Contains> wrapped) {
        ArrayList<ValueSet.Expansion.Contains> unwrapped = new ArrayList<ValueSet.Expansion.Contains>(wrapped.size());
        for (Contains contains : wrapped) {
            unwrapped.add(ValueSetSupport.unwrap(contains));
        }
        return unwrapped;
    }

    private static ValueSet.Expansion.Contains unwrap(Contains contains) {
        return contains.getContains();
    }

    private static boolean validateCode(Map<java.lang.String, Set<java.lang.String>> codeSetMap, Code code) {
        java.lang.String codeValue;
        java.lang.String string = codeValue = code != null ? code.getValue() : null;
        if (codeValue != null) {
            java.lang.String normalizedCodeValue = CodeSystemSupport.normalize(codeValue);
            for (Set<java.lang.String> codeSet : codeSetMap.values()) {
                if (!codeSet.contains(codeValue) && !codeSet.contains(normalizedCodeValue)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean validateCode(Map<java.lang.String, Set<java.lang.String>> codeSetMap, Coding coding) {
        java.lang.String system = coding.getSystem() != null ? coding.getSystem().getValue() : null;
        java.lang.String version = coding.getVersion() != null ? coding.getVersion().getValue() : null;
        java.lang.String code = coding.getCode() != null ? coding.getCode().getValue() : null;
        return ValueSetSupport.validateCode(codeSetMap, system, version, code);
    }

    private static boolean validateCode(Map<java.lang.String, Set<java.lang.String>> codeSetMap, java.lang.String system, java.lang.String version, java.lang.String code) {
        java.lang.String url;
        if (system == null || code == null) {
            return false;
        }
        java.lang.String string = url = version != null ? system + "|" + version : system;
        if (!CodeSystemSupport.isCaseSensitive(url)) {
            code = CodeSystemSupport.normalize(code);
        }
        if (version != null) {
            Set<java.lang.String> codeSet = codeSetMap.get(system + "|" + version);
            if (codeSet != null) {
                if (codeSet.contains(code)) {
                    return true;
                }
                codeSet = codeSetMap.get(system + "|" + VERSION_UNKNOWN);
                if (codeSet != null) {
                    return codeSet.contains(code);
                }
            }
        } else {
            java.lang.String prefix = system + "|";
            for (java.lang.String key : codeSetMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                return codeSetMap.get(key).contains(code);
            }
        }
        return false;
    }

    private static List<Contains> wrap(Collection<ValueSet.Expansion.Contains> unwrapped) {
        ArrayList<Contains> wrapped = new ArrayList<Contains>(unwrapped.size());
        for (ValueSet.Expansion.Contains contains : unwrapped) {
            wrapped.add(ValueSetSupport.wrap(contains));
        }
        return wrapped;
    }

    private static Contains wrap(ValueSet.Expansion.Contains contains) {
        return new Contains(contains);
    }

    private static class Contains {
        private final ValueSet.Expansion.Contains contains;
        private final int hashCode;

        public Contains(ValueSet.Expansion.Contains contains) {
            this.contains = contains;
            this.hashCode = Objects.hash(contains.getSystem(), contains.getVersion(), contains.getCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Contains other = (Contains)obj;
            return Objects.equals(this.contains.getSystem(), other.contains.getSystem()) && Objects.equals(this.contains.getVersion(), other.contains.getVersion()) && Objects.equals(this.contains.getCode(), other.contains.getCode());
        }

        public ValueSet.Expansion.Contains getContains() {
            return this.contains;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

