/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.UConverterDataReader;
import com.ibm.icu.charset.UConverterSharedData;
import com.ibm.icu.charset.UConverterStaticData;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.InvalidFormatException;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Locale;

class CharsetMBCS
extends CharsetICU {
    private byte[] fromUSubstitution = null;
    UConverterSharedData sharedData = null;
    private static final int MAX_VERSION_LENGTH = 4;
    static final int UCNV_SET_FILTER_NONE = 1;
    static final int UCNV_SET_FILTER_DBCS_ONLY = 2;
    static final int UCNV_SET_FILTER_2022_CN = 3;
    static final int UCNV_SET_FILTER_SJIS = 4;
    static final int UCNV_SET_FILTER_GR94DBCS = 5;
    static final int UCNV_SET_FILTER_HZ = 6;
    static final int UCNV_SET_FILTER_COUNT = 7;
    static final int MBCS_OPT_LENGTH_MASK = 63;
    static final int MBCS_OPT_NO_FROM_U = 64;
    static final int MBCS_OPT_INCOMPATIBLE_MASK = 65472;
    static final int MBCS_OPT_UNKNOWN_INCOMPATIBLE_MASK = 65408;
    static final int SBCS_FAST_MAX = 4095;
    static final int SBCS_FAST_LIMIT = 4096;
    static final int MBCS_FAST_MAX = 55295;
    static final int MBCS_FAST_LIMIT = 55296;
    private static final short EBCDIC_LF = 37;
    private static final short EBCDIC_NL = 21;
    private static final short EBCDIC_RT_LF = 3877;
    private static final short EBCDIC_RT_NL = 3861;
    private static final short U_LF = 10;
    private static final short U_NL = 133;
    static final int MBCS_OUTPUT_1 = 0;
    static final int MBCS_OUTPUT_2 = 1;
    static final int MBCS_OUTPUT_3 = 2;
    static final int MBCS_OUTPUT_4 = 3;
    static final int MBCS_OUTPUT_3_EUC = 8;
    static final int MBCS_OUTPUT_4_EUC = 9;
    static final int MBCS_OUTPUT_2_SISO = 12;
    static final int MBCS_OUTPUT_2_HZ = 13;
    static final int MBCS_OUTPUT_EXT_ONLY = 14;
    static final int MBCS_OUTPUT_DBCS_ONLY = 219;
    private static int LINEAR_18030_BASE = CharsetMBCS.LINEAR_18030(129, 48, 129, 48);
    private static final int[][] gb18030Ranges = new int[][]{{65536, 0x10FFFF, CharsetMBCS.LINEAR(-1875869392), CharsetMBCS.LINEAR(-483222987)}, {40870, 55295, CharsetMBCS.LINEAR(-2110419149), CharsetMBCS.LINEAR(-2093562056)}, {1106, 7742, CharsetMBCS.LINEAR(-2127506640), CharsetMBCS.LINEAR(-2127170506)}, {7744, 8207, CharsetMBCS.LINEAR(-2127170504), CharsetMBCS.LINEAR(-2127125199)}, {59493, 63787, CharsetMBCS.LINEAR(-2093559760), CharsetMBCS.LINEAR(-2077194956)}, {9795, 11904, CharsetMBCS.LINEAR(-2127058887), CharsetMBCS.LINEAR(-2126971592)}, {64042, 65071, CharsetMBCS.LINEAR(-2077189064), CharsetMBCS.LINEAR(-2077129417)}, {15585, 16469, CharsetMBCS.LINEAR(-2110663624), CharsetMBCS.LINEAR(-2110607566)}, {13851, 14615, CharsetMBCS.LINEAR(-2110740941), CharsetMBCS.LINEAR(-2110721481)}, {18872, 19574, CharsetMBCS.LINEAR(-2110480079), CharsetMBCS.LINEAR(-2110462157)}, {16736, 17206, CharsetMBCS.LINEAR(-2110600905), CharsetMBCS.LINEAR(-2110588873)}, {18318, 18758, CharsetMBCS.LINEAR(-2110527432), CharsetMBCS.LINEAR(-2110482888)}, {17623, 17995, CharsetMBCS.LINEAR(-2110545095), CharsetMBCS.LINEAR(-2110535375)}, {65510, 65535, CharsetMBCS.LINEAR(-2077121996), CharsetMBCS.LINEAR(-2077121479)}};
    private static final int MBCS_OPTION_GB18030 = 32768;
    private static final int MBCS_OPTION_KEIS = 4096;
    private static final int MBCS_OPTION_JEF = 8192;
    private static final int MBCS_OPTION_JIPS = 16384;
    private static final byte[] KEIS_SO_CHAR = new byte[]{10, 66};
    private static final byte[] KEIS_SI_CHAR = new byte[]{10, 65};
    private static final byte JEF_SO_CHAR = 40;
    private static final byte JEF_SI_CHAR = 41;
    private static final byte[] JIPS_SO_CHAR = new byte[]{26, 112};
    private static final byte[] JIPS_SI_CHAR = new byte[]{26, 113};
    static final int MBCS_MAX_STATE_COUNT = 128;
    static final int MBCS_STATE_VALID_DIRECT_16 = 0;
    static final int MBCS_STATE_VALID_DIRECT_20 = 1;
    static final int MBCS_STATE_FALLBACK_DIRECT_16 = 2;
    static final int MBCS_STATE_FALLBACK_DIRECT_20 = 3;
    static final int MBCS_STATE_VALID_16 = 4;
    static final int MBCS_STATE_VALID_16_PAIR = 5;
    static final int MBCS_STATE_UNASSIGNED = 6;
    static final int MBCS_STATE_ILLEGAL = 7;
    static final int MBCS_STATE_CHANGE_ONLY = 8;
    static final int EXT_INDEXES_LENGTH = 0;
    static final int EXT_TO_U_INDEX = 1;
    static final int EXT_TO_U_LENGTH = 2;
    static final int EXT_TO_U_UCHARS_INDEX = 3;
    static final int EXT_TO_U_UCHARS_LENGTH = 4;
    static final int EXT_FROM_U_UCHARS_INDEX = 5;
    static final int EXT_FROM_U_VALUES_INDEX = 6;
    static final int EXT_FROM_U_LENGTH = 7;
    static final int EXT_FROM_U_BYTES_INDEX = 8;
    static final int EXT_FROM_U_BYTES_LENGTH = 9;
    static final int EXT_FROM_U_STAGE_12_INDEX = 10;
    static final int EXT_FROM_U_STAGE_1_LENGTH = 11;
    static final int EXT_FROM_U_STAGE_12_LENGTH = 12;
    static final int EXT_FROM_U_STAGE_3_INDEX = 13;
    static final int EXT_FROM_U_STAGE_3_LENGTH = 14;
    static final int EXT_FROM_U_STAGE_3B_INDEX = 15;
    static final int EXT_FROM_U_STAGE_3B_LENGTH = 16;
    private static final int EXT_COUNT_BYTES = 17;
    static final int EXT_FROM_U_MAX_DIRECT_LENGTH = 3;
    private static final int TO_U_BYTE_SHIFT = 24;
    private static final int TO_U_VALUE_MASK = 0xFFFFFF;
    private static final int TO_U_MIN_CODE_POINT = 0x1F0000;
    private static final int TO_U_MAX_CODE_POINT = 0x2FFFFF;
    private static final int TO_U_ROUNDTRIP_FLAG = 0x800000;
    private static final int TO_U_INDEX_MASK = 262143;
    private static final int TO_U_LENGTH_SHIFT = 18;
    private static final int TO_U_LENGTH_OFFSET = 12;
    static final int MAX_UCHARS = 19;
    private static final int STAGE_2_LEFT_SHIFT = 2;
    private static final int FROM_U_LENGTH_SHIFT = 24;
    private static final int FROM_U_ROUNDTRIP_FLAG = Integer.MIN_VALUE;
    static final int FROM_U_RESERVED_MASK = 0x60000000;
    private static final int FROM_U_DATA_MASK = 0xFFFFFF;
    static final int FROM_U_SUBCHAR1 = -2147483647;
    private static final int FROM_U_MAX_DIRECT_LENGTH = 3;
    static final int MAX_BYTES = 31;

    public CharsetMBCS(String icuCanonicalName, String javaCanonicalName, String[] aliases, String classPath, ClassLoader loader) throws InvalidFormatException {
        super(icuCanonicalName, javaCanonicalName, aliases);
        if (icuCanonicalName.indexOf(",swaplfnl") > -1) {
            this.options = 16;
            this.icuCanonicalName = icuCanonicalName = icuCanonicalName.substring(0, icuCanonicalName.indexOf(",swaplfnl"));
        }
        this.sharedData = this.loadConverter(1, icuCanonicalName, classPath, loader);
        this.maxBytesPerChar = this.sharedData.staticData.maxBytesPerChar;
        this.minBytesPerChar = this.sharedData.staticData.minBytesPerChar;
        this.maxCharsPerByte = 1.0f;
        this.fromUSubstitution = this.sharedData.staticData.subChar;
        this.subChar = this.sharedData.staticData.subChar;
        this.subCharLen = this.sharedData.staticData.subCharLen;
        this.subChar1 = this.sharedData.staticData.subChar1;
        this.fromUSubstitution = new byte[this.sharedData.staticData.subCharLen];
        System.arraycopy(this.sharedData.staticData.subChar, 0, this.fromUSubstitution, 0, this.sharedData.staticData.subCharLen);
        this.initializeConverter(this.options);
    }

    public CharsetMBCS(String icuCanonicalName, String javaCanonicalName, String[] aliases) throws InvalidFormatException {
        this(icuCanonicalName, javaCanonicalName, aliases, "data/icudt69b", null);
    }

    private UConverterSharedData loadConverter(int nestedLoads, String myName, String classPath, ClassLoader loader) throws InvalidFormatException {
        boolean noFromU = false;
        UConverterStaticData staticData = new UConverterStaticData();
        UConverterDataReader reader = null;
        try {
            ByteBuffer b;
            InputStream i;
            String itemName = myName + '.' + "cnv";
            String resourceName = classPath + '/' + itemName;
            if (loader != null) {
                i = ICUData.getRequiredStream((ClassLoader)loader, (String)resourceName);
                b = ICUBinary.getByteBufferFromInputStreamAndCloseStream((InputStream)i);
            } else if (!classPath.equals("data/icudt69b")) {
                i = ICUData.getRequiredStream((String)resourceName);
                b = ICUBinary.getByteBufferFromInputStreamAndCloseStream((InputStream)i);
            } else {
                b = ICUBinary.getRequiredData((String)itemName);
            }
            reader = new UConverterDataReader(b);
            reader.readStaticData(staticData);
        }
        catch (IOException e) {
            throw new InvalidFormatException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidFormatException((Throwable)e);
        }
        byte type = staticData.conversionType;
        if (type != 2 || staticData.structSize != 100) {
            throw new InvalidFormatException();
        }
        UConverterSharedData data = new UConverterSharedData(staticData);
        UConverterMBCSTable mbcsTable = data.mbcs;
        MBCSHeader header = new MBCSHeader();
        try {
            reader.readMBCSHeader(header);
        }
        catch (IOException e) {
            throw new InvalidFormatException();
        }
        String baseNameString = null;
        if (header.version[0] == 5 && header.version[1] >= 3 && (header.options & 0xFF80) == 0) {
            noFromU = (header.options & 0x40) != 0;
        } else if (header.version[0] != 4) {
            throw new InvalidFormatException();
        }
        mbcsTable.outputType = (byte)header.flags;
        int offset = header.flags >>> 8;
        if (mbcsTable.outputType == 14) {
            try {
                baseNameString = reader.readBaseTableName();
                if (offset != 0) {
                    mbcsTable.extIndexes = reader.readExtIndexes(offset - reader.bytesReadAfterStaticData());
                }
            }
            catch (IOException e) {
                throw new InvalidFormatException();
            }
        }
        if (mbcsTable.outputType == 14) {
            UConverterSharedData baseSharedData = null;
            ByteBuffer extIndexes = mbcsTable.extIndexes;
            if (extIndexes == null) {
                throw new InvalidFormatException();
            }
            if (nestedLoads != 1) {
                throw new InvalidFormatException();
            }
            String baseName = baseNameString;
            if (baseName.equals(staticData.name)) {
                throw new InvalidFormatException();
            }
            baseSharedData = this.loadConverter(2, baseName, classPath, loader);
            if (baseSharedData.staticData.conversionType != 2 || baseSharedData.mbcs.baseSharedData != null) {
                throw new InvalidFormatException();
            }
            mbcsTable = data.mbcs = baseSharedData.mbcs;
            mbcsTable.baseSharedData = baseSharedData;
            mbcsTable.extIndexes = extIndexes;
            mbcsTable.swapLFNLStateTable = null;
            mbcsTable.swapLFNLFromUnicodeChars = null;
            mbcsTable.swapLFNLName = null;
            if (staticData.conversionType == 1 || staticData.conversionType == 2 && staticData.minBytesPerChar >= 2) {
                if (baseSharedData.mbcs.outputType == 12) {
                    int entry = mbcsTable.stateTable[0][14];
                    if (CharsetMBCS.MBCS_ENTRY_IS_FINAL(entry) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 8 && CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry) != 0) {
                        mbcsTable.dbcsOnlyState = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                        mbcsTable.outputType = (short)219;
                    }
                } else if (baseSharedData.staticData.conversionType == 2 && baseSharedData.staticData.minBytesPerChar == 1 && baseSharedData.staticData.maxBytesPerChar == 2 && mbcsTable.countStates <= 127) {
                    int i;
                    short count = mbcsTable.countStates;
                    int[][] newStateTable = new int[(count + 1) * 1024][256];
                    for (i = 0; i < mbcsTable.stateTable.length; ++i) {
                        System.arraycopy(mbcsTable.stateTable[i], 0, newStateTable[i], 0, mbcsTable.stateTable[i].length);
                    }
                    int[] state = newStateTable[0];
                    for (i = 0; i < 256; ++i) {
                        if (!CharsetMBCS.MBCS_ENTRY_IS_FINAL(state[i])) continue;
                        state[i] = CharsetMBCS.MBCS_ENTRY_TRANSITION(count, 0);
                    }
                    state = newStateTable[count];
                    for (i = 0; i < 256; ++i) {
                        state[i] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 7, 0);
                    }
                    mbcsTable.stateTable = newStateTable;
                    mbcsTable.countStates = (byte)(count + 1);
                    mbcsTable.stateTableOwned = true;
                    mbcsTable.outputType = (short)219;
                }
            }
        } else {
            switch (mbcsTable.outputType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 12: {
                    break;
                }
                default: {
                    throw new InvalidFormatException();
                }
            }
            mbcsTable.unicodeMask = reader.dataFormatHasUnicodeMask() ? (short)(staticData.unicodeMask & 3) : (short)3;
            try {
                reader.readMBCSTable(header, mbcsTable);
            }
            catch (IOException e) {
                throw new InvalidFormatException();
            }
            if (offset != 0) {
                try {
                    mbcsTable.extIndexes = reader.readExtIndexes(offset - reader.bytesReadAfterStaticData());
                }
                catch (IOException e) {
                    throw new InvalidFormatException();
                }
            }
            if (header.version[1] >= 3 && (mbcsTable.unicodeMask & 2) == 0 && (mbcsTable.countStates == 1 ? (char)header.version[2] >= '\u000f' : (char)header.version[2] >= '\u00d7')) {
                mbcsTable.utf8Friendly = true;
                mbcsTable.maxFastUChar = mbcsTable.countStates == 1 ? (char)4095 : (char)(header.version[2] << 8 | 0xFF);
            }
            int asciiRoundtrips = -1;
            for (int i = 0; i < 128; ++i) {
                if (mbcsTable.stateTable[0][i] == CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, i)) continue;
                asciiRoundtrips &= ~(1 << (i >> 2));
            }
            mbcsTable.asciiRoundtrips = asciiRoundtrips;
            if (noFromU) {
                int stage1Length = (mbcsTable.unicodeMask & 1) != 0 ? 1088 : 64;
                int stage2Length = (header.offsetFromUBytes - header.offsetFromUTable) / 4 - stage1Length / 2;
                CharsetMBCS.reconstituteData(mbcsTable, stage1Length, stage2Length, header.fullStage2Length);
            }
            if (mbcsTable.outputType == 219 || mbcsTable.outputType == 12) {
                mbcsTable.asciiRoundtrips = 0;
            }
        }
        mbcsTable.mbcsIndex = null;
        return data;
    }

    private static boolean writeStage3Roundtrip(UConverterMBCSTable mbcsTable, long value, int[] codePoints) {
        char[] table = mbcsTable.fromUnicodeTable;
        int[] tableInts = mbcsTable.fromUnicodeTableInts;
        byte[] bytes = mbcsTable.fromUnicodeBytes;
        char[] chars = mbcsTable.fromUnicodeChars;
        int[] ints = mbcsTable.fromUnicodeInts;
        switch (mbcsTable.outputType) {
            case 8: {
                if (value <= 65535L) break;
                if (value <= 0x8EFFFFL) {
                    value &= 0x7FFFL;
                    break;
                }
                value &= 0xFF7FL;
                break;
            }
            case 9: {
                if (value <= 0xFFFFFFL) break;
                if (value <= 0x8EFFFFFFL) {
                    value &= 0x7FFFFFL;
                    break;
                }
                value &= 0xFF7FFFL;
                break;
            }
        }
        for (int i = 0; i <= 31; ++i) {
            int c = codePoints[i];
            if (c >= 0) {
                int stage2 = table[c >> 10] + (c >> 4 & 0x3F);
                int st3 = tableInts[stage2];
                st3 = (char)(st3 * 16 + (c & 0xF));
                switch (mbcsTable.outputType) {
                    case 2: 
                    case 9: {
                        int p = st3 * 3;
                        bytes[p] = (byte)(value >> 16);
                        bytes[p + 1] = (byte)(value >> 8);
                        bytes[p + 2] = (byte)value;
                        break;
                    }
                    case 3: {
                        ints[st3] = (int)value;
                        break;
                    }
                    default: {
                        chars[st3] = (char)value;
                    }
                }
                int shift = 16 + (c & 0xF);
                int n = stage2;
                tableInts[n] = (int)((long)tableInts[n] | 1L << shift);
            }
            ++value;
        }
        return true;
    }

    private static void reconstituteData(UConverterMBCSTable mbcsTable, int stage1Length, int stage2Length, int fullStage2Length) {
        char[] stage1 = mbcsTable.fromUnicodeTable;
        int numStage1Ints = stage1Length / 2;
        int[] stage2 = new int[numStage1Ints + fullStage2Length];
        System.arraycopy(mbcsTable.fromUnicodeTableInts, numStage1Ints, stage2, fullStage2Length - stage2Length + numStage1Ints, stage2Length);
        mbcsTable.fromUnicodeTableInts = stage2;
        int stageUTF8Length = mbcsTable.maxFastUChar + '\u0001' >> 6;
        int stageUTF8Index = 0;
        int st1 = 0;
        while (stageUTF8Index < stageUTF8Length) {
            int st2 = stage1[st1];
            if (st2 != stage1Length / 2) {
                for (int i = 0; i < 16; ++i) {
                    int st3;
                    if ((st3 = mbcsTable.mbcsIndex.get(stageUTF8Index++)) != 0) {
                        st3 >>= 4;
                        stage2[st2++] = st3++;
                        stage2[st2++] = st3++;
                        stage2[st2++] = st3++;
                        stage2[st2++] = st3;
                        continue;
                    }
                    st2 += 4;
                }
            } else {
                stageUTF8Index += 16;
            }
            ++st1;
        }
        switch (mbcsTable.outputType) {
            case 1: 
            case 8: 
            case 12: {
                mbcsTable.fromUnicodeChars = new char[mbcsTable.fromUBytesLength / 2];
                break;
            }
            case 2: 
            case 9: {
                mbcsTable.fromUnicodeBytes = new byte[mbcsTable.fromUBytesLength];
                break;
            }
            case 3: {
                mbcsTable.fromUnicodeInts = new int[mbcsTable.fromUBytesLength / 4];
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        CharsetMBCS.MBCSEnumToUnicode(mbcsTable);
    }

    private static void MBCSEnumToUnicode(UConverterMBCSTable mbcsTable) {
        byte[] stateProps = new byte[128];
        CharsetMBCS.getStateProp(mbcsTable.stateTable, stateProps, 0);
        for (int state = 0; state < mbcsTable.countStates; ++state) {
            if (stateProps[state] < 64) continue;
            CharsetMBCS.enumToU(mbcsTable, stateProps, state, 0, 0);
        }
    }

    private static boolean enumToU(UConverterMBCSTable mbcsTable, byte[] stateProps, int state, int offset, int value) {
        int[] codePoints = new int[32];
        int[] row = mbcsTable.stateTable[state];
        char[] unicodeCodeUnits = mbcsTable.unicodeCodeUnits;
        value <<= 8;
        int anyCodePoints = -1;
        int b = (stateProps[state] & 0x38) << 2;
        if (b == 0 && stateProps[state] >= 64) {
            codePoints[0] = -1;
            b = 1;
        }
        int limit = (stateProps[state] & 7) + 1 << 5;
        while (b < limit) {
            int entry = row[b];
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry)) {
                int nextState = CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                if (stateProps[nextState] >= 0 && !CharsetMBCS.enumToU(mbcsTable, stateProps, nextState, offset + CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry), value | b)) {
                    return false;
                }
                codePoints[b & 0x1F] = -1;
            } else {
                int finalOffset;
                int c;
                int action = CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                if (action == 0) {
                    c = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                } else if (action == 4) {
                    finalOffset = offset + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                    c = unicodeCodeUnits[finalOffset];
                    if (c >= 65534) {
                        c = -1;
                    }
                } else if (action == 5) {
                    finalOffset = offset + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                    if ((c = unicodeCodeUnits[finalOffset++]) >= 55296) {
                        c = c <= 56319 ? ((c & 0x3FF) << 10) + unicodeCodeUnits[finalOffset] + 9216 : (c == 57344 ? unicodeCodeUnits[finalOffset] : -1);
                    }
                } else {
                    c = action == 1 ? CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry) + 65536 : -1;
                }
                codePoints[b & 0x1F] = c;
                anyCodePoints &= c;
            }
            if ((++b & 0x1F) != 0 || anyCodePoints < 0) continue;
            if (!CharsetMBCS.writeStage3Roundtrip(mbcsTable, value | b - 32, codePoints)) {
                return false;
            }
            anyCodePoints = -1;
        }
        return true;
    }

    private static byte getStateProp(int[][] stateTable, byte[] stateProps, int state) {
        int max;
        int entry;
        int nextState;
        int[] row = stateTable[state];
        stateProps[state] = 0;
        int min = 0;
        while (true) {
            if (stateProps[nextState = CharsetMBCS.MBCS_ENTRY_STATE(entry = row[min])] == -1) {
                CharsetMBCS.getStateProp(stateTable, stateProps, nextState);
            }
            if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry) ? CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) < 6 : stateProps[nextState] > 0) break;
            if (min == 255) {
                stateProps[state] = -64;
                return stateProps[state];
            }
            ++min;
        }
        int n = state;
        stateProps[n] = (byte)(stateProps[n] | (byte)(min >> 5 << 3));
        for (max = 255; min < max; --max) {
            entry = row[max];
            nextState = CharsetMBCS.MBCS_ENTRY_STATE(entry);
            if (stateProps[nextState] == -1) {
                CharsetMBCS.getStateProp(stateTable, stateProps, nextState);
            }
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry) ? stateProps[nextState] > 0 : CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) < 6) break;
        }
        int n2 = state;
        stateProps[n2] = (byte)(stateProps[n2] | (byte)(max >> 5));
        while (min <= max) {
            entry = row[min];
            nextState = CharsetMBCS.MBCS_ENTRY_STATE(entry);
            if (stateProps[nextState] == -1) {
                CharsetMBCS.getStateProp(stateTable, stateProps, nextState);
            }
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry)) {
                int n3 = nextState;
                stateProps[n3] = (byte)(stateProps[n3] | 0x40);
                if (CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) <= 3) {
                    int n4 = state;
                    stateProps[n4] = (byte)(stateProps[n4] | 0x40);
                }
            }
            ++min;
        }
        return stateProps[state];
    }

    protected void initializeConverter(int myOptions) {
        ByteBuffer extIndexes;
        String lowerCaseName;
        UConverterMBCSTable mbcsTable = this.sharedData.mbcs;
        short outputType = mbcsTable.outputType;
        if (outputType == 219) {
            this.options = myOptions &= 0xFFFFFFEF;
        }
        if ((myOptions & 0x10) != 0) {
            boolean isCached;
            boolean bl = isCached = mbcsTable.swapLFNLStateTable != null;
            if (!isCached) {
                try {
                    if (!this.EBCDICSwapLFNL()) {
                        this.options = myOptions & 0xFFFFFFEF;
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        if ((lowerCaseName = this.icuCanonicalName.toLowerCase(Locale.ENGLISH)).indexOf("gb18030") >= 0) {
            this.options |= 0x8000;
        } else if (lowerCaseName.indexOf("keis") >= 0) {
            this.options |= 0x1000;
        } else if (lowerCaseName.indexOf("jef") >= 0) {
            this.options |= 0x2000;
        } else if (lowerCaseName.indexOf("jips") >= 0) {
            this.options |= 0x4000;
        }
        if (outputType == 12) {
            this.maxBytesPerChar = 4;
        }
        if ((extIndexes = mbcsTable.extIndexes) != null) {
            byte maxBytesPerUChar = (byte)CharsetMBCS.GET_MAX_BYTES_PER_UCHAR(extIndexes);
            if (outputType == 12) {
                maxBytesPerUChar = (byte)(maxBytesPerUChar + 1);
            }
            if (maxBytesPerUChar > this.maxBytesPerChar) {
                this.maxBytesPerChar = maxBytesPerUChar;
            }
        }
    }

    private boolean EBCDICSwapLFNL() throws Exception {
        int stage2Entry;
        char[] chars;
        UConverterMBCSTable mbcsTable = this.sharedData.mbcs;
        char[] table = mbcsTable.fromUnicodeTable;
        int[] tableInts = this.sharedData.mbcs.fromUnicodeTableInts;
        char[] results = chars = mbcsTable.fromUnicodeChars;
        if (mbcsTable.outputType != 0 && mbcsTable.outputType != 12 || mbcsTable.stateTable[0][37] != CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 10) || mbcsTable.stateTable[0][21] != CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 133)) {
            return false;
        }
        if (mbcsTable.outputType == 0) {
            if ('\u0f25' != CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, 10) || '\u0f15' != CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, 133)) {
                return false;
            }
        } else {
            stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, 10);
            if (!CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, 10) || '%' != CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(chars, stage2Entry, 10)) {
                return false;
            }
            stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, 133);
            if (!CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, 133) || '\u0015' != CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(chars, stage2Entry, 133)) {
                return false;
            }
        }
        if (mbcsTable.fromUBytesLength <= 0) {
            throw new Exception("U_INVALID_FORMAT_ERROR");
        }
        int[][] newStateTable = new int[mbcsTable.stateTable.length][mbcsTable.stateTable[0].length];
        for (int i = 0; i < newStateTable.length; ++i) {
            System.arraycopy(mbcsTable.stateTable[i], 0, newStateTable[i], 0, newStateTable[i].length);
        }
        newStateTable[0][37] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 133);
        newStateTable[0][21] = CharsetMBCS.MBCS_ENTRY_FINAL(0, 0, 10);
        char[] newResults = new char[chars.length];
        System.arraycopy(chars, 0, newResults, 0, chars.length);
        if (mbcsTable.outputType == 0) {
            CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U_SET(table, newResults, 10, 3861);
            CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U_SET(table, newResults, 133, 3877);
        } else {
            stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, 10);
            CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2_SET(newResults, stage2Entry, 10, 21);
            stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, 133);
            CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2_SET(newResults, stage2Entry, 133, 37);
        }
        String newName = this.icuCanonicalName.concat(",swaplfnl");
        if (mbcsTable.swapLFNLStateTable == null) {
            mbcsTable.swapLFNLStateTable = newStateTable;
            mbcsTable.swapLFNLFromUnicodeChars = newResults;
            mbcsTable.swapLFNLName = newName;
        }
        return true;
    }

    private static int LINEAR_18030(int a, int b, int c, int d) {
        return (((a & 0xFF) * 10 + (b & 0xFF)) * 126 + (c & 0xFF)) * 10 + (d & 0xFF);
    }

    private static int LINEAR(int x) {
        return CharsetMBCS.LINEAR_18030(x >>> 24, x >>> 16 & 0xFF, x >>> 8 & 0xFF, x & 0xFF);
    }

    private static int getSISOBytes(SISO_Option option, int cnvOption, byte[] value) {
        int SISOLength = 0;
        switch (option) {
            case SI: {
                if ((cnvOption & 0x1000) != 0) {
                    value[0] = KEIS_SI_CHAR[0];
                    value[1] = KEIS_SI_CHAR[1];
                    SISOLength = 2;
                    break;
                }
                if ((cnvOption & 0x2000) != 0) {
                    value[0] = 41;
                    SISOLength = 1;
                    break;
                }
                if ((cnvOption & 0x4000) != 0) {
                    value[0] = JIPS_SI_CHAR[0];
                    value[1] = JIPS_SI_CHAR[1];
                    SISOLength = 2;
                    break;
                }
                value[0] = 15;
                SISOLength = 1;
                break;
            }
            case SO: {
                if ((cnvOption & 0x1000) != 0) {
                    value[0] = KEIS_SO_CHAR[0];
                    value[1] = KEIS_SO_CHAR[1];
                    SISOLength = 2;
                    break;
                }
                if ((cnvOption & 0x2000) != 0) {
                    value[0] = 40;
                    SISOLength = 1;
                    break;
                }
                if ((cnvOption & 0x4000) != 0) {
                    value[0] = JIPS_SO_CHAR[0];
                    value[1] = JIPS_SO_CHAR[1];
                    SISOLength = 2;
                    break;
                }
                value[0] = 14;
                SISOLength = 1;
                break;
            }
        }
        return SISOLength;
    }

    static int MBCS_ENTRY_SET_STATE(int entry, int state) {
        return entry & 0x80FFFFFF | state << 24;
    }

    static int MBCS_ENTRY_STATE(int entry) {
        return entry >> 24 & 0x7F;
    }

    static int MBCS_ENTRY_TRANSITION(int state, int offset) {
        return state << 24 | offset;
    }

    static int MBCS_ENTRY_FINAL(int state, int action, int value) {
        return Integer.MIN_VALUE | state << 24 | action << 20 | value;
    }

    static boolean MBCS_ENTRY_IS_TRANSITION(int entry) {
        return entry >= 0;
    }

    static boolean MBCS_ENTRY_IS_FINAL(int entry) {
        return entry < 0;
    }

    static int MBCS_ENTRY_TRANSITION_STATE(int entry) {
        return entry >>> 24;
    }

    static int MBCS_ENTRY_TRANSITION_OFFSET(int entry) {
        return entry & 0xFFFFFF;
    }

    static int MBCS_ENTRY_FINAL_STATE(int entry) {
        return entry >>> 24 & 0x7F;
    }

    static boolean MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(int entry) {
        return entry < -2146435072;
    }

    static int MBCS_ENTRY_FINAL_ACTION(int entry) {
        return entry >>> 20 & 0xF;
    }

    static int MBCS_ENTRY_FINAL_VALUE(int entry) {
        return entry & 0xFFFFF;
    }

    static char MBCS_ENTRY_FINAL_VALUE_16(int entry) {
        return (char)entry;
    }

    static boolean MBCS_IS_ASCII_ROUNDTRIP(int b, long asciiRoundtrips) {
        return (asciiRoundtrips & (long)(1 << (b >> 2))) != 0L;
    }

    static char MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(UConverterMBCSTable mbcs, int b) {
        assert (0 <= b && b <= 255);
        return CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(mbcs.stateTable[0][b]);
    }

    static char MBCS_SINGLE_RESULT_FROM_U(char[] table, char[] results, int c) {
        int i1 = table[c >>> 10] + (c >>> 4 & 0x3F);
        int i = table[i1] + (c & 0xF);
        return results[i];
    }

    static void MBCS_SINGLE_RESULT_FROM_U_SET(char[] table, char[] results, int c, int newValue) {
        int i1 = table[c >>> 10] + (c >>> 4 & 0x3F);
        int i = table[i1] + (c & 0xF);
        results[i] = (char)newValue;
    }

    static int MBCS_STAGE_2_FROM_U(char[] table, int[] tableInts, int c) {
        int i = table[c >>> 10] + (c >>> 4 & 0x3F);
        return tableInts[i];
    }

    private static boolean MBCS_FROM_U_IS_ROUNDTRIP(int stage2Entry, int c) {
        return (stage2Entry & 1 << 16 + (c & 0xF)) != 0;
    }

    static char MBCS_VALUE_2_FROM_STAGE_2(char[] chars, int stage2Entry, int c) {
        int i = 16 * (stage2Entry & 0xFFFF) + (c & 0xF);
        return chars[i];
    }

    static void MBCS_VALUE_2_FROM_STAGE_2_SET(char[] chars, int stage2Entry, int c, int newValue) {
        int i = 16 * (stage2Entry & 0xFFFF) + (c & 0xF);
        chars[i] = (char)newValue;
    }

    private static int MBCS_VALUE_4_FROM_STAGE_2(int[] ints, int stage2Entry, int c) {
        int i = 16 * (stage2Entry & 0xFFFF) + (c & 0xF);
        return ints[i];
    }

    static int MBCS_POINTER_3_FROM_STAGE_2(byte[] bytes, int stage2Entry, int c) {
        return (16 * (stage2Entry & 0xFFFF) + (c & 0xF)) * 3;
    }

    static int TO_U_GET_BYTE(int word) {
        return word >>> 24;
    }

    static int TO_U_GET_VALUE(int word) {
        return word & 0xFFFFFF;
    }

    static boolean TO_U_IS_ROUNDTRIP(int value) {
        return (value & 0x800000) != 0;
    }

    static boolean TO_U_IS_PARTIAL(int value) {
        return 0 <= value && value < 0x1F0000;
    }

    static int TO_U_GET_PARTIAL_INDEX(int value) {
        return value;
    }

    static int TO_U_MASK_ROUNDTRIP(int value) {
        return value & 0xFF7FFFFF;
    }

    private static int TO_U_MAKE_WORD(byte b, int value) {
        return b << 24 | value;
    }

    static boolean TO_U_IS_CODE_POINT(int value) {
        assert (value >= 0);
        return value <= 0x2FFFFF;
    }

    static int TO_U_GET_CODE_POINT(int value) {
        assert (value >= 0);
        return value - 0x1F0000;
    }

    private static int TO_U_GET_INDEX(int value) {
        return value & 0x3FFFF;
    }

    private static int TO_U_GET_LENGTH(int value) {
        return (value >>> 18) - 12;
    }

    static int FROM_U(CharBuffer stage12, CharBuffer stage3, int s1Index, int c) {
        return stage3.get((stage12.get(stage12.get(s1Index) + (c >>> 4 & 0x3F)) << 2) + (c & 0xF));
    }

    static boolean FROM_U_IS_PARTIAL(int value) {
        return value >>> 24 == 0;
    }

    static int FROM_U_GET_PARTIAL_INDEX(int value) {
        return value;
    }

    static boolean FROM_U_IS_ROUNDTRIP(int value) {
        return (value & Integer.MIN_VALUE) != 0;
    }

    private static int FROM_U_MASK_ROUNDTRIP(int value) {
        return value & Integer.MAX_VALUE;
    }

    static int FROM_U_GET_LENGTH(int value) {
        return value >>> 24 & 0x1F;
    }

    static int FROM_U_GET_DATA(int value) {
        return value & 0xFFFFFF;
    }

    static Buffer ARRAY(ByteBuffer indexes, int index, Class<?> itemType) {
        int oldpos = indexes.position();
        indexes.position(indexes.getInt(index << 2));
        Buffer b = itemType == Integer.TYPE ? indexes.asIntBuffer() : (itemType == Character.TYPE ? indexes.asCharBuffer() : (itemType == Short.TYPE ? indexes.asShortBuffer() : indexes.slice()));
        indexes.position(oldpos);
        return b;
    }

    private static int GET_MAX_BYTES_PER_UCHAR(ByteBuffer indexes) {
        indexes.position(0);
        return indexes.getInt(17) & 0xFF;
    }

    static int findFromU(CharBuffer fromUSection, int length, char u) {
        int i;
        int start = 0;
        int limit = length;
        while ((i = limit - start) > 1) {
            if (i <= 4) {
                if (u <= fromUSection.get(fromUSection.position() + start) || ++start < limit && u <= fromUSection.get(fromUSection.position() + start) || ++start < limit && u <= fromUSection.get(fromUSection.position() + start)) break;
                ++start;
                break;
            }
            i = (start + limit) / 2;
            if (u < fromUSection.get(fromUSection.position() + i)) {
                limit = i;
                continue;
            }
            start = i;
        }
        if (start < limit && u == fromUSection.get(fromUSection.position() + start)) {
            return start;
        }
        return -1;
    }

    static int findToU(IntBuffer toUSection, int length, short byt) {
        int i;
        int start = CharsetMBCS.TO_U_GET_BYTE(toUSection.get(toUSection.position()));
        int limit = CharsetMBCS.TO_U_GET_BYTE(toUSection.get(toUSection.position() + length - 1));
        if (byt < start || limit < byt) {
            return 0;
        }
        if (length == limit - start + 1) {
            return CharsetMBCS.TO_U_GET_VALUE(toUSection.get(toUSection.position() + byt - start));
        }
        long word0 = (long)CharsetMBCS.TO_U_MAKE_WORD((byte)byt, 0) & 0xFFFFFFFFL;
        long word = word0 | 0xFFFFFFL;
        start = 0;
        limit = length;
        while ((i = limit - start) > 1) {
            if (i <= 4) {
                if (word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL) || ++start < limit && word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL) || ++start < limit && word0 <= ((long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL)) break;
                ++start;
                break;
            }
            i = (start + limit) / 2;
            if (word < ((long)toUSection.get(toUSection.position() + i) & 0xFFFFFFFFL)) {
                limit = i;
                continue;
            }
            start = i;
        }
        if (start < limit && byt == CharsetMBCS.TO_U_GET_BYTE((int)(word = (long)toUSection.get(toUSection.position() + start) & 0xFFFFFFFFL))) {
            return CharsetMBCS.TO_U_GET_VALUE((int)word);
        }
        return 0;
    }

    static boolean TO_U_VERIFY_SISO_MATCH(byte sisoState, int match) {
        return sisoState < 0 || sisoState == 0 == (match == 1);
    }

    private static int SISO_STATE(UConverterSharedData sharedData, int mode) {
        return sharedData.mbcs.outputType == 12 ? (byte)mode : (sharedData.mbcs.outputType == 219 ? (byte)1 : (byte)-1);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderMBCS(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderMBCS(this);
    }

    void MBCSGetFilteredUnicodeSetForUnicode(UConverterSharedData data, UnicodeSet setFillIn, int which, int filter) {
        UConverterMBCSTable mbcsTable = data.mbcs;
        char[] table = mbcsTable.fromUnicodeTable;
        char maxStage1 = mbcsTable.hasSupplementary() ? (char)'\u0440' : '@';
        int c = 0;
        if (mbcsTable.outputType == 0) {
            char[] results = mbcsTable.fromUnicodeChars;
            char minValue = which == 0 ? (char)'\u0f00' : '\u0800';
            for (char st1 = '\u0000'; st1 < maxStage1; st1 = (char)(st1 + '\u0001')) {
                char st2 = table[st1];
                if (st2 > maxStage1) {
                    char stage2 = st2;
                    for (st2 = '\u0000'; st2 < '@'; st2 = (char)(st2 + '\u0001')) {
                        char st3 = table[stage2 + st2];
                        if (st3 != '\u0000') {
                            char stage3 = st3;
                            do {
                                char c2 = stage3;
                                stage3 = (char)(stage3 + '\u0001');
                                if (results[c2] < minValue) continue;
                                setFillIn.add(c);
                            } while ((++c & 0xF) != 0);
                            continue;
                        }
                        c += 16;
                    }
                    continue;
                }
                c += 1024;
            }
        } else {
            int st3Multiplier;
            int[] tableInts = mbcsTable.fromUnicodeTableInts;
            byte[] bytes = mbcsTable.fromUnicodeBytes;
            char[] chars = mbcsTable.fromUnicodeChars;
            int[] ints = mbcsTable.fromUnicodeInts;
            boolean useFallBack = which == 1;
            switch (mbcsTable.outputType) {
                case 2: 
                case 9: {
                    st3Multiplier = 3;
                    break;
                }
                case 3: {
                    st3Multiplier = 4;
                    break;
                }
                default: {
                    st3Multiplier = 2;
                }
            }
            for (char st1 = '\u0000'; st1 < maxStage1; st1 = (char)(st1 + '\u0001')) {
                char st2 = table[st1];
                if (st2 > maxStage1 >> 1) {
                    char stage2 = st2;
                    block21: for (st2 = '\u0000'; st2 < '@'; st2 = (char)(st2 + '\u0001')) {
                        int st3 = tableInts[stage2 + st2];
                        if (st3 != 0) {
                            int stage3 = st3Multiplier * 16 * (st3 & 0xFFFF);
                            st3 >>>= 16;
                            switch (filter) {
                                case 1: {
                                    do {
                                        if ((st3 & 1) != 0) {
                                            setFillIn.add(c);
                                        } else if (useFallBack) {
                                            int b = 0;
                                            switch (st3Multiplier) {
                                                case 4: {
                                                    b = ints[stage3 / 4];
                                                    break;
                                                }
                                                case 3: {
                                                    b |= bytes[stage3] | bytes[stage3 + 1] | bytes[stage3 + 2];
                                                    break;
                                                }
                                                case 2: {
                                                    b = chars[stage3 / 2];
                                                    break;
                                                }
                                            }
                                            stage3 += st3Multiplier;
                                            if (b != 0) {
                                                setFillIn.add(c);
                                            }
                                        }
                                        st3 >>= 1;
                                    } while ((++c & 0xF) != 0);
                                    continue block21;
                                }
                                case 2: {
                                    do {
                                        if (((st3 & 1) != 0 || useFallBack) && chars[stage3 / 2] >= '\u0100') {
                                            setFillIn.add(c);
                                        }
                                        st3 >>= 1;
                                        stage3 += 2;
                                    } while ((++c & 0xF) != 0);
                                    continue block21;
                                }
                                case 3: {
                                    int value;
                                    do {
                                        if (!((st3 & 1) == 0 && !useFallBack || (value = 0xFF & bytes[stage3]) != 129 && value != 130)) {
                                            setFillIn.add(c);
                                        }
                                        st3 >>= 1;
                                        stage3 += 3;
                                    } while ((++c & 0xF) != 0);
                                    continue block21;
                                }
                                case 4: {
                                    int value;
                                    do {
                                        if (((st3 & 1) != 0 || useFallBack) && (value = chars[stage3 / 2]) >= 33088 && value <= 61436) {
                                            setFillIn.add(c);
                                        }
                                        st3 >>= 1;
                                        stage3 += 2;
                                    } while ((++c & 0xF) != 0);
                                    continue block21;
                                }
                                case 5: {
                                    int value;
                                    do {
                                        if (((st3 & 1) != 0 || useFallBack) && (0xFFFF & (value = chars[stage3 / 2]) - 41377) <= 23901 && (0xFF & value - 161) <= 93) {
                                            setFillIn.add(c);
                                        }
                                        st3 >>= 1;
                                        stage3 += 2;
                                    } while ((++c & 0xF) != 0);
                                    continue block21;
                                }
                                case 6: {
                                    int value;
                                    do {
                                        if (((st3 & 1) != 0 || useFallBack) && (0xFFFF & (value = chars[stage3 / 2]) - 41377) <= 23645 && (0xFF & value - 161) <= 93) {
                                            setFillIn.add(c);
                                        }
                                        st3 >>= 1;
                                        stage3 += 2;
                                    } while ((++c & 0xF) != 0);
                                    continue block21;
                                }
                                default: {
                                    return;
                                }
                            }
                        }
                        c += 16;
                    }
                    continue;
                }
                c += 1024;
            }
        }
        CharsetMBCS.extGetUnicodeSet(setFillIn, which, filter, data);
    }

    static void extGetUnicodeSetString(ByteBuffer cx, UnicodeSet setFillIn, boolean useFallback, int minLength, int c, char[] s, int length, int sectionIndex) {
        StringBuilder normalizedStringBuilder;
        int value;
        CharBuffer fromUSectionUChar = (CharBuffer)CharsetMBCS.ARRAY(cx, 5, Character.TYPE);
        IntBuffer fromUSectionValues = (IntBuffer)CharsetMBCS.ARRAY(cx, 6, Integer.TYPE);
        int fromUSectionUCharIndex = fromUSectionUChar.position() + sectionIndex;
        int fromUSectionValuesIndex = fromUSectionValues.position() + sectionIndex;
        int count = fromUSectionUChar.get(fromUSectionUCharIndex++);
        if ((value = fromUSectionValues.get(fromUSectionValuesIndex++)) != 0 && (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || useFallback) && CharsetMBCS.FROM_U_GET_LENGTH(value) >= minLength) {
            if (c >= 0) {
                setFillIn.add(c);
            } else {
                normalizedStringBuilder = new StringBuilder();
                for (int j = 0; j < length; ++j) {
                    normalizedStringBuilder.append(s[j]);
                }
                String normalizedString = normalizedStringBuilder.toString();
                for (int j = 0; j < length; ++j) {
                    setFillIn.add((CharSequence)normalizedString);
                }
            }
        }
        for (int i = 0; i < count; ++i) {
            s[length] = fromUSectionUChar.get(fromUSectionUCharIndex + i);
            value = fromUSectionValues.get(fromUSectionValuesIndex + i);
            if (value == 0) continue;
            if (CharsetMBCS.FROM_U_IS_PARTIAL(value)) {
                CharsetMBCS.extGetUnicodeSetString(cx, setFillIn, useFallback, minLength, -1, s, length + 1, CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(value));
                continue;
            }
            if (!(useFallback ? (value & 0x60000000) == 0 : (value & 0xE0000000) == Integer.MIN_VALUE) || CharsetMBCS.FROM_U_GET_LENGTH(value) < minLength) continue;
            normalizedStringBuilder = new StringBuilder();
            for (int j = 0; j < length + 1; ++j) {
                normalizedStringBuilder.append(s[j]);
            }
            setFillIn.add((CharSequence)normalizedStringBuilder.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    static void extGetUnicodeSet(UnicodeSet setFillIn, int which, int filter, UConverterSharedData Data) {
        s = new char[19];
        cx = Data.mbcs.extIndexes;
        if (cx == null) {
            return;
        }
        stage12 = (CharBuffer)CharsetMBCS.ARRAY(cx, 10, Character.TYPE);
        stage3 = (CharBuffer)CharsetMBCS.ARRAY(cx, 13, Character.TYPE);
        stage3b = (IntBuffer)CharsetMBCS.ARRAY(cx, 15, Integer.TYPE);
        stage1Length = cx.asIntBuffer().get(11);
        useFallback = which == 1;
        c = 0;
        minLength = filter == 3 ? 3 : (Data.mbcs.outputType == 219 || filter != 1 ? 2 : 1);
        for (st1 = 0; st1 < stage1Length; ++st1) {
            block14: {
                st2 = stage12.get(st1);
                if (st2 <= stage1Length) break block14;
                ps2 = st2;
                for (st2 = 0; st2 < 64; ++st2) {
                    block15: {
                        st3 = stage12.get(ps2 + st2) << 2;
                        if (st3 == 0) break block15;
                        ps3 = st3;
                        block8: do {
                            if ((value = stage3b.get(stage3.get(ps3++))) == 0) continue;
                            if (CharsetMBCS.FROM_U_IS_PARTIAL(value)) {
                                length = 0;
                                length = UTF16.append((char[])s, (int)length, (int)c);
                                CharsetMBCS.extGetUnicodeSetString(cx, setFillIn, useFallback, minLength, c, s, length, CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(value));
                                continue;
                            }
                            if (!(useFallback != false ? (value & 0x60000000) == 0 : (value & -536870912) == -2147483648) || CharsetMBCS.FROM_U_GET_LENGTH(value) < minLength) continue;
                            switch (filter) {
                                case 3: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(value) != 3 || CharsetMBCS.FROM_U_GET_DATA(value) > 0x82FFFF) {
                                        break;
                                    }
                                    ** GOTO lbl43
                                }
                                case 4: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(value) != 2 || (value = CharsetMBCS.FROM_U_GET_DATA(value)) < 33088 || value > 61436) {
                                        break;
                                    }
                                    ** GOTO lbl43
                                }
                                case 5: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(value) != 2 || (value = CharsetMBCS.FROM_U_GET_DATA(value)) - 41377 > 23901 || (255 & value - 161) > 93) {
                                        break;
                                    }
                                    ** GOTO lbl43
                                }
                                case 6: {
                                    if (CharsetMBCS.FROM_U_GET_LENGTH(value) != 2 || (value = CharsetMBCS.FROM_U_GET_DATA(value)) - 41377 > 23645 || (255 & value - 161) > 93) continue block8;
                                }
lbl43:
                                // 5 sources

                                default: {
                                    setFillIn.add(c);
                                }
                            }
                        } while ((++c & 15) != 0);
                        continue;
                    }
                    c += 16;
                }
                continue;
            }
            c += 1024;
        }
    }

    void MBCSGetUnicodeSetForUnicode(UConverterSharedData data, UnicodeSet setFillIn, int which) {
        this.MBCSGetFilteredUnicodeSetForUnicode(data, setFillIn, which, this.sharedData.mbcs.outputType == 219 ? 2 : 1);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        if ((this.options & 0x8000) != 0) {
            setFillIn.add(0, 55295);
            setFillIn.add(57344, 0x10FFFF);
        } else {
            this.MBCSGetUnicodeSetForUnicode(this.sharedData, setFillIn, which);
        }
    }

    class CharsetEncoderMBCS
    extends CharsetEncoderICU {
        private boolean allowReplacementChanges;

        CharsetEncoderMBCS(CharsetICU cs) {
            super(cs, CharsetMBCS.this.fromUSubstitution);
            this.allowReplacementChanges = false;
            this.allowReplacementChanges = true;
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.preFromUFirstCP = -1;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int stage2Entry = 0;
            int value = 0;
            int length = 0;
            byte[] si_value = new byte[2];
            byte[] so_value = new byte[2];
            int si_value_length = 0;
            int so_value_length = 0;
            boolean gotoUnassigned = false;
            try {
                SideEffects x;
                int prevLength;
                if (!flush && this.preFromUFirstCP >= 0) {
                    cr[0] = this.continueMatchFromU(source, target, offsets, flush, -1);
                    if (cr[0].isError()) return cr[0];
                    if (this.preFromULength < 0) {
                        return cr[0];
                    }
                }
                short outputType = CharsetMBCS.this.sharedData.mbcs.outputType;
                short uniMask = CharsetMBCS.this.sharedData.mbcs.unicodeMask;
                if (outputType == 0 && (uniMask & 2) == 0) {
                    if ((uniMask & 1) == 0) {
                        cr[0] = this.cnvMBCSSingleFromBMPWithOffsets(source, target, offsets, flush);
                        return cr[0];
                    }
                    cr[0] = this.cnvMBCSSingleFromUnicodeWithOffsets(source, target, offsets, flush);
                    return cr[0];
                }
                if (outputType == 1) {
                    cr[0] = this.cnvMBCSDoubleFromUnicodeWithOffsets(source, target, offsets, flush);
                    return cr[0];
                }
                char[] table = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
                int[] tableInts = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTableInts;
                int sourceArrayIndex = source.position();
                byte[] bytes = CharsetMBCS.this.sharedData.mbcs.fromUnicodeBytes;
                int[] ints = CharsetMBCS.this.sharedData.mbcs.fromUnicodeInts;
                char[] chars = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
                int c = this.fromUChar32;
                if (outputType == 12) {
                    prevLength = this.fromUnicodeStatus;
                    if (prevLength == 0) {
                        prevLength = 1;
                    }
                } else {
                    prevLength = 0;
                }
                int prevSourceIndex = -1;
                int sourceIndex = c == 0 ? 0 : -1;
                int nextSourceIndex = 0;
                si_value_length = CharsetMBCS.getSISOBytes(SISO_Option.SI, CharsetMBCS.this.options, si_value);
                so_value_length = CharsetMBCS.getSISOBytes(SISO_Option.SO, CharsetMBCS.this.options, so_value);
                boolean doloop = true;
                boolean doread = true;
                if (c != 0 && target.hasRemaining()) {
                    if (UTF16.isLeadSurrogate((char)((char)c)) && (uniMask & 2) == 0) {
                        x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, prevLength);
                        doloop = this.getTrail(source, target, uniMask, x, flush, cr);
                        doread = x.doread;
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        sourceIndex = x.sourceIndex;
                        nextSourceIndex = x.nextSourceIndex;
                        prevSourceIndex = x.prevSourceIndex;
                        prevLength = x.prevLength;
                    } else {
                        doread = false;
                    }
                }
                if (doloop) {
                    while (!doread || sourceArrayIndex < source.limit()) {
                        if (target.hasRemaining()) {
                            if (doread) {
                                c = source.get(sourceArrayIndex++);
                                ++nextSourceIndex;
                                if (UTF16.isSurrogate((char)((char)c)) && (uniMask & 2) == 0) {
                                    if (UTF16.isLeadSurrogate((char)((char)c))) {
                                        x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, prevLength);
                                        doloop = this.getTrail(source, target, uniMask, x, flush, cr);
                                        c = x.c;
                                        sourceArrayIndex = x.sourceArrayIndex;
                                        sourceIndex = x.sourceIndex;
                                        nextSourceIndex = x.nextSourceIndex;
                                        prevSourceIndex = x.prevSourceIndex;
                                        if (x.doread) {
                                            if (!doloop) break;
                                            continue;
                                        }
                                    } else {
                                        cr[0] = CoderResult.malformedForLength(1);
                                        break;
                                    }
                                }
                            } else {
                                doread = true;
                            }
                            stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, c);
                            switch (outputType) {
                                case 12: {
                                    this.fromUnicodeStatus = prevLength;
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(chars, stage2Entry, c);
                                    if (value <= 255) {
                                        if (value == 0 && !CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c)) {
                                            length = 0;
                                            break;
                                        }
                                        if (prevLength <= 1) {
                                            length = 1;
                                            break;
                                        }
                                        if (si_value_length == 1) {
                                            value |= si_value[0] << 8;
                                            length = 2;
                                        } else if (si_value_length == 2) {
                                            value |= si_value[1] << 8;
                                            value |= si_value[0] << 16;
                                            length = 3;
                                        }
                                        prevLength = 1;
                                        break;
                                    }
                                    if (prevLength == 2) {
                                        length = 2;
                                        break;
                                    }
                                    if (so_value_length == 1) {
                                        value |= so_value[0] << 16;
                                        length = 3;
                                    } else if (so_value_length == 2) {
                                        value |= so_value[1] << 16;
                                        value |= so_value[0] << 24;
                                        length = 4;
                                    }
                                    prevLength = 2;
                                    break;
                                }
                                case 219: {
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(chars, stage2Entry, c);
                                    if (value <= 255) {
                                        stage2Entry = 0;
                                        value = 0;
                                        length = 0;
                                        break;
                                    }
                                    length = 2;
                                    break;
                                }
                                case 2: {
                                    byte[] pArray = bytes;
                                    int pArrayIndex = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                                    value = (pArray[pArrayIndex] & 0xFF) << 16 | (pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF;
                                    if (value <= 255) {
                                        length = 1;
                                        break;
                                    }
                                    if (value <= 65535) {
                                        length = 2;
                                        break;
                                    }
                                    length = 3;
                                    break;
                                }
                                case 3: {
                                    value = CharsetMBCS.MBCS_VALUE_4_FROM_STAGE_2(ints, stage2Entry, c);
                                    if (value < 0) {
                                        length = 4;
                                        break;
                                    }
                                    if (value <= 255) {
                                        length = 1;
                                        break;
                                    }
                                    if (value <= 65535) {
                                        length = 2;
                                        break;
                                    }
                                    if (value <= 0xFFFFFF) {
                                        length = 3;
                                        break;
                                    }
                                    length = 4;
                                    break;
                                }
                                case 8: {
                                    value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(chars, stage2Entry, c);
                                    if (value <= 255) {
                                        length = 1;
                                        break;
                                    }
                                    if ((value & 0x8000) == 0) {
                                        value |= 0x8E8000;
                                        length = 3;
                                        break;
                                    }
                                    if ((value & 0x80) == 0) {
                                        value |= 0x8F0080;
                                        length = 3;
                                        break;
                                    }
                                    length = 2;
                                    break;
                                }
                                case 9: {
                                    byte[] pArray = bytes;
                                    int pArrayIndex = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                                    value = (pArray[pArrayIndex] & 0xFF) << 16 | (pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF;
                                    if (value <= 255) {
                                        length = 1;
                                        break;
                                    }
                                    if (value <= 65535) {
                                        length = 2;
                                        break;
                                    }
                                    if ((value & 0x800000) == 0) {
                                        value |= 0x8E800000;
                                        length = 4;
                                        break;
                                    }
                                    if ((value & 0x8000) == 0) {
                                        value |= 0x8F008000;
                                        length = 4;
                                        break;
                                    }
                                    length = 3;
                                    break;
                                }
                                default: {
                                    stage2Entry = 0;
                                    value = 0;
                                    length = 0;
                                }
                            }
                            if (gotoUnassigned || !CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) && (!this.isFromUUseFallback(c) || value == 0)) {
                                gotoUnassigned = false;
                                x = new SideEffects(c, sourceArrayIndex, sourceIndex, nextSourceIndex, prevSourceIndex, prevLength);
                                doloop = this.unassigned(source, target, offsets, x, flush, cr);
                                c = x.c;
                                sourceArrayIndex = x.sourceArrayIndex;
                                sourceIndex = x.sourceIndex;
                                nextSourceIndex = x.nextSourceIndex;
                                prevSourceIndex = x.prevSourceIndex;
                                prevLength = x.prevLength;
                                if (!doloop) break;
                                continue;
                            }
                            if (length <= target.remaining()) {
                                switch (length) {
                                    case 4: {
                                        target.put((byte)(value >>> 24));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 3: {
                                        target.put((byte)(value >>> 16));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 2: {
                                        target.put((byte)(value >>> 8));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 1: {
                                        target.put((byte)value);
                                        if (offsets == null) break;
                                        offsets.put(sourceIndex);
                                        break;
                                    }
                                }
                                c = 0;
                                if (offsets == null) continue;
                            } else {
                                int errorBufferArrayIndex = 0;
                                switch (length -= target.remaining()) {
                                    case 3: {
                                        this.errorBuffer[errorBufferArrayIndex++] = (byte)(value >>> 16);
                                    }
                                    case 2: {
                                        this.errorBuffer[errorBufferArrayIndex++] = (byte)(value >>> 8);
                                    }
                                    case 1: {
                                        this.errorBuffer[errorBufferArrayIndex] = (byte)value;
                                        break;
                                    }
                                }
                                this.errorBufferLength = (byte)length;
                                value >>>= 8 * length;
                                switch (target.remaining()) {
                                    case 3: {
                                        target.put((byte)(value >>> 16));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 2: {
                                        target.put((byte)(value >>> 8));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                    }
                                    case 1: {
                                        target.put((byte)value);
                                        if (offsets == null) break;
                                        offsets.put(sourceIndex);
                                        break;
                                    }
                                }
                                cr[0] = CoderResult.OVERFLOW;
                                c = 0;
                                break;
                            }
                            prevSourceIndex = sourceIndex;
                            sourceIndex = nextSourceIndex;
                            continue;
                        }
                        cr[0] = CoderResult.OVERFLOW;
                        break;
                    }
                }
                if (outputType == 12 && prevLength == 2 && flush && sourceArrayIndex >= source.limit() && c == 0) {
                    if (target.hasRemaining()) {
                        target.put(si_value[0]);
                        if (si_value_length == 2) {
                            if (target.remaining() > 0) {
                                target.put(si_value[1]);
                            } else {
                                this.errorBuffer[0] = si_value[1];
                                this.errorBufferLength = 1;
                                cr[0] = CoderResult.OVERFLOW;
                            }
                        }
                        if (offsets != null) {
                            offsets.put(prevSourceIndex);
                        }
                    } else {
                        this.errorBuffer[0] = si_value[0];
                        if (si_value_length == 2) {
                            this.errorBuffer[1] = si_value[1];
                        }
                        this.errorBufferLength = si_value_length;
                        cr[0] = CoderResult.OVERFLOW;
                    }
                    prevLength = 1;
                }
                this.fromUChar32 = c;
                this.fromUnicodeStatus = prevLength;
                source.position(sourceArrayIndex);
                return cr[0];
            }
            catch (BufferOverflowException ex) {
                cr[0] = CoderResult.OVERFLOW;
            }
            return cr[0];
        }

        int fromUChar32(int c, int[] pValue, boolean isUseFallback) {
            int length;
            if (c <= 65535 || CharsetMBCS.this.sharedData.mbcs.hasSupplementary()) {
                char[] table = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
                if (CharsetMBCS.this.sharedData.mbcs.outputType == 0) {
                    char value = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars, c);
                    if (isUseFallback ? value >= '\u0800' : value >= '\u0c00') {
                        pValue[0] = value & 0xFF;
                        return 1;
                    }
                } else {
                    int value;
                    int[] tableInts = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTableInts;
                    int stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, c);
                    switch (CharsetMBCS.this.sharedData.mbcs.outputType) {
                        case 1: {
                            value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars, stage2Entry, c);
                            if (value <= 255) {
                                length = 1;
                                break;
                            }
                            length = 2;
                            break;
                        }
                        case 2: {
                            byte[] bytes = CharsetMBCS.this.sharedData.mbcs.fromUnicodeBytes;
                            int p = CharsetMBCS.MBCS_POINTER_3_FROM_STAGE_2(bytes, stage2Entry, c);
                            value = (bytes[p] & 0xFF) << 16 | (bytes[p + 1] & 0xFF) << 8 | bytes[p + 2] & 0xFF;
                            if (value <= 255) {
                                length = 1;
                                break;
                            }
                            if (value <= 65535) {
                                length = 2;
                                break;
                            }
                            length = 3;
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    if (CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) || CharsetEncoderICU.isFromUUseFallback(isUseFallback, c) && value != 0) {
                        pValue[0] = value;
                        return length;
                    }
                }
            }
            if (CharsetMBCS.this.sharedData.mbcs.extIndexes != null) {
                length = this.simpleMatchFromU(c, pValue, isUseFallback);
                return length >= 0 ? length : -length;
            }
            return 0;
        }

        private CoderResult continueMatchFromU(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush, int srcIndex) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int[] value = new int[1];
            int match = this.matchFromU(this.preFromUFirstCP, this.preFromUArray, this.preFromUBegin, this.preFromULength, source, value, this.useFallback, flush);
            if (match >= 2) {
                if ((match -= 2) >= this.preFromULength) {
                    source.position(source.position() + match - this.preFromULength);
                    this.preFromULength = 0;
                } else {
                    int length = this.preFromULength - match;
                    System.arraycopy(this.preFromUArray, this.preFromUBegin + match, this.preFromUArray, this.preFromUBegin, length);
                    this.preFromULength = (byte)(-length);
                }
                this.preFromUFirstCP = -1;
                this.writeFromU(value[0], target, offsets, srcIndex);
            } else if (match < 0) {
                int sArrayIndex = source.position();
                match = -match - 2;
                for (int j = this.preFromULength; j < match; ++j) {
                    this.preFromUArray[j] = source.get(sArrayIndex++);
                }
                source.position(sArrayIndex);
                this.preFromULength = (byte)match;
            } else {
                if (match == 1) {
                    this.useSubChar1 = true;
                }
                this.fromUChar32 = this.preFromUFirstCP;
                this.preFromUFirstCP = -1;
                this.preFromULength = (byte)(-this.preFromULength);
                cr = CoderResult.unmappableForLength(1);
            }
            return cr;
        }

        private int matchFromU(int firstCP, char[] preArray, int preArrayBegin, int preLength, CharBuffer source, int[] pMatchValue, boolean isUseFallback, boolean flush) {
            int matchLength;
            int matchValue;
            ByteBuffer cx = CharsetMBCS.this.sharedData.mbcs.extIndexes;
            if (cx == null) {
                return 0;
            }
            int index = firstCP >>> 10;
            if (index >= cx.asIntBuffer().get(11)) {
                return 0;
            }
            CharBuffer stage12 = (CharBuffer)CharsetMBCS.ARRAY(cx, 10, Character.TYPE);
            CharBuffer stage3 = (CharBuffer)CharsetMBCS.ARRAY(cx, 13, Character.TYPE);
            index = CharsetMBCS.FROM_U(stage12, stage3, index, firstCP);
            IntBuffer stage3b = (IntBuffer)CharsetMBCS.ARRAY(cx, 15, Integer.TYPE);
            int value = stage3b.get(stage3b.position() + index);
            if (value == 0) {
                return 0;
            }
            if (CharsetMBCS.TO_U_IS_PARTIAL(value)) {
                block17: {
                    index = CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(value);
                    CharBuffer fromUTableUChars = (CharBuffer)CharsetMBCS.ARRAY(cx, 5, Character.TYPE);
                    IntBuffer fromUTableValues = (IntBuffer)CharsetMBCS.ARRAY(cx, 6, Integer.TYPE);
                    matchValue = 0;
                    matchLength = 0;
                    int j = 0;
                    int i = 0;
                    while (true) {
                        char c;
                        int oldpos = fromUTableUChars.position();
                        CharBuffer fromUSectionUChars = ((CharBuffer)fromUTableUChars.position(index)).slice();
                        fromUTableUChars.position(oldpos);
                        oldpos = fromUTableValues.position();
                        IntBuffer fromUSectionValues = ((IntBuffer)fromUTableValues.position(index)).slice();
                        fromUTableValues.position(oldpos);
                        int length = fromUSectionUChars.get();
                        value = fromUSectionValues.get();
                        if (value != 0 && (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || CharsetEncoderMBCS.isFromUUseFallback(isUseFallback, firstCP))) {
                            matchValue = value;
                            matchLength = 2 + i + j;
                        }
                        if (i < preLength) {
                            c = preArray[preArrayBegin + i++];
                        } else {
                            if (source == null || j >= source.remaining()) {
                                if (!flush && (length = i + j) <= 19) {
                                    return -(2 + length);
                                }
                                break block17;
                            }
                            c = source.get(source.position() + j++);
                        }
                        index = CharsetMBCS.findFromU(fromUSectionUChars, length, c);
                        if (index < 0) break block17;
                        value = fromUSectionValues.get(fromUSectionValues.position() + index);
                        if (!CharsetMBCS.FROM_U_IS_PARTIAL(value)) break;
                        index = CharsetMBCS.FROM_U_GET_PARTIAL_INDEX(value);
                    }
                    if (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || CharsetEncoderMBCS.isFromUUseFallback(isUseFallback, firstCP)) {
                        matchValue = value;
                        matchLength = 2 + i + j;
                    }
                }
                if (matchLength == 0) {
                    return 0;
                }
            } else if (CharsetMBCS.FROM_U_IS_ROUNDTRIP(value) || CharsetEncoderMBCS.isFromUUseFallback(isUseFallback, firstCP)) {
                matchValue = value;
                matchLength = 2;
            } else {
                return 0;
            }
            if ((matchValue & 0x60000000) != 0) {
                return 0;
            }
            if (matchValue == -2147483647) {
                return 1;
            }
            pMatchValue[0] = CharsetMBCS.FROM_U_MASK_ROUNDTRIP(matchValue);
            return matchLength;
        }

        private int simpleMatchFromU(int cp, int[] pValue, boolean isUseFallback) {
            int[] value = new int[1];
            int match = this.matchFromU(cp, null, 0, 0, null, value, isUseFallback, true);
            if (match >= 2) {
                boolean isRoundtrip = CharsetMBCS.FROM_U_IS_ROUNDTRIP(value[0]);
                int length = CharsetMBCS.FROM_U_GET_LENGTH(value[0]);
                value[0] = CharsetMBCS.FROM_U_GET_DATA(value[0]);
                if (length <= 3) {
                    pValue[0] = value[0];
                    return isRoundtrip ? length : -length;
                }
            }
            return 0;
        }

        private CoderResult writeFromU(int value, ByteBuffer target, IntBuffer offsets, int srcIndex) {
            int resultArrayIndex;
            byte[] resultArray;
            ByteBuffer cx = CharsetMBCS.this.sharedData.mbcs.extIndexes;
            byte[] bufferArray = new byte[32];
            int bufferArrayIndex = 0;
            int length = CharsetMBCS.FROM_U_GET_LENGTH(value);
            value = CharsetMBCS.FROM_U_GET_DATA(value);
            if (length <= 3) {
                int p = bufferArrayIndex + 1;
                switch (length) {
                    case 3: {
                        bufferArray[p++] = (byte)(value >>> 16);
                    }
                    case 2: {
                        bufferArray[p++] = (byte)(value >>> 8);
                    }
                    case 1: {
                        bufferArray[p++] = (byte)value;
                    }
                }
                resultArray = bufferArray;
                resultArrayIndex = bufferArrayIndex + 1;
            } else {
                byte[] slice = new byte[length];
                ByteBuffer bb = (ByteBuffer)CharsetMBCS.ARRAY(cx, 8, Byte.TYPE);
                bb.position(value);
                bb.get(slice, 0, slice.length);
                resultArray = slice;
                resultArrayIndex = 0;
            }
            int prevLength = this.fromUnicodeStatus;
            if (prevLength != 0) {
                int shiftByte;
                if (prevLength > 1 && length == 1) {
                    shiftByte = 15;
                    this.fromUnicodeStatus = 1;
                } else if (prevLength == 1 && length > 1) {
                    shiftByte = 14;
                    this.fromUnicodeStatus = 2;
                } else {
                    shiftByte = 0;
                }
                if (shiftByte != 0) {
                    bufferArray[0] = shiftByte;
                    if (resultArray != bufferArray || resultArrayIndex != bufferArrayIndex + 1) {
                        System.arraycopy(resultArray, resultArrayIndex, bufferArray, bufferArrayIndex + 1, length);
                    }
                    resultArray = bufferArray;
                    resultArrayIndex = bufferArrayIndex;
                    ++length;
                }
            }
            return CharsetEncoderMBCS.fromUWriteBytes(this, resultArray, resultArrayIndex, length, target, offsets, srcIndex);
        }

        private int fromU(int cp, CharBuffer source, ByteBuffer target, IntBuffer offsets, int sourceIndex, int length, boolean flush, CoderResult[] cr) {
            this.useSubChar1 = false;
            if (CharsetMBCS.this.sharedData.mbcs.extIndexes != null && this.initialMatchFromU(cp, source, target, offsets, sourceIndex, flush, cr)) {
                return 0;
            }
            if ((CharsetMBCS.this.options & 0x8000) != 0) {
                for (int i = 0; i < gb18030Ranges.length; ++i) {
                    int[] range = gb18030Ranges[i];
                    if (range[0] > cp || cp > range[1]) continue;
                    byte[] bytes = new byte[4];
                    int linear = range[2] - LINEAR_18030_BASE;
                    bytes[3] = (byte)(48 + (linear += cp - range[0]) % 10);
                    bytes[2] = (byte)(129 + (linear /= 10) % 126);
                    bytes[1] = (byte)(48 + (linear /= 126) % 10);
                    bytes[0] = (byte)(129 + (linear /= 10));
                    cr[0] = CharsetEncoderMBCS.fromUWriteBytes(this, bytes, 0, 4, target, offsets, sourceIndex);
                    return 0;
                }
            }
            cr[0] = CoderResult.unmappableForLength(length);
            return cp;
        }

        private boolean initialMatchFromU(int cp, CharBuffer source, ByteBuffer target, IntBuffer offsets, int srcIndex, boolean flush, CoderResult[] cr) {
            int[] value = new int[1];
            int match = this.matchFromU(cp, null, 0, 0, source, value, this.useFallback, flush);
            if (match >= 2 && (CharsetMBCS.FROM_U_GET_LENGTH(value[0]) != 1 || CharsetMBCS.this.sharedData.mbcs.outputType != 219)) {
                source.position(source.position() + match - 2);
                cr[0] = this.writeFromU(value[0], target, offsets, srcIndex);
                return true;
            }
            if (match < 0) {
                this.preFromUFirstCP = cp;
                int sArrayIndex = source.position();
                match = -match - 2;
                for (int j = 0; j < match; ++j) {
                    this.preFromUArray[j] = source.get(sArrayIndex++);
                }
                source.position(sArrayIndex);
                this.preFromULength = (byte)match;
                return true;
            }
            if (match == 1) {
                this.useSubChar1 = true;
                return false;
            }
            return false;
        }

        CoderResult cnvMBCSFromUnicodeWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            return this.encodeLoop(source, target, offsets, flush);
        }

        private CoderResult cnvMBCSSingleFromBMPWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            SideEffectsSingleBMP x;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            int targetCapacity = target.remaining();
            char[] table = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
            char[] results = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
            char minValue = this.useFallback ? (char)'\u0800' : '\u0c00';
            int c = this.fromUChar32;
            int sourceIndex = c == 0 ? 0 : -1;
            int lastSource = sourceArrayIndex;
            int length = source.limit() - sourceArrayIndex;
            if (length < targetCapacity) {
                targetCapacity = length;
            }
            boolean doloop = true;
            if (c != 0 && targetCapacity > 0) {
                x = new SideEffectsSingleBMP(c, sourceArrayIndex);
                doloop = this.getTrailSingleBMP(source, x, cr);
                c = x.c;
                sourceArrayIndex = x.sourceArrayIndex;
            }
            if (doloop) {
                while (targetCapacity > 0) {
                    char value;
                    if ((value = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, c = (int)source.get(sourceArrayIndex++))) >= minValue) {
                        target.put((byte)value);
                        --targetCapacity;
                        c = 0;
                        continue;
                    }
                    if (UTF16.isSurrogate((char)((char)c))) {
                        if (UTF16.isLeadSurrogate((char)((char)c))) {
                            x = new SideEffectsSingleBMP(c, sourceArrayIndex);
                            doloop = this.getTrailSingleBMP(source, x, cr);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            if (!doloop) {
                                break;
                            }
                        } else {
                            cr[0] = CoderResult.malformedForLength(1);
                            break;
                        }
                    }
                    length = UTF16.getCharCount((int)c);
                    if (offsets != null) {
                        int count = sourceArrayIndex - lastSource;
                        count -= length;
                        while (count > 0) {
                            offsets.put(sourceIndex++);
                            --count;
                        }
                    }
                    lastSource = sourceArrayIndex;
                    source.position(sourceArrayIndex);
                    c = this.fromU(c, source, target, offsets, sourceIndex, length, flush, cr);
                    sourceArrayIndex = source.position();
                    sourceIndex += length + (sourceArrayIndex - lastSource);
                    lastSource = sourceArrayIndex;
                    if (cr[0].isError()) break;
                    targetCapacity = target.remaining();
                    length = source.limit() - sourceArrayIndex;
                    if (length >= targetCapacity) continue;
                    targetCapacity = length;
                }
            }
            if (sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr[0] = CoderResult.OVERFLOW;
            }
            if (offsets != null) {
                for (int count = sourceArrayIndex - lastSource; count > 0; --count) {
                    offsets.put(sourceIndex++);
                }
            }
            this.fromUChar32 = c;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        private CoderResult cnvMBCSSingleFromUnicodeWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            SideEffectsDouble x;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            char[] table = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
            char[] results = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
            char minValue = this.useFallback ? (char)'\u0800' : '\u0c00';
            short uniMask = CharsetMBCS.this.sharedData.mbcs.unicodeMask;
            int c = this.fromUChar32;
            int sourceIndex = c == 0 ? 0 : -1;
            int nextSourceIndex = 0;
            boolean doloop = true;
            boolean doread = true;
            if (c != 0 && target.hasRemaining()) {
                if (UTF16.isLeadSurrogate((char)((char)c))) {
                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                    doloop = this.getTrailDouble(source, target, uniMask, x, flush, cr);
                    doread = x.doread;
                    c = x.c;
                    sourceArrayIndex = x.sourceArrayIndex;
                    sourceIndex = x.sourceIndex;
                    nextSourceIndex = x.nextSourceIndex;
                } else {
                    doread = false;
                }
            }
            if (doloop) {
                while (!doread || sourceArrayIndex < source.limit()) {
                    if (target.hasRemaining()) {
                        char value;
                        if (doread) {
                            c = source.get(sourceArrayIndex++);
                            ++nextSourceIndex;
                            if (UTF16.isSurrogate((char)((char)c))) {
                                if (UTF16.isLeadSurrogate((char)((char)c))) {
                                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                                    doloop = this.getTrailDouble(source, target, uniMask, x, flush, cr);
                                    c = x.c;
                                    sourceArrayIndex = x.sourceArrayIndex;
                                    sourceIndex = x.sourceIndex;
                                    nextSourceIndex = x.nextSourceIndex;
                                    if (x.doread) {
                                        if (!doloop) break;
                                        continue;
                                    }
                                } else {
                                    cr[0] = CoderResult.malformedForLength(1);
                                    break;
                                }
                            }
                        } else {
                            doread = true;
                        }
                        if ((value = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, results, c)) >= minValue) {
                            target.put((byte)value);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            c = 0;
                            sourceIndex = nextSourceIndex;
                            continue;
                        }
                        x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                        doloop = this.unassignedDouble(source, target, x, flush, cr);
                        c = x.c;
                        sourceArrayIndex = x.sourceArrayIndex;
                        sourceIndex = x.sourceIndex;
                        nextSourceIndex = x.nextSourceIndex;
                        if (doloop) continue;
                        break;
                    }
                    cr[0] = CoderResult.OVERFLOW;
                    break;
                }
            }
            this.fromUChar32 = c;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        /*
         * Enabled aggressive block sorting
         */
        private CoderResult cnvMBCSDoubleFromUnicodeWithOffsets(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            SideEffectsDouble x;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            short uniMask = CharsetMBCS.this.sharedData.mbcs.unicodeMask;
            int sourceArrayIndex = source.position();
            char[] table = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTable;
            int[] tableInts = CharsetMBCS.this.sharedData.mbcs.fromUnicodeTableInts;
            char[] chars = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLFromUnicodeChars : CharsetMBCS.this.sharedData.mbcs.fromUnicodeChars;
            int c = this.fromUChar32;
            int sourceIndex = c == 0 ? 0 : -1;
            int nextSourceIndex = 0;
            boolean doloop = true;
            boolean doread = true;
            if (c != 0 && target.hasRemaining()) {
                if (UTF16.isLeadSurrogate((char)((char)c))) {
                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                    doloop = this.getTrailDouble(source, target, uniMask, x, flush, cr);
                    doread = x.doread;
                    c = x.c;
                    sourceArrayIndex = x.sourceArrayIndex;
                    sourceIndex = x.sourceIndex;
                    nextSourceIndex = x.nextSourceIndex;
                } else {
                    doread = false;
                }
            }
            if (doloop) {
                while (!doread || sourceArrayIndex < source.limit()) {
                    if (target.hasRemaining()) {
                        int stage2Entry;
                        char value;
                        if (doread) {
                            c = source.get(sourceArrayIndex++);
                            ++nextSourceIndex;
                            if (UTF16.isSurrogate((char)((char)c)) && (uniMask & 2) == 0) {
                                if (UTF16.isLeadSurrogate((char)((char)c))) {
                                    x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                                    doloop = this.getTrailDouble(source, target, uniMask, x, flush, cr);
                                    c = x.c;
                                    sourceArrayIndex = x.sourceArrayIndex;
                                    sourceIndex = x.sourceIndex;
                                    nextSourceIndex = x.nextSourceIndex;
                                    if (x.doread) {
                                        if (!doloop) break;
                                        continue;
                                    }
                                } else {
                                    cr[0] = CoderResult.malformedForLength(1);
                                    break;
                                }
                            }
                        } else {
                            doread = true;
                        }
                        int length = (value = CharsetMBCS.MBCS_VALUE_2_FROM_STAGE_2(chars, stage2Entry = CharsetMBCS.MBCS_STAGE_2_FROM_U(table, tableInts, c), c)) <= '\u00ff' ? 1 : 2;
                        if (!(CharsetMBCS.MBCS_FROM_U_IS_ROUNDTRIP(stage2Entry, c) || this.isFromUUseFallback(c) && value != '\u0000')) {
                            x = new SideEffectsDouble(c, sourceArrayIndex, sourceIndex, nextSourceIndex);
                            doloop = this.unassignedDouble(source, target, x, flush, cr);
                            c = x.c;
                            sourceArrayIndex = x.sourceArrayIndex;
                            sourceIndex = x.sourceIndex;
                            nextSourceIndex = x.nextSourceIndex;
                            if (!doloop) break;
                            continue;
                        }
                        if (length == 1) {
                            target.put((byte)value);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                        } else {
                            target.put((byte)(value >>> 8));
                            if (2 <= target.remaining()) {
                                target.put((byte)value);
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                    offsets.put(sourceIndex);
                                }
                            } else {
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                }
                                this.errorBuffer[0] = (byte)value;
                                this.errorBufferLength = 1;
                                cr[0] = CoderResult.OVERFLOW;
                                c = 0;
                                break;
                            }
                        }
                        c = 0;
                        sourceIndex = nextSourceIndex;
                        continue;
                    }
                    cr[0] = CoderResult.OVERFLOW;
                    break;
                }
            }
            this.fromUChar32 = c;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private final boolean getTrailSingleBMP(CharBuffer source, SideEffectsSingleBMP x, CoderResult[] cr) {
            if (x.sourceArrayIndex < source.limit()) {
                char trail = source.get(x.sourceArrayIndex);
                if (UTF16.isTrailSurrogate((char)trail)) {
                    ++x.sourceArrayIndex;
                    x.c = UCharacter.getCodePoint((char)((char)x.c), (char)trail);
                    cr[0] = CoderResult.unmappableForLength(2);
                    return false;
                }
                cr[0] = CoderResult.malformedForLength(1);
                return false;
            }
            return false;
        }

        private final boolean getTrail(CharBuffer source, ByteBuffer target, int uniMask, SideEffects x, boolean flush, CoderResult[] cr) {
            if (x.sourceArrayIndex < source.limit()) {
                char trail = source.get(x.sourceArrayIndex);
                if (UTF16.isTrailSurrogate((char)trail)) {
                    ++x.sourceArrayIndex;
                    ++x.nextSourceIndex;
                    x.c = UCharacter.getCodePoint((char)((char)x.c), (char)trail);
                    if ((uniMask & 1) == 0) {
                        this.fromUnicodeStatus = x.prevLength;
                        x.doread = true;
                        return this.unassigned(source, target, null, x, flush, cr);
                    }
                    x.doread = false;
                    return true;
                }
                cr[0] = CoderResult.malformedForLength(1);
                return false;
            }
            return false;
        }

        private final boolean unassigned(CharBuffer source, ByteBuffer target, IntBuffer offsets, SideEffects x, boolean flush, CoderResult[] cr) {
            int sourceBegin = x.sourceArrayIndex;
            source.position(x.sourceArrayIndex);
            x.c = this.fromU(x.c, source, target, null, x.sourceIndex, x.nextSourceIndex, flush, cr);
            x.sourceArrayIndex = source.position();
            x.nextSourceIndex += x.sourceArrayIndex - sourceBegin;
            x.prevLength = this.fromUnicodeStatus;
            if (cr[0].isError()) {
                return false;
            }
            if (offsets != null) {
                x.prevSourceIndex = x.sourceIndex;
                x.sourceIndex = x.nextSourceIndex;
            }
            return true;
        }

        private final boolean getTrailDouble(CharBuffer source, ByteBuffer target, int uniMask, SideEffectsDouble x, boolean flush, CoderResult[] cr) {
            if (x.sourceArrayIndex < source.limit()) {
                char trail = source.get(x.sourceArrayIndex);
                if (UTF16.isTrailSurrogate((char)trail)) {
                    ++x.sourceArrayIndex;
                    ++x.nextSourceIndex;
                    x.c = UCharacter.getCodePoint((char)((char)x.c), (char)trail);
                    if ((uniMask & 1) == 0) {
                        x.doread = true;
                        return this.unassignedDouble(source, target, x, flush, cr);
                    }
                    x.doread = false;
                    return true;
                }
                cr[0] = CoderResult.malformedForLength(1);
                return false;
            }
            return false;
        }

        private final boolean unassignedDouble(CharBuffer source, ByteBuffer target, SideEffectsDouble x, boolean flush, CoderResult[] cr) {
            int sourceBegin = x.sourceArrayIndex;
            source.position(x.sourceArrayIndex);
            x.c = this.fromU(x.c, source, target, null, x.sourceIndex, x.nextSourceIndex, flush, cr);
            x.sourceArrayIndex = source.position();
            x.nextSourceIndex += x.sourceArrayIndex - sourceBegin;
            if (cr[0].isError()) {
                return false;
            }
            x.sourceIndex = x.nextSourceIndex;
            return true;
        }

        @Override
        protected CoderResult cbFromUWriteSub(CharsetEncoderICU encoder, CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            int length;
            byte[] subchar;
            CharsetMBCS cs = (CharsetMBCS)encoder.charset();
            if (cs.subChar1 != 0 && (cs.sharedData.mbcs.extIndexes != null ? encoder.useSubChar1 : encoder.invalidUCharBuffer[0] <= '\u00ff')) {
                subchar = new byte[]{cs.subChar1};
                length = 1;
            } else {
                subchar = cs.subChar;
                length = cs.subCharLen;
            }
            encoder.useSubChar1 = false;
            if (cs.sharedData.mbcs.outputType == 12) {
                byte[] buffer = new byte[4];
                int i = 0;
                switch (length) {
                    case 1: {
                        if (encoder.fromUnicodeStatus == 2) {
                            encoder.fromUnicodeStatus = 1;
                            buffer[i++] = 15;
                        }
                        buffer[i++] = subchar[0];
                        break;
                    }
                    case 2: {
                        if (encoder.fromUnicodeStatus <= 1) {
                            encoder.fromUnicodeStatus = 2;
                            buffer[i++] = 14;
                        }
                        buffer[i++] = subchar[0];
                        buffer[i++] = subchar[1];
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                subchar = buffer;
                length = i;
            }
            return CharsetEncoderICU.fromUWriteBytes(encoder, subchar, 0, length, target, offsets, source.position());
        }

        @Override
        protected void implReplaceWith(byte[] replacement) {
            if (this.allowReplacementChanges) {
                CharsetMBCS cs = (CharsetMBCS)this.charset();
                System.arraycopy(replacement, 0, cs.subChar, 0, replacement.length);
                cs.subCharLen = (byte)replacement.length;
                cs.subChar1 = 0;
            }
        }

        private final class SideEffectsDouble {
            int c;
            int sourceArrayIndex;
            int sourceIndex;
            int nextSourceIndex;
            boolean doread = true;

            SideEffectsDouble(int c_, int sourceArrayIndex_, int sourceIndex_, int nextSourceIndex_) {
                this.c = c_;
                this.sourceArrayIndex = sourceArrayIndex_;
                this.sourceIndex = sourceIndex_;
                this.nextSourceIndex = nextSourceIndex_;
            }
        }

        private final class SideEffects {
            int c;
            int sourceArrayIndex;
            int sourceIndex;
            int nextSourceIndex;
            int prevSourceIndex;
            int prevLength;
            boolean doread = true;

            SideEffects(int c_, int sourceArrayIndex_, int sourceIndex_, int nextSourceIndex_, int prevSourceIndex_, int prevLength_) {
                this.c = c_;
                this.sourceArrayIndex = sourceArrayIndex_;
                this.sourceIndex = sourceIndex_;
                this.nextSourceIndex = nextSourceIndex_;
                this.prevSourceIndex = prevSourceIndex_;
                this.prevLength = prevLength_;
            }
        }

        private final class SideEffectsSingleBMP {
            int c;
            int sourceArrayIndex;

            SideEffectsSingleBMP(int c_, int sourceArrayIndex_) {
                this.c = c_;
                this.sourceArrayIndex = sourceArrayIndex_;
            }
        }
    }

    class CharsetDecoderMBCS
    extends CharsetDecoderICU {
        CharsetDecoderMBCS(CharsetICU cs) {
            super(cs);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            return this.cnvMBCSToUnicodeWithOffsets(source, target, offsets, flush);
        }

        private CoderResult continueMatchToU(ByteBuffer source, CharBuffer target, IntBuffer offsets, int srcIndex, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int[] value = new int[1];
            int match = this.matchToU((byte)CharsetMBCS.SISO_STATE(CharsetMBCS.this.sharedData, this.mode), this.preToUArray, this.preToUBegin, this.preToULength, source, value, CharsetDecoderMBCS.isToUUseFallback(), flush);
            if (match > 0) {
                if (match >= this.preToULength) {
                    source.position(source.position() + match - this.preToULength);
                    this.preToULength = 0;
                } else {
                    int length = this.preToULength - match;
                    System.arraycopy(this.preToUArray, this.preToUBegin + match, this.preToUArray, this.preToUBegin, length);
                    this.preToULength = (byte)(-length);
                }
                cr = this.writeToU(value[0], target, offsets, srcIndex);
            } else if (match < 0) {
                int sArrayIndex = source.position();
                match = -match;
                for (int j = this.preToULength; j < match; ++j) {
                    this.preToUArray[j] = source.get(sArrayIndex++);
                }
                source.position(sArrayIndex);
                this.preToULength = (byte)match;
            } else {
                System.arraycopy(this.preToUArray, this.preToUBegin, this.toUBytesArray, this.toUBytesBegin, this.preToUFirstLength);
                this.toULength = this.preToUFirstLength;
                int length = this.preToULength - this.preToUFirstLength;
                if (length > 0) {
                    System.arraycopy(this.preToUArray, this.preToUBegin + this.preToUFirstLength, this.preToUArray, this.preToUBegin, length);
                }
                this.preToULength = (byte)(-length);
                cr = CoderResult.unmappableForLength(this.preToUFirstLength);
            }
            return cr;
        }

        private int matchToU(byte sisoState, byte[] preArray, int preArrayBegin, int preLength, ByteBuffer source, int[] pMatchValue, boolean isUseFallback, boolean flush) {
            int matchLength;
            int matchValue;
            block15: {
                int value;
                ByteBuffer cx = CharsetMBCS.this.sharedData.mbcs.extIndexes;
                int srcLength = 0;
                if (cx == null || cx.asIntBuffer().get(2) <= 0) {
                    return 0;
                }
                IntBuffer toUTable = (IntBuffer)CharsetMBCS.ARRAY(cx, 1, Integer.TYPE);
                int index = 0;
                matchValue = 0;
                matchLength = 0;
                int j = 0;
                int i = 0;
                if (source != null) {
                    srcLength = source.remaining();
                }
                if (sisoState == 0) {
                    if (preLength > 1) {
                        return 0;
                    }
                    if (preLength == 1) {
                        srcLength = 0;
                    } else if (srcLength > 1) {
                        srcLength = 1;
                    }
                    flush = true;
                }
                while (true) {
                    short b;
                    int oldpos = toUTable.position();
                    IntBuffer toUSection = ((IntBuffer)toUTable.position(index)).slice();
                    toUTable.position(oldpos);
                    value = toUSection.get();
                    int length = CharsetMBCS.TO_U_GET_BYTE(value);
                    value = CharsetMBCS.TO_U_GET_VALUE(value);
                    if (value != 0 && (CharsetMBCS.TO_U_IS_ROUNDTRIP(value) || CharsetDecoderMBCS.isToUUseFallback(isUseFallback)) && CharsetMBCS.TO_U_VERIFY_SISO_MATCH(sisoState, i + j)) {
                        matchValue = value;
                        matchLength = i + j;
                    }
                    if (i < preLength) {
                        b = (short)(preArray[preArrayBegin + i++] & 0xFF);
                    } else {
                        if (j >= srcLength) {
                            if (!flush && (length = i + j) <= 31) {
                                return -length;
                            }
                            break block15;
                        }
                        b = (short)(source.get(source.position() + j++) & 0xFF);
                    }
                    value = CharsetMBCS.findToU(toUSection, length, b);
                    if (value == 0) break block15;
                    if (!CharsetMBCS.TO_U_IS_PARTIAL(value)) break;
                    index = CharsetMBCS.TO_U_GET_PARTIAL_INDEX(value);
                }
                if ((CharsetMBCS.TO_U_IS_ROUNDTRIP(value) || CharsetDecoderMBCS.isToUUseFallback(isUseFallback)) && CharsetMBCS.TO_U_VERIFY_SISO_MATCH(sisoState, i + j)) {
                    matchValue = value;
                    matchLength = i + j;
                }
            }
            if (matchLength == 0) {
                return 0;
            }
            pMatchValue[0] = CharsetMBCS.TO_U_MASK_ROUNDTRIP(matchValue);
            return matchLength;
        }

        private CoderResult writeToU(int value, CharBuffer target, IntBuffer offsets, int srcIndex) {
            ByteBuffer cx = CharsetMBCS.this.sharedData.mbcs.extIndexes;
            if (CharsetMBCS.TO_U_IS_CODE_POINT(value)) {
                return this.toUWriteCodePoint(CharsetMBCS.TO_U_GET_CODE_POINT(value), target, offsets, srcIndex);
            }
            char[] a = new char[CharsetMBCS.TO_U_GET_LENGTH(value)];
            CharBuffer cb = (CharBuffer)CharsetMBCS.ARRAY(cx, 3, Character.TYPE);
            cb.position(CharsetMBCS.TO_U_GET_INDEX(value));
            cb.get(a, 0, a.length);
            return CharsetDecoderMBCS.toUWriteUChars(this, a, 0, a.length, target, offsets, srcIndex);
        }

        private CoderResult toUWriteCodePoint(int c, CharBuffer target, IntBuffer offsets, int sourceIndex) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int tBeginIndex = target.position();
            if (target.hasRemaining()) {
                if (c <= 65535) {
                    target.put((char)c);
                    c = -1;
                } else {
                    target.put(UTF16.getLeadSurrogate((int)c));
                    c = UTF16.getTrailSurrogate((int)c);
                    if (target.hasRemaining()) {
                        target.put((char)c);
                        c = -1;
                    }
                }
                if (offsets != null) {
                    offsets.put(sourceIndex);
                    if (tBeginIndex + 1 < target.position()) {
                        offsets.put(sourceIndex);
                    }
                }
            }
            if (c >= 0) {
                this.charErrorBufferLength = UTF16.append((char[])this.charErrorBufferArray, (int)0, (int)c);
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }

        private int toU(int length, ByteBuffer source, CharBuffer target, IntBuffer offsets, int sourceIndex, boolean flush, CoderResult[] cr) {
            if (CharsetMBCS.this.sharedData.mbcs.extIndexes != null && this.initialMatchToU(length, source, target, offsets, sourceIndex, flush, cr)) {
                return 0;
            }
            if (length == 4 && (CharsetMBCS.this.options & 0x8000) != 0) {
                int linear = CharsetMBCS.LINEAR_18030(this.toUBytesArray[0], this.toUBytesArray[1], this.toUBytesArray[2], this.toUBytesArray[3]);
                for (int i = 0; i < gb18030Ranges.length; ++i) {
                    int[] range = gb18030Ranges[i];
                    if (range[2] > linear || linear > range[3]) continue;
                    cr[0] = CoderResult.UNDERFLOW;
                    linear = range[0] + (linear - range[2]);
                    cr[0] = this.toUWriteCodePoint(linear, target, offsets, sourceIndex);
                    return 0;
                }
            }
            cr[0] = CoderResult.unmappableForLength(length);
            return length;
        }

        private boolean initialMatchToU(int firstLength, ByteBuffer source, CharBuffer target, IntBuffer offsets, int srcIndex, boolean flush, CoderResult[] cr) {
            int[] value = new int[1];
            int match = 0;
            match = this.matchToU((byte)CharsetMBCS.SISO_STATE(CharsetMBCS.this.sharedData, this.mode), this.toUBytesArray, this.toUBytesBegin, firstLength, source, value, CharsetDecoderMBCS.isToUUseFallback(), flush);
            if (match > 0) {
                source.position(source.position() + match - firstLength);
                cr[0] = this.writeToU(value[0], target, offsets, srcIndex);
                return true;
            }
            if (match < 0) {
                int j;
                byte[] sArray = this.toUBytesArray;
                int sArrayIndex = this.toUBytesBegin;
                this.preToUFirstLength = (byte)firstLength;
                for (j = 0; j < firstLength; ++j) {
                    this.preToUArray[j] = sArray[sArrayIndex++];
                }
                sArrayIndex = source.position();
                match = -match;
                while (j < match) {
                    this.preToUArray[j] = source.get(sArrayIndex++);
                    ++j;
                }
                source.position(sArrayIndex);
                this.preToULength = (byte)match;
                return true;
            }
            return false;
        }

        private int simpleMatchToU(ByteBuffer source, boolean useFallback) {
            int sourceLimit;
            byte[] sourceArray;
            int sourcePosition;
            int[] value = new int[1];
            if (source.remaining() <= 0) {
                return 65535;
            }
            if (source.isReadOnly()) {
                sourcePosition = source.position();
                sourceArray = new byte[Math.min(source.remaining(), 31)];
                source.get(sourceArray).position(sourcePosition);
                sourcePosition = 0;
                sourceLimit = sourceArray.length;
            } else {
                sourceArray = source.array();
                sourcePosition = source.position();
                sourceLimit = source.limit();
            }
            int match = this.matchToU((byte)-1, sourceArray, sourcePosition, sourceLimit, null, value, useFallback, true);
            if (match == source.remaining() && CharsetMBCS.TO_U_IS_CODE_POINT(value[0])) {
                return CharsetMBCS.TO_U_GET_CODE_POINT(value[0]);
            }
            return 65534;
        }

        /*
         * Enabled aggressive block sorting
         */
        CoderResult cnvMBCSToUnicodeWithOffsets(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            int sourceArrayIndexStart;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int entry = 0;
            if (this.preToULength > 0) {
                cr[0] = this.continueMatchToU(source, target, offsets, -1, flush);
                if (cr[0].isError()) return cr[0];
                if (this.preToULength < 0) {
                    return cr[0];
                }
            }
            if (CharsetMBCS.this.sharedData.mbcs.countStates == 1) {
                if (!CharsetMBCS.this.sharedData.mbcs.hasSupplementary()) {
                    cr[0] = this.cnvMBCSSingleToBMPWithOffsets(source, target, offsets, flush);
                    return cr[0];
                }
                cr[0] = this.cnvMBCSSingleToUnicodeWithOffsets(source, target, offsets, flush);
                return cr[0];
            }
            int sourceArrayIndex = sourceArrayIndexStart = source.position();
            int[][] stateTable = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLStateTable : CharsetMBCS.this.sharedData.mbcs.stateTable;
            char[] unicodeCodeUnits = CharsetMBCS.this.sharedData.mbcs.unicodeCodeUnits;
            int offset = this.toUnicodeStatus;
            int byteIndex = this.toULength;
            byte[] bytes = this.toUBytesArray;
            byte state = (byte)this.mode;
            if (state == 0) {
                state = CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState;
            }
            int sourceIndex = byteIndex == 0 ? 0 : -1;
            int nextSourceIndex = 0;
            while (sourceArrayIndex < source.limit()) {
                block51: {
                    byte action;
                    block58: {
                        char c;
                        block55: {
                            block57: {
                                block56: {
                                    block54: {
                                        block52: {
                                            block53: {
                                                if (!target.hasRemaining()) {
                                                    cr[0] = CoderResult.OVERFLOW;
                                                    break;
                                                }
                                                if (byteIndex != 0) {
                                                    ++nextSourceIndex;
                                                    int n = byteIndex++;
                                                    byte by = source.get(sourceArrayIndex++);
                                                    bytes[n] = by;
                                                    entry = stateTable[state][by & 0xFF];
                                                } else {
                                                    do {
                                                        if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][source.get(sourceArrayIndex) & 0xFF])) {
                                                            state = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                            offset = CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                            if (++sourceArrayIndex < source.limit() && CharsetMBCS.MBCS_ENTRY_IS_FINAL(entry = stateTable[state][source.get(sourceArrayIndex) & 0xFF]) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 4 && (c = unicodeCodeUnits[offset + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)]) < '\ufffe') {
                                                                ++sourceArrayIndex;
                                                                target.put(c);
                                                                if (offsets != null) {
                                                                    offsets.put(sourceIndex);
                                                                    sourceIndex = nextSourceIndex += 2;
                                                                }
                                                                state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                                offset = 0;
                                                                continue;
                                                            }
                                                            ++nextSourceIndex;
                                                            bytes[0] = source.get(sourceArrayIndex - 1);
                                                            byteIndex = 1;
                                                            break;
                                                        }
                                                        if (!CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry)) break;
                                                        ++sourceArrayIndex;
                                                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                                                        if (offsets != null) {
                                                            offsets.put(sourceIndex);
                                                            sourceIndex = ++nextSourceIndex;
                                                        }
                                                        state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                    } while (sourceArrayIndex < source.limit() && target.hasRemaining());
                                                    if (sourceArrayIndex >= source.limit()) break;
                                                    if (!target.hasRemaining()) {
                                                        cr[0] = CoderResult.OVERFLOW;
                                                        break;
                                                    }
                                                    ++nextSourceIndex;
                                                    bytes[byteIndex++] = source.get(sourceArrayIndex++);
                                                }
                                                if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry)) {
                                                    state = (byte)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                                                    offset += CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                                                    continue;
                                                }
                                                this.mode = state;
                                                state = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_STATE(entry);
                                                action = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                                                if (action != 4) break block52;
                                                c = unicodeCodeUnits[offset += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)];
                                                if (c >= '\ufffe') break block53;
                                                target.put(c);
                                                if (offsets != null) {
                                                    offsets.put(sourceIndex);
                                                }
                                                byteIndex = 0;
                                                break block51;
                                            }
                                            if (c == '\ufffe') {
                                                if (this.isFallbackUsed() && (entry = this.getFallback(CharsetMBCS.this.sharedData.mbcs, offset)) != 65534) {
                                                    target.put((char)entry);
                                                    if (offsets != null) {
                                                        offsets.put(sourceIndex);
                                                    }
                                                    byteIndex = 0;
                                                }
                                                break block51;
                                            } else {
                                                cr[0] = CoderResult.malformedForLength(byteIndex);
                                            }
                                            break block51;
                                        }
                                        if (action != 0) break block54;
                                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                                        if (offsets != null) {
                                            offsets.put(sourceIndex);
                                        }
                                        byteIndex = 0;
                                        break block51;
                                    }
                                    if (action != 5) break block55;
                                    offset += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                                    if ((c = unicodeCodeUnits[offset++]) >= '\ud800') break block56;
                                    target.put(c);
                                    if (offsets != null) {
                                        offsets.put(sourceIndex);
                                    }
                                    byteIndex = 0;
                                    break block51;
                                }
                                if (!(this.isFallbackUsed() ? c <= '\udfff' : c <= '\udbff')) break block57;
                                target.put((char)(c & 0xDBFF));
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                }
                                byteIndex = 0;
                                if (target.hasRemaining()) {
                                    target.put(unicodeCodeUnits[offset]);
                                    if (offsets != null) {
                                        offsets.put(sourceIndex);
                                    }
                                    break block51;
                                } else {
                                    this.charErrorBufferArray[0] = unicodeCodeUnits[offset];
                                    this.charErrorBufferLength = 1;
                                    cr[0] = CoderResult.OVERFLOW;
                                    offset = 0;
                                    break;
                                }
                            }
                            if (this.isFallbackUsed() ? (c & 0xFFFE) == 57344 : c == '\ue000') {
                                target.put(unicodeCodeUnits[offset]);
                                if (offsets != null) {
                                    offsets.put(sourceIndex);
                                }
                                byteIndex = 0;
                                break block51;
                            } else if (c == '\uffff') {
                                cr[0] = CoderResult.malformedForLength(byteIndex);
                            }
                            break block51;
                        }
                        if (action != 1 && (action != 3 || !this.isFallbackUsed())) break block58;
                        entry = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry);
                        target.put((char)(0xD800 | (char)(entry >> 10)));
                        if (offsets != null) {
                            offsets.put(sourceIndex);
                        }
                        byteIndex = 0;
                        c = (char)(0xDC00 | (char)(entry & 0x3FF));
                        if (target.hasRemaining()) {
                            target.put(c);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            break block51;
                        } else {
                            this.charErrorBufferArray[0] = c;
                            this.charErrorBufferLength = 1;
                            cr[0] = CoderResult.OVERFLOW;
                            offset = 0;
                            break;
                        }
                    }
                    if (action == 8) {
                        if (CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState == 0) {
                            byteIndex = 0;
                        } else {
                            state = (byte)this.mode;
                            cr[0] = CoderResult.malformedForLength(byteIndex);
                        }
                    } else if (action == 2) {
                        if (this.isFallbackUsed()) {
                            target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            byteIndex = 0;
                        }
                    } else if (action != 6) {
                        if (action == 7) {
                            cr[0] = CoderResult.malformedForLength(byteIndex);
                        } else {
                            byteIndex = 0;
                        }
                    }
                }
                offset = 0;
                if (byteIndex == 0) {
                    sourceIndex = nextSourceIndex;
                    continue;
                }
                if (cr[0].isError()) {
                    int i;
                    if (byteIndex <= 1) break;
                    boolean isDBCSOnly = CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState != 0;
                    for (i = 1; i < byteIndex && !this.isSingleOrLead(stateTable, state, isDBCSOnly, (short)(bytes[i] & 0xFF)); i = (int)((byte)(i + 1))) {
                    }
                    if (i >= byteIndex) break;
                    byte backOutDistance = (byte)(byteIndex - i);
                    int bytesFromThisBuffer = sourceArrayIndex - sourceArrayIndexStart;
                    byteIndex = i;
                    if (backOutDistance <= bytesFromThisBuffer) {
                        sourceArrayIndex -= backOutDistance;
                        break;
                    }
                    this.preToULength = (byte)(bytesFromThisBuffer - backOutDistance);
                    for (int n = 0; n < -this.preToULength; ++n) {
                        this.preToUArray[n] = bytes[i + n];
                    }
                    sourceArrayIndex = sourceArrayIndexStart;
                    break;
                }
                int sourceBeginIndex = sourceArrayIndex;
                source.position(sourceArrayIndex);
                byteIndex = this.toU(byteIndex, source, target, offsets, sourceIndex, flush, cr);
                sourceArrayIndex = source.position();
                sourceIndex = nextSourceIndex += sourceArrayIndex - sourceBeginIndex;
                if (!cr[0].isError() && !cr[0].isOverflow()) continue;
            }
            this.toUnicodeStatus = offset;
            this.mode = state;
            this.toULength = byteIndex;
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private CoderResult cnvMBCSSingleToBMPWithOffsets(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            int count;
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            int targetCapacity = target.remaining();
            int[][] stateTable = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLStateTable : CharsetMBCS.this.sharedData.mbcs.stateTable;
            int sourceIndex = 0;
            int lastSource = sourceArrayIndex;
            int length = source.remaining();
            if (length < targetCapacity) {
                targetCapacity = length;
            }
            while (targetCapacity > 0 && sourceArrayIndex < source.limit()) {
                int entry;
                if (CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry = stateTable[0][source.get(sourceArrayIndex++) & 0xFF])) {
                    target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                    --targetCapacity;
                    continue;
                }
                byte action = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                if (action == 2) {
                    if (this.isFallbackUsed()) {
                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                        --targetCapacity;
                        continue;
                    }
                } else if (action != 6) {
                    if (action != 7) continue;
                    cr[0] = CoderResult.malformedForLength(sourceArrayIndex - lastSource);
                }
                if (offsets != null) {
                    count = sourceArrayIndex - lastSource;
                    while (--count > 0) {
                        offsets.put(sourceIndex++);
                    }
                }
                if (cr[0].isError()) break;
                lastSource = sourceArrayIndex;
                this.toUBytesArray[0] = source.get(sourceArrayIndex - 1);
                source.position(sourceArrayIndex);
                this.toULength = this.toU(1, source, target, offsets, sourceIndex, flush, cr);
                sourceArrayIndex = source.position();
                sourceIndex += 1 + (sourceArrayIndex - lastSource);
                if (cr[0].isError()) break;
                targetCapacity = target.remaining();
                length = source.remaining();
                if (length >= targetCapacity) continue;
                targetCapacity = length;
            }
            if (!cr[0].isError() && sourceArrayIndex < source.limit() && !target.hasRemaining()) {
                cr[0] = CoderResult.OVERFLOW;
            }
            if (offsets != null) {
                for (count = sourceArrayIndex - lastSource; count > 0; --count) {
                    offsets.put(sourceIndex++);
                }
            }
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private CoderResult cnvMBCSSingleToUnicodeWithOffsets(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult[] cr = new CoderResult[]{CoderResult.UNDERFLOW};
            int sourceArrayIndex = source.position();
            int[][] stateTable = (CharsetMBCS.this.options & 0x10) != 0 ? CharsetMBCS.this.sharedData.mbcs.swapLFNLStateTable : CharsetMBCS.this.sharedData.mbcs.stateTable;
            int sourceIndex = 0;
            while (sourceArrayIndex < source.limit()) {
                int entry;
                if (!target.hasRemaining()) {
                    cr[0] = CoderResult.OVERFLOW;
                    break;
                }
                if (CharsetMBCS.MBCS_ENTRY_FINAL_IS_VALID_DIRECT_16(entry = stateTable[0][source.get(sourceArrayIndex++) & 0xFF])) {
                    target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                    if (offsets != null) {
                        offsets.put(sourceIndex);
                    }
                    ++sourceIndex;
                    continue;
                }
                byte action = (byte)CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
                if (action == 1 || action == 3 && this.isFallbackUsed()) {
                    entry = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry);
                    target.put((char)(0xD800 | (char)(entry >>> 10)));
                    if (offsets != null) {
                        offsets.put(sourceIndex);
                    }
                    char c = (char)(0xDC00 | (char)(entry & 0x3FF));
                    if (target.hasRemaining()) {
                        target.put(c);
                        if (offsets != null) {
                            offsets.put(sourceIndex);
                        }
                    } else {
                        this.charErrorBufferArray[0] = c;
                        this.charErrorBufferLength = 1;
                        cr[0] = CoderResult.OVERFLOW;
                        break;
                    }
                    ++sourceIndex;
                    continue;
                }
                if (action == 2) {
                    if (this.isFallbackUsed()) {
                        target.put(CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry));
                        if (offsets != null) {
                            offsets.put(sourceIndex);
                        }
                        ++sourceIndex;
                        continue;
                    }
                } else if (action != 6) {
                    if (action == 7) {
                        cr[0] = CoderResult.malformedForLength(1);
                    } else {
                        ++sourceIndex;
                        continue;
                    }
                }
                if (cr[0].isError()) break;
                int sourceBeginIndex = sourceArrayIndex;
                this.toUBytesArray[0] = source.get(sourceArrayIndex - 1);
                source.position(sourceArrayIndex);
                this.toULength = this.toU(1, source, target, offsets, sourceIndex, flush, cr);
                sourceArrayIndex = source.position();
                sourceIndex += 1 + (sourceArrayIndex - sourceBeginIndex);
                if (!cr[0].isError()) continue;
                break;
            }
            source.position(sourceArrayIndex);
            return cr[0];
        }

        private int getFallback(UConverterMBCSTable mbcsTable, int offset) {
            int limit = mbcsTable.countToUFallbacks;
            if (limit > 0) {
                MBCSToUFallback[] toUFallbacks = mbcsTable.toUFallbacks;
                int start = 0;
                while (start < limit - 1) {
                    int i = start + limit >>> 1;
                    if (offset < toUFallbacks[i].offset) {
                        limit = i;
                        continue;
                    }
                    start = i;
                }
                if (offset == toUFallbacks[start].offset) {
                    return toUFallbacks[start].codePoint;
                }
            }
            return 65534;
        }

        int simpleGetNextUChar(ByteBuffer source, boolean useFallback) {
            int c;
            int entry;
            int[][] stateTable = CharsetMBCS.this.sharedData.mbcs.stateTable;
            char[] unicodeCodeUnits = CharsetMBCS.this.sharedData.mbcs.unicodeCodeUnits;
            int offset = 0;
            int state = CharsetMBCS.this.sharedData.mbcs.dbcsOnlyState;
            int i = source.position();
            int length = source.limit() - i;
            while (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry = stateTable[state][source.get(i++) & 0xFF])) {
                state = CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry);
                offset += CharsetMBCS.MBCS_ENTRY_TRANSITION_OFFSET(entry);
                if (i != source.limit()) continue;
                return 65535;
            }
            int action = CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
            if (action == 4) {
                c = unicodeCodeUnits[offset += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry)];
                if (c == 65534 && CharsetDecoderMBCS.isToUUseFallback()) {
                    c = this.getFallback(CharsetMBCS.this.sharedData.mbcs, offset);
                }
            } else if (action == 0) {
                c = CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
            } else if (action == 5) {
                offset += CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
                if ((c = unicodeCodeUnits[offset++]) >= 55296) {
                    if (CharsetDecoderMBCS.isToUUseFallback() ? c <= 57343 : c <= 56319) {
                        c = ((c & 0x3FF) << 10) + unicodeCodeUnits[offset] + 9216;
                    } else if (CharsetDecoderMBCS.isToUUseFallback() ? (c & 0xFFFE) == 57344 : c == 57344) {
                        c = unicodeCodeUnits[offset];
                    } else {
                        if (c == 65535) {
                            return 65535;
                        }
                        c = 65534;
                    }
                }
            } else if (action == 1) {
                c = 65536 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry);
            } else if (action == 2) {
                c = !CharsetDecoderMBCS.isToUUseFallback(useFallback) ? 65534 : (int)CharsetMBCS.MBCS_ENTRY_FINAL_VALUE_16(entry);
            } else if (action == 3) {
                c = !CharsetDecoderMBCS.isToUUseFallback(useFallback) ? 65534 : 65536 + CharsetMBCS.MBCS_ENTRY_FINAL_VALUE(entry);
            } else if (action == 6) {
                c = 65534;
            } else {
                return 65535;
            }
            if (i != source.limit()) {
                return 65535;
            }
            if (c == 65534 && CharsetMBCS.this.sharedData.mbcs.extIndexes != null) {
                if (source.limit() > i + length) {
                    source.limit(i + length);
                }
                return this.simpleMatchToU(source, useFallback);
            }
            return c;
        }

        private boolean hasValidTrailBytes(int[][] stateTable, short state) {
            int b;
            int[] row = stateTable[state];
            int entry = row[161];
            if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) != 7) {
                return true;
            }
            entry = row[65];
            if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry) && CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) != 7) {
                return true;
            }
            for (b = 0; b <= 255; ++b) {
                entry = row[b];
                if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry) || CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry) == 7) continue;
                return true;
            }
            for (b = 0; b <= 255; ++b) {
                entry = row[b];
                if (!CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry) || !this.hasValidTrailBytes(stateTable, (short)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry))) continue;
                return true;
            }
            return false;
        }

        private boolean isSingleOrLead(int[][] stateTable, int state, boolean isDBCSOnly, int b) {
            int[] row = stateTable[state];
            int entry = row[b];
            if (CharsetMBCS.MBCS_ENTRY_IS_TRANSITION(entry)) {
                return this.hasValidTrailBytes(stateTable, (short)CharsetMBCS.MBCS_ENTRY_TRANSITION_STATE(entry));
            }
            int action = CharsetMBCS.MBCS_ENTRY_FINAL_ACTION(entry);
            if (action == 8 && isDBCSOnly) {
                return false;
            }
            return action != 7;
        }
    }

    private static enum SISO_Option {
        SI,
        SO;

    }

    static final class MBCSHeader {
        byte[] version = new byte[4];
        int countStates;
        int countToUFallbacks;
        int offsetToUCodeUnits;
        int offsetFromUTable;
        int offsetFromUBytes;
        int flags;
        int fromUBytesLength;
        int options;
        int fullStage2Length;

        MBCSHeader() {
        }
    }

    static final class UConverterMBCSTable {
        short countStates;
        byte dbcsOnlyState;
        boolean stateTableOwned;
        int countToUFallbacks;
        int[][] stateTable;
        int[][] swapLFNLStateTable;
        char[] unicodeCodeUnits;
        MBCSToUFallback[] toUFallbacks;
        char[] fromUnicodeTable;
        int[] fromUnicodeTableInts;
        byte[] fromUnicodeBytes;
        char[] fromUnicodeChars;
        int[] fromUnicodeInts;
        char[] swapLFNLFromUnicodeChars;
        int fromUBytesLength;
        short outputType;
        short unicodeMask;
        String swapLFNLName;
        UConverterSharedData baseSharedData;
        ByteBuffer extIndexes;
        CharBuffer mbcsIndex = null;
        boolean utf8Friendly = false;
        char maxFastUChar;
        int asciiRoundtrips;

        UConverterMBCSTable() {
        }

        boolean hasSupplementary() {
            return (this.unicodeMask & 1) != 0;
        }
    }

    static final class MBCSToUFallback {
        int offset;
        int codePoint;

        MBCSToUFallback(int off, int cp) {
            this.offset = off;
            this.codePoint = cp;
        }
    }
}

