/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetSCSU
extends CharsetICU {
    private static final short SQ0 = 1;
    private static final short SQ7 = 8;
    private static final short SDX = 11;
    private static final short SQU = 14;
    private static final short SCU = 15;
    private static final short SC0 = 16;
    private static final short SC7 = 23;
    private static final short SD0 = 24;
    private static final short UC0 = 224;
    private static final short UC7 = 231;
    private static final short UD0 = 232;
    private static final short UD7 = 239;
    private static final short UQU = 240;
    private static final short UDX = 241;
    private static final short Urs = 242;
    private static final int gapThreshold = 104;
    private static final int gapOffset = 44032;
    private static final int reservedStart = 168;
    private static final int fixedThreshold = 249;
    protected byte[] fromUSubstitution = new byte[]{14, -1, -3};
    private static final int[] staticOffsets = new int[]{0, 128, 256, 768, 8192, 8320, 8448, 12288};
    private static final int[] initialDynamicOffsets = new int[]{128, 192, 1024, 1536, 2304, 12352, 12448, 65280};
    private static final int[] fixedOffsets = new int[]{192, 592, 880, 1328, 12352, 12448, 65376};
    private static final int readCommand = 0;
    private static final int quotePairOne = 1;
    private static final int quotePairTwo = 2;
    private static final int quoteOne = 3;
    private static final int definePairOne = 4;
    private static final int definePairTwo = 5;
    private static final int defineOne = 6;
    static final byte[] initialWindowUse = new byte[]{7, 0, 3, 2, 4, 5, 6, 1};
    private SCSUData extraInfo = null;

    public CharsetSCSU(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.extraInfo = new SCSUData();
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderSCSU(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderSCSU(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        CharsetICU.getCompleteUnicodeSet(setFillIn);
    }

    class CharsetEncoderSCSU
    extends CharsetEncoderICU {
        private static final int Loop = 0;
        private static final int GetTrailUnicode = 1;
        private static final int OutputBytes = 2;
        private static final int EndLoop = 3;
        private int delta;
        private int length;
        private int offset;
        private char lead;
        private char trail;
        private int code;
        private byte window;
        private boolean isSingleByteMode;
        private byte dynamicWindow;
        private int currentOffset;
        int c;
        SCSUData data;
        private int sourceIndex;
        private int nextSourceIndex;
        private int targetCapacity;
        private boolean LabelLoop;
        private boolean AfterGetTrail;
        private boolean AfterGetTrailUnicode;
        CoderResult cr;

        public CharsetEncoderSCSU(CharsetICU cs) {
            super(cs, CharsetSCSU.this.fromUSubstitution);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            CharsetSCSU.this.extraInfo.initialize();
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            this.data = CharsetSCSU.this.extraInfo;
            this.cr = CoderResult.UNDERFLOW;
            this.isSingleByteMode = this.data.fromUIsSingleByteMode;
            this.dynamicWindow = this.data.fromUDynamicWindow;
            this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
            this.c = this.fromUChar32;
            this.sourceIndex = this.c == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            this.targetCapacity = target.limit() - target.position();
            this.sourceIndex = this.c == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            int labelType = 0;
            this.LabelLoop = true;
            this.AfterGetTrail = false;
            this.AfterGetTrailUnicode = false;
            while (this.LabelLoop) {
                switch (labelType) {
                    case 0: {
                        labelType = this.loop(source, target, offsets);
                        break;
                    }
                    case 1: {
                        labelType = this.getTrailUnicode(source, target, offsets);
                        break;
                    }
                    case 2: {
                        labelType = this.outputBytes(source, target, offsets);
                        break;
                    }
                    case 3: {
                        this.endLoop(source, target, offsets);
                    }
                }
            }
            return this.cr;
        }

        private byte getWindow(int[] offsets) {
            for (int i = 0; i < 8; ++i) {
                if (((long)(this.c - offsets[i]) & 0xFFFFFFFFL) > 127L) continue;
                return (byte)i;
            }
            return -1;
        }

        private boolean isInOffsetWindowOrDirect(int offsetValue, int a) {
            return ((long)a & 0xFFFFFFFFL) <= ((long)offsetValue & 0xFFFFFFFFL) + 127L & (((long)a & 0xFFFFFFFFL) >= ((long)offsetValue & 0xFFFFFFFFL) || ((long)a & 0xFFFFFFFFL) <= 127L && (((long)a & 0xFFFFFFFFL) >= 32L || (1L << (int)((long)a & 0xFFFFFFFFL) & 0x2601L) != 0L));
        }

        private byte getNextDynamicWindow() {
            byte windowValue = this.data.windowUse[this.data.nextWindowUseIndex];
            this.data.nextWindowUseIndex = (byte)(this.data.nextWindowUseIndex + 1);
            if (this.data.nextWindowUseIndex == 8) {
                this.data.nextWindowUseIndex = 0;
            }
            return windowValue;
        }

        private void useDynamicWindow(byte windowValue) {
            int i = this.data.nextWindowUseIndex;
            do {
                if (--i >= 0) continue;
                i = 7;
            } while (this.data.windowUse[i] != windowValue);
            int j = i + 1;
            if (j == 8) {
                j = 0;
            }
            while (j != this.data.nextWindowUseIndex) {
                this.data.windowUse[i] = this.data.windowUse[j];
                i = j++;
                if (j != 8) continue;
                j = 0;
            }
            this.data.windowUse[i] = windowValue;
        }

        private int getDynamicOffset() {
            for (int i = 0; i < 7; ++i) {
                if (((long)(this.c - fixedOffsets[i]) & 0xFFFFFFFFL) > 127L) continue;
                this.offset = fixedOffsets[i];
                return 249 + i;
            }
            if (((long)this.c & 0xFFFFFFFFL) < 128L) {
                return -1;
            }
            if (((long)this.c & 0xFFFFFFFFL) < 13312L || ((long)(this.c - 65536) & 0xFFFFFFFFL) < 16384L || ((long)(this.c - 118784) & 0xFFFFFFFFL) <= 12287L) {
                this.offset = this.c & 0x7FFFFF80;
                return this.c >> 7;
            }
            if (57344L <= ((long)this.c & 0xFFFFFFFFL) && ((long)this.c & 0xFFFFFFFFL) != 65279L && ((long)this.c & 0xFFFFFFFFL) < 65520L) {
                this.offset = this.c & 0x7FFFFF80;
                return this.c - 44032 >> 7;
            }
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int loop(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            int label = 0;
            if (!this.isSingleByteMode) {
                if (this.c != 0 && this.targetCapacity > 0 && !this.AfterGetTrailUnicode) {
                    return 1;
                }
            } else {
                if (this.c != 0 && this.targetCapacity > 0 && !this.AfterGetTrail) {
                    return this.getTrail(source, target, offsets);
                }
                while (true) {
                    block51: {
                        if (!this.AfterGetTrail) {
                            if (!source.hasRemaining()) return 3;
                        }
                        if (this.targetCapacity <= 0 && !this.AfterGetTrail) {
                            this.cr = CoderResult.OVERFLOW;
                            return 3;
                        }
                        if (!this.AfterGetTrail) {
                            this.c = source.get();
                            ++this.nextSourceIndex;
                        }
                        if (((long)(this.c - 32) & 0xFFFFFFFFL) <= 95L && !this.AfterGetTrail) {
                            target.put((byte)this.c);
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                            --this.targetCapacity;
                        } else if (((long)this.c & 0xFFFFFFFFL) < 32L && !this.AfterGetTrail) {
                            if ((1L << (int)((long)this.c & 0xFFFFFFFFL) & 0x2601L) == 0L) {
                                this.c |= 0x100;
                                this.length = 2;
                                return 2;
                            }
                            target.put((byte)this.c);
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                            --this.targetCapacity;
                        } else {
                            this.delta = this.c - this.currentOffset;
                            if (((long)this.delta & 0xFFFFFFFFL) <= 127L && !this.AfterGetTrail) {
                                target.put((byte)(this.delta | 0x80));
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                                --this.targetCapacity;
                            } else {
                                if (this.AfterGetTrail || UTF16.isSurrogate((int)this.c)) {
                                    if (!this.AfterGetTrail) {
                                        if (!UTF16.isLeadSurrogate((int)this.c)) {
                                            this.cr = CoderResult.malformedForLength(1);
                                            return 3;
                                        }
                                        label = this.getTrail(source, target, offsets);
                                        if (label == 3) {
                                            return label;
                                        }
                                    }
                                    if (this.AfterGetTrail) {
                                        this.AfterGetTrail = false;
                                    }
                                    if (((long)(this.delta = this.c - this.currentOffset) & 0xFFFFFFFFL) <= 127L) {
                                        target.put((byte)(this.delta | 0x80));
                                        if (offsets != null) {
                                            offsets.put(this.sourceIndex);
                                        }
                                        --this.targetCapacity;
                                        break block51;
                                    } else {
                                        this.window = this.getWindow(this.data.fromUDynamicOffsets);
                                        if (this.window >= 0) {
                                            this.dynamicWindow = this.window;
                                            this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                                            this.useDynamicWindow(this.dynamicWindow);
                                            this.c = 16 + this.dynamicWindow << 8 | this.c - this.currentOffset | 0x80;
                                            this.length = 2;
                                            return 2;
                                        }
                                        this.code = this.getDynamicOffset();
                                        if (this.code >= 0) {
                                            this.code -= 512;
                                            this.dynamicWindow = this.getNextDynamicWindow();
                                            this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                                            this.useDynamicWindow(this.dynamicWindow);
                                            this.c = 0xB000000 | this.dynamicWindow << 21 | this.code << 8 | this.c - this.currentOffset | 0x80;
                                            this.length = 4;
                                            return 2;
                                        }
                                        this.isSingleByteMode = false;
                                        target.put((byte)15);
                                        if (offsets != null) {
                                            offsets.put(this.sourceIndex);
                                        }
                                        --this.targetCapacity;
                                        this.c = this.lead << 16 | this.trail;
                                        this.length = 4;
                                        return 2;
                                    }
                                }
                                if (((long)this.c & 0xFFFFFFFFL) < 160L) {
                                    this.c = this.c & 0x7F | 0x200;
                                    this.length = 2;
                                    return 2;
                                }
                                if (((long)this.c & 0xFFFFFFFFL) == 65279L || ((long)this.c & 0xFFFFFFFFL) >= 65520L) {
                                    this.c |= 0xE0000;
                                    this.length = 3;
                                    return 2;
                                }
                                this.window = this.getWindow(this.data.fromUDynamicOffsets);
                                if (this.window >= 0) {
                                    if (source.position() < source.limit() && !this.isInOffsetWindowOrDirect(this.data.fromUDynamicOffsets[this.window], source.get(source.position()))) {
                                        this.c = 1 + this.window << 8 | this.c - this.data.fromUDynamicOffsets[this.window] | 0x80;
                                        this.length = 2;
                                        return 2;
                                    }
                                    this.dynamicWindow = this.window;
                                    this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                                    this.useDynamicWindow(this.dynamicWindow);
                                    this.c = 16 + this.window << 8 | this.c - this.currentOffset | 0x80;
                                    this.length = 2;
                                    return 2;
                                }
                                this.window = this.getWindow(staticOffsets);
                                if (this.window >= 0) {
                                    this.c = 1 + this.window << 8 | this.c - staticOffsets[this.window];
                                    this.length = 2;
                                    return 2;
                                }
                                this.code = this.getDynamicOffset();
                                if (this.code >= 0) {
                                    this.dynamicWindow = this.getNextDynamicWindow();
                                    this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                                    this.useDynamicWindow(this.dynamicWindow);
                                    this.c = 24 + this.dynamicWindow << 16 | this.code << 8 | this.c - this.currentOffset | 0x80;
                                    this.length = 3;
                                    return 2;
                                }
                                if ((int)((long)(this.c - 13312) & 0xFFFFFFFFL) < 41984 && (source.position() >= source.limit() || (int)((long)(source.get(source.position()) - 13312) & 0xFFFFFFFFL) < 41984)) {
                                    this.isSingleByteMode = false;
                                    this.c |= 0xF0000;
                                    this.length = 3;
                                    return 2;
                                }
                                this.c |= 0xE0000;
                                this.length = 3;
                                return 2;
                            }
                        }
                    }
                    this.c = 0;
                    this.sourceIndex = this.nextSourceIndex;
                }
            }
            while (true) {
                if (!this.AfterGetTrailUnicode) {
                    if (!source.hasRemaining()) return 3;
                }
                if (this.targetCapacity <= 0 && !this.AfterGetTrailUnicode) break;
                if (!this.AfterGetTrailUnicode) {
                    this.c = source.get();
                    ++this.nextSourceIndex;
                }
                if (((long)(this.c - 13312) & 0xFFFFFFFFL) < 41984L && !this.AfterGetTrailUnicode) {
                    if (this.targetCapacity < 2) {
                        this.length = 2;
                        return 2;
                    }
                    target.put((byte)(this.c >> 8));
                    target.put((byte)this.c);
                    if (offsets != null) {
                        offsets.put(this.sourceIndex);
                        offsets.put(this.sourceIndex);
                    }
                    this.targetCapacity -= 2;
                } else {
                    if (((long)(this.c - 13312) & 0xFFFFFFFFL) >= 48896L && !this.AfterGetTrailUnicode) {
                        if (!source.hasRemaining() || ((long)(source.get(source.position()) - 13312) & 0xFFFFFFFFL) >= 41984L) {
                            if (((long)(this.c - 48) & 0xFFFFFFFFL) < 10L || ((long)(this.c - 97) & 0xFFFFFFFFL) < 26L || ((long)(this.c - 65) & 0xFFFFFFFFL) < 26L) {
                                this.isSingleByteMode = true;
                                this.c |= 224 + this.dynamicWindow << 8 | this.c;
                                this.length = 2;
                                return 2;
                            }
                            this.window = this.getWindow(this.data.fromUDynamicOffsets);
                            if (this.window >= 0) {
                                this.isSingleByteMode = true;
                                this.dynamicWindow = this.window;
                                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                                this.useDynamicWindow(this.dynamicWindow);
                                this.c = 224 + this.dynamicWindow << 8 | this.c - this.currentOffset | 0x80;
                                this.length = 2;
                                return 2;
                            }
                            this.code = this.getDynamicOffset();
                            if (this.code >= 0) {
                                this.isSingleByteMode = true;
                                this.dynamicWindow = this.getNextDynamicWindow();
                                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                                this.useDynamicWindow(this.dynamicWindow);
                                this.c = 232 + this.dynamicWindow << 16 | this.code << 8 | this.c - this.currentOffset | 0x80;
                                this.length = 3;
                                return 2;
                            }
                        }
                        this.length = 2;
                        return 2;
                    }
                    if (this.c < 57344 && !this.AfterGetTrailUnicode) {
                        return 1;
                    }
                    if (!this.AfterGetTrailUnicode) {
                        this.c |= 0xF00000;
                        this.length = 3;
                        return 2;
                    }
                }
                if (this.AfterGetTrailUnicode) {
                    this.AfterGetTrailUnicode = false;
                }
                this.c = 0;
                this.sourceIndex = this.nextSourceIndex;
            }
            this.cr = CoderResult.OVERFLOW;
            this.LabelLoop = false;
            return 3;
        }

        private int getTrail(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            this.lead = (char)this.c;
            int label = 0;
            if (source.hasRemaining()) {
                this.trail = source.get(source.position());
                if (UTF16.isTrailSurrogate((int)this.trail)) {
                    source.position(source.position() + 1);
                    ++this.nextSourceIndex;
                    this.c = UCharacter.getCodePoint((int)this.c, (int)this.trail);
                    label = 0;
                } else {
                    this.cr = CoderResult.malformedForLength(1);
                    label = 3;
                }
            } else {
                label = 3;
            }
            this.AfterGetTrail = true;
            return label;
        }

        /*
         * Enabled aggressive block sorting
         */
        private int getTrailUnicode(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            int label = 3;
            this.AfterGetTrailUnicode = true;
            if (!UTF16.isLeadSurrogate((int)this.c)) {
                this.cr = CoderResult.malformedForLength(1);
                return 3;
            }
            this.lead = (char)this.c;
            if (!source.hasRemaining()) {
                return 3;
            }
            this.trail = source.get(source.position());
            if (!UTF16.isTrailSurrogate((int)this.trail)) {
                this.cr = CoderResult.malformedForLength(1);
                return 3;
            }
            source.get();
            ++this.nextSourceIndex;
            this.c = UCharacter.getCodePoint((int)this.c, (int)this.trail);
            this.window = this.getWindow(this.data.fromUDynamicOffsets);
            if (!(this.window < 0 || source.hasRemaining() && ((long)(source.get(source.position()) - 13312) & 0xFFFFFFFFL) < 41984L)) {
                this.isSingleByteMode = true;
                this.dynamicWindow = this.window;
                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow];
                this.useDynamicWindow(this.dynamicWindow);
                this.c = 224 + this.dynamicWindow << 8 | this.c - this.currentOffset | 0x80;
                this.length = 2;
                return 2;
            }
            if (source.hasRemaining() && this.lead == source.get(source.position()) && (this.code = this.getDynamicOffset()) >= 0) {
                this.isSingleByteMode = true;
                this.dynamicWindow = this.getNextDynamicWindow();
                this.currentOffset = this.data.fromUDynamicOffsets[this.dynamicWindow] = this.offset;
                this.useDynamicWindow(this.dynamicWindow);
                this.c = 0xF1000000 | this.dynamicWindow << 21 | this.code << 8 | this.c - this.currentOffset | 0x80;
                this.length = 4;
                return 2;
            }
            this.c = this.lead << 16 | this.trail;
            this.length = 4;
            return 2;
        }

        private void endLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            this.data.fromUIsSingleByteMode = this.isSingleByteMode;
            this.data.fromUDynamicWindow = this.dynamicWindow;
            this.fromUChar32 = this.c;
            this.LabelLoop = false;
        }

        private int outputBytes(CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            if (this.length <= this.targetCapacity) {
                switch (this.length) {
                    case 4: {
                        target.put((byte)(this.c >> 24));
                        if (offsets != null) {
                            offsets.put(this.sourceIndex);
                        }
                    }
                    case 3: {
                        target.put((byte)(this.c >> 16));
                        if (offsets != null) {
                            offsets.put(this.sourceIndex);
                        }
                    }
                    case 2: {
                        target.put((byte)(this.c >> 8));
                        if (offsets != null) {
                            offsets.put(this.sourceIndex);
                        }
                    }
                    case 1: {
                        target.put((byte)this.c);
                        if (offsets == null) break;
                        offsets.put(this.sourceIndex);
                    }
                }
                this.targetCapacity -= this.length;
                this.c = 0;
                this.sourceIndex = this.nextSourceIndex;
                int label = 0;
                return label;
            }
            ByteBuffer p = ByteBuffer.wrap(this.errorBuffer);
            this.length -= this.targetCapacity;
            switch (this.length) {
                case 4: {
                    p.put((byte)(this.c >> 24));
                }
                case 3: {
                    p.put((byte)(this.c >> 16));
                }
                case 2: {
                    p.put((byte)(this.c >> 8));
                }
                case 1: {
                    p.put((byte)this.c);
                }
            }
            this.errorBufferLength = this.length;
            this.c >>= 8 * this.length;
            switch (this.targetCapacity) {
                case 3: {
                    target.put((byte)(this.c >> 16));
                    if (offsets != null) {
                        offsets.put(this.sourceIndex);
                    }
                }
                case 2: {
                    target.put((byte)(this.c >> 8));
                    if (offsets != null) {
                        offsets.put(this.sourceIndex);
                    }
                }
                case 1: {
                    target.put((byte)this.c);
                    if (offsets == null) break;
                    offsets.put(this.sourceIndex);
                }
            }
            this.targetCapacity = 0;
            this.cr = CoderResult.OVERFLOW;
            this.c = 0;
            int label = 3;
            return label;
        }
    }

    class CharsetDecoderSCSU
    extends CharsetDecoderICU {
        private static final int FastSingle = 0;
        private static final int SingleByteMode = 1;
        private static final int EndLoop = 2;
        private static final int ByteMode = 0;
        private static final int UnicodeMode = 1;
        short b;
        private boolean isSingleByteMode;
        private short state;
        private byte quoteWindow;
        private byte dynamicWindow;
        private short byteOne;
        private int sourceIndex;
        private int nextSourceIndex;
        CoderResult cr;
        SCSUData data;
        private boolean LabelLoop;

        public CharsetDecoderSCSU(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.toULength = 0;
            CharsetSCSU.this.extraInfo.initialize();
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            this.data = CharsetSCSU.this.extraInfo;
            this.isSingleByteMode = this.data.toUIsSingleByteMode;
            this.state = this.data.toUState;
            this.quoteWindow = this.data.toUQuoteWindow;
            this.dynamicWindow = this.data.toUDynamicWindow;
            this.byteOne = this.data.toUByteOne;
            this.LabelLoop = true;
            this.sourceIndex = this.data.toUState == 0 ? 0 : -1;
            this.nextSourceIndex = 0;
            this.cr = CoderResult.UNDERFLOW;
            int labelType = 0;
            while (this.LabelLoop) {
                if (this.isSingleByteMode) {
                    switch (labelType) {
                        case 0: {
                            labelType = this.fastSingle(source, target, offsets, 0);
                            break;
                        }
                        case 1: {
                            labelType = this.singleByteMode(source, target, offsets, 0);
                            break;
                        }
                        case 2: {
                            this.endLoop(source, target, offsets);
                        }
                    }
                    continue;
                }
                switch (labelType) {
                    case 0: {
                        labelType = this.fastSingle(source, target, offsets, 1);
                        break;
                    }
                    case 1: {
                        labelType = this.singleByteMode(source, target, offsets, 1);
                        break;
                    }
                    case 2: {
                        this.endLoop(source, target, offsets);
                    }
                }
            }
            return this.cr;
        }

        private int fastSingle(ByteBuffer source, CharBuffer target, IntBuffer offsets, int modeType) {
            int label = 0;
            if (modeType == 0) {
                if (this.state == 0) {
                    while (source.hasRemaining() && target.hasRemaining() && (this.b = (short)(source.get(source.position()) & 0xFF)) >= 32) {
                        source.position(source.position() + 1);
                        ++this.nextSourceIndex;
                        if (this.b <= 127) {
                            target.put((char)this.b);
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                        } else {
                            int c = this.data.toUDynamicOffsets[this.dynamicWindow] + (this.b & 0x7F);
                            if (c <= 65535) {
                                target.put((char)c);
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                            } else {
                                target.put((char)(55232 + (c >> 10)));
                                if (target.hasRemaining()) {
                                    target.put((char)(0xDC00 | c & 0x3FF));
                                    if (offsets != null) {
                                        offsets.put(this.sourceIndex);
                                        offsets.put(this.sourceIndex);
                                    }
                                } else {
                                    if (offsets != null) {
                                        offsets.put(this.sourceIndex);
                                    }
                                    this.charErrorBufferArray[0] = (char)(0xDC00 | c & 0x3FF);
                                    this.charErrorBufferLength = 1;
                                    label = 2;
                                    this.cr = CoderResult.OVERFLOW;
                                    return label;
                                }
                            }
                        }
                        this.sourceIndex = this.nextSourceIndex;
                    }
                }
            } else if (modeType == 1 && this.state == 0) {
                while (source.position() + 1 < source.limit() && target.hasRemaining() && ((this.b = (short)source.get(source.position())) - 224 & 0xFF) > 18) {
                    target.put((char)(this.b << 8 | source.get(source.position() + 1) & 0xFF));
                    if (offsets != null) {
                        offsets.put(this.sourceIndex);
                    }
                    this.sourceIndex = this.nextSourceIndex;
                    this.nextSourceIndex += 2;
                    source.position(source.position() + 2);
                }
            }
            label = 1;
            return label;
        }

        private int singleByteMode(ByteBuffer source, CharBuffer target, IntBuffer offsets, int modeType) {
            int label = 1;
            if (modeType == 0) {
                while (source.hasRemaining()) {
                    if (!target.hasRemaining()) {
                        this.cr = CoderResult.OVERFLOW;
                        label = 2;
                        return label;
                    }
                    this.b = (short)(source.get() & 0xFF);
                    ++this.nextSourceIndex;
                    switch (this.state) {
                        case 0: {
                            if ((1L << this.b & 0x2601L) != 0L) {
                                target.put((char)this.b);
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                                this.sourceIndex = this.nextSourceIndex;
                                label = 0;
                                return label;
                            }
                            if (16 <= this.b) {
                                if (this.b <= 23) {
                                    this.dynamicWindow = (byte)(this.b - 16);
                                    this.sourceIndex = this.nextSourceIndex;
                                    label = 0;
                                    return label;
                                }
                                this.dynamicWindow = (byte)(this.b - 24);
                                this.state = (short)6;
                            } else if (this.b <= 8) {
                                this.quoteWindow = (byte)(this.b - 1);
                                this.state = (short)3;
                            } else if (this.b == 11) {
                                this.state = (short)4;
                            } else if (this.b == 14) {
                                this.state = 1;
                            } else {
                                if (this.b == 15) {
                                    this.sourceIndex = this.nextSourceIndex;
                                    this.isSingleByteMode = false;
                                    label = 0;
                                    return label;
                                }
                                this.cr = CoderResult.malformedForLength(1);
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                label = 2;
                                return label;
                            }
                            this.toUBytesArray[0] = (byte)this.b;
                            this.toULength = 1;
                            break;
                        }
                        case 1: {
                            this.byteOne = this.b;
                            this.toUBytesArray[1] = (byte)this.b;
                            this.toULength = 2;
                            this.state = (short)2;
                            break;
                        }
                        case 2: {
                            target.put((char)(this.byteOne << 8 | this.b));
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            label = 0;
                            return label;
                        }
                        case 3: {
                            if (this.b < 128) {
                                target.put((char)(staticOffsets[this.quoteWindow] + this.b));
                                if (offsets != null) {
                                    offsets.put(this.sourceIndex);
                                }
                            } else {
                                int c = this.data.toUDynamicOffsets[this.quoteWindow] + (this.b & 0x7F);
                                if (c <= 65535) {
                                    target.put((char)c);
                                    if (offsets != null) {
                                        offsets.put(this.sourceIndex);
                                    }
                                } else {
                                    target.put((char)(55232 + (c >> 10)));
                                    if (target.hasRemaining()) {
                                        target.put((char)(0xDC00 | c & 0x3FF));
                                        if (offsets != null) {
                                            offsets.put(this.sourceIndex);
                                            offsets.put(this.sourceIndex);
                                        }
                                    } else {
                                        if (offsets != null) {
                                            offsets.put(this.sourceIndex);
                                        }
                                        this.charErrorBufferArray[0] = (char)(0xDC00 | c & 0x3FF);
                                        this.charErrorBufferLength = 1;
                                        label = 2;
                                        this.cr = CoderResult.OVERFLOW;
                                        this.LabelLoop = false;
                                        return label;
                                    }
                                }
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            label = 0;
                            return label;
                        }
                        case 4: {
                            this.dynamicWindow = (byte)(this.b >> 5 & 7);
                            this.byteOne = (byte)(this.b & 0x1F);
                            this.toUBytesArray[1] = (byte)this.b;
                            this.toULength = 2;
                            this.state = (short)5;
                            break;
                        }
                        case 5: {
                            this.data.toUDynamicOffsets[this.dynamicWindow] = 65536 + (this.byteOne << 15 | this.b << 7);
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            label = 0;
                            return label;
                        }
                        case 6: {
                            if (this.b == 0) {
                                this.toUBytesArray[1] = (byte)this.b;
                                this.toULength = 2;
                                label = 2;
                                return label;
                            }
                            if (this.b < 104) {
                                this.data.toUDynamicOffsets[this.dynamicWindow] = this.b << 7;
                            } else if ((this.b - 104 & 0xFF) < 64) {
                                this.data.toUDynamicOffsets[this.dynamicWindow] = (this.b << 7) + 44032;
                            } else if (this.b >= 249) {
                                this.data.toUDynamicOffsets[this.dynamicWindow] = fixedOffsets[this.b - 249];
                            } else {
                                this.toUBytesArray[1] = (byte)this.b;
                                this.toULength = 2;
                                label = 2;
                                return label;
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            label = 0;
                            return label;
                        }
                    }
                }
            } else if (modeType == 1) {
                while (source.hasRemaining()) {
                    if (!target.hasRemaining()) {
                        this.cr = CoderResult.OVERFLOW;
                        label = 2;
                        return label;
                    }
                    this.b = (short)(source.get() & 0xFF);
                    ++this.nextSourceIndex;
                    switch (this.state) {
                        case 0: {
                            if ((short)(this.b - 224 & 0xFF) > 18) {
                                this.byteOne = this.b;
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = (short)2;
                                break;
                            }
                            if ((this.b & 0xFF) <= 231) {
                                this.dynamicWindow = (byte)(this.b - 224);
                                this.sourceIndex = this.nextSourceIndex;
                                this.isSingleByteMode = true;
                                label = 0;
                                return label;
                            }
                            if ((this.b & 0xFF) <= 239) {
                                this.dynamicWindow = (byte)(this.b - 232);
                                this.isSingleByteMode = true;
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = (short)6;
                                label = 1;
                                return label;
                            }
                            if ((this.b & 0xFF) == 241) {
                                this.isSingleByteMode = true;
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = (short)4;
                                label = 1;
                                return label;
                            }
                            if ((this.b & 0xFF) == 240) {
                                this.toUBytesArray[0] = (byte)this.b;
                                this.toULength = 1;
                                this.state = 1;
                                break;
                            }
                            this.cr = CoderResult.malformedForLength(1);
                            this.toUBytesArray[0] = (byte)this.b;
                            this.toULength = 1;
                            label = 2;
                            return label;
                        }
                        case 1: {
                            this.byteOne = this.b;
                            this.toUBytesArray[1] = (byte)this.b;
                            this.toULength = 2;
                            this.state = (short)2;
                            break;
                        }
                        case 2: {
                            target.put((char)(this.byteOne << 8 | this.b));
                            if (offsets != null) {
                                offsets.put(this.sourceIndex);
                            }
                            this.sourceIndex = this.nextSourceIndex;
                            this.state = 0;
                            label = 0;
                            return label;
                        }
                    }
                }
            }
            label = 2;
            return label;
        }

        private void endLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets) {
            if (this.cr == CoderResult.OVERFLOW) {
                this.state = 0;
            } else if (this.state == 0) {
                this.toULength = 0;
            }
            this.data.toUIsSingleByteMode = this.isSingleByteMode;
            this.data.toUState = this.state;
            this.data.toUQuoteWindow = this.quoteWindow;
            this.data.toUDynamicWindow = this.dynamicWindow;
            this.data.toUByteOne = this.byteOne;
            this.LabelLoop = false;
        }
    }

    private static final class SCSUData {
        int[] toUDynamicOffsets = new int[8];
        int[] fromUDynamicOffsets = new int[8];
        boolean toUIsSingleByteMode;
        short toUState;
        byte toUQuoteWindow;
        byte toUDynamicWindow;
        short toUByteOne;
        boolean fromUIsSingleByteMode;
        byte fromUDynamicWindow;
        byte locale;
        byte nextWindowUseIndex;
        byte[] windowUse = new byte[8];

        SCSUData() {
            this.initialize();
        }

        void initialize() {
            int i;
            for (i = 0; i < 8; ++i) {
                this.toUDynamicOffsets[i] = initialDynamicOffsets[i];
            }
            this.toUIsSingleByteMode = true;
            this.toUState = 0;
            this.toUQuoteWindow = 0;
            this.toUDynamicWindow = 0;
            this.toUByteOne = 0;
            this.fromUIsSingleByteMode = true;
            this.fromUDynamicWindow = 0;
            for (i = 0; i < 8; ++i) {
                this.fromUDynamicOffsets[i] = initialDynamicOffsets[i];
            }
            this.nextWindowUseIndex = 0;
            switch (this.locale) {
                default: 
            }
            for (i = 0; i < 8; ++i) {
                this.windowUse[i] = initialWindowUse[i];
            }
        }
    }
}

