/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetUTF16BE;
import com.ibm.icu.charset.CharsetUTF16LE;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF16
extends CharsetICU {
    private static final int SIGNATURE_LENGTH = 2;
    private static final byte[] fromUSubstitution_BE = new byte[]{-1, -3};
    private static final byte[] fromUSubstitution_LE = new byte[]{-3, -1};
    private static final byte[] BOM_BE = new byte[]{-2, -1};
    private static final byte[] BOM_LE = new byte[]{-1, -2};
    private static final int ENDIAN_XOR_BE = 0;
    private static final int ENDIAN_XOR_LE = 1;
    private static final int NEED_TO_WRITE_BOM = 1;
    private boolean isEndianSpecified;
    private boolean isBigEndian;
    private int endianXOR;
    private byte[] bom;
    private byte[] fromUSubstitution;
    private int version;

    public CharsetUTF16(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        int versionIndex = icuCanonicalName.indexOf("version=");
        this.version = versionIndex > 0 ? Integer.decode(icuCanonicalName.substring(versionIndex + 8, versionIndex + 9)) : 0;
        this.isEndianSpecified = this instanceof CharsetUTF16BE || this instanceof CharsetUTF16LE;
        boolean bl = this.isBigEndian = !(this instanceof CharsetUTF16LE);
        if (this.isBigEndian) {
            this.bom = BOM_BE;
            this.fromUSubstitution = fromUSubstitution_BE;
            this.endianXOR = 0;
        } else {
            this.bom = BOM_LE;
            this.fromUSubstitution = fromUSubstitution_LE;
            this.endianXOR = 1;
        }
        this.maxBytesPerChar = 2;
        this.minBytesPerChar = 2;
        this.maxCharsPerByte = 1.0f;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF16(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF16(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        CharsetUTF16.getNonSurrogateUnicodeSet(setFillIn);
    }

    class CharsetEncoderUTF16
    extends CharsetEncoderICU {
        private final byte[] temp;

        public CharsetEncoderUTF16(CharsetICU cs) {
            super(cs, CharsetUTF16.this.fromUSubstitution);
            this.temp = new byte[4];
            this.fromUnicodeStatus = CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version != 1 ? 0 : 1;
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version != 1 ? 0 : 1;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            if (this.fromUnicodeStatus == 1) {
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                this.fromUnicodeStatus = 0;
                cr = CharsetEncoderUTF16.fromUWriteBytes(this, CharsetUTF16.this.bom, 0, CharsetUTF16.this.bom.length, target, offsets, -1);
                if (cr.isOverflow()) {
                    return cr;
                }
            }
            if (this.fromUChar32 != 0) {
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                cr = this.encodeChar(source, target, offsets, (char)this.fromUChar32);
                if (cr != null) {
                    return cr;
                }
            }
            do {
                if (!source.hasRemaining()) {
                    return CoderResult.UNDERFLOW;
                }
                if (target.hasRemaining()) continue;
                return CoderResult.OVERFLOW;
            } while ((cr = this.encodeChar(source, target, offsets, source.get())) == null);
            return cr;
        }

        private final CoderResult encodeChar(CharBuffer source, ByteBuffer target, IntBuffer offsets, char ch) {
            CoderResult cr;
            int sourceIndex = source.position() - 1;
            if (UTF16.isSurrogate((int)ch)) {
                cr = this.handleSurrogates(source, ch);
                if (cr != null) {
                    return cr;
                }
                char trail = UTF16.getTrailSurrogate((int)this.fromUChar32);
                this.fromUChar32 = 0;
                this.temp[0 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)(ch >>> 8);
                this.temp[1 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)ch;
                this.temp[2 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)(trail >>> 8);
                this.temp[3 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)trail;
                cr = CharsetEncoderUTF16.fromUWriteBytes(this, this.temp, 0, 4, target, offsets, sourceIndex);
            } else {
                this.temp[0 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)(ch >>> 8);
                this.temp[1 ^ ((CharsetUTF16)CharsetUTF16.this).endianXOR] = (byte)ch;
                cr = CharsetEncoderUTF16.fromUWriteBytes(this, this.temp, 0, 2, target, offsets, sourceIndex);
            }
            return cr.isUnderflow() ? null : cr;
        }
    }

    class CharsetDecoderUTF16
    extends CharsetDecoderICU {
        private boolean isBOMReadYet;
        private int actualEndianXOR;
        private byte[] actualBOM;

        public CharsetDecoderUTF16(CharsetICU cs) {
            super(cs);
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.isBOMReadYet = false;
            this.actualBOM = null;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            CoderResult cr2;
            if (!this.isBOMReadYet) {
                block19: {
                    while (true) {
                        if (!source.hasRemaining()) {
                            return CoderResult.UNDERFLOW;
                        }
                        this.toUBytesArray[this.toULength++] = source.get();
                        if (this.toULength == 1) {
                            if ((!CharsetUTF16.this.isEndianSpecified || CharsetUTF16.this.isBigEndian) && this.toUBytesArray[this.toULength - 1] == BOM_BE[this.toULength - 1]) {
                                this.actualBOM = BOM_BE;
                                this.actualEndianXOR = 0;
                                continue;
                            }
                            if (!(CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.isBigEndian || this.toUBytesArray[this.toULength - 1] != BOM_LE[this.toULength - 1])) {
                                this.actualBOM = BOM_LE;
                                this.actualEndianXOR = 1;
                                continue;
                            }
                            if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1) {
                                this.actualBOM = CharsetUTF16.this.isBigEndian ? BOM_BE : BOM_LE;
                                this.actualEndianXOR = CharsetUTF16.this.isBigEndian ? 0 : 1;
                            } else {
                                this.actualBOM = null;
                                this.actualEndianXOR = CharsetUTF16.this.endianXOR;
                            }
                            break block19;
                        }
                        if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 2] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 1]) {
                            return CoderResult.malformedForLength(2);
                        }
                        if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 1] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 2]) {
                            this.toULength = 0;
                            break block19;
                        }
                        if (CharsetUTF16.this.isEndianSpecified || this.toUBytesArray[this.toULength - 1] != this.actualBOM[this.toULength - 1]) {
                            this.actualBOM = null;
                            this.actualEndianXOR = CharsetUTF16.this.endianXOR;
                            break block19;
                        }
                        if (this.toULength == 2) break;
                    }
                    this.toULength = 0;
                }
                this.isBOMReadYet = true;
            }
            if (this.toUnicodeStatus != 0 && (cr2 = this.decodeTrail(source, target, offsets, (char)this.toUnicodeStatus)) != null) {
                return cr2;
            }
            while (true) {
                if (this.toULength < 2) {
                    if (!source.hasRemaining()) {
                        return CoderResult.UNDERFLOW;
                    }
                    this.toUBytesArray[this.toULength++] = source.get();
                    continue;
                }
                if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 2] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 1]) {
                    return CoderResult.malformedForLength(2);
                }
                if (CharsetUTF16.this.isEndianSpecified && CharsetUTF16.this.version == 1 && this.toUBytesArray[this.toULength - 1] == this.actualBOM[this.toULength - 1] && this.toUBytesArray[this.toULength - 2] == this.actualBOM[this.toULength - 2]) {
                    this.toULength = 0;
                    continue;
                }
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char char16 = (char)((this.toUBytesArray[0 ^ this.actualEndianXOR] & 0xFF) << 8 | this.toUBytesArray[1 ^ this.actualEndianXOR] & 0xFF);
                if (!UTF16.isSurrogate((int)char16)) {
                    this.toULength = 0;
                    target.put(char16);
                    continue;
                }
                cr = this.decodeTrail(source, target, offsets, char16);
                if (cr != null) break;
            }
            return cr;
        }

        private final CoderResult decodeTrail(ByteBuffer source, CharBuffer target, IntBuffer offsets, char lead) {
            if (!UTF16.isLeadSurrogate((int)lead)) {
                this.toUnicodeStatus = 0;
                return CoderResult.malformedForLength(2);
            }
            while (this.toULength < 4) {
                if (!source.hasRemaining()) {
                    this.toUnicodeStatus = lead;
                    return CoderResult.UNDERFLOW;
                }
                this.toUBytesArray[this.toULength++] = source.get();
            }
            char trail = (char)((this.toUBytesArray[2 ^ this.actualEndianXOR] & 0xFF) << 8 | this.toUBytesArray[3 ^ this.actualEndianXOR] & 0xFF);
            if (!UTF16.isTrailSurrogate((int)trail)) {
                this.toULength = 2;
                source.position(source.position() - 2);
                this.toUnicodeStatus = 0;
                return CoderResult.malformedForLength(2);
            }
            this.toUnicodeStatus = 0;
            this.toULength = 0;
            target.put(lead);
            if (target.hasRemaining()) {
                target.put(trail);
                return null;
            }
            this.charErrorBufferArray[0] = trail;
            this.charErrorBufferLength = 1;
            return CoderResult.OVERFLOW;
        }
    }
}

