/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.QuantityFormatter;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.text.FieldPosition;
import java.util.EnumMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelativeDateTimeFormatter {
    private final EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap;
    private final EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap;
    private final MessageFormat combinedDateAndTime;
    private final PluralRules pluralRules;
    private NumberFormat numberFormat;
    private static final Cache cache = new Cache();

    public static RelativeDateTimeFormatter getInstance() {
        return RelativeDateTimeFormatter.getInstance(ULocale.getDefault());
    }

    public static RelativeDateTimeFormatter getInstance(ULocale locale) {
        RelativeDateTimeFormatterData data = cache.get(locale);
        return new RelativeDateTimeFormatter(data.qualitativeUnitMap, data.quantitativeUnitMap, new MessageFormat(data.dateTimePattern), PluralRules.forLocale(locale), NumberFormat.getInstance(locale));
    }

    public static RelativeDateTimeFormatter getInstance(ULocale locale, NumberFormat nf) {
        RelativeDateTimeFormatterData data = cache.get(locale);
        return new RelativeDateTimeFormatter(data.qualitativeUnitMap, data.quantitativeUnitMap, new MessageFormat(data.dateTimePattern), PluralRules.forLocale(locale), (NumberFormat)nf.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(double quantity, Direction direction, RelativeUnit unit) {
        if (direction != Direction.LAST && direction != Direction.NEXT) {
            throw new IllegalArgumentException("direction must be NEXT or LAST");
        }
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return this.getQuantity(unit, direction == Direction.NEXT).format(quantity, this.numberFormat, this.pluralRules);
        }
    }

    public String format(Direction direction, AbsoluteUnit unit) {
        if (unit == AbsoluteUnit.NOW && direction != Direction.PLAIN) {
            throw new IllegalArgumentException("NOW can only accept direction PLAIN.");
        }
        return this.qualitativeUnitMap.get((Object)unit).get((Object)direction);
    }

    public String combineDateAndTime(String relativeDateString, String timeString) {
        return this.combinedDateAndTime.format(new Object[]{timeString, relativeDateString}, new StringBuffer(), (FieldPosition)null).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberFormat getNumberFormat() {
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            return (NumberFormat)this.numberFormat.clone();
        }
    }

    private static void addQualitativeUnit(EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnits, AbsoluteUnit unit, String current) {
        EnumMap<Direction, String> unitStrings = new EnumMap<Direction, String>(Direction.class);
        unitStrings.put(Direction.PLAIN, current);
        qualitativeUnits.put(unit, unitStrings);
    }

    private static void addQualitativeUnit(EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnits, AbsoluteUnit unit, ICUResourceBundle bundle, String plain) {
        EnumMap<Direction, String> unitStrings = new EnumMap<Direction, String>(Direction.class);
        unitStrings.put(Direction.LAST, bundle.getStringWithFallback("-1"));
        unitStrings.put(Direction.THIS, bundle.getStringWithFallback("0"));
        unitStrings.put(Direction.NEXT, bundle.getStringWithFallback("1"));
        RelativeDateTimeFormatter.addOptionalDirection(unitStrings, Direction.LAST_2, bundle, "-2");
        RelativeDateTimeFormatter.addOptionalDirection(unitStrings, Direction.NEXT_2, bundle, "2");
        unitStrings.put(Direction.PLAIN, plain);
        qualitativeUnits.put(unit, unitStrings);
    }

    private static void addOptionalDirection(EnumMap<Direction, String> unitStrings, Direction direction, ICUResourceBundle bundle, String key) {
        if ((bundle = bundle.findWithFallback(key)) != null) {
            unitStrings.put(direction, bundle.getString());
        }
    }

    private RelativeDateTimeFormatter(EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap, EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap, MessageFormat combinedDateAndTime, PluralRules pluralRules, NumberFormat numberFormat) {
        this.qualitativeUnitMap = qualitativeUnitMap;
        this.quantitativeUnitMap = quantitativeUnitMap;
        this.combinedDateAndTime = combinedDateAndTime;
        this.pluralRules = pluralRules;
        this.numberFormat = numberFormat;
    }

    private QuantityFormatter getQuantity(RelativeUnit unit, boolean isFuture) {
        QuantityFormatter[] quantities = this.quantitativeUnitMap.get((Object)unit);
        return isFuture ? quantities[1] : quantities[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Loader {
        private final ULocale ulocale;

        public Loader(ULocale ulocale) {
            this.ulocale = ulocale;
        }

        public RelativeDateTimeFormatterData load() {
            EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap = new EnumMap<AbsoluteUnit, EnumMap<Direction, String>>(AbsoluteUnit.class);
            EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap = new EnumMap<RelativeUnit, QuantityFormatter[]>(RelativeUnit.class);
            ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt53b", this.ulocale);
            this.addTimeUnit(r.getWithFallback("fields/day"), RelativeUnit.DAYS, AbsoluteUnit.DAY, quantitativeUnitMap, qualitativeUnitMap);
            this.addTimeUnit(r.getWithFallback("fields/week"), RelativeUnit.WEEKS, AbsoluteUnit.WEEK, quantitativeUnitMap, qualitativeUnitMap);
            this.addTimeUnit(r.getWithFallback("fields/month"), RelativeUnit.MONTHS, AbsoluteUnit.MONTH, quantitativeUnitMap, qualitativeUnitMap);
            this.addTimeUnit(r.getWithFallback("fields/year"), RelativeUnit.YEARS, AbsoluteUnit.YEAR, quantitativeUnitMap, qualitativeUnitMap);
            Loader.addTimeUnit(r.getWithFallback("fields/second"), RelativeUnit.SECONDS, quantitativeUnitMap);
            Loader.addTimeUnit(r.getWithFallback("fields/minute"), RelativeUnit.MINUTES, quantitativeUnitMap);
            Loader.addTimeUnit(r.getWithFallback("fields/hour"), RelativeUnit.HOURS, quantitativeUnitMap);
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap, AbsoluteUnit.NOW, r.getStringWithFallback("fields/second/relative/0"));
            EnumMap<AbsoluteUnit, String> dayOfWeekMap = Loader.readDaysOfWeek(r.getWithFallback("calendar/gregorian/dayNames/stand-alone/wide"));
            Loader.addWeekDay(r.getWithFallback("fields/mon"), dayOfWeekMap, AbsoluteUnit.MONDAY, qualitativeUnitMap);
            Loader.addWeekDay(r.getWithFallback("fields/tue"), dayOfWeekMap, AbsoluteUnit.TUESDAY, qualitativeUnitMap);
            Loader.addWeekDay(r.getWithFallback("fields/wed"), dayOfWeekMap, AbsoluteUnit.WEDNESDAY, qualitativeUnitMap);
            Loader.addWeekDay(r.getWithFallback("fields/thu"), dayOfWeekMap, AbsoluteUnit.THURSDAY, qualitativeUnitMap);
            Loader.addWeekDay(r.getWithFallback("fields/fri"), dayOfWeekMap, AbsoluteUnit.FRIDAY, qualitativeUnitMap);
            Loader.addWeekDay(r.getWithFallback("fields/sat"), dayOfWeekMap, AbsoluteUnit.SATURDAY, qualitativeUnitMap);
            Loader.addWeekDay(r.getWithFallback("fields/sun"), dayOfWeekMap, AbsoluteUnit.SUNDAY, qualitativeUnitMap);
            CalendarData calData = new CalendarData(this.ulocale, r.getStringWithFallback("calendar/default"));
            return new RelativeDateTimeFormatterData(qualitativeUnitMap, quantitativeUnitMap, calData.getDateTimePattern());
        }

        private void addTimeUnit(ICUResourceBundle timeUnitBundle, RelativeUnit relativeUnit, AbsoluteUnit absoluteUnit, EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap, EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap) {
            Loader.addTimeUnit(timeUnitBundle, relativeUnit, quantitativeUnitMap);
            String unitName = timeUnitBundle.getStringWithFallback("dn");
            if (this.ulocale.getLanguage().equals("en")) {
                unitName = unitName.toLowerCase();
            }
            timeUnitBundle = timeUnitBundle.getWithFallback("relative");
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap, absoluteUnit, timeUnitBundle, unitName);
        }

        private static void addTimeUnit(ICUResourceBundle timeUnitBundle, RelativeUnit relativeUnit, EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap) {
            QuantityFormatter.Builder future = new QuantityFormatter.Builder();
            QuantityFormatter.Builder past = new QuantityFormatter.Builder();
            timeUnitBundle = timeUnitBundle.getWithFallback("relativeTime");
            Loader.addTimeUnit(timeUnitBundle.getWithFallback("future"), future);
            Loader.addTimeUnit(timeUnitBundle.getWithFallback("past"), past);
            quantitativeUnitMap.put(relativeUnit, new QuantityFormatter[]{past.build(), future.build()});
        }

        private static void addTimeUnit(ICUResourceBundle pastOrFuture, QuantityFormatter.Builder builder) {
            int size = pastOrFuture.getSize();
            for (int i = 0; i < size; ++i) {
                UResourceBundle r = pastOrFuture.get(i);
                builder.add(r.getKey(), r.getString());
            }
        }

        private static void addWeekDay(ICUResourceBundle weekdayBundle, EnumMap<AbsoluteUnit, String> dayOfWeekMap, AbsoluteUnit weekDay, EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap) {
            weekdayBundle = weekdayBundle.findWithFallback("relative");
            RelativeDateTimeFormatter.addQualitativeUnit(qualitativeUnitMap, weekDay, weekdayBundle, dayOfWeekMap.get((Object)weekDay));
        }

        private static EnumMap<AbsoluteUnit, String> readDaysOfWeek(ICUResourceBundle daysOfWeekBundle) {
            EnumMap<AbsoluteUnit, String> dayOfWeekMap = new EnumMap<AbsoluteUnit, String>(AbsoluteUnit.class);
            if (daysOfWeekBundle.getSize() != 7) {
                throw new IllegalStateException(String.format("Expect 7 days in a week, got %d", daysOfWeekBundle.getSize()));
            }
            int idx = 0;
            dayOfWeekMap.put(AbsoluteUnit.SUNDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.MONDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.TUESDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.WEDNESDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.THURSDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.FRIDAY, daysOfWeekBundle.getString(idx++));
            dayOfWeekMap.put(AbsoluteUnit.SATURDAY, daysOfWeekBundle.getString(idx++));
            return dayOfWeekMap;
        }
    }

    private static class Cache {
        private final ICUCache<String, RelativeDateTimeFormatterData> cache = new SimpleCache<String, RelativeDateTimeFormatterData>();

        private Cache() {
        }

        public RelativeDateTimeFormatterData get(ULocale locale) {
            String key = locale.toString();
            RelativeDateTimeFormatterData result = this.cache.get(key);
            if (result == null) {
                result = new Loader(locale).load();
                this.cache.put(key, result);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelativeDateTimeFormatterData {
        public final EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap;
        public final EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap;
        public final String dateTimePattern;

        public RelativeDateTimeFormatterData(EnumMap<AbsoluteUnit, EnumMap<Direction, String>> qualitativeUnitMap, EnumMap<RelativeUnit, QuantityFormatter[]> quantitativeUnitMap, String dateTimePattern) {
            this.qualitativeUnitMap = qualitativeUnitMap;
            this.quantitativeUnitMap = quantitativeUnitMap;
            this.dateTimePattern = dateTimePattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        LAST_2,
        LAST,
        THIS,
        NEXT,
        NEXT_2,
        PLAIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AbsoluteUnit {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelativeUnit {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;

    }
}

