/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUConfig;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.DisplayContext;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public abstract class LocaleDisplayNames {
    private static final Method FACTORY_DIALECTHANDLING;
    private static final Method FACTORY_DISPLAYCONTEXT;

    public static LocaleDisplayNames getInstance(ULocale locale) {
        return LocaleDisplayNames.getInstance(locale, DialectHandling.STANDARD_NAMES);
    }

    public static LocaleDisplayNames getInstance(Locale locale) {
        return LocaleDisplayNames.getInstance(ULocale.forLocale(locale));
    }

    public static LocaleDisplayNames getInstance(ULocale locale, DialectHandling dialectHandling) {
        LocaleDisplayNames result = null;
        if (FACTORY_DIALECTHANDLING != null) {
            try {
                result = (LocaleDisplayNames)FACTORY_DIALECTHANDLING.invoke(null, new Object[]{locale, dialectHandling});
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new LastResortLocaleDisplayNames(locale, dialectHandling);
        }
        return result;
    }

    public static LocaleDisplayNames getInstance(ULocale locale, DisplayContext ... contexts) {
        LocaleDisplayNames result = null;
        if (FACTORY_DISPLAYCONTEXT != null) {
            try {
                result = (LocaleDisplayNames)FACTORY_DISPLAYCONTEXT.invoke(null, locale, (Object[])contexts);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new LastResortLocaleDisplayNames(locale, contexts);
        }
        return result;
    }

    public static LocaleDisplayNames getInstance(Locale locale, DisplayContext ... contexts) {
        return LocaleDisplayNames.getInstance(ULocale.forLocale(locale), contexts);
    }

    public abstract ULocale getLocale();

    public abstract DialectHandling getDialectHandling();

    public abstract DisplayContext getContext(DisplayContext.Type var1);

    public abstract String localeDisplayName(ULocale var1);

    public abstract String localeDisplayName(Locale var1);

    public abstract String localeDisplayName(String var1);

    public abstract String languageDisplayName(String var1);

    public abstract String scriptDisplayName(String var1);

    @Deprecated
    public String scriptDisplayNameInContext(String script) {
        return this.scriptDisplayName(script);
    }

    public abstract String scriptDisplayName(int var1);

    public abstract String regionDisplayName(String var1);

    public abstract String variantDisplayName(String var1);

    public abstract String keyDisplayName(String var1);

    public abstract String keyValueDisplayName(String var1, String var2);

    @Deprecated
    protected LocaleDisplayNames() {
    }

    static {
        String implClassName = ICUConfig.get("com.ibm.icu.text.LocaleDisplayNames.impl", "com.ibm.icu.impl.LocaleDisplayNamesImpl");
        Method factoryDialectHandling = null;
        Method factoryDisplayContext = null;
        try {
            Class<?> implClass = Class.forName(implClassName);
            try {
                factoryDialectHandling = implClass.getMethod("getInstance", ULocale.class, DialectHandling.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                factoryDisplayContext = implClass.getMethod("getInstance", ULocale.class, DisplayContext[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        FACTORY_DIALECTHANDLING = factoryDialectHandling;
        FACTORY_DISPLAYCONTEXT = factoryDisplayContext;
    }

    private static class LastResortLocaleDisplayNames
    extends LocaleDisplayNames {
        private ULocale locale;
        private DisplayContext[] contexts;

        private LastResortLocaleDisplayNames(ULocale locale, DialectHandling dialectHandling) {
            this.locale = locale;
            DisplayContext context = dialectHandling == DialectHandling.DIALECT_NAMES ? DisplayContext.DIALECT_NAMES : DisplayContext.STANDARD_NAMES;
            this.contexts = new DisplayContext[]{context};
        }

        private LastResortLocaleDisplayNames(ULocale locale, DisplayContext ... contexts) {
            this.locale = locale;
            this.contexts = new DisplayContext[contexts.length];
            System.arraycopy(contexts, 0, this.contexts, 0, contexts.length);
        }

        public ULocale getLocale() {
            return this.locale;
        }

        public DialectHandling getDialectHandling() {
            DialectHandling result = DialectHandling.STANDARD_NAMES;
            for (DisplayContext context : this.contexts) {
                if (context.type() != DisplayContext.Type.DIALECT_HANDLING || context.value() != DisplayContext.DIALECT_NAMES.ordinal()) continue;
                result = DialectHandling.DIALECT_NAMES;
                break;
            }
            return result;
        }

        public DisplayContext getContext(DisplayContext.Type type) {
            DisplayContext result = DisplayContext.STANDARD_NAMES;
            for (DisplayContext context : this.contexts) {
                if (context.type() != type) continue;
                result = context;
                break;
            }
            return result;
        }

        public String localeDisplayName(ULocale locale) {
            return locale.getName();
        }

        public String localeDisplayName(Locale locale) {
            return ULocale.forLocale(locale).getName();
        }

        public String localeDisplayName(String localeId) {
            return new ULocale(localeId).getName();
        }

        public String languageDisplayName(String lang) {
            return lang;
        }

        public String scriptDisplayName(String script) {
            return script;
        }

        public String scriptDisplayName(int scriptCode) {
            return UScript.getShortName(scriptCode);
        }

        public String regionDisplayName(String region) {
            return region;
        }

        public String variantDisplayName(String variant) {
            return variant;
        }

        public String keyDisplayName(String key) {
            return key;
        }

        public String keyValueDisplayName(String key, String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialectHandling {
        STANDARD_NAMES,
        DIALECT_NAMES;

    }
}

