/**
 * File: Cmd.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011,2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;


/**
 * A Cmd object represents the <code>Cmd</code> element of a type-2 command response message. This element
 * contains information about the type-2 command as it was passed to OM. You can use this information
 * to validate that a command succeeded or failed, or to associate a response message with a 
 * specific command.
 *
 *@since Enterprise Suite 2.1
 */
public interface Cmd
{
    /**
     * Gets any plain text encapsulated by the <code>Cmd</code> element.
     * @return the cmdElementText
     */
    public String getCmdElementText();
    
    /**
     * Gets the original command input string that was passed to Operations Manager.
     * @return the input
     */
    public String getInput();
    
    /**
     * Gets the original type-2 command keyword.
     * @return the kwd
     */
    public String getKwd();
    
    /**
     * Gets the name of the command processing client that processed the type-2 command.
     * @return the master
     */
    public String getMaster();
    
    /**
     * Gets the user ID under which the type-2 command was issued.
     * @return the userid
     */
    public String getUserid();
    
    /**
     * Gets the short form of the original type-2 command verb.
     * @return the verb
     */
    public String getVerb();
}
