/**
 * File: Cmderr.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011,2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import java.util.ArrayList;

/**
 * A Cmderr object represents the <code>Cmderr</code> element of a type-2 command response message. This
 * element contains error information returned by OM command processing clients that experienced an 
 * error while attempting to execute a type-2 command. One <code>Cmderr</code> element is returned
 * for a type-2 command that caused an error in at least one command processing client. A child <code>Mbr</code>
 * element is returned for each command processing client that experienced an error.
 * 
 * @since Enterprise Suite 2.1
 */
public interface Cmderr
{
    /**
     * Gets any plain text encapsulated by the element.
     * @return the elementText
     */
    public String getElementText();
    
    /**
     * Gets Mbr objects for each command processing client that returned an error.
     * @return the mbr
     */
    public ArrayList<Mbr> getMbr();
}