/**
 * File: Cmdrsphdr.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011,2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import java.util.ArrayList;


/**
 * A Cmdrsphdr object represents the <code>Cmdrsphdr</code> element in a type-2 command response
 * message. This element contains formatting instructions for the response data in the <code>Cmdrsphdr</code>
 * element. Your client application can use this information to present the response data in a graphical
 * user interface.
 * @see <a href="../com.ibm.ims13.doc.spr/ims_csl_opmgrxml_descript.htm#ims_csl_opmgrxml_descript">XML tags returned as CSL OM responses</a>
 *
 *@since Enterprise Suite 2.1
 */
public interface Cmdrsphdr
{
    /**
     * Gets any plain text encapsulated by the element.
     * @return the cmdrsphdrElementText
     */
    public String getElementText();
    
    /**
     * Gets all of the Hdr objects for the response message.
     * @return the hdrArray
     */
    public ArrayList<Hdr> getHdrArray();
    
    /**
     * Gets a specific Hdr object from the response message list.
     * @return the hdr element at anIndex
     */
    public Hdr getHdrArrayElement(int anIndex);
}