/*
 * File: IMSConnectCommunicationException.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2009,2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */package com.ibm.ims.connect;

/**
 * This class reports an error condition in communicating with IMS Connect.
 */
public class ImsConnectCommunicationException extends ImsConnectApiException
{
    /**
     * 
     */
    private static final long serialVersionUID = 235303625054893699L;

    public static final String copyright =
        "Licensed Material - Property of IBM "
            + "5655-TDA"
            + "(C) Copyright IBM Corp. 2009, 2013  All Rights Reserved. "
            + "US Government Users Restricted Rights - Use, duplication or "
            + "disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
            
    private String errorNumber = "HWS0000E";

    /**
     * @param errNo
     * @param errMsg
     */
    public ImsConnectCommunicationException(String errNo, String errMsg)
    {
        super(errNo, errMsg);
        
        this.errorNumber = errNo;
    }

    public String getErrorNumber()
    {
        return this.errorNumber;
    }
}
