/*
 * File: ImsConnectErrorMessageResourceBundle.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2009,2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

/**
 * The resource bundle containing the error messages.
 * 
 */
public class ImsConnectErrorMessageResourceBundle extends
        java.util.ListResourceBundle
{
    public static final String copyright =
        "Licensed Material - Property of IBM "
            + "5655-T62"
            + "(C) Copyright IBM Corp. 2009, 2013  All Rights Reserved. "
            + "US Government Users Restricted Rights - Use, duplication or "
            + "disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";

//         1         2         3         4         5         6         7         0
//12345678901234567890123456789012345678901234567890123456789012345678901234567890                  

    private static Object[][] contents = 
    {
            { ImsConnectErrorMessage.HWS0001E, ImsConnectErrorMessage.HWS0001E + 
                  ": IMS Connect API processing error. Original error: [{0}]" },
            { ImsConnectErrorMessage.HWS0002E, ImsConnectErrorMessage.HWS0002E + 
                  ": Unable to open {0} [{1}]. Original error: [{2}]" }, 
            { ImsConnectErrorMessage.HWS0003E, ImsConnectErrorMessage.HWS0003E + 
                  ": IMS Connect returned error. Return code: [{0}], Reason code: [{1}] ({2})" },
            { ImsConnectErrorMessage.HWS0004E, ImsConnectErrorMessage.HWS0004E + 
                  ": IMS OTMA returned error. IMS Connect return code: [{0}], OTMA sense code: [{1}]" },
            { ImsConnectErrorMessage.HWS0005E, ImsConnectErrorMessage.HWS0005E + 
                  ": IMS OTMA returned error. IMS Connect return code: [{0}], OTMA sense code: [{1}], OTMA reason code: [{2}] ({3})" },
            { ImsConnectErrorMessage.HWS0006E, ImsConnectErrorMessage.HWS0006E + 
                  ": Failed to connect to IMS Connect. Hostname [{0}], portNumber [{1}], Transport error: [{2}]" },
            { ImsConnectErrorMessage.HWS0007E, ImsConnectErrorMessage.HWS0007E + 
                  ": {0} value [{1}] is invalid (value must be -1 or signed integer greater than 0)" },
            { ImsConnectErrorMessage.HWS0008E, ImsConnectErrorMessage.HWS0008E + 
                  ": Failed to send or receive messages to and from IMS Connect hostName [{0}], portNumber [{1}]. Original error: [{2}]" },
            { ImsConnectErrorMessage.HWS0009E, ImsConnectErrorMessage.HWS0009E + 
                  ": Failed to successfully initialize SSL context. Original error: [{0}]" },
            { ImsConnectErrorMessage.HWS0010E, ImsConnectErrorMessage.HWS0010E + 
                  ": Failed to successfully complete SSL handshake with IMS Connect at host [{0}], port [{1}]. Original error: [{2}]" },
            
            { ImsConnectErrorMessage.HWS0011E, ImsConnectErrorMessage.HWS0011E + 
                  ": IMS Connect returned a timeout error for this interaction. IMS Connect Return code: [{0}], Reason code: [{1}] ({2})" },
            { ImsConnectErrorMessage.HWS0012E, ImsConnectErrorMessage.HWS0012E + 
                  ": IMS Connect returned a timeout error for this interaction. IMS Connect Return code: [{0}], Reason code: 0 (IMS Connect used IMS Connect TIMEOUT value)" },
/*                  
            { ImsConnectErrorMessage.HWS0013E, ImsConnectErrorMessage.HWS0013E + 
                  ": IMS Connect XML Adapter returned an error. Return code: [{0}].  Specified XML Converter [{1}] was not found or failed to load" },
            { ImsConnectErrorMessage.HWS0014E, ImsConnectErrorMessage.HWS0014E + 
                  ": IMS Connect XML Adapter returned an error. Original error: [{0}]" },
*/                 
            { ImsConnectErrorMessage.HWS0015E, ImsConnectErrorMessage.HWS0015E + 
                  ": RESUME_TPIPE_AUTO or RESUME_TPIPE_NOAUTO interactions are not supported for use with API internal ACK" },
            { ImsConnectErrorMessage.HWS0016E, ImsConnectErrorMessage.HWS0016E + 
                  ": RESUME_TPIPE and SENDONLY interactions are only supported for use with non-conversational, Commit Mode 0 interactions" },
            { ImsConnectErrorMessage.HWS0017E, ImsConnectErrorMessage.HWS0017E + 
                  ": Error processing {0} data. Codepage {1} not supported" },
            { ImsConnectErrorMessage.HWS0018E, ImsConnectErrorMessage.HWS0018E + 
                  ": Response message from IMS Connect (CSM or RSM) formatted incorrectly" },
            { ImsConnectErrorMessage.HWS0019E, ImsConnectErrorMessage.HWS0019E + 
                  ": The length of the output response message from IMS Connect, [{0}], is too short to be a valid response message" },
            { ImsConnectErrorMessage.HWS0020E, ImsConnectErrorMessage.HWS0020E + 
                  ": The length of the output response message from IMS Connect, [{0}], does not match message's LLLL value, [{1}]" },
/*                  
            { ImsConnectErrorMessage.HWS0021E, ImsConnectErrorMessage.HWS0021E + 
                  ": IMS Connect XML Adapter error message formatted incorrectly. Unable to retrieve content" },
            { ImsConnectErrorMessage.HWS0022E, ImsConnectErrorMessage.HWS0022E + 
                  ": IMS Connect XML Adapter type [{0}] ({1}) not supported" },
            { ImsConnectErrorMessage.HWS0023E, ImsConnectErrorMessage.HWS0023E + 
                  ": IMS Connect XML Converter Driver returned error. Original error: [{0}]" },
            { ImsConnectErrorMessage.HWS0024E, ImsConnectErrorMessage.HWS0024E + 
                  ": Specified XML {0} name cannot be empty or all blanks" },
*/                  
            { ImsConnectErrorMessage.HWS0025E, ImsConnectErrorMessage.HWS0025E + 
                  ": {0} timeout occurred. Timeout value specified was [{1}] milliseconds. Original error: [{2}]" },
            { ImsConnectErrorMessage.HWS0026E, ImsConnectErrorMessage.HWS0026E + 
                  ": Value [{0}] of [{1}] property exceeds [{2}] characters" },
            { ImsConnectErrorMessage.HWS0027E, ImsConnectErrorMessage.HWS0027E + 
                  ": [{0}] property value not set to true - purgeUndeliverableOutput and rerouteUndeliverableOutput cannot both be true" },
            { ImsConnectErrorMessage.HWS0028E, ImsConnectErrorMessage.HWS0028E + 
                  ": Property name [{0}] invalid" },
            { ImsConnectErrorMessage.HWS0029E, ImsConnectErrorMessage.HWS0029E + 
                  ": [{0}] property value [{1}] invalid - value must be 1- to 8-character, host-style name" },
            { ImsConnectErrorMessage.HWS0030E, ImsConnectErrorMessage.HWS0030E + 
                  ": [{0}] property value [{1}] invalid - value must be {2}" },
            { ImsConnectErrorMessage.HWS0031E, ImsConnectErrorMessage.HWS0031E + 
                  ": [{0}] property value [{1}] invalid - value must be {2}. Original error: [{3}]" },
            { ImsConnectErrorMessage.HWS0032E, ImsConnectErrorMessage.HWS0032E + 
                  ": [{0}] properties file contained unterminated /* comment at line [{1}], position [{2}]" },
            { ImsConnectErrorMessage.HWS0033E, ImsConnectErrorMessage.HWS0033E + 
                  ": Change to [{0}] property attempted on already-connected clientId [{1}] connection" },
            { ImsConnectErrorMessage.HWS0034E, ImsConnectErrorMessage.HWS0034E + 
                  ": Connection attempt made on already-connected clientId [{0}] connection" },
            { ImsConnectErrorMessage.HWS0035E, ImsConnectErrorMessage.HWS0035E + 
                  ": Specifying LLZZ within input data String not valid" },
            { ImsConnectErrorMessage.HWS0036E, ImsConnectErrorMessage.HWS0036E + 
                  ": LL value specified, [{0}], not valid - value must be greater than or equal to 4 and less than or equal to 32,767" },
            { ImsConnectErrorMessage.HWS0037E, ImsConnectErrorMessage.HWS0037E + 
                  ": TCP/IP socket call {0} failed.  Original error was [{1}]" },
            { ImsConnectErrorMessage.HWS0038E, ImsConnectErrorMessage.HWS0038E + 
                  "Variable value [{0}] of type [{1}] is invalid."}, // C API only
            { ImsConnectErrorMessage.HWS0039E, ImsConnectErrorMessage.HWS0039E + 
                  ": Connection to hostname[{0}], portnumber[{1}] using clientId [{2}] no longer connected" }, // C API only
            { ImsConnectErrorMessage.HWS0040E, ImsConnectErrorMessage.HWS0040E + 
                  ": USER ERROR: initializeAPI() function not called"}, // C API only
//------------------Added for Sync callout------------------------------////
            { ImsConnectErrorMessage.HWS0041E, ImsConnectErrorMessage.HWS0041E + 
                  ": Specified error reason code, {0}, is out of range - value must be greater than {1} and {2}, inclusive" },
            { ImsConnectErrorMessage.HWS0042E, ImsConnectErrorMessage.HWS0042E + 
                  ": Error occurred at setCorrelatorTkn(byte[] aCorelatorToken).The length of correlator token received , {0}, is invalid.  The correlator token should be 40 bytes in length " },
//--------------------------------------End------------------------
            { ImsConnectErrorMessage.HWS0043E, ImsConnectErrorMessage.HWS0043E + 
                  ": RACF returned an error. \n\n\tIMS Connect return code: [{0}], \n\tIMS Connect reason code: [{1}], \n\tRACF return code: [{2}], RACF return code meaning: ({3})" },
            { ImsConnectErrorMessage.HWS0044E, ImsConnectErrorMessage.HWS0044E + 
                  ": Type-2 command XML response data formatted incorrectly.  Original error: [{0}]" },
            { ImsConnectErrorMessage.HWS0045E, ImsConnectErrorMessage.HWS0045E + 
                  ": The requested interaction, [{0}], cannot be executed in the current \n IMS Connect protocol state.  The previous interaction must be acknowledged \n(an ApiProperties INTERACTION_TYPE_DESC_ACK or INTERACTION_TYPE_DESC_NAK \ninteraction must be executed) before any further interactions can be executed" },
                  
            { ImsConnectErrorMessage.NO_CONN, " - socket not connected" },
            { ImsConnectErrorMessage.MSG_BLD_ERR, " - error building input message, cause: [{0}]" },
            { ImsConnectErrorMessage.CODEPAGE_ERR, " - error converting input data into the given codepage, cause: [{0}]" },
            { ImsConnectErrorMessage.INVALID_SSLSESSION, "sslSession.isValid() returned false indicating SSL session object created is not usable" },
            { ImsConnectErrorMessage.TRACE_FILE, "trace file" },
            { ImsConnectErrorMessage.CONNECTION_PROPERTIES_FILE, "Connection properties file" },  // do not translate the class name Connection
            { ImsConnectErrorMessage.TMINTERACTION_PROPERTIES_FILE, "TmInteraction properties file" },  // do not translate the class name TmInteraction
            { ImsConnectErrorMessage.UNKNOWN_TYPE_FILE, "unknown type file" },
            { ImsConnectErrorMessage.FILE_LINE_LIMIT, "File too big to be parsed" },
            
            //IMS Connect Reason code messages
            { ImsConnectErrorMessage.HWS_RESCODE_4, "Input data exceeds buffer size" },
            { ImsConnectErrorMessage.HWS_RESCODE_5, "Negative length value" },
            { ImsConnectErrorMessage.HWS_RESCODE_6, "IRM length invalid" },
            { ImsConnectErrorMessage.HWS_RESCODE_7, "Total message length invalid" },
            { ImsConnectErrorMessage.HWS_RESCODE_8, "OTMA NAK with no sense code or RC" },
            { ImsConnectErrorMessage.HWS_RESCODE_9, "Contents of buffer invalid. See the API troubleshooting information." },
            { ImsConnectErrorMessage.HWS_RESCODE_10, "Output data exceeds buffer size" },
            { ImsConnectErrorMessage.HWS_RESCODE_11, "Invalid unicode definition" },
            { ImsConnectErrorMessage.HWS_RESCODE_12, "Invalid message, no data" },
            { ImsConnectErrorMessage.HWS_RESCODE_13, "No Adapter name returned from User Message Exit" },
            { ImsConnectErrorMessage.HWS_RESCODE_14, "Message not processed by Adapter [{0}]" },
            { ImsConnectErrorMessage.HWS_RESCODE_15, "Invalid Adapter return code" },
            { ImsConnectErrorMessage.HWS_RESCODE_16, "Do not know who client is" },
            { ImsConnectErrorMessage.HWS_RESCODE_17, "Invalid User Message Exit Function" },
            { ImsConnectErrorMessage.HWS_RESCODE_20, "OTMA segment length error" },
            { ImsConnectErrorMessage.HWS_RESCODE_24, "FIC missing" },
            { ImsConnectErrorMessage.HWS_RESCODE_28, "LIC missing" },
            { ImsConnectErrorMessage.HWS_RESCODE_32, "Sequence number error" },
            { ImsConnectErrorMessage.HWS_RESCODE_34, "Unable to locate context token" },
            { ImsConnectErrorMessage.HWS_RESCODE_36, "Protocol error" },

            { ImsConnectErrorMessage.HWS_RESCODE_40, "Security violation. User ID [{0}], Group ID[{1}]" },
            { ImsConnectErrorMessage.HWS_RESCODE_44, "Message incomplete" },
            { ImsConnectErrorMessage.HWS_RESCODE_48, "Incorrect message length" },

            { ImsConnectErrorMessage.HWS_RESCODE_51, "Security failure: no OTMA security header" },
            { ImsConnectErrorMessage.HWS_RESCODE_52, "Security failure: no security data in the OTMA security header" },
            { ImsConnectErrorMessage.HWS_RESCODE_53, "Security failure: no password" },
            { ImsConnectErrorMessage.HWS_RESCODE_54, "Security failure: no user ID" },
            { ImsConnectErrorMessage.HWS_RESCODE_55, "Security failure: no password and no user ID" },
            { ImsConnectErrorMessage.HWS_RESCODE_56, "Duplicate client ID was used; the client ID, [{0}] is currently in use" },
            { ImsConnectErrorMessage.HWS_RESCODE_57, "Invalid token is being used; internal error" },
            { ImsConnectErrorMessage.HWS_RESCODE_58, "Invalid client status; internal error" },
            { ImsConnectErrorMessage.HWS_RESCODE_59, "Cancel Timer completed successfully" },

            { ImsConnectErrorMessage.HWS_RESCODE_70, "Component not found" },
            { ImsConnectErrorMessage.HWS_RESCODE_71, "Function not found" },
            { ImsConnectErrorMessage.HWS_RESCODE_72, "IMS Datastore [{0}] not found" },
            { ImsConnectErrorMessage.HWS_RESCODE_73, "IMS Connect is shutdown" },
            { ImsConnectErrorMessage.HWS_RESCODE_74, "IMS Datastore [{0}] in stop or close process" },
            { ImsConnectErrorMessage.HWS_RESCODE_75, "Datastore communication error" },
            { ImsConnectErrorMessage.HWS_RESCODE_76, "Datastore was stopped by a command" },
            { ImsConnectErrorMessage.HWS_RESCODE_77, "Datastore command error to pending client" },
            { ImsConnectErrorMessage.HWS_RESCODE_78, "Security failure.  A RACF call failed; an IMS Connect call failed" },
            { ImsConnectErrorMessage.HWS_RESCODE_79, "An IMS Connect protocol error occurred" },

            { ImsConnectErrorMessage.HWS_RESCODE_80, "The IMSplex connection is not active" },

            { ImsConnectErrorMessage.HWS_RESCODE_93, "An invalid commit mode of 1 was specified on the RESUME TPIPE request" },
            { ImsConnectErrorMessage.HWS_RESCODE_94, "Request" },
            { ImsConnectErrorMessage.HWS_RESCODE_95, "Conversation" },
            { ImsConnectErrorMessage.HWS_RESCODE_96, "Request and conversation" },
            { ImsConnectErrorMessage.HWS_RESCODE_97, "Deallocate confirmed" },
            { ImsConnectErrorMessage.HWS_RESCODE_98, "Deallocate abort" },
            { ImsConnectErrorMessage.HWS_RESCODE_99, "Default reason code" },

            // OTMA reason codes associated with OTMA sense code X'1A' (decimal 26)
            { ImsConnectErrorMessage.OTMA_RESCODE_03, "RACF RACROUTE VERIFY call failed for incorrect input user ID" },
            
            { ImsConnectErrorMessage.OTMA_RESCODE_21, "Message segment length or ZZ field cannot be changed by DFSNPRT0 exit" },
            { ImsConnectErrorMessage.OTMA_RESCODE_22, "Invalid security option specified in message prefix" },
            { ImsConnectErrorMessage.OTMA_RESCODE_23, "Invalid command from OTMA client (see DFS1285E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_24, "Transaction currently not available for use (see DFS3470E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_25, "SMB transaction or LTERM stopped (see DFS065)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_26, "Invalid CPIC transaction (see DFS1286E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_27, "Invalid remote destination (RCNT) (see DFS1287E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_28, "Invalid CNT name specified (see DFS1288E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_29, "SMB not found (see DFS064)" },
            
            { ImsConnectErrorMessage.OTMA_RESCODE_30, "Invalid security (see DFS1292E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_31, "System error requested" },
            { ImsConnectErrorMessage.OTMA_RESCODE_32, "System error message" },
            { ImsConnectErrorMessage.OTMA_RESCODE_33, "User error message" },
            { ImsConnectErrorMessage.OTMA_RESCODE_34, "Single-segment message (see DFS1290E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_35, "All messages discarded (see DFS249)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_36, "Null segment sent (see DFS249)" }, 
            { ImsConnectErrorMessage.OTMA_RESCODE_37, "Queue overflow as unsuccessful insert" },
            { ImsConnectErrorMessage.OTMA_RESCODE_38, "Commit mode 0 not allowed for IMS conversational or Fast Path transaction (see DFS1291E)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_39, "IMS conversation stopped" },
            
            { ImsConnectErrorMessage.OTMA_RESCODE_40, "DFSNPRT0 requested message be rerouted to remote system, but failed (see DFS064)" },
            { ImsConnectErrorMessage.OTMA_RESCODE_41, "DFSNPRT0 requested message be rerouted to remote system, but failed (see DFS070)" },
            
            { ImsConnectErrorMessage.OTMA_RESCODE_50, "Message or segment length exceeds length specified on MSGLEN key parameter of XCF IXCMSGO macro" },
            
            { ImsConnectErrorMessage.RACF_RETCODE_4, "0x04 - User profile not defined to RACF" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_8, "0x08 - Password/password phrase not authorized" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_12, "0x0C - Password or password phrase has expired" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_16, "0x10 - New password or password phrase not valid or change not allowed since minimum password-change interval has not passed" },
            { ImsConnectErrorMessage.RACF_RETCODE_20, "0x14 - User not defined to the group" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_24, "0x18 - RACF request was failed by installation exit routine" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_28, "0x1C - User's access has been revoked" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_36, "0x24 - User's access to specified group has been revoked" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_40, "0x28 - OIDCARD parameter required but not supplied" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_44, "0x2C - OIDCARD parameter not valid for specified user" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_48, "0x30 - User not authorized to the port of entry in TERMINAL, JESINPUT, or CONSOLE class" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_52, "0x34 - User not authorized to use application" }, 
            { ImsConnectErrorMessage.RACF_RETCODE_56, "0x38 - SECLABEL checking failed" },
            { ImsConnectErrorMessage.RACF_RETCODE_68, "0x44 - A default token is used as input token" },
            { ImsConnectErrorMessage.RACF_RETCODE_72, "0x48 - Unprivileged user issued RACROUTE REQUEST=VERIFY in tranquil state (MLQUIET)" },
            { ImsConnectErrorMessage.RACF_RETCODE_76, "0x4C - NODES checking failed" },
            { ImsConnectErrorMessage.RACF_RETCODE_80, "0x50 - Surrogate submit attempt failed" },
            { ImsConnectErrorMessage.RACF_RETCODE_84, "0x54 - JESJOBS check failed" },
            { ImsConnectErrorMessage.RACF_RETCODE_92, "0x5C - Error occurred while retrieving data from RACF database" },
            { ImsConnectErrorMessage.RACF_RETCODE_100, "0x64 - CHECK subparameter of RELEASE keyword was specified on execute form of RACROUTE REQUEST=VERIFY macro, but list form of macro does not have same release parameter. Macro processing terminated" },
            
            
            //COBOL Adapter Reason code message
            //LLL{ ImsConnectErrorMessage.CBLADP_RETCODE_10, "The COBOL Adapter
            // received an invalid function code from IMS Connect" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_10,
                    "The XML Adapter received an invalid function code from IMS Connect" },

            { ImsConnectErrorMessage.CBLADP_RETCODE_110,
                    "Inbound Error: The specified XML Converter Driver was not found or there was a load failure" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_115,
                    "Inbound Error: LE failed to load the XML Converter Driver to its PreInit table" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_120,
                    "Inbound Error: LE failed to load the XML Converter Driver Metadata Service to its PreInit table" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_125,
                    "Inbound Error: LE failed to invoke the Driver Metadata Service to obtain storage size and codepage information" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_131,
                    "Inbound Error: Failed to obtain storage for storing converted message" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_136,
                    "Inbound Error: LE failed to invoke the XML Converter Driver" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_141,
                    "Inbound Error: XML converter Driver error" },

            { ImsConnectErrorMessage.CBLADP_RETCODE_210,
                    "Outbound Error: The specified XML Converter Driver was not found or there was a load failure" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_215,
                    "Outbound Error: LE failed to load the XML Converter Driver to its PreInit table" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_220,
                    "Outbound Error: LE failed to load the XML Converter Driver Metadata Service to its PreInit table" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_225,
                    "Outbound Error: LE failed to invoke the Driver Metadata Service to obtain storage size and codepage information" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_231,
                    "Outbound Error: Failed to obtain storage for storing converted message" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_236,
                    "Outbound Error: LE failed to invoke the XML Converter Driver" },
            { ImsConnectErrorMessage.CBLADP_RETCODE_241,
                    "Outbound Error: XML converter Driver error" },
            
            
            // Detailed valid property value descriptions
            // generic property types
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_STRING, "a String" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_BOOLEAN, "a boolean" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_INTEGER, "an integer" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_BYTE, "a byte" }, 
            
            // Connection property types
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_HOSTNAME, "valid IPV4 or IPV6 IP address or host name" },
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_PORTNUMBER, "between 1 and 65535, inclusive" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_SOCKETTYPE, "a byte value of 0x00 or 0x10" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_SSLENCRYPTIONTYPE, "a byte value of 0x00, 0x01 or 0x02" }, 
            
            //TmInteraction property types
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_ACKNAKPROVIDER, "a byte value of 0x00 or 0x01" },  
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_ARCHLEVEL, "an achitecture level between " + com.ibm.ims.connect.ApiProperties.ARCH_LEVEL_MIN_VALUE + " and " + com.ibm.ims.connect.ApiProperties.ARCH_LEVEL_MAX_VALUE },
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_COMMITMODE, "a byte value of 0x20 or 0x40" },  
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_IMSCONNECTTIMEOUT, "an integer value of -23 or between -1 and 3,600,000, inclusive" },
//            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_IMSCONNECTUNICODEENCODINGSCHEMA, "a byte value of 0x00, 0x01 or 0x02" }, 
//            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_IMSCONNECTUNICODEUSAGE, "a byte value of 0x00, 0x10 or 0x20" },
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_INPUTMESSAGEOPTIONS, "a byte value of 0x00 or 0x40" },
//          ***** Do NOT translate VALID_PROPERTY_VALUE_INTERACTIONTYPEDESCRIPTION - values shown in message should match values required to be set in TmInteraction.setInteractionTypeDesc()       
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_INTERACTIONTYPEDESCRIPTION, "\"ACK\", \"CANCELTIMER\", \"ENDCONVERSATION\", \"RECEIVE\", \"SENDONLYACK\", \"NAK\", \"SENDONLYXCFORDDLV\", \"RESUMETPIPE\", \"SENDONLY\", \"SENDONLYCALLOUTRESPONSE\",\"SENDONLYACKCALLOUTRESPONSE\", or \"SENDRECV\"" },
            //------------------Added for Sync callout------------------------------////
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_CALLOUTREQUESTNAKPROCESSING, "\"DISCARDREQUESTCONTINUERESUMETPIPE\", \"DISCARDREQUESTENDRESUMETPIPE\", or \"REQUEUEREQUESTENDRESUMETPIPE\"" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_RESPONSEMESSAGETYPE, "\"CALLOUTRESPONSEMESSAGE\", or \"CALLOUTERRORMESSAGE\"" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_RESUMETPIPERETRIEVALTYPE, "a byte value of 0x00 or 0x40 or 0x80" },
            //--------------------End-----------------------------------------------////
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_RESUMETPIPEPROCESSING, "a byte value of 0x01, 0x02, 0x04 or 0x10" }, 
            { ImsConnectErrorMessage.VALID_PROPERTY_VALUE_SYNCLEVEL, "a byte value of 0x00 or 0x01" }, 
    };

    /*
     * (non-Javadoc)
     * 
     * @see java.util.ListResourceBundle#getContents()
     */
    protected Object[][] getContents()
    {
        return contents;
    }
}
