/*
 * File: ImsConnectExecutionException.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2009, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

/**
 * This class reports an error condition in executing an interaction with IMS
 * Connect. 
 */
public class ImsConnectExecutionException extends Exception
{
    /**
     * 
     */
    private static final long serialVersionUID = -8421202229573577200L;


    public static final String copyright =
        "Licensed Material - Property of IBM "
            + "5655-TDA"
            + "(C) Copyright IBM Corp. 2009, 2013  All Rights Reserved. "
            + "US Government Users Restricted Rights - Use, duplication or "
            + "disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
            

    private String errorNumber; // = "HWS0000E";
    private String errorMessage; // = "Unrecognized error"; 
    private int returnCode; //     = -1; // -1 indicates that a return code was not available for this exception
    private int reasonCode; //     = -1; // -1 indicates that a reason code was not available for this exception
    private int racfReturnCode; // = -1; // -1 indicates that a return code was not available for this exception
    private String racfReturnCodeString; // = ""; // "" indicates that a return code string was not available for this exception


    /**
     * @param anErrNo
     * @param anErrMsg
     */
    public ImsConnectExecutionException(String anErrNo, String anErrMsg)
    {
        super(anErrMsg);
        this.errorMessage = anErrMsg;
        this.errorNumber = anErrNo;
    }

    /**
     * @param errNo
     * @param errMsg
     */
    public ImsConnectExecutionException(String anErrNo, 
                                        String anErrMsg,
                                        int anImsConnectReturnCode,
                                        int anImsConnectReasonCode,
                                        int aRacfReturnCode,
                                        String aRacfRetCodeString)
    {
//        super(anErrMsg);
        this.errorNumber = anErrNo;
        this.errorMessage = anErrMsg;
        this.returnCode = anImsConnectReturnCode;
        this.reasonCode = anImsConnectReasonCode;
        this.racfReturnCode = aRacfReturnCode;
        this.racfReturnCodeString = aRacfRetCodeString;
    }

    /**
     * @param errorNumber the errorNumber to set
     */
    public void setErrorNumber(String errorNumber)
    {
        this.errorNumber = errorNumber;
    }

    /**
     * @return the errorMessage
     */
    public String getErrorMessage()
    {
        return this.errorMessage;
    }

    /**
     * @param errorMessage the errorMessage to set
     */
    public void setErrorMessage(String errorMessage)
    {
        this.errorMessage = errorMessage;
    }

    public String getErrorNumber()
    {
        return this.errorNumber;
    }
    
    /**
     * @return
     */
    public int getReasonCode()
    {
        return reasonCode;
    }

    /**
     * @param i
     */
    public void setReasonCode(int i)
    {
        reasonCode = i;
    }

    /**
     * @return
     */
    public int getReturnCode()
    {
        return returnCode;
    }

    /**
     * @param i
     */
    public void setReturnCode(int i)
    {
        returnCode = i;
    }

    /**
     * @return
     */
    public int getracfReturnCode()
    {
        return racfReturnCode;
    }

    /**
     * @param i
     */
    public void setRacfReturnCode(int i)
    {
        racfReturnCode = i;
    }

    /**
     * @return
     */
    public String getracfReturnCodeString()
    {
        return racfReturnCodeString;
    }

    /**
     * @param aString
     */
    public void setRacfReturnCodeString(String aString)
    {
        racfReturnCodeString = aString;
    }

    /**
     * @return
     */
    public String toString()
    {
        return errorMessage;
    }
}
