/**
 * File: Mbr.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import java.util.Vector;

/**
 * A Mbr object represents a specific <code>Mbr</code> element of a type-2 command response message.
 * This element can be contained within any of the following elements in the response message:
 * <ul>
 * <li>Cmdclients: returned for a QUERY(CMDCLIENTS) request</li>
 * <li>Msgdata: returned for requests that returned IMS messages from one or more command processing clients</li>
 * <li>Cmderr: returned for requests that resulted in a processing error from one or more command processing clients</li>
 * </ul>
 * <p> This element associates a subset of the parent element with a specific OM command processing client. 
 * For example, each command processing client that encountered an error while executing a type-2 command
 * will have a separate <code>Mbr</code> element. You can instantiate a Mbr object ArrayList for each parent element
 * from the object that represents each parent element with the getMbr methods of that object.</p>
 *
 *@since Enterprise Suite 2.1
 */
public interface Mbr
{
    /**
     * Returns true if the <code>typ</code> element exists for this <code>mbr</code> element. 
     * @return the typPresent
     */
    public boolean isTypPresent();

    /**
     * Returns true if the <code>styp</code> element exists for this <code>mbr</code> element. 
     * @return the stypPresent
     */
    public boolean isStypPresent();
    
    /**
     * Returns true if the <code>vsn</code> element exists for this <code>mbr</code> element.
     * @return the vsnPresent
     */
    public boolean isVsnPresent();
    
    /**
     * Returns true if the <code>jobname</code> element exists for this <code>mbr</code> element.
     * @return the jobnamePresent
     */
    public boolean isJobnamePresent();
    
    /** 
     * Returns true if the <code>rc</code> element exists for this <code>mbr</code> element.
     * @return the rcPresent
     */
    public boolean isRcPresent();
    
    /**
     * Returns true if the <code>rsn</code> element exists for this <code>mbr</code> element.
     * @return the rsnPresent
     */
    public boolean isRsnPresent();
    
    /**
     * Returns true if the <code>rsntxt</code> element exists for this <code>mbr</code> element.
     * @return the rsntxtPresent
     */
    public boolean isRsntxtPresent();
    
    /**
     * Returns true if the <code>msg</code> element exists for this <code>mbr</code> element.
     * @return the msgPresent
     */
    public boolean isMsgPresent();
    
    /**
     * Gets the text from the <code>jobname</code> element. This is the name of the job within which the
     * client processed the command.
     * @return the jobname
     */
    public String getJobname();
    
    /**
     * Gets any plain text in this <code>mbr</code> element. This includes the name of the command
     * processing client.
     * @return the elementText
     */
    public String getElementText();
    
    /**
     * Gets all of the IMS messages returned by this command processing client. This information is
     * present if the <code>Mbr</code> element that this Mbr object represents is a child of the <code>msgdata</code>
     * element in the response message.
     * @return the msg
     */
    public String[] getMsg();
    
    /**
     * Gets the last message returned by this command processing client. If an abend or command failure occured,
     * the last message in the list typically contains information about the failure. This information is
     * present if the <code>Mbr</code> element that this Mbr object represents is a child of the <code>msgdata</code>
     * element in the response message.
     * @return the last element of the msg String Vector
     */
    public String getLastMsgElement();
    
    /**
     * Gets a specific IMS message in the message list. This information is
     * present if the <code>Mbr</code> element that this Mbr object represents is a child of the <code>msgdata</code>
     * element in the response message.
     * @return the msg element at position anElementNumber
     * @see Type2CmdResponse#getMsgdataMbrMsgStringArray()
     */
    public String getMsg(int anElementNumber);
    
    /**
     * Gets the command return code for this command processing client. This information is present if the <code>Mbr</code>
     * element that this Mbr object represents is a child of the <code>cmderr</code> element in the response message.
     * @return the rc
     */
    public String getRc();
    
    /**
     * Gets the command reason code for this command processing client. This information is present if the <code>Mbr</code>
     * element that this Mbr object represents is a child of the <code>cmderr</code> element in the response message.
     * @return the rsn
     */
    public String getRsn();
    
    /**
     * Gets the command reason text for this command processing client. This information is present if the <code>Mbr</code>
     * element that this Mbr object represents is a child of the <code>cmderr</code> element in the response message.
     * @return the rsntxt
     */
    public String getRsntxt();
    
    /**
     * Gets the IMSPlex member subtype for this command processing client. This information is present if the <code>Mbr</code>
     * element that this Mbr object represents is a child of the <code>cmdclients</code> element in the response message.
     * @return the styp
     */
    public String getStyp();
    
    /**
     * Gets the IMSPlex member type for this command processing client. This information is present if the <code>Mbr</code>
     * element that this Mbr object represents is a child of the <code>cmdclients</code> element in the response message.
     * @return the typ
     */
    public String getTyp();
    
    /**
     * Gets the version number of this command processing client. This information is present if the <code>Mbr</code> element
     * that this Mbr object represents is a child of the <code>cmdclients</code> element in the response message.
     * @return the vsn
     */
    public String getVsn();
}