/*
 * File: OutputMessageProperties.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2009, 2014 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

/**
 * @author hfung
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class OutputMessageProperties implements ApiProperties
{
    public static final String copyright =
        "Licensed Material - Property of IBM "
            + "5655-TDA"
            + "(C) Copyright IBM Corp. 2009, 2013  All Rights Reserved. "
            + "US Government Users Restricted Rights - Use, duplication or "
            + "disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
            
    public final static int MSGTYPE_INVALID = -1;

    public final static int MSGTYPE_DATA = 0;

    public final static int MSGTYPE_DFS = 1;

    public final static int MSGTYPE_RSM_REQSTS = 2;

    public final static int MSGTYPE_RSM_CBLADP = 3;

    public final static int MSGTYPE_T2CMD_XML_RESPONSE = 4;

    // Properties for RSM
    public static String RSM_ID_REQSTS = "*REQSTS*";

    public static String RSM_ID_CBLADP = "*XADPST*";

    // Properties for Type-2 command XML response  
    public static String T2C_ID = "</IMSOUT>";
    
    // Lengths
    public final static int LEN_RSM = 20;

    public final static int LEN_RSM_ID = 8;

    public final static int LEN_RSM_RETCOD = 4;

    public final static int LEN_RSM_RSNCOD = 4;

    public final static int LEN_CSM = 12;

    public final static int LEN_CSM_ID = 8;

    public final static int LEN_RMM_ID = 8;
    
    public final static int LEN_RMM = 8;
    
    public final static int LEN_GENCID = 8;
   

    //------------------Added for Sync callout------------------------------////
   
    public final static int LEN_COR = 40;
    
    public final static int LEN_COR_SEGMENT = 52;
    
    public final static int LEN_COR_ID = 8;
  
    public final static String COR_ID_CORTKN = "*CORTKN*";
    //-----------------End-----------------------------------------
    
    public final static int LEN_MSG_MIN = LEN_CSM;

    public final static int LEN_LLZZ = 4;
    

    public final static int POS_LLLL = 0;

//    public static int POS_RSM_ID = 8;
    public final static int POS_RSM_ID = 4;

    public final static int POS_RSM_RETCOD = POS_RSM_ID + LEN_RSM_ID; // 16 // 12

//    public static int POS_RSM_RSNCOD = POS_RSM_RETCOD + LEN_RSM_RSNCOD; //20
    public final static int POS_RSM_RSNCOD = POS_RSM_RETCOD + LEN_RSM_RETCOD; //16

    public final static int POS_MSG = 4;

    // Properties for CSM
    // himakar 03/05/07 Callout changes; these are from IMS Connect manuals
    public final static String CSM_ID_CSMOKY = "*CSMOKY*";

    public final static int POS_CSM_FLG_Z1 = 2;

    public final static int POS_CSM_FLG_Z2 = 3;

    public final static int POS_CSM_ID = 4;

    public final static byte CSM_FLG1_NOFLAG = (byte) 0x00; // no flags set
    
    public final static byte CSM_FLG1_PLAVAIL = (byte) 0x10; // protocol level reporting supported
    
    public final static byte CSM_FLG1_RESP = (byte) 0x20; // ACK/NAK required

    public final static byte CSM_FLG1_CONV = (byte) 0x40; // Conversational output

    public final static byte CSM_FLG1_ASYNC = (byte) 0x80; // Async output available
    
    public final static byte CSM_FLG2_NOFLAG = (byte) 0x00; // base protocol level (no CM0 ACK No Wait support)
    
    public final static byte CSM_FLG2_PL2 = (byte) 0x02; // protocol level 2 (CM0 ACK No Wait supported)
    
    // Properties for RMM
    public final static int POS_RMM_ID = 4;
    
    public final static int POS_RMM = 12;
    
    public final static String RMM_ID_REQMOD = "*REQMOD*";
    
    public final static int LEN_RMM_ID_REQMOD = 8;
 
    // Properties for GENCID
    public final static int POS_CLIENTID_ID = 4;
    
    public final static int POS_CLIENTID = 12;
    
    public final static String CLIENTID_ID_GENCID = "*GENCID*";
    
    public final static int LEN_CLIENTID_ID_GENCID = 8;
    
    
    
    // Properties for COBOL Adapter
    public final static byte COBOL_ADAPTER_REASON_CODE_INBOUND_DRIVER_LOAD_ERROR = 110;

//    public final static byte COBOL_ADAPTER_REASON_CODE_OUTBOUND_DRIVER_LOAD_ERROR = 210;

  //------------------Added for Sync callout------------------------------////
   
    public final static String CALLOUT_ID_CORTKN = "*CORTKN*";
    //----------------------End----------------------------------------
}
