/**
 * File: Saf.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

/**
 * Represents the <code>saf</code> element of a type-2 command response message. The <code>saf</code> element
 * contains information about a security authorization failure that was generated by RACF or an equivalent
 * security product.
 *
 * @since Enterprise Suite 2.1
 */
public interface Saf
{
    /**
     * Gets any plain text in the element.
     * @return the safElementText
     */
    public String getSafElementText();
    
    /**
     * Gets the text of the <code>rc</code> child element. This element contains the SAF return code for the failure,
     * if one exists.
     * @return the rc
     */
    public String getRc();
    
    /**
     * Gets the text of the <code>racfrc</code> child element. This element contains the return code from RACF or an 
     * equivalent security product.
     * @return the racfrc
     */
    public String getRacfrc();
    
    /**
     * Gets the text of the <code>racfrsn</code> child element. This element contains the reason code from RACF
     * or an equivalent security product.
     * @return the racfrsn
     */
    public String getRacfrsn();
}
