/**
 * File: Type2CmdResponse.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.impl.CmdrspdataImpl;
import com.ibm.ims.connect.impl.ImsoutImpl;

import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

/**
 * Provide methods for retrieving type-2 command response output.
 * <p>Instantiate this object with the getType2CommandResponse method of the OutputMessage object
 * in your client application program after it receives a response from IMS Connect.
 * <p>You can retrieve the type-2 response data in three ways:
 * <ul>
 * <li>Call getXmlTaggedRspStringArray() to get the response as an XML 1.0 document.</li>
 * <li>Call getRspElementPropertiesObject() to get a a key-value paired array of element names and values.</li>
 * <li>Instantiate individual child element objects to get specific response message element content.</li>
 * </ul>
 * <p>The contents of the response message vary depending on the success or failure of the command,
 * the command that was issued, and the exact result of the command. 
 * <p>
 * <p>See the IMS type-2 command documentation for the specific command you issued for more information.
 * @see <a href="../com.ibm.ims13.doc.spr/ims_csl_opmgrxml.htm">CSL Operations Manager XML output</a>
 * @since Enterprise Suite 2.1
 *
 */
public class Type2CmdResponse
{
    private Logger logger; 
    
    private String imsConnect = null;
    private String myImsConnectCodepage = null;
    
    @SuppressWarnings("unused")
    private String[] hdrStringArray = null;
//    Properties[] arrayOfHdrElements = null;
    private Properties[] attributesForAllHdrElementsAsPropertiesObjects = null;
  
    protected String[] rspStringArray = null;
    private Properties[] rspElementPropertiesObject = null;
    private String[] xmlTaggedRspStringArray = null;
    
    private String[] msgdataMbrMsgStringArray = null;
//    private Properties[] arrayOfMsgdataMbrMsgElementPropertiesObjects = null;
//    private String[] xmlTaggedMsgdataMbrMsgStringArray = null;
    
    @SuppressWarnings("unused")
//    private String[] mbrStringArray = null;
//    Properties[] arrayOfMbrElements = null;
    
    private String[] msgStringArray = null;
    Properties[] arrayOfMsgElementProperties = null;
    
    private boolean type2CmdRspStale = false;
    
    private boolean responseContainsCmdrspdataElement = false;
    private boolean responseContainsMsgdataElement = false;
    
    private boolean imsOutBeingParsed = false;
    
    private boolean ctlBeingParsed = false;
    private boolean ctlOmnameBeingParsed = false;
    private boolean ctlOmvsnBeingParsed = false;
    private boolean ctlXmlvsnBeingParsed = false;
    private boolean ctlStatimeBeingParsed = false;
    private boolean ctlStotimeBeingParsed = false;
    private boolean ctlStaseqBeingParsed = false;
    private boolean ctlStoseqBeingParsed = false;
    private boolean ctlRqsttkn1BeingParsed = false;
    private boolean ctlRqsttkn2BeingParsed = false;
    private boolean ctlRcBeingParsed = false; 
    private boolean ctlRsnBeingParsed = false; 
    private boolean ctlRsnmsgBeingParsed = false; 
    private boolean ctlRsntxtBeingParsed = false; 
    private boolean ctlUomBeingParsed = false;
    
    private boolean cmdclientsBeingParsed = false; 
    private boolean cmdclientsMbrBeingParsed = false; 
    private boolean cmdclientsMbrTypBeingParsed = false; 
    private boolean cmdclientsMbrStypBeingParsed = false; 
    private boolean cmdclientsMbrVsnBeingParsed = false; 
    private boolean cmdclientsMbrJobnameBeingParsed = false; 
    
    private boolean cmdsyntaxBeingParsed = false; 
    
    private boolean cmddtdBeingParsed = false; 
    
    private boolean cmdtextBeingParsed = false; 
    
    private boolean cmderrBeingParsed = false; 
    private boolean cmderrMbrBeingParsed = false; 
    private boolean cmderrMbrTypBeingParsed = false; 
    private boolean cmderrMbrStypBeingParsed = false; 
    private boolean cmderrMbrRcBeingParsed = false; 
    private boolean cmderrMbrRsnBeingParsed = false; 
    private boolean cmderrMbrRsntxtBeingParsed = false; 
    
    private boolean cmdsecerrBeingParsed = false; 
    private boolean cmdsecerrExitBeingParsed = false; 
    private boolean cmdsecerrExitRcBeingParsed = false; 
    private boolean cmdsecerrExitUserdataBeingParsed = false; 
    private boolean cmdsecerrSafBeingParsed = false; 
    private boolean cmdsecerrSafRcBeingParsed = false; 
    private boolean cmdsecerrSafRacfrcBeingParsed = false; 
    private boolean cmdsecerrSafRacfrsnBeingParsed = false; 
    
    private boolean cmdBeingParsed = false;
    private boolean cmdMasterBeingParsed = false;
    private boolean cmdUserIdBeingParsed = false;
    private boolean cmdVerbBeingParsed = false;
    private boolean cmdKwdBeingParsed = false;
    private boolean cmdInputBeingParsed = false;
    
    private boolean cmdrsphdrBeingParsed = false;
    private boolean cmdrsphdrHdrBeingParsed = false; 
    
    private boolean cmdrspdataBeingParsed = false;
    private boolean cmdrspdataRspBeingParsed = false;
    
    private boolean msgdataBeingParsed = false;
    private boolean msgdataMbrBeingParsed = false;
    private boolean msgdataMbrMsgBeingParsed = false;
    
    private Imsout imsout = new ImsoutImpl();
    @SuppressWarnings("unused")
    private Ctl ctl = null;
/*    private String ctlOmname = null;
    private String ctlOmvsn = null;
    private String ctlXmlvsn = null;
    private String ctlStatime = null;
    private String ctlStotime = null;
    private String ctlStaseq = null;
    private String ctlStoseq = null;
    private byte[] ctlRqsttkn1 = null; // byte array containing the contents of the rqsttkn1 element of imsout 
    private byte[] ctlRqsttkn2 = null; // byte array containing the contents of the rqsttkn2 element of imsout
    private String ctlRc = null;
    private String ctlRsn = null;
    private String ctlRsnmsg = null;
    private String ctlRsntxt = null;
    private String ctlUom = null;
**/    
    private Cmdclients cmdclients = null; 
/*    private Mbr[] cmdclientsMbr = null; 
    private String cmdclientsMbrTyp = null; 
    private String cmdclientsMbrStyp = null; 
    private String cmdclientsMbrVsn = null; 
    private String cmdclientsMbrJobname = null; 
    private String cmdclientsMbrRc = null; 
    private String cmdclientsMbrRsn = null; 
    private String cmdclientsMbrRsntxt = null; 
    private String[] cmdclientsMbrMsg = null; 
**/    
    private String cmdsyntax = null; 
    
    private String cmddtd = null; 
    
    private String cmdtext = null; 
    
    private Cmderr cmderr = null; 
/*    private Mbr[] cmderrMbr = null; 
    private String cmderrMbrTyp = null; 
    private String cmderrMbrStyp = null; 
    private String cmderrMbrVsn = null; 
    private String cmderrMbrJobname = null; 
    private String cmderrMbrRc = null; 
    private String cmderrMbrRsn = null;
    private String cmderrMbrRsntxt = null;
    private String[] cmderrMbrMsg = null; 
**/    
    private Cmdsecerr cmdsecerr = null; 
/*    private String cmdsecerrExit = null; 
    private String cmdsecerrExitRc = null; 
    private String cmdsecerrExitUserdata = null; 
    private String cmdsecerrSaf = null; 
    private String cmdsecerrSafRc = null; 
    private String cmdsecerrSafRacfrc = null; 
    private String cmdsecerrSafRacfrsn = null; 
**/    
    private Cmd cmd = null;
/*    private String cmdElementText = null;
    private String cmdMaster = null;
    private String cmdUserId = null;
    private String cmdVerb = null;
    private String cmdKwd = null;
**/    private String cmdInput = null;
    
    private Cmdrsphdr cmdrsphdr = null;
//    private CmdrsphdrHdr[] cmdrsphdrHdr = null;  // array of all cmdrsphdrHdr elements in imsout
    
    private Cmdrspdata cmdrspdata = null;
//    private String[] cmdrspdataRsp = null; // array of all rsp elements in imsout
    
    private Msgdata msgdata = null;
/*    private String msgdataElementText = null;
    private Mbr[] msgdataMbr = null; // array of all mbr elements in imsout
    private int numberOfMsgdataMbrElements = 0;
    private String msgdataMbrElementText = null;
    private String msgdataMbrTyp = null; 
    private String msgdataMbrStyp = null; 
    private String msgdataMbrVsn = null; 
    private String msgdataMbrJobname = null; 
    private String msgdataMbrRc = null; 
    private String msgdataMbrRsn = null;
    private String msgdataMbrRsntxt = null; 
    private String[] msgdataMbrMsg = null; 
**/
    //Declared for Constructor Type2CmdResponse(String anImsConnectCodepage,byte[] omOutputByteArray) for parsing
    private XmlParser myXmlParser = new XmlParser();
    
    public Type2CmdResponse(String anImsConnectCodepage)
    {
        logger = Logger.getLogger("com.ibm.ims.connect");
        this.myImsConnectCodepage = anImsConnectCodepage;
    }
    
    public Type2CmdResponse(String anImsConnectCodepage,byte[] omOutputByteArray) throws ImsConnectApiException
    {
        logger = Logger.getLogger("com.ibm.ims.connect");
        this.myImsConnectCodepage = anImsConnectCodepage;
        this.setType2CmdrspdataStale(true);// Setting value to get it parsed
		
    	myXmlParser.parseXml(this,
    			omOutputByteArray, myImsConnectCodepage);
    	
    	this.setType2CmdrspdataStale(false);
    }
    
    /**
     * Resets all of the fields of this object to the starting state
     * @param anImsConnectCodepage
     */
    public void reset(String anImsConnectCodepage)
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
              logger.finer("--> Type2CmdResponse.reset()");
          
        imsConnect = null;
        myImsConnectCodepage = anImsConnectCodepage;
        
        hdrStringArray = null;
//        arrayOfHdrElements = null;
      
        rspStringArray = null;
        rspElementPropertiesObject = null;
        
//        mbrStringArray = null;
//        arrayOfMbrElements = null;
        
        msgStringArray = null;
        arrayOfMsgElementProperties = null;
        
        setType2CmdrspdataStale(false);
        
        responseContainsCmdrspdataElement = false;
        responseContainsMsgdataElement = false;
        
        imsOutBeingParsed = false;
        
        ctlBeingParsed = false;
        ctlOmnameBeingParsed = false;
        ctlOmvsnBeingParsed = false;
        ctlXmlvsnBeingParsed = false;
        ctlStatimeBeingParsed = false;
        ctlStotimeBeingParsed = false;
        ctlStaseqBeingParsed = false;
        ctlStoseqBeingParsed = false;
        ctlRqsttkn1BeingParsed = false;
        ctlRqsttkn2BeingParsed = false;
        ctlRcBeingParsed = false; 
        ctlRsnBeingParsed = false; 
        ctlRsnmsgBeingParsed = false; 
        ctlRsntxtBeingParsed = false; 
        ctlUomBeingParsed = false; 
        
        cmdclientsBeingParsed = false; 
        cmdclientsMbrBeingParsed = false; 
        cmdclientsMbrTypBeingParsed = false; 
        cmdclientsMbrStypBeingParsed = false; 
        cmdclientsMbrVsnBeingParsed = false; 
        cmdclientsMbrJobnameBeingParsed = false; 
//        cmdclientsMbrRcBeingParsed = false; 
//        cmdclientsMbrRsnBeingParsed = false; 
//        cmdclientsMbrRsntxtBeingParsed = false; 
//        cmdclientsMbrMsgBeingParsed = false; 
        
        cmdsyntaxBeingParsed = false; 
        
        cmddtdBeingParsed = false; 
        
        cmdtextBeingParsed = false; 
        
        cmderrBeingParsed = false; 
        cmderrMbrBeingParsed = false; 
        cmderrMbrTypBeingParsed = false; 
        cmderrMbrStypBeingParsed = false; 
//        cmderrMbrVsnBeingParsed = false; 
//        cmderrMbrJobnameBeingParsed = false; 
        cmderrMbrRcBeingParsed = false; 
        cmderrMbrRsnBeingParsed = false; 
        cmderrMbrRsntxtBeingParsed = false; 
//        cmderrMbrMsgBeingParsed = false; 
        
        cmdsecerrBeingParsed = false; 
        cmdsecerrExitBeingParsed = false; 
        cmdsecerrExitRcBeingParsed = false; 
        cmdsecerrExitUserdataBeingParsed = false; 
        cmdsecerrSafBeingParsed = false; 
        cmdsecerrSafRcBeingParsed = false; 
        cmdsecerrSafRacfrcBeingParsed = false; 
        cmdsecerrSafRacfrsnBeingParsed = false; 
        
        cmdBeingParsed = false;
        cmdMasterBeingParsed = false;
        cmdUserIdBeingParsed = false;
        cmdVerbBeingParsed = false;
        cmdKwdBeingParsed = false;
        cmdInputBeingParsed = false;
        
        cmdrsphdrBeingParsed = false;
        cmdrsphdrHdrBeingParsed = false; 
        
        cmdrspdataBeingParsed = false;
        cmdrspdataRspBeingParsed = false;
        
        msgdataBeingParsed = false;
        msgdataMbrBeingParsed = false;
//        msgdataMbrTypBeingParsed = false; 
//        msgdataMbrStypBeingParsed = false; 
//        msgdataMbrVsnBeingParsed = false; 
//        msgdataMbrJobnameBeingParsed = false; 
//        msgdataMbrRcBeingParsed = false; 
//        msgdataMbrRsnBeingParsed = false; 
//        msgdataMbrRsntxtBeingParsed = false; 
        msgdataMbrMsgBeingParsed = false;
        
        imsout = new ImsoutImpl();
        ctl = null;
/*        ctlOmname = null;
        ctlOmvsn = null;
        ctlXmlvsn = null;
        ctlStatime = null;
        ctlStotime = null;
        ctlStaseq = null;
        ctlStoseq = null;
        ctlRqsttkn1 = null; // byte array containing the contents of the rqsttkn1 element of imsout 
        ctlRqsttkn2 = null; // byte array containing the contents of the rqsttkn2 element of imsout
        ctlRc = null;
        ctlRsn = null;
        ctlRsnmsg = null;
        ctlRsntxt = null;
        ctlUom = null;
**/        cmdclients = null; 
/*       cmdclientsMbr = null; 
        cmdclientsMbrTyp = null; 
        cmdclientsMbrStyp = null; 
        cmdclientsMbrVsn = null; 
        cmdclientsMbrJobname = null; 
        cmdclientsMbrRc = null; 
        cmdclientsMbrRsn = null; 
        cmdclientsMbrMsg = null; 
**/        cmdsyntax = null; 
        cmddtd = null; 
        cmdtext = null; 
        cmderr = null; 
/*        cmderrMbr = null; 
        cmderrMbrTyp = null; 
        cmderrMbrStyp = null; 
        cmderrMbrVsn = null; 
        cmderrMbrJobname = null; 
        cmderrMbrRc = null; 
        cmderrMbrRsn = null; 
        cmderrMbrMsg = null; 
**/        cmdsecerr = null; 
/*        cmdsecerrExit = null; 
        cmdsecerrExitRc = null; 
        cmdsecerrExitUserdata = null; 
        cmdsecerrSaf = null; 
        cmdsecerrSafRc = null; 
        cmdsecerrSafRacfrc = null; 
        cmdsecerrSafRacfrsn = null; 
**/        cmd = null;
/*        cmdElementText = null;
        cmdMaster = null;
        cmdUserId = null;
        cmdVerb = null;
        cmdKwd = null;
        cmdInput = null;
**/        cmdrsphdr = null;
/*        cmdrsphdrHdr = null;  // array of all hdr elements in imsout
**/        cmdrspdata = null;
/*        cmdrspdataRsp = null; // array of all rsp elements in imsout
**/        msgdata = null;
/*        msgdataElementText = null;
        msgdataMbr = null; // array of all mbr elements in imsout
        numberOfMsgdataMbrElements = 0;
        msgdataMbrElementText = null;
        msgdataMbrTyp = null; 
        msgdataMbrStyp = null; 
        msgdataMbrVsn = null; 
        msgdataMbrJobname = null; 
        msgdataMbrRc = null; 
        msgdataMbrRsn = null; 
        msgdataMbrMsg = null; 
**/        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
              logger.finer("<-- Type2CmdResponse.reset()");
    }
    
    
    /**
     * Gets the XML response data as an array of decomposed element Strings.
     * @return the xmlTaggedRspStringArray, or null if the original command was invalid
     */
    public String[] getXmlTaggedRspStringArray() throws ImsConnectApiException
    {
        if(this.xmlTaggedRspStringArray == null)
        {
            getRspElementPropertiesObject();
        }
        return this.xmlTaggedRspStringArray;
    }
    
    
    /**
     * Gets an instance of the Imsout object for this response message. The <code>Imsout</code> element is
     * returned for every type-2 command request and encapsulates the entire OM response message.
     * @return the imsout
     * @see Imsout
     */
    public Imsout getImsout()
    {
        return this.imsout;
    }
    
    /**
     * @param imsout the imsout to set
     */
    protected void setImsout(Imsout imsout)
    {
        this.imsout = imsout;
    }
    
    
    /**
     * Gets the name of the IMS Connect host that the command was routed through.
     * @return the imsConnect
     */
    public String getImsConnect()
    {
        return this.imsConnect;
    }
    
    /**
     * @param imsConnect the imsConnect to set
     */
    protected void setImsConnect(String imsConnect)
    {
        this.imsConnect = imsConnect;
    }
    
    
    
    /**
     * @return the cmddtdElementBeingParsed
     */
    protected boolean isCmddtdElementBeingParsed()
    {
        return this.cmddtdBeingParsed;
    }

    /**
     * @param cmddtdElementBeingParsed the cmddtdElementBeingParsed to set
     */
    protected void setCmddtdElementBeingParsed(boolean cmddtdElementBeingParsed)
    {
        this.cmddtdBeingParsed = cmddtdElementBeingParsed;
    }

    /**
     * @return the cmdsecerrElementBeingParsed
     */
    protected boolean isCmdsecerrElementBeingParsed()
    {
        return this.cmdsecerrBeingParsed;
    }

    /**
     * @param cmdsecerrElementBeingParsed the cmdsecerrElementBeingParsed to set
     */
    protected void setCmdsecerrElementBeingParsed(boolean cmdsecerrElementBeingParsed)
    {
        this.cmdsecerrBeingParsed = cmdsecerrElementBeingParsed;
    }

    /**
     * @return the cmdsyntaxElementBeingParsed
     */
    protected boolean isCmdsyntaxElementBeingParsed()
    {
        return this.cmdsyntaxBeingParsed;
    }

    /**
     * @param cmdsyntaxElementBeingParsed the cmdsyntaxElementBeingParsed to set
     */
    protected void setCmdsyntaxElementBeingParsed(boolean cmdsyntaxElementBeingParsed)
    {
        this.cmdsyntaxBeingParsed = cmdsyntaxElementBeingParsed;
    }

    /**
     * @return the cmdtextElementBeingParsed
     */
    protected boolean isCmdtextElementBeingParsed()
    {
        return this.cmdtextBeingParsed;
    }

    /**
     * @param cmdtextElementBeingParsed the cmdtextElementBeingParsed to set
     */
    protected void setCmdtextElementBeingParsed(boolean cmdtextElementBeingParsed)
    {
        this.cmdtextBeingParsed = cmdtextElementBeingParsed;
    }

    /**
     * @return the cmdclientsElementBeingParsed
     */
    protected boolean isCmdclientsElementBeingParsed()
    {
        return this.cmdclientsBeingParsed;
    }

    /**
     * @param cmdclientsBeingParsed the cmdclientsElementBeingParsed to set
     */
    protected void setCmdclientsElementBeingParsed(boolean aCmdclientsElementBeingParsed)
    {
        this.cmdclientsBeingParsed = aCmdclientsElementBeingParsed;
    }

    /**
     * @return the cmdclientsMbrJobnameElementBeingParsed
     */
    protected boolean isCmdclientsMbrJobnameElementBeingParsed()
    {
        return this.cmdclientsMbrJobnameBeingParsed;
    }

    /**
     * @param cmdclientsMbrJobnameBeingParsed the cmdclientsMbrJobnameElementBeingParsed to set
     */
    protected void setCmdclientsMbrJobnameElementBeingParsed(boolean aCmdclientsMbrJobnameElementBeingParsed)
    {
        this.cmdclientsMbrJobnameBeingParsed = aCmdclientsMbrJobnameElementBeingParsed;
    }

    /**
     * @return the cmdclientsMbrElementBeingParsed
     */
    protected boolean isCmdclientsMbrElementBeingParsed()
    {
        return this.cmdclientsMbrBeingParsed;
    }

    /**
     * @param cmdclientsMbrBeingParsed the cmdclientsMbrElementBeingParsed to set
     */
    protected void setCmdclientsMbrElementBeingParsed(boolean aCmdclientsMbrElementBeingParsed)
    {
        this.cmdclientsMbrBeingParsed = aCmdclientsMbrElementBeingParsed;
    }

    /**
     * @return the cmdclientsMbrStypElementBeingParsed
     */
    protected boolean isCmdclientsMbrStypElementBeingParsed()
    {
        return this.cmdclientsMbrStypBeingParsed;
    }

    /**
     * @param cmdclientsMbrStypBeingParsed the cmdclientsMbrStypElementBeingParsed to set
     */
    protected void setCmdclientsMbrStypElementBeingParsed(boolean aCmdclientsMbrStypElementBeingParsed)
    {
        this.cmdclientsMbrStypBeingParsed = aCmdclientsMbrStypElementBeingParsed;
    }

    /**
     * @return the cmdclientsMbrTypElementBeingParsed
     */
    protected boolean isCmdclientsMbrTypElementBeingParsed()
    {
        return this.cmdclientsMbrTypBeingParsed;
    }

    /**
     * @param cmdclientsMbrTypElementBeingParsed the cmdclientsMbrTypElementBeingParsed to set
     */
    protected void setCmdclientsMbrTypElementBeingParsed(boolean cmdclientsMbrTypElementBeingParsed)
    {
        this.cmdclientsMbrTypBeingParsed = cmdclientsMbrTypElementBeingParsed;
    }

    /**
     * @return the cmdclientsMbrVsnElementBeingParsed
     */
    protected boolean isCmdclientsMbrVsnElementBeingParsed()
    {
        return this.cmdclientsMbrVsnBeingParsed;
    }

    /**
     * @param aCmdclientsMbrVsnElementBeingParsed the cmdclientsMbrVsnElementBeingParsed to set
     */
    protected void setCmdclientsMbrVsnElementBeingParsed(boolean aCmdclientsMbrVsnElementBeingParsed)
    {
        this.cmdclientsMbrVsnBeingParsed = aCmdclientsMbrVsnElementBeingParsed;
    }

    /**
     * @return the cmderrMbrElementBeingParsed
     */
    protected boolean isCmderrMbrElementBeingParsed()
    {
        return this.cmderrMbrBeingParsed;
    }

    /**
     * @param cmderrMbrBeingParsed the cmderrMbrElementBeingParsed to set
     */
    protected void setCmderrMbrElementBeingParsed(boolean aCmdErrMbrElementBeingParsed)
    {
        this.cmderrMbrBeingParsed = aCmdErrMbrElementBeingParsed;
    }

    /**
     * @return the cmderrMbrRcElementBeingParsed
     */
    protected boolean isCmderrMbrRcElementBeingParsed()
    {
        return this.cmderrMbrRcBeingParsed;
    }

    /**
     * @param cmderrMbrRcBeingParsed the cmderrMbrRcElementBeingParsed to set
     */
    protected void setCmderrMbrRcElementBeingParsed(boolean aCmdErrMbrRcElementBeingParsed)
    {
        this.cmderrMbrRcBeingParsed = aCmdErrMbrRcElementBeingParsed;
    }

    /**
     * @return the cmderrMbrRsnElementBeingParsed
     */
    protected boolean isCmderrMbrRsnElementBeingParsed()
    {
        return this.cmderrMbrRsnBeingParsed;
    }

    /**
     * @param cmderrMbrRsnBeingParsed the cmderrMbrRsnElementBeingParsed to set
     */
    protected void setCmderrMbrRsnElementBeingParsed(boolean aCmdErrMbrRsnElementBeingParsed)
    {
        this.cmderrMbrRsnBeingParsed = aCmdErrMbrRsnElementBeingParsed;
    }

    /**
     * @return the cmderrMbrRsntxtBeingParsed
     */
    protected boolean isCmderrMbrRsntxtBeingParsed()
    {
        return this.cmderrMbrRsntxtBeingParsed;
    }


    /**
     * @param cmderrMbrRsntxtBeingParsed the cmderrMbrRsntxtBeingParsed to set
     */
    protected void setCmderrMbrRsntxtBeingParsed(boolean cmderrMbrRsntxtBeingParsed)
    {
        this.cmderrMbrRsntxtBeingParsed = cmderrMbrRsntxtBeingParsed;
    }


    /**
     * @return the cmderrMbrStypElementBeingParsed
     */
    protected boolean isCmderrMbrStypElementBeingParsed()
    {
        return this.cmderrMbrStypBeingParsed;
    }

    /**
     * @param cmderrMbrStypBeingParsed the cmderrMbrStypElementBeingParsed to set
     */
    protected void setCmderrMbrStypElementBeingParsed(boolean aCmdErrMbrStypElementBeingParsed)
    {
        this.cmderrMbrStypBeingParsed = aCmdErrMbrStypElementBeingParsed;
    }

    /**
     * @return the cmderrMbrTypElementBeingParsed
     */
    protected boolean isCmderrMbrTypElementBeingParsed()
    {
        return this.cmderrMbrTypBeingParsed;
    }

    /**
     * @param cmderrMbrTypBeingParsed the cmderrMbrTypElementBeingParsed to set
     */
    protected void setCmderrMbrTypElementBeingParsed(boolean aCmdErrMbrTypElementBeingParsed)
    {
        this.cmderrMbrTypBeingParsed = aCmdErrMbrTypElementBeingParsed;
    }

    /**
     * @return the cmderrElementBeingParsed
     */
    protected boolean isCmderrElementBeingParsed()
    {
        return this.cmderrBeingParsed;
    }

    /**
     * @param cmderrBeingParsed the cmderrElementBeingParsed to set
     */
    protected void setCmderrElementBeingParsed(boolean aCmdErrElementBeingParsed)
    {
        this.cmderrBeingParsed = aCmdErrElementBeingParsed;
    }

    /**
     * @return the cmdElementBeingParsed
     */
    protected boolean isCmdElementBeingParsed()
    {
        return this.cmdBeingParsed;
    }

    /**
     * @param cmdBeingParsed the cmdElementBeingParsed to set
     */
    protected void setCmdElementBeingParsed(boolean aCmdElementBeingParsed)
    {
        this.cmdBeingParsed = aCmdElementBeingParsed;
    }

    /**
     * @return the cmdrspdataElementBeingParsed
     */
    protected boolean isCmdrspdataElementBeingParsed()
    {
        return this.cmdrspdataBeingParsed;
    }

    /**
     * @param cmdrspdataBeingParsed the cmdrspdataElementBeingParsed to set
     */
    protected void setCmdrspdataElementBeingParsed(boolean aCmdrspdataElementBeingParsed)
    {
        this.cmdrspdataBeingParsed = aCmdrspdataElementBeingParsed;
    }

    /**
     * @return the cmdrsphdrElementBeingParsed
     */
    protected boolean isCmdrsphdrElementBeingParsed()
    {
        return this.cmdrsphdrBeingParsed;
    }

    /**
     * @param cmdrsphdrBeingParsed the cmdrsphdrElementBeingParsed to set
     */
    protected void setCmdrsphdrElementBeingParsed(boolean aCmdrsphdrElementBeingParsed)
    {
        this.cmdrsphdrBeingParsed = aCmdrsphdrElementBeingParsed;
    }

    /**
     * @return the ctlElementBeingParsed
     */
    protected boolean isCtlElementBeingParsed()
    {
        return this.ctlBeingParsed;
    }

    /**
     * @param aCtlElementBeingParsed the ctlElementBeingParsed to set
     */
    protected void setCtlElementBeingParsed(boolean aCtlElementBeingParsed)
    {
        this.ctlBeingParsed = aCtlElementBeingParsed;
    }

    /**
     * @return the cmdsecerrExitElementBeingParsed
     */
    protected boolean isCmdsecerrExitElementBeingParsed()
    {
        return this.cmdsecerrExitBeingParsed;
    }

    /**
     * @param cmdsecerrExitBeingParsed the cmdsecerrExitElementBeingParsed to set
     */
    protected void setCmdsecerrExitElementBeingParsed(boolean aCmdsecerrExitElementBeingParsed)
    {
        this.cmdsecerrExitBeingParsed = aCmdsecerrExitElementBeingParsed;
    }

    /**
     * @return the cmdsecerrExitRcElementBeingParsed
     */
    protected boolean isCmdsecerrExitRcElementBeingParsed()
    {
        return this.cmdsecerrExitRcBeingParsed;
    }

    /**
     * @param cmdsecerrExitRcBeingParsed the cmdsecerrExitRcElementBeingParsed to set
     */
    protected void setCmdsecerrExitRcElementBeingParsed(boolean mdsecerrExitRcElementBeingParsed)
    {
        this.cmdsecerrExitRcBeingParsed = mdsecerrExitRcElementBeingParsed;
    }

    /**
     * @return the cmdrsphdrHdrElementBeingParsed
     */
    protected boolean isCmdrsphdrHdrElementBeingParsed()
    {
        return this.cmdrsphdrHdrBeingParsed;
    }

    /**
     * @param cmdrsphdrHdrBeingParsed the cmdrsphdrHdrElementBeingParsed to set
     */
    protected void setCmdrsphdrHdrElementBeingParsed(boolean aCmdrsphdrHdrElementBeingParsed)
    {
        this.cmdrsphdrHdrBeingParsed = aCmdrsphdrHdrElementBeingParsed;
    }

    /**
     * @return the imsOutElementBeingParsed
     */
    protected boolean isImsOutElementBeingParsed()
    {
        return this.imsOutBeingParsed;
    }

    /**
     * @param anImsOutElementBeingParsed the imsOutElementBeingParsed to set
     */
    protected void setImsOutElementBeingParsed(boolean anImsOutElementBeingParsed)
    {
        this.imsOutBeingParsed = anImsOutElementBeingParsed;
    }

    /**
     * @return the cmdInputElementBeingParsed
     */
    protected boolean isCmdInputElementBeingParsed()
    {
        return this.cmdInputBeingParsed;
    }

    /**
     * @param cmdInputBeingParsed the cmdInputElementBeingParsed to set
     */
    protected void setCmdInputElementBeingParsed(boolean aCmdInputElementBeingParsed)
    {
        this.cmdInputBeingParsed = aCmdInputElementBeingParsed;
    }

    /**
     * @return the cmdKwdElementBeingParsed
     */
    protected boolean isCmdKwdElementBeingParsed()
    {
        return this.cmdKwdBeingParsed;
    }

    /**
     * @param cmdKwdBeingParsed the cmdKwdElementBeingParsed to set
     */
    protected void setCmdKwdElementBeingParsed(boolean aCmdKwdElementBeingParsed)
    {
        this.cmdKwdBeingParsed = aCmdKwdElementBeingParsed;
    }

    /**
     * @return the cmdMasterElementBeingParsed
     */
    protected boolean isCmdMasterElementBeingParsed()
    {
        return this.cmdMasterBeingParsed;
    }

    /**
     * @param cmdMasterBeingParsed the cmdMasterElementBeingParsed to set
     */
    protected void setCmdMasterElementBeingParsed(boolean masterElementBeingParsed)
    {
        this.cmdMasterBeingParsed = masterElementBeingParsed;
    }

    /**
     * @return the msgdataMbrMsgElementBeingParsed
     */
    protected boolean isMsgdataMbrMsgElementBeingParsed()
    {
        return this.msgdataMbrMsgBeingParsed;
    }

    /**
     * @param msgdataMbrMsgBeingParsed the msgdataMbrMsgElementBeingParsed to set
     */
    protected void setMsgdataMbrMsgElementBeingParsed(
            boolean messagedataMemberMessageElementBeingParsed)
    {
        this.msgdataMbrMsgBeingParsed = messagedataMemberMessageElementBeingParsed;
    }

    /**
     * @return the msgdataMbrElementBeingParsed
     */
    protected boolean isMsgdataMbrElementBeingParsed()
    {
        return this.msgdataMbrBeingParsed;
    }

    /**
     * @param msgdataMbrBeingParsed the msgdataMbrElementBeingParsed to set
     */
    protected void setMsgdataMbrElementBeingParsed(boolean messagedataMemberElementBeingParsed)
    {
        this.msgdataMbrBeingParsed = messagedataMemberElementBeingParsed;
    }

    /**
     * @return the msgdataElementBeingParsed
     */
    protected boolean isMsgdataElementBeingParsed()
    {
        return this.msgdataBeingParsed;
    }

    /**
     * @param msgdataBeingParsed the msgdataElementBeingParsed to set
     */
    protected void setMsgdataElementBeingParsed(boolean messagedataElementBeingParsed)
    {
        this.msgdataBeingParsed = messagedataElementBeingParsed;
    }

    /**
     * @return the ctlOmnameElementBeingParsed
     */
    protected boolean isCtlOmnameElementBeingParsed()
    {
        return this.ctlOmnameBeingParsed;
    }

    /**
     * @param ctlOmnameBeingParsed the ctlOmnameElementBeingParsed to set
     */
    protected void setCtlOmnameElementBeingParsed(boolean omNameElementBeingParsed)
    {
        this.ctlOmnameBeingParsed = omNameElementBeingParsed;
    }

    /**
     * @return the ctlOmvsnElementBeingParsed
     */
    protected boolean isCtlOmvsnElementBeingParsed()
    {
        return this.ctlOmvsnBeingParsed;
    }

    /**
     * @param ctlOmvsnBeingParsed the ctlOmvsnElementBeingParsed to set
     */
    protected void setCtlOmvsnElementBeingParsed(boolean omVersionElementBeingParsed)
    {
        this.ctlOmvsnBeingParsed = omVersionElementBeingParsed;
    }

    /**
     * @return the cmdsecerrSafRacfrcElementBeingParsed
     */
    protected boolean isCmdsecerrSafRacfrcElementBeingParsed()
    {
        return this.cmdsecerrSafRacfrcBeingParsed;
    }

    /**
     * @param cmdsecerrSafRacfrcBeingParsed the cmdsecerrSafRacfrcElementBeingParsed to set
     */
    protected void setCmdsecerrSafRacfrcElementBeingParsed(boolean racfrcElementBeingParsed)
    {
        this.cmdsecerrSafRacfrcBeingParsed = racfrcElementBeingParsed;
    }

    /**
     * @return the cmdsecerrSafRacfrsnElementBeingParsed
     */
    protected boolean isCmdsecerrSafRacfrsnElementBeingParsed()
    {
        return this.cmdsecerrSafRacfrsnBeingParsed;
    }

    /**
     * @param cmdsecerrSafRacfrsnBeingParsed the cmdsecerrSafRacfrsnElementBeingParsed to set
     */
    protected void setCmdsecerrSafRacfrsnElementBeingParsed(boolean racfrsnElementBeingParsed)
    {
        this.cmdsecerrSafRacfrsnBeingParsed = racfrsnElementBeingParsed;
    }

    /**
     * @return the ctlRsnmsgElementBeingParsed
     */
    protected boolean isCtlRsnmsgElementBeingParsed()
    {
        return this.ctlRsnmsgBeingParsed;
    }

    /**
     * @param ctlRsnmsgBeingParsed the ctlRsnmsgElementBeingParsed to set
     */
    protected void setCtlRsnmsgElementBeingParsed(boolean reasonCodeMessageElementBeingParsed)
    {
        this.ctlRsnmsgBeingParsed = reasonCodeMessageElementBeingParsed;
    }

    /**
     * @return the ctlRsnElementBeingParsed
     */
    protected boolean isCtlRsnElementBeingParsed()
    {
        return this.ctlRsnBeingParsed;
    }

    /**
     * @param ctlRsnBeingParsed the ctlRsnElementBeingParsed to set
     */
    protected void setCtlRsnElementBeingParsed(boolean reasonCodeElementBeingParsed)
    {
        this.ctlRsnBeingParsed = reasonCodeElementBeingParsed;
    }

    /**
     * @return the ctlRsntxtElementBeingParsed
     */
    protected boolean isCtlRsntxtElementBeingParsed()
    {
        return this.ctlRsntxtBeingParsed;
    }

    /**
     * @param ctlRsntxtBeingParsed the ctlRsntxtElementBeingParsed to set
     */
    protected void setCtlRsntxtElementBeingParsed(boolean reasonCodeTextElementBeingParsed)
    {
        this.ctlRsntxtBeingParsed = reasonCodeTextElementBeingParsed;
    }

    /**
     * @return the ctlRqsttkn1ElementBeingParsed
     */
    protected boolean isCtlRqsttkn1ElementBeingParsed()
    {
        return this.ctlRqsttkn1BeingParsed;
    }

    /**
     * @param ctlRqsttkn1BeingParsed the ctlRqsttkn1ElementBeingParsed to set
     */
    protected void setCtlRqsttkn1ElementBeingParsed(boolean requestToken1ElementBeingParsed)
    {
        this.ctlRqsttkn1BeingParsed = requestToken1ElementBeingParsed;
    }

    /**
     * @return the ctlRqsttkn2ElementBeingParsed
     */
    protected boolean isCtlRqsttkn2ElementBeingParsed()
    {
        return this.ctlRqsttkn2BeingParsed;
    }

    /**
     * @param ctlRqsttkn2BeingParsed the ctlRqsttkn2ElementBeingParsed to set
     */
    protected void setCtlRqsttkn2ElementBeingParsed(boolean requestToken2ElementBeingParsed)
    {
        this.ctlRqsttkn2BeingParsed = requestToken2ElementBeingParsed;
    }

    /**
     * @return the cmdrspdataRspElementBeingParsed
     */
    protected boolean isCmdrspdataRspElementBeingParsed()
    {
        return this.cmdrspdataRspBeingParsed;
    }

    /**
     * @param cmdrspdataRspBeingParsed the cmdrspdataRspElementBeingParsed to set
     */
    protected void setCmdrspdataRspElementBeingParsed(boolean responseElementBeingParsed)
    {
        this.cmdrspdataRspBeingParsed = responseElementBeingParsed;
    }

    /**
     * @return the ctlRcElementBeingParsed
     */
    protected boolean isCtlRcElementBeingParsed()
    {
        return this.ctlRcBeingParsed;
    }

    /**
     * @param ctlRcBeingParsed the ctlRcElementBeingParsed to set
     */
    protected void setCtlRcElementBeingParsed(boolean returnCodeElementBeingParsed)
    {
        this.ctlRcBeingParsed = returnCodeElementBeingParsed;
    }

    /**
     * @return the cmdsecerrSafElementBeingParsed
     */
    protected boolean isCmdsecerrSafElementBeingParsed()
    {
        return this.cmdsecerrSafBeingParsed;
    }

    /**
     * @param cmdsecerrSafBeingParsed the cmdsecerrSafElementBeingParsed to set
     */
    protected void setCmdsecerrSafElementBeingParsed(boolean safElementBeingParsed)
    {
        this.cmdsecerrSafBeingParsed = safElementBeingParsed;
    }

    /**
     * @return the cmdsecerrSafRcElementBeingParsed
     */
    protected boolean isCmdsecerrSafRcElementBeingParsed()
    {
        return this.cmdsecerrSafRcBeingParsed;
    }

    /**
     * @param cmdsecerrSafRcBeingParsed the cmdsecerrSafRcElementBeingParsed to set
     */
    protected void setCmdsecerrSafRcElementBeingParsed(boolean safRcElementBeingParsed)
    {
        this.cmdsecerrSafRcBeingParsed = safRcElementBeingParsed;
    }

    /**
     * @return the ctlStaseqElementBeingParsed
     */
    protected boolean isCtlStaseqElementBeingParsed()
    {
        return this.ctlStaseqBeingParsed;
    }

    /**
     * @param ctlStaseqBeingParsed the ctlStaseqElementBeingParsed to set
     */
    protected void setCtlStaseqElementBeingParsed(boolean startSequenceElementBeingParsed)
    {
        this.ctlStaseqBeingParsed = startSequenceElementBeingParsed;
    }

    /**
     * @return the ctlStatimeElementBeingParsed
     */
    protected boolean isCtlStatimeElementBeingParsed()
    {
        return this.ctlStatimeBeingParsed;
    }

    /**
     * @param ctlStatimeBeingParsed the ctlStatimeElementBeingParsed to set
     */
    protected void setCtlStatimeElementBeingParsed(boolean startTimeElementBeingParsed)
    {
        this.ctlStatimeBeingParsed = startTimeElementBeingParsed;
    }

    /**
     * @return the ctlStoseqElementBeingParsed
     */
    protected boolean isCtlStoseqElementBeingParsed()
    {
        return this.ctlStoseqBeingParsed;
    }

    /**
     * @param ctlStoseqBeingParsed the ctlStoseqElementBeingParsed to set
     */
    protected void setCtlStoseqElementBeingParsed(boolean stopSequenceElementBeingParsed)
    {
        this.ctlStoseqBeingParsed = stopSequenceElementBeingParsed;
    }

    /**
     * @return the ctlStotimeElementBeingParsed
     */
    protected boolean isCtlStotimeElementBeingParsed()
    {
        return this.ctlStotimeBeingParsed;
    }

    /**
     * @param ctlStotimeBeingParsed the ctlStotimeElementBeingParsed to set
     */
    protected void setCtlStotimeElementBeingParsed(boolean stopTimeElementBeingParsed)
    {
        this.ctlStotimeBeingParsed = stopTimeElementBeingParsed;
    }

    /**
     * @return the ctlUomElementBeingParsed
     */
    protected boolean isCtlUomElementBeingParsed()
    {
        return this.ctlUomBeingParsed;
    }

    /**
     * @param ctlUomBeingParsed the ctlUomElementBeingParsed to set
     */
    protected void setCtlUomElementBeingParsed(boolean uomElementBeingParsed)
    {
        this.ctlUomBeingParsed = uomElementBeingParsed;
    }

    /**
     * @return the cmdsecerrExitUserdataElementBeingParsed
     */
    protected boolean isCmdsecerrExitUserdataElementBeingParsed()
    {
        return this.cmdsecerrExitUserdataBeingParsed;
    }

    /**
     * @param cmdsecerrExitUserdataBeingParsed the cmdsecerrExitUserdataElementBeingParsed to set
     */
    protected void setCmdsecerrExitUserdataElementBeingParsed(boolean userdataElementBeingParsed)
    {
        this.cmdsecerrExitUserdataBeingParsed = userdataElementBeingParsed;
    }

    /**
     * @return the cmdUserIdElementBeingParsed
     */
    protected boolean isCmdUserIdElementBeingParsed()
    {
        return this.cmdUserIdBeingParsed;
    }

    /**
     * @param cmdUserIdBeingParsed the cmdUserIdElementBeingParsed to set
     */
    protected void setCmdUserIdElementBeingParsed(boolean userIdElementBeingParsed)
    {
        this.cmdUserIdBeingParsed = userIdElementBeingParsed;
    }

    /**
     * @return the cmdVerbElementBeingParsed
     */
    protected boolean isCmdVerbElementBeingParsed()
    {
        return this.cmdVerbBeingParsed;
    }

    /**
     * @param cmdVerbBeingParsed the cmdVerbElementBeingParsed to set
     */
    protected void setCmdVerbElementBeingParsed(boolean verbElementBeingParsed)
    {
        this.cmdVerbBeingParsed = verbElementBeingParsed;
    }

    /**
     * @return the ctlXmlvsnElementBeingParsed
     */
    protected boolean isCtlXmlvsnElementBeingParsed()
    {
        return this.ctlXmlvsnBeingParsed;
    }

    /**
     * @param ctlXmlvsnBeingParsed the ctlXmlvsnElementBeingParsed to set
     */
    protected void setCtlXmlvsnElementBeingParsed(boolean xmlVersionElementBeingParsed)
    {
        this.ctlXmlvsnBeingParsed = xmlVersionElementBeingParsed;
    }
    
    
    
    /**
     * Gets the <code>ctl</code> element from the XML cmdrspdataRsp from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * response message. The <code>ctl</code> element is returned for every type-2 command request
     * and contains information about the OM that processed the command and how the command was processed.
     * @return the ctl
     * @see Ctl
     */
    public Ctl getCtl()
    {
        return this.imsout.getCtl();
    }
    
    /**
     * @param aControl the ctl to set
     */
    protected void setCtl(Ctl aControl)
    {
        ((ImsoutImpl)this.imsout).setCtl(aControl);
    }
    
    /**
     * Gets any text from the <coce>ctl</code> element in the response message.
     * @return the ctl element text 
     */
    public String getControlElementText()
    {
        return this.imsout.getCtl().getCtlElementText();
    }
    
    /*
     * @param aControlElementText the ctl to set
     */
/*    protected void setControlElementText(String aControlElementText)
    {
        this.imsout.getCtl().setCtlElementText(aControlElementText);
    }
    
    
    /**
     * @return the omname
     */
/*    public String getCtlOmName()
    {
        return this.ctl.getOmname();
    }
    
    /**
     * @param aControlOmname the ctlOmName to set
     */
/*   protected void setCtlOmName(String aControlOmname)
    {
        this.imsout.getCtl().setOmname(aControlOmname);
        this.ctlOmname = aControlOmname;
    }
    
    
    /**
     * @return the ctlOmVsn
     */
/*    public String getCtlOmVsn()
    {
        return this.ctlOmvsn;
    }
    
    /**
     * @param aControlOmVsn the ctlOmVsn to set
     */
/*    protected void setCtlOmVsn(String aControlOmVsn)
    {
        this.imsout.getCtl().setOmvsn(aControlOmVsn);
        this.ctlOmvsn = aControlOmVsn;
    }
    
    
    /**
     * @return the ctlXmlVsn
     */
/*    public String getCtlXmlVsn()
    {
        return this.ctlXmlvsn;
    }
    
    /**
     * @param aControlXmlVsn the ctlXmlVsn to set
     */
/*    protected void setCtlXmlVsn(String aControlXmlVsn)
    {
        this.imsout.getCtl().setXmlvsn(aControlXmlVsn);
        this.ctlXmlvsn = aControlXmlVsn;
    }
    
    
    /**
     * @return the ctlStatime
     */
/*    public String getCtlStatime()
    {
        return this.ctlStatime;
    }
    
    /**
     * @param aControlStartTime the ctlStatime to set
     */
/*    protected void setCtlStatime(String aControlStartTime)
    {
        this.ctlStatime = aControlStartTime;
    }
    
    
    /**
     * @return the ctlStotime
     */
/*   public String getCtlStotime()
    {
        return this.ctlStotime;
    }
    
    /**
     * @param aControlStopTime the ctlStotime to set
     */
/*    protected void setCtlStotime(String aControlStopTime)
    {
        this.imsout.getCtl().setStotime(aControlStopTime);
        this.ctlStotime = aControlStopTime;
    }
    
    
    /**
     * @return the ctlStaseq
     */
/*    public String getCtlStaseq()
    {
        return this.ctlStaseq;
    }
    
    /**
     * @param aControlStartSequence the ctlStaseq to set
     */
/*    protected void setCtlStaseq(String aControlStartSequence)
    {
        this.imsout.getCtl().setStaseq(aControlStartSequence);
        this.ctlStaseq = aControlStartSequence;
    }
    
    
    /**
     * @return the ctlStoseq
     */
/*    public String getCtlStoseq()
    {
        return this.ctlStoseq;
    }
    
    /**
     * @param aControlStopSequence the ctlStoseq to set
     */
/*    protected void setCtlStoseq(String aControlStopSequence)
    {
        this.imsout.getCtl().setStoseq(aControlStopSequence);
        this.ctlStoseq = aControlStopSequence;
    }
    
    
    /**
     * @return the ctlRqsttkn1
     */
/*    public byte[] getCtlRqsttkn1()
    {
        return this.ctlRqsttkn1;
    }
    
    /**
     * @param aControlRequestToken1 the ctlRqsttkn1 to set
     */
/*    protected void setCtlRqsttkn1(byte[] aControlRequestToken1)
    {
        this.imsout.getCtl().setRqsttkn1(aControlRequestToken1);
        this.ctlRqsttkn1 = aControlRequestToken1;
    }
    
    
    /**
     * @return the ctlRqsttkn2
     */
/*    public byte[] getCtlRqsttkn2()
    {
        return this.ctlRqsttkn2;
    }
    
    /**
     * @param aRequestToken1 the ctlRqsttkn2 to set
     */
/*    protected void setCtlRqsttkn2(byte[] aControlRequestToken2)
    {
        this.imsout.getCtl().setRqsttkn2(aControlRequestToken2);
        this.ctlRqsttkn2 = aControlRequestToken2;
    }
    
    
    /**
     * @return the ctlRc
     */
/*    public String getCtlRc()
    {
        return this.ctlRc;
    }
    
    /**
     * @param aControlReturnCode the ctlRc to set
     */
/*    protected void setCtlRc(String aControlReturnCode)
    {
        this.imsout.getCtl().setRc(aControlReturnCode);
        this.ctlRc = aControlReturnCode;
    }
    
    
    /**
     * @return the ctlRsn
     */
/*    public String getCtlRsn()
    {
        return this.ctlRsn;
    }
    
    /**
     * @param aControlReasonCode the ctlRsn to set
     */
/*    protected void setCtlRsn(String aControlReasonCode)
    {
        this.imsout.getCtl().setRsn(aControlReasonCode);
        this.ctlRsn = aControlReasonCode;
    }
    
    
    /**
     * @return the ctlRsnmsg
     */
/*    public String getCtlRsnmsg()
    {
        return this.ctlRsnmsg;
    }
    
    /**
     * @param aControlReasonMessage the ctlRsnmsg to set
     */
/*    protected void setCtlRsnmsg(String aControlReasonMessage)
    {
        this.imsout.getCtl().setRsnmsg(aControlReasonMessage);
        this.ctlRsnmsg = aControlReasonMessage;
    }
    
    
    /**
     * @return the ctlRsntxt
     */
/*    public String getCtlRsntxt()
    {
        return this.ctlRsntxt;
    }
    
    /**
     * @param ctlRsntxt the ctlRsntxt to set
     */
/*    protected void setCtlRsntxt(String aControlReasonText)
    {
        this.imsout.getCtl().setRsntxt(aControlReasonText);
        this.ctlRsntxt = aControlReasonText;
    }
    
    
    /**
     * @return the ctlUom
     */
/*    public String getCtlUom()
    {
        return this.ctlUom;
    }
    
    /**
     * @param aControlUom the ctlUom to set
     */
/*    protected void setCtlUom(String aControlUom)
    {
        this.imsout.getCtl().setUom(aControlUom);
        this.ctlUom = aControlUom;
    }
    */
    
    /**
     * Gets a <code>Cmdclients</code> object from the response message for a type-2 QUERY(CMDCLIENTS) request.
     * @return the cmdclients
     * @see Cmdclients
     */
    public Cmdclients getCmdclients()
    {
        return this.cmdclients;
    }
    
    /**
     * @param aCmdclients the cmdclients to set
     */
    protected void setCmdclients(Cmdclients aCmdclients)
    {
        this.cmdclients = aCmdclients;
    }
    
    /*
     * @return the cmdclients
     */
/*    public String getCmdclientsElementText()
    {
        return this.cmdclients.getCmdclientsElementText();
    }
    
    /**
     * @param aCmdclientsElementText the cmdclientsElementText to set
     */
/*    protected void setCmdclientsElementText(String aCmdclientsElementText)
    {
        this.imsout.getCmdclient().setCmdclientsElementText(aCmdclientsElementText);
    }
    
    
    /**
     * @return the cmdclientsMbr
     */
/*    public Mbr[] getCmdclientsMbr()
    {
        return this.cmdclientsMbr;
    }
    
    /**
     * @param aCmdclientsMbr the cmdclientsMbr to set
     */
/*    protected void setCmdclientMbr(Vector<Mbr> aCmdclientsMbr)
    {
        this.imsout.getCmdclient().setMbr(aCmdclientsMbr);
        this.cmdclientsMbr = (Mbr[])aCmdclientsMbr.toArray();
    }
    
    
    /**
     * @param cmdclientsMbr the cmdclientsMbr to set
     */
/*    protected void setCmdclientsMbr(Mbr[] cmdclientMbr)
    {
        this.cmdclientsMbr = cmdclientMbr;
    }
    
    
    /**
     * @return the cmdclientsMbrJobname
     */
/*    public String getCmdclientsMbrJobname()
    {
        return this.cmdclientsMbrJobname;
    }
    
    /**
     * @param cmdclientsMbrJobname the cmdclientsMbrJobname to set
     */
/*    protected void setCmdclientsMbrJobname(String aCmdclientsMbrJobname)
    {
        this.imsout.getCmdclient().getLastMbrElement().setJobname(aCmdclientsMbrJobname);
        this.cmdclientsMbrJobname = aCmdclientsMbrJobname;
    }
    
    
    /**
     * @return the cmdclientsMbrMsg
     */
/*    public String[] getCmdclientsMbrMsg()
    {
        return this.cmdclientsMbrMsg;
    }
    
    /**
     * @param cmdclientsMbrMsg the cmdclientsMbrMsg to set
     */
/*    protected void setCmdclientsMbrMsg(String[] cmdclientsMbrMsg)
    {
        this.cmdclientsMbrMsg = cmdclientsMbrMsg;
    }
    
    
    /**
     * @return the cmdclientsMbrMsg
     */
/*   public String getCmdclientsMbrMsg()
    {
        return this.cmdclientsMbrMsg;
    }
    
    /**
     * @param aCmdclientsMbrMsg the cmdclientsMbrMsg to set
     */
/*    protected void setCmdclientsMbrMsg(String aCmdclientsMbrMsg)
    {
        this.cmdclientsMbrMsg = aCmdclientsMbrMsg;
    }
    
    
    /**
     * @return the cmdclientsMbrRsn
     */
/*    public String getCmdclientsMbrRsn()
    {
        return this.cmdclientsMbrRsn;
    }

    /**
     * @param aCmdclientsMbrRsn the cmdclientsMbrRsn to set
     */
/*    protected void setCmdclientsMbrRsn(String aCmdclientsMbrRsn)
    {
        this.imsout.getCmdclient().getLastMbrElement().setRsn(aCmdclientsMbrRsn);
        this.cmdclientsMbrRsn = aCmdclientsMbrRsn;
    }
    
    
    /**
     * @return the cmdclientsMbrRc
     */
/*    public String getCmdclientsMbrRc()
    {
        return this.cmdclientsMbrRc;
    }
    
    /**
     * @param aCmdclientsMbrRc the cmdclientsMbrRc to set
     */
/*    protected void setCmdclientsMbrRc(String aCmdclientsMbrRc)
    {
        this.imsout.getCmdclient().getLastMbrElement().setRc(aCmdclientsMbrRc);
        this.cmdclientsMbrRc = aCmdclientsMbrRc;
    }
    
    
    /**
     * @return the cmdclientsMbrStyp
     */
/*    public String getCmdclientsMbrStyp()
    {
        return this.cmdclientsMbrStyp;
    }
    
    /**
     * @param aCmdclientsMbrStyp the cmdclientsMbrStyp to set
     */
/*    protected void setCmdclientsMbrStyp(String aCmdclientsMbrStyp)
    {
        this.imsout.getCmdclient().getLastMbrElement().setStyp(aCmdclientsMbrStyp);
        this.cmdclientsMbrStyp = aCmdclientsMbrStyp;
    }
    
    
    /**
     * @return the cmdclientsMbrTyp
     */
/*    public String getCmdclientsMbrTyp()
    {
        return this.cmdclientsMbrTyp;
    }
    
    /**
     * @param aCmdclientsMbrTyp the cmdclientsMbrTyp to set
     */
/*    protected void setCmdclientsMbrTyp(String aCmdclientsMbrTyp)
    {
        this.imsout.getCmdclient().getLastMbrElement().setStyp(aCmdclientsMbrTyp);
        this.cmdclientsMbrTyp = aCmdclientsMbrTyp;
    }
    
    
    /**
     * @return the cmdclientsMbrVsn
     */
/*    public String getCmdclientsMbrVsn()
    {
        return this.cmdclientsMbrVsn;
    }
    
    /**
     * @param aCmdclientsMbrVsn the cmdclientsMbrVsn to set
     */
/*    protected void setCmdclientsMbrVsn(String aCmdclientsMbrVsn)
    {
        this.imsout.getCmdclient().getLastMbrElement().setStyp(aCmdclientsMbrVsn);
        this.cmdclientsMbrVsn = aCmdclientsMbrVsn;
    }
    */
    
    /**
     * Gets the document type definition (DTD) tags that are defined by OM for command syntax and OM output
     * XML. This information is returned for a QUERY(CMDSYNTAX) request.
     * @return the cmddtd
     */
    public String getCmddtd()
    {
        return this.cmddtd;
    }
    
    /**
     * @param aCmddtd the cmddtd to set
     */
    protected void setCmddtd(String aCmddtd)
    {
        ((ImsoutImpl)this.imsout).setCmddtd(aCmddtd);
        this.cmddtd = aCmddtd;
    }
    
    
    /**
     * Gets the XML definitions for the commands that are registered to OM by command processing clients.
     * This information is returned for a QUERY(CMDSYNTAX) request.
     * @return the cmdsyntax
     */
    public String getCmdsyntax()
    {
        return this.cmdsyntax;
    }
    
    /**
     * @param aCmdsyntax the cmdsyntax to set
     */
    protected void setCmdsyntax(String aCmdsyntax)
    {
        this.cmdsyntax = aCmdsyntax;
    }
    
    
    /**
     * Gets the translatable text strings that are associated with the XML command syntax tags for 
     * commands registered to OM from command processing clients. This information is returned for a QUERY(CMDSYNTAX) request.
     * @return the cmdtext
     */
    public String getCmdtext()
    {
        return this.cmdtext;
    }

    /**
     * @param aCmdtext the cmdtext to set
     */
    protected void setCmdtext(String aCmdtext)
    {
        this.cmdtext = aCmdtext;
    }
    
    
    /**
     * Gets a Cmderr object from the type-2 command response message.
     * @return the cmderr
     * @see Cmderr
     */
    public Cmderr getCmderr()
    {
        return this.cmderr;
    }
    
    /**
     * @param aCmderr the cmderr to set
     */
    protected void setCmderr(Cmderr aCmderr)
    {
        this.cmderr = aCmderr; 
    }
    
    
    /**
     * Gets an array of <code>Mbr</code> objects from the <code>Cmderr</code> element of a type-2
     * command error response. One object is generated for each IMSPlex member that returned an error response
     * to the type-2 command.
     * @return the cmderrMbr
     * @see Mbr
     */
/*    public Mbr[] getCmderrMbr()
    {
        return this.cmderrMbr;
    }
    
    /**
     * @param aCmderrMbr the cmderrMbr to set
     */
/*    protected void setCmderrMbr(Mbr[] aCmderrMbr)
    {
        this.cmderrMbr = aCmderrMbr;
    }
    
    /**
     * @param aCmderrMbrElement the cmderrMbr element (Mbr instance) to set
     */
/*    public void addCommandErrorMemberElement(Mbr aCmderrMbrElement)
    {
        this.imsout.getCmderr().addMbr(aCmderrMbrElement);
    }
    
    
    /**
     * @return the cmderrMbrJobname
     */
/*    public String getCmderrMbrJobname()
    {
        return this.cmderrMbrJobname;
    }

    /**
     * @param aCmderrMbrJobname the cmderrMbrJobname to set
     */
/*    protected void setCmderrMbrJobname(String aCmderrMbrJobname)
    {
        this.cmderrMbrJobname = aCmderrMbrJobname;
    }

    /**
     * @return the cmderrMbrMsg
     */
/*    public String[] getCmderrMbrMsg()
    {
        return this.cmderrMbrMsg;
    }

    /**
     * @param aCmderrMbrMsg the cmderrMbrMsg to set
     */
/*    protected void setCmderrMbrMsg(String[] aCmderrMbrMsg)
    {
        this.cmderrMbrMsg = aCmderrMbrMsg;
    }

    /**
     * @return the cmderrMbrRsn
     */
/*    public String getCmderrMbrRsn()
    {
        return this.cmderrMbrRsn;
    }

    /**
     * @param aCmderrMbrRsn the cmderrMbrRsn to set
     */
/*    protected void setCmderrMbrRsn(String aCmderrMbrRsn)
    {
        this.cmderrMbrRsn = aCmderrMbrRsn;
    }

    /**
     * @return the cmderrMbrRc
     */
/*    public String getCmderrMbrRc()
    {
        return this.cmderrMbrRc;
    }

    /**
     * @param aCmderrMbrRc the cmderrMbrRc to set
     */
/*    protected void setCmderrMbrRc(String aCmderrMbrRc)
    {
        this.cmderrMbrRc = aCmderrMbrRc;
    }

    /**
     * @return the cmderrMbrStyp
     */
/*    public String getCmderrMbrStyp()
    {
        return this.cmderrMbrStyp;
    }

    /**
     * @param aCmderrMbrStyp the cmderrMbrStyp to set
     */
/*    protected void setCmderrMbrStyp(String aCmderrMbrStyp)
    {
        this.cmderrMbrStyp = aCmderrMbrStyp;
    }

    /**
     * @return the cmderrMbrTyp
     */
/*    public String getCmderrMbrTyp()
    {
        return this.cmderrMbrTyp;
    }

    /**
     * @param aCmderrMbrTyp the cmderrMbrTyp to set
     */
/*    protected void setCmderrMbrTyp(String aCmderrMbrTyp)
    {
        this.cmderrMbrTyp = aCmderrMbrTyp;
    }

    /**
     * @return the cmderrMbrVsn
     */
/*    public String getCmderrMbrVsn()
    {
        return this.cmderrMbrVsn;
    }

    /**
     * @param aCmderrMbrVsn the cmderrMbrVsn to set
     */
/*    protected void setCmderrMbrVsn(String aCmderrMbrVsn)
    {
        this.cmderrMbrVsn = aCmderrMbrVsn;
    }
*/
    /**
     * Gets the text of the <code>cmdsecerr</code> element from the response message.
     * @return the cmdsecerr
     */
    public Cmdsecerr getCmdsecerr()
    {
        return this.cmdsecerr;
    }
    
    /**
     * @param aCmdsecerr the cmdsecerr to set
     */
    protected void setCmdsecerr(Cmdsecerr aCmdsecerr)
    {
        this.cmdsecerr = aCmdsecerr;
    }
    
    
    /*
     * Gets any text from the <code>exit</code> element within the <code>cmdsecerr</code> element of the response message.
     * @return the cmdsecerrExit
     */
/*    public String getCmdsecerrExit()
    {
        return this.cmdsecerrExit;
    }
    
    /**
     * @param anExit the cmdsecerrExit to set
     */
/*    protected void setCmdsecerrExit(String anExit)
    {
        this.imsout.getCmdsecerr().setExit(anExit);
        this.cmdsecerrExit = anExit;
    }
    
    
    /**
     * @return the cmdsecerrExitRc
     */
/*    public String getCmdsecerrExitRc()
    {
        return this.cmdsecerrExitRc;
    }
    
    /**
     * @param anExitRc the cmdsecerrExitRc to set
     */
/*    protected void setCmdsecerrExitRc(String anExitRc)
    {
        this.imsout.getCmdsecerr().setRc(anExitRc);
        this.cmdsecerrExitRc = anExitRc;
    }
    
    
    /**
     * @return the cmdsecerrExitUserdata
     */
/*    public String getCmdsecerrExitUserdata()
    {
        return this.cmdsecerrExitUserdata;
    }
    
    /**
     * @param cmdsecerrExitUserdata the cmdsecerrExitUserdata to set
     */
/*    protected void setCmdsecerrExitUserdata(String userdata)
    {
        this.cmdsecerrExitUserdata = userdata;
    }
    
    
    /**
     * @return the cmdsecerrSaf
     */
/*    public String getCmdsecerrSaf()
    {
        return this.cmdsecerrSaf;
    }
    
    /**
     * @param cmdsecerrSaf the cmdsecerrSaf to set
     */
/*    protected void setCmdsecerrSaf(String cmdsecSaf)
    {
        this.cmdsecerrSaf = cmdsecSaf;
    }
    
    
    /**
     * @return the cmdsecerrSafRacfrc
     */
/*    public String getCmdsecerrSafRacfrc()
    {
        return this.cmdsecerrSafRacfrc;
    }
    
    /**
     * @param cmdsecerrSafRacfrc the cmdsecerrSafRacfrc to set
     */
/*    protected void setCmdsecerrSafRacfrc(String cmdsecSafRacfrc)
    {
        this.cmdsecerrSafRacfrc = cmdsecSafRacfrc;
    }
    
    
    /**
     * @return the cmdsecerrSafRacfrsn
     */
/*    public String getCmdsecerrSafRacfrsn()
    {
        return this.cmdsecerrSafRacfrsn;
    }
    
    /**
     * @param cmdsecerrSafRacfrsn the cmdsecerrSafRacfrsn to set
     */
/*    protected void setCmdsecerrSafRacfrsn(String cmdsecSafRacfrsn)
    {
        this.cmdsecerrSafRacfrsn = cmdsecSafRacfrsn;
    }
    
    
    /**
     * @return the cmdsecerrSafRc
     */
/*    public String getCmdsecerrSafRc()
    {
        return this.cmdsecerrSafRc;
    }
    
    /**
     * @param cmdsecerrSafRc the cmdsecerrSafRc to set
     */
/*    protected void setCmdsecerrSafRc(String cmdsecSafRc)
    {
        this.cmdsecerrSafRc = cmdsecSafRc;
    }
    */
    
    /**
     * Gets the <cmd> element from the XML cmdrspdataRsp from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * @return the cmd
     */
    public Cmd getCmd()
    {
        return this.cmd;
    }
    
    /**
     * @param aCmd the cmd to set
     */
    protected void setCmd(Cmd aCmd)
    {
        ((ImsoutImpl)this.imsout).setCmd(aCmd);
    }
    
    
    /*
     * Gets any text from the <cmd> element in the XML cmdrspdataRsp from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * @return the cmd
     */
/*    public String getCmdElementText()
    {
        return this.cmd.getCmdElementText();
    }
    
    /**
     * @param aCmdElementText the cmd element text to set
     */
/*    protected void setCmdElementText(String aCmdElementText)
    {
        this.imsout.getCmd().setCmdElementText(aCmdElementText);
    }
    */
    
    /**
     * Gets the <cmdrsphdr> element from the XML from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * @return the cmdrsphdr
     * @see Cmdrsphdr
     */
    public Cmdrsphdr getCmdrsphdr()
    {
        return this.cmdrsphdr;
    }
    
    /**
     * @param aCmdrsphdr the cmdrsphdr element to set
     */
    protected void setCmdrsphdr(Cmdrsphdr aCmdrsphdr)
    {
        ((ImsoutImpl)this.imsout).setCmdrsphdr(aCmdrsphdr);
    }
    
    
    /*
     * Gets any text from the <cmdRspHdr> element in the XML from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * @return the cmdrsphdr.cmdrsphdrElementText
     */
/*    public String getCmdrsphdrElementText()
    {
        return this.imsout.getCmdrsphdr().getCmdrsphdrElementText();
    }
    
    /**
     * @param cmdrsphdr the cmdrsphdr to set
     */
/*    protected void setCmdrsphdrElementText(String aCmdrsphdrElementText)
    {
        this.imsout.getCmdrsphdr().setCmdrsphdrElementText(aCmdrsphdrElementText);
    }
    
    
    /**
     * @return the cmdrsphdrHdr
     */
/*   public String[] getCmdrsphdrHdr()
    {
        return this.cmdrsphdrHdr;
    }
    
    /**
     * @param cmdrsphdrHdr the cmdrsphdrHdr to set
     */
/*    protected void setCmdrsphdrHdr(String[] cmdrsphdrHdr)
    {
        this.cmdrsphdrHdr = cmdrsphdrHdr;
    }
    */
    
    /**
     * Gets the <cmdrspdata> element from the XML cmdrspdataRsp from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * Gets a Cmdrspdata object from the <code>Cmdrspdata</code> element 
     * in the response message. This object can be queried to retrieve the type-2 command response data.
     * @return the cmdrspdata
     * @see Cmdrspdata
     */
    public Cmdrspdata getCmdrspdata()
    {
        return this.cmdrspdata;
    }
    
    /**
     * @param aCmdrspdata the cmdrspdata element to set
     */
    protected void setCmdrspdata(Cmdrspdata aCmdrspdata)
    {
        ((ImsoutImpl)this.imsout).setCmdrspdata(aCmdrspdata);
    }
    
    /*
     * Gets any text from the <cmdrspdata> element in the XML from IMS Connect for an IMS Connect or IMS Type 2 cmd  
     * @return the cmdrspdataElementText
     */
/*    public String getCmdrspdataElementText()
    {
        return this.imsout.getCmdrspdata().getCmdrspdataElementText();
    }
    
    /**
     * @param aCmdrspdataElementText the cmdrspdata element text to set
     */
/*    protected void setCmdrspdataElementText(String aCmdrspdataElementText)
    {
        this.imsout.getCmdrspdata().setCmdrspdataElementText(aCmdrspdataElementText);
    }
    
    
    /**
     * @return the cmdrspdataRsp
     */
/*    public String[] getCmdrspdataRsp()
    {
        return this.cmdrspdataRsp;
    }
    
    /**
     * @param cmdrspdataRsp the cmdrspdataRsp to set
     */
/*    protected void setCmdrspdataRsp(String[] cmdrspdataRsp)
    {
        this.cmdrspdataRsp = cmdrspdataRsp;
    }
    
    
    /**
     * @return the cmdInput
     */
/*    public String getCmdInput()
    {
        return this.imsout.getCmd().getInput();
    }
    
    /**
     * @param anInput the cmdInput to set
     */
/*    protected void setCmdInput(String anInput)
    {
        this.imsout.getCmd().setInput(anInput);
    }
    
    
    /**
     * @return the cmdKwd
     */
/*    public String getCmdKwd()
    {
        return this.imsout.getCmd().getKwd();
    }
    
    /**
     * @param aKwd the cmdKwd to set
     */
/*   protected void setCmdKwd(String aKwd)
    {
        this.imsout.getCmd().setKwd(aKwd);
    }
    
    
    /**
     * @return the cmdMaster
     */
/*   public String getCmdMaster()
    {
        return this.imsout.getCmd().getMaster();
    }
    
    /**
     * @param aMaster the cmdMaster to set
     */
/*    protected void setCmdMaster(String aMaster)
    {
        this.imsout.getCmd().setMaster(aMaster);
    }
    
    
    /**
     * @return the cmdUserId
     */
/*    public String getCmdUserId()
    {
        return this.imsout.getCmd().getUserid();
    }
    
    /**
     * @param aUserId the cmdUserId to set
     */
/*   protected void setCmdUserId(String aUserId)
    {
        this.imsout.getCmd().setUserid(aUserId);
    }
    
    
    /**
     * @return the cmdVerb
     */
/*    public String getCmdVerb()
    {
        return this.imsout.getCmd().getVerb();
    }
    
    /**
     * @param cmdVerb the cmdVerb to set
     */
/*    protected void setCmdVerb(String verb)
    {
        this.imsout.getCmd().setVerb(verb);
    }
    */
    
// msgdata element
    /**
     * Gets the <msgdata> element in the response from IMS Connect for an IMS Type 1 cmd
     * Gets the <code>Msgdata</code> element from the response message. This method returns
     * an object rather than a text string. This element contains an IMS or IMS
     * component message that was generated by the IMSPlex member that processed the type-2
     * command.
     * @return the msgdata
     * @see Msgdata
     */
    public Msgdata getMsgdata()
    {
        return this.msgdata;
    }

    /**
     * @param msgdataMbr the msgdataMbr to set
     */
    protected void setMsgdata(Msgdata aMsgdata)
    {
        this.msgdata = aMsgdata;
    }
    
    /*
     * Gets any text from the <msgdata> element in the response from IMS Connect for an IMS Connect or IMS Type 2 command  
     * @return the msgdata.messagedata.ElementText 
     */
/*    public String getMsgdataElementText()
    {
        return this.msgdataElementText;
    }

    /**
     * @param aMessagedata the msgdata to set
     */
/*    protected void setMsgdataElementText(String aMessagedataElementText)
    {
        this.msgdataElementText = aMessagedataElementText;
        this.imsout.getMsgdata().setMsgdataElementText(aMessagedataElementText);
    }
    */
    
//  msgdataMbr element
    /*
     * @return the msgdataMbr
     */
/*    public Mbr[] getMsgdataMbr()
    {
        return this.msgdataMbr;
    }
    
    /**
     * @param msgdataMbr the msgdataMbr to set
     */
/*    protected void setMsgdataMbr(Mbr[] msgdataMbr)
    {
        this.msgdataMbr = msgdataMbr;
        this.numberOfMsgdataMbrElements = msgdataMbr.length;
    }
    
    
    /**
     * @return the numberOfMsgdataMbrElements
     */
/*    public int getNumberOfMsgdataMbrElements()
    {
        return this.numberOfMsgdataMbrElements;
    }
    
    /**
     * @param numberOfMsgdataMbrElements the numberOfMsgdataMbrElements to set
     */
/*    protected void setNumberOfMsgdataMbrElements(int numberOfMsgdataMbrElements)
    {
        this.numberOfMsgdataMbrElements = numberOfMsgdataMbrElements;
    }
    
    
    /**
     * @return the msgdataMbrElementText
     */
/*    public String getMsgdataMbrElementText()
    {
        return this.msgdataMbrElementText;
    }
    
    /**
     * @param msgdataMbrElementText the msgdataMbrElementText to set
     */
/*    protected void setMsgdataMbrElementText(String msgdataMbrElementText)
    {
        this.msgdataMbrElementText = msgdataMbrElementText;
    }
    
    
    /**
     * @return the msgdataMbrTyp
     */
/*    public String getMsgdataMbrTyp()
    {
        return this.msgdataMbrTyp;
    }
    
    /**
     * @param msgdataMbrTyp the msgdataMbrTyp to set
     */
/*    protected void setMsgdataMbrTyp(String msgdataMbrTyp)
    {
        this.msgdataMbrTyp = msgdataMbrTyp;
    }
    
    
    /**
     * @return the msgdataMbrStyp
     */
/*    public String getMsgdataMbrStyp()
    {
        return this.msgdataMbrStyp;
    }
    
    /**
     * @param msgdataMbrStyp the msgdataMbrStyp to set
     */
/*    protected void setMsgdataMbrStyp(String msgdataMbrStyp)
    {
        this.msgdataMbrStyp = msgdataMbrStyp;
    }
    
    
    /**
     * @return the msgdataMbrVsn
     */
/*   public String getMsgdataMbrVsn()
    {
        return this.msgdataMbrVsn;
    }
    
    /**
     * @param msgdataMbrVsn the msgdataMbrVsn to set
     */
/*    protected void setMsgdataMbrVsn(String msgdataMbrVsn)
    {
        this.msgdataMbrVsn = msgdataMbrVsn;
    }
    
    
    /**
     * @return the msgdataMbrJobname
     */
/*    public String getMsgdataMbrJobname()
    {
        return this.msgdataMbrJobname;
    }
    
    /**
     * @param msgdataMbrJobname the msgdataMbrJobname to set
     */
/*    protected void setMsgdataMbrJobname(String msgdataMbrJobname)
    {
        this.msgdataMbrJobname = msgdataMbrJobname;
    }
    
    
    /**
     * @return the msgdataMbrRc
     */
/*    public String getMsgdataMbrRc()
    {
        return this.msgdataMbrRc;
    }
    
    /**
     * @param msgdataMbrRc the msgdataMbrRc to set
     */
/*    protected void setMsgdataMbrRc(String msgdataMbrRc)
    {
        this.msgdataMbrRc = msgdataMbrRc;
    }
    
    
    /**
     * @return the msgdataMbrRsn
     */
/*    public String getMsgdataMbrRsn()
    {
        return this.msgdataMbrRsn;
    }
    
    /**
     * @param msgdataMbrRsn the msgdataMbrRsn to set
     */
/*    protected void setMsgdataMbrRsn(String msgdataMbrRsn)
    {
        this.msgdataMbrRsn = msgdataMbrRsn;
    }
    
    
    /**
     * @return the msgdataMbrMsg
     */
/*    public String[] getMsgdataMbrMsg()
    {
        return this.msgdataMbrMsg;
    }
    
    /**
     * @param aMsgdataMbrMsg the msgdataMbrMsg to set
     */
/*    protected void setMsgdataMbrMsg(String[] aMsgdataMbrMsgStringArray)
    {
        this.msgdataMbrMsg = aMsgdataMbrMsgStringArray;
        Mbr[] msgdataMbrArray = this.imsout.getMsgdata().getMbr();
        msgdataMbrArray[msgdataMbrArray.length - 1].setMsg(aMsgdataMbrMsgStringArray);
    }*/
    
    /**
     * Gets an array with the full list of messages from all of the participating type-2 command processing
     * clients. You can use this method to more easily get all of the error, warning,
     * and informational messages that were returned in response to the type-2 command without instantiating 
     * individual <code>Mbr</code> elements for each command processing client.
     * @return the msgdataMbrMsgStringArray
     * @see Mbr#getMsg()
     */
    public String[] getMsgdataMbrMsgStringArray()
    {
    	if(this.isResponseContainsMsgdataElement())
    	{
	        if(this.msgdataMbrMsgStringArray == null)
	        {
	        	//Using get(0) here since for Msgdata there will be only 1 mbr element
	            Mbr msgdataMbrElement = this.imsout.getMsgdata().getMbr().get(0);
	            if(msgdataMbrElement!=null)
	              this.msgdataMbrMsgStringArray = msgdataMbrElement.getMsg(); 
	        }
    	}
        return this.msgdataMbrMsgStringArray;
    }
    
    
    /**
     * @set the MsgdataMbrMsgStringArray 
     */
    protected void setMsgdataMbrMsgStringArray()
    {
    	if(this.isResponseContainsMsgdataElement())
    	{	        
	        	//Using get(0) here since for Msgdata there will be only 1 mbr element
	            Mbr msgdataMbrElement = this.imsout.getMsgdata().getMbr().get(0);
	            if(msgdataMbrElement!=null)
	              this.msgdataMbrMsgStringArray = msgdataMbrElement.getMsg(); 
	        
    	}
    }
    
    /*
    /**
     * @return the member
     */
/*    public Mbr[] getAllMsgdataMbrElements()
    {
        return this.msgdataMbr;
    }
    
    /**
     * Adds an element to the elements of the msgdataMbr 
     * array. Creates a new element if the msgdataMbr array   
     * is null (not yet initialized) or there are currently  
     * noelements in the msgdataMbr array.  If 
     * anAddNewMsgdataMbrElement is true, the new element is 
     * appended to the end of the existing msgdataMbr array.  
     * If anAddNewMsgdataMbrElement is false, the value of 
     * aMsgdataMbrElementText is appended to the value of the  
     * last element in the existing member array (since 
     * elements are sometimes processed in multiple pieces, 
     * one piece at a time) 
     * @param anAddNewMsgdataMbrElement the msgdataMbrElement to set
     */
/*    protected void addMsgdataMbrElement(String aMsgdataMbrElementText, boolean anAddNewMsgdataMbrElement)
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.addMsgdataMbrElement(String aMsgdataMbrElementText, boolean anAddNewMsgdataMbrElement)");
        
        int msgdataMbrArrayLength = (this.msgdataMbr == null ? 0 : this.msgdataMbr.length);
        
        if(this.msgdataMbr == null) // create a new msgdataMbr array with one element 
        {
            this.imsout.getMsgdata().addMbr(new Mbr(aMsgdataMbrElementText));
        }
        else if((anAddNewMsgdataMbrElement) || (msgdataMbrArrayLength == 0)) // append a new msgdataMbr element to the existing array
        {
            this.imsout.getMsgdata().addMbr(new Mbr(aMsgdataMbrElementText));
        }
        else // aMsgdataMbrElementText contains a continuation of the text value of the last msgdataMbr element text value so append  
        {    // aMsgdataMbrElementText to text of the last element of the existing aMsgdataMbr array
            this.imsout.getMsgdata().appendToLastMsgdataMbrElement(aMsgdataMbrElementText);
        }
        this.setMsgdataMbr((Mbr[])this.imsout.getMsgdata().getMbr());
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.addMsgdataMbrElement(String aMbrElementText, boolean anAddNewMbrElement)");
    }
    
    /**
     * @return the arrayOfMsgdataMbrMsgElementPropertiesObjects
     */
/*    public Properties[] getArrayOfMsgdataMbrMsgElementPropertiesObjects() throws ImsConnectApiException
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.getArrayOfMsgdataElementPropertiesObjects()");
        if(this.arrayOfMsgdataMbrMsgElementPropertiesObjects != null)
            return this.arrayOfMsgdataMbrMsgElementPropertiesObjects;
        else
        {
//            setArrayOfMsgdataElementPropertiesObjects(); ?????
        }
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.getArrayOfMsgdataElementPropertiesObjects()");
        
        return arrayOfMsgdataMbrMsgElementPropertiesObjects; 
    }

    /**
     * @return the arrayOfRspElementPropertiesObjects
     */
/*    protected void setArrayOfMsgdataMbrMsgElementPropertiesObjects() throws ImsConnectApiException
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.getArrayOfMsgdataElementProperties()");
        
        ResponseProcessor myMsgdataMbrMsgProcessor = new ResponseProcessor();
        if(msgdataMbrMsgStringArray == null)
;//            this.setMsgdataStringArray();  ????? // uncomment all of these lines after msgdataMbr/msgdateMbrMsg support is fixed
//        int numberOfMsgdataElements = this.msgdataStringArray.length;
        arrayOfMsgdataMbrMsgElementPropertiesObjects = new Properties[0];
//        xmlTaggedMsgdataStringArray = new String[numberOfMsgdataElements];
//        for(int i=0; i<numberOfMsgdataElements; i++)
        {
//            this.addAnElementToArrayOfMsgdataElementsPropertiesObjects(myMsgdataProcessor.processProperties(this.msgdataStringArray[i], myImsConnectCodepage));
//            xmlTaggedMsgdataStringArray[i] = new String(myMsgdataProcessor.getProcessedResponse());
        }
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.getArrayOfRspElementProperties()");
    }
**/
    /*
     * @return a specific messagedataMember element
     */
/*    public Mbr getOneMsgdataMbrElement(int anElementIndex)
    {
        return this.msgdataMbr[anElementIndex];
    }

    /**
     * @param aMsgdataElement the arrayOfMsgdataMbrMsgElementPropertiesObjects element to set
     */
/*    protected void addAnElementToArrayOfMsgdataElementsPropertiesObjects(Properties aMsgdataElement)
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.addAnElementToArrayOfMsgdataElementsProperties(Properties aMsgdataElement)");
        
        int len = this.arrayOfMsgdataMbrMsgElementPropertiesObjects == null ? 0 : this.arrayOfMsgdataMbrMsgElementPropertiesObjects.length;
        Properties[] newArrayOfMsgdataElementsPropertiesArray = new Properties[len + 1];
        if(len > 0)
            System.arraycopy(this.arrayOfMsgdataMbrMsgElementPropertiesObjects, 0, newArrayOfMsgdataElementsPropertiesArray, 0, len);
        
        newArrayOfMsgdataElementsPropertiesArray[len] = (Properties)aMsgdataElement.clone();
        
        this.arrayOfMsgdataMbrMsgElementPropertiesObjects = newArrayOfMsgdataElementsPropertiesArray.clone();
//        setRspStringArray();
        this.setResponseContainsMsgdataElement(true);
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.addAnElementToArrayOfMsgdataElementsProperties(Properties aMsgdataElement)");
    }
    
    
    /**
     * @return the arrayOfMsgElementProperties
     */
/*    public String[] getMsgStringArray()
    {
        return this.msgStringArray;
    }

    /**
     * @set the rspStringArray with the msg elements in aMbrElement
     */
/*    protected void setMsgStringArray(Mbr aMbrElement)
    {
        this.msgStringArray = (String[])aMbrElement.getMsg(); 
    }
    
    */
    
//  cmdRspdata    
    /**
     * For API internal use only.
     * @return the type2CmdRspStale. 
     */
    public boolean isType2CmdRspStale()
    {
        return this.type2CmdRspStale;
    }
    
    /**
     * For API internl use only.
     * @param type2CmdRspStale the type2CmdRspStale to set. 
     */
    public void setType2CmdrspdataStale(boolean type2CmdRspStale)
    {
        this.type2CmdRspStale = type2CmdRspStale;
    }

    /**
     * Adds an element to the elements of the cmdrspdataRsp array
     * Creates a new element if the cmdrspdataRsp array is null 
     * (not yet initialized) or there are currently no 
     * elements in the cmdrspdataRsp array.  If 
     * anAddNewResponseElement is true, the new element is 
     * appended as a new element to the end of the existing 
     * cmdrspdataRsp array.  If aNewResponseElement is false, the 
     * value of aResponse is appended to the value of the 
     * last element in the existing cmdrspdataRsp array (since 
     * elements are sometimes processed in multiple pieces, 
     * one piece at a time) 
     * @param cmdrspdataRsp the cmdrspdataRsp to set
     */
    protected void addResponseElement(String aCmdrspdataRsp, boolean anAppendNewResponseElement)
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.addResponseElement(String aResponse, boolean anAppendNewResponseElement)");
        
        int rspStringArrayLength = (this.imsout.getCmdrspdata() == null ? 0 : this.imsout.getCmdrspdata().getRsp().size());
        
        if(this.imsout.getCmdrspdata() == null) // create a new cmdrspdataRsp array with one element 
        {
            ((ImsoutImpl)this.imsout).setCmdrspdata(new CmdrspdataImpl(""));
            ((CmdrspdataImpl)(this.imsout.getCmdrspdata())).addRspElement(aCmdrspdataRsp);
        }//else if statement changed for defect: ipsdb00096308.Added (rspStringArray == null)&&
        else if(((rspStringArray == null)&&(anAppendNewResponseElement) || (rspStringArrayLength == 0))) // append a new element to the existing cmdrspdataRsp array
        {
            ((CmdrspdataImpl)(this.imsout.getCmdrspdata())).addRspElement(aCmdrspdataRsp);
        }
        else // aResponse contains the original value of this cmdrspdataRsp element plus a continuation of that cmdrspdataRsp element   
        {    
            ((CmdrspdataImpl)(this.imsout.getCmdrspdata())).SetLastRspElement(aCmdrspdataRsp);
        }
        this.setResponseContainsCmdrspdataElement(true);
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.addResponseElement(String aResponse, boolean anAppendNewResponseElement)");
    }
    
    /**
     * Gets the command output data from the <code>rsp</code> element or elements in the type-2 command
     * response message.
     * @return the Vector of cmdrspdataRsp Strings
     */
    public ArrayList<String> getResponseVectorOfStrings()
    {
        return this.imsout.getCmdrspdata().getRsp();
    }
    
    
    /**
     * Gets the values of the rsp elements in the type-2 command response message. 
     * Each rsp element contains a single line of output that was generated by one of the OM clients that
     * responded to the command.
     * @return the array of RspElements
     */
    public String[] getRspStringArray()
    {
        if(this.rspStringArray == null)
        {
        	if(this.imsout.getCmdrspdata()!=null)
        	{
            ArrayList<String> rspVector = this.imsout.getCmdrspdata().getRsp();
            if(rspVector!=null)
               this.rspStringArray = rspVector.toArray(new String[rspVector.size()]); 
        	}
        }
        return this.rspStringArray;
    }
    
    /**
     * @set the rspStringArray with the values of the arrayOfRspElementPropertiesObjects
     */
    protected void setRspStringArray()
    {
    	if(this.imsout.getCmdrspdata()!=null)
    	{
        ArrayList<String> rspVector = this.imsout.getCmdrspdata().getRsp();
        if(rspVector!=null)
          this.rspStringArray = rspVector.toArray(new String[rspVector.size()]); 
    	}
    } 
    
    
    /**
     * Gets a Properties array containing the column header attributes for the type-2 command
     * response data. 
     * @return the hdrElementAttributesObject
     */
    public Properties[] getAttributesForAllHdrsAsPropertiesObjects() throws ImsConnectApiException
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.getHdrElementAttributesObject()");
        if(this.attributesForAllHdrElementsAsPropertiesObjects != null)
            return this.attributesForAllHdrElementsAsPropertiesObjects;
        else
        {
            setAttributesForAllHdrElementsAsPropertiesObjects();
        }
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.getHdrElementAttributesObject()");
        
        return attributesForAllHdrElementsAsPropertiesObjects; 
    }

    /**
     * @set the attributesForAllHdrElementsAsPropertiesObjects
     */
    protected void setAttributesForAllHdrElementsAsPropertiesObjects() throws ImsConnectApiException
    {
        int aHdrArraySize = 0;
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.setAttributesForAllHdrElementsAsPropertiesObjects()");
        
        ArrayList<Hdr> aHdrArray = this.getImsout().getCmdrsphdr().getHdrArray();
        aHdrArraySize = aHdrArray.size();
        attributesForAllHdrElementsAsPropertiesObjects = new Properties[aHdrArraySize];
        
        for(int i = 0; i < aHdrArraySize; i++)
        {
            attributesForAllHdrElementsAsPropertiesObjects[i] = aHdrArray.get(i).getHdrElementAttributesAsPropertiesObject(myImsConnectCodepage);
        }
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.setAttributesForAllHdrElementsAsPropertiesObjects()");
    }
    
    
    /**
     * Gets a Properties object containing the response elements from the type-2 command response XML message.
     * @return the rspElementPropertiesObject for a valid request or null for an invalid request
     */
    public Properties[] getRspElementPropertiesObject() throws ImsConnectApiException
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.getRspElementPropertiesObject()");
        if(this.rspElementPropertiesObject != null)
            return this.rspElementPropertiesObject;
        else
        {
            setRspElementPropertiesObject();
        }
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.getRspElementPropertiesObject()");
        
        return rspElementPropertiesObject; 
    }

    /**
     * @return the rspElementPropertiesObject
     */
    protected void setRspElementPropertiesObject() throws ImsConnectApiException
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.setRspElementPropertiesObject()");
        
        if(rspStringArray == null)
            this.setRspStringArray();
        if(rspStringArray!=null)
        {
        ResponseProcessor myRspProcessor = new ResponseProcessor();
        
        int numberOfRspElements = this.rspStringArray.length;
        rspElementPropertiesObject = new Properties[0];
        xmlTaggedRspStringArray = new String[numberOfRspElements];
        for(int i=0; i<numberOfRspElements; i++)
        {
            this.addPropertyToRspElementsPropertiesObject(myRspProcessor.processProperties(this.rspStringArray[i], myImsConnectCodepage));
            xmlTaggedRspStringArray[i] = new String(myRspProcessor.getProcessedResponse());
        }
        }
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.setRspElementPropertiesObject()");
    }
    
    
    /**
     * Gets a Properties object containing a specific element of the type-2 command response
     * XML message.
     * @return a specific rspElementPropertiesObject element
     */
    public Properties getOneElementOfRspElementPropertiesObject(int elementNumber)
    {
        return this.rspElementPropertiesObject[elementNumber];
    }

    /**
     * @param aRspElement the rspElementPropertiesObject element to set
     */
    protected void addPropertyToRspElementsPropertiesObject(Properties aRspElement)
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.addPropertyToRspElementsPropertiesObject(Properties aRspElement)");
        
        int len = this.rspElementPropertiesObject == null ? 0 : this.rspElementPropertiesObject.length;
        Properties[] newRspElementsPropertiesObject = new Properties[len + 1];
        if(len > 0)
            System.arraycopy(this.rspElementPropertiesObject, 0, newRspElementsPropertiesObject, 0, len);
        
        newRspElementsPropertiesObject[len] = (Properties)aRspElement.clone();
        
        this.rspElementPropertiesObject = newRspElementsPropertiesObject.clone();
//        setRspStringArray();
        this.setResponseContainsCmdrspdataElement(true);
        
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("<-- Type2CmdResponse.addAnElementToArrayOfRspElementsProperties(Properties aRspElement)");
    }
    
    
    /**
     * Returns true if the type-2 command response message XML contains the <code>msgdata</code element.
     * This element contains information about IMS messages that were generated by the OM command processing
     * clients. If the element exists, at least one command processing client that executed the command generated
     * an IMS response message.
     * @return the responseContainsMsgdataElement
     */
    public boolean isResponseContainsMsgdataElement()
    {
        return this.responseContainsMsgdataElement;
    }

    /**
     * @param aResponseContainsMsgdataElement the responseContainsMsgdataElement to set
     */
    protected void setResponseContainsMsgdataElement(boolean aResponseContainsMsgdataElement)
    {
        this.responseContainsMsgdataElement = aResponseContainsMsgdataElement;
    }
    
    
    /**
     * Returns true if the <code>cmdrspdata</code> element exists in the response message. This
     * element contains the command response information if any was returned in the response message.
     * @return the responseContainsCmdrspdataElement
     * @see Cmdrspdata
     */
    public boolean isResponseContainsCmdrspdataElement()
    {
        return this.responseContainsCmdrspdataElement;
    }

    /**
     * @param aResponseContainsRspElement the responseContainsCmdrspdataElement to set
     */
    protected void setResponseContainsCmdrspdataElement(boolean aResponseContainsRspElement)
    {
        this.responseContainsCmdrspdataElement = aResponseContainsRspElement;
    }
    
    
    /**
     * Returns true if any command response data was returned in the response message. 
     * @return a boolean indicating if the type-2 cmdrspdataRsp included one or more <code>rsp</code> (cmdrspdataRsp) elements
     * @see Cmdrspdata
     */
    public boolean isType2CommandSuccessful()
    {
        try
        {
            if ((Integer.parseInt(this.getCtl().getRc(), 16) == 0) && (Integer.parseInt(this.getCtl().getRsn(), 16) == 0))
                return (this.isResponseContainsCmdrspdataElement() || this.isResponseContainsMsgdataElement());
            else
                return false;
        }
        catch(NumberFormatException nfe)
        {
            return false;
        }
    }
    
    
    protected void updateType2CmdResponseProperties(Imsout anImsout)
    {
        if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
            logger.finer("--> Type2CmdResponse.updateType2CmdResponseProperties(Imsout)");
        
        if(anImsout != null)
        {
            this.ctl = anImsout.getCtl();
            this.cmdclients = anImsout.getCmdclients();
            this.cmdsyntax = anImsout.getCmdsyntax();
            this.cmddtd = anImsout.getCmddtd();
            this.cmdtext = anImsout.getCmdtext();
            this.cmderr = anImsout.getCmderr();
            this.cmdsecerr = anImsout.getCmdsecerr();
            this.cmd = anImsout.getCmd();
            this.cmdrsphdr = anImsout.getCmdrsphdr(); 
            this.cmdrspdata = anImsout.getCmdrspdata();
            this.msgdata = anImsout.getMsgdata();
            
            this.cmdInput = anImsout.getCmd().getInput();
            
            setRspStringArray();
            setMsgdataMbrMsgStringArray();
            
            if (logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) 
                logger.finer("<-- Type2CmdResponse.updateType2CmdResponseProperties(Imsout)");
        }
    }
}