/**
 * File: CmdrspdataImpl.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect.impl;

import com.ibm.ims.connect.Cmdrspdata;

import java.util.ArrayList;

/**
 * @author kevin
 *
 */
public class CmdrspdataImpl implements Cmdrspdata
{
    private String elementText;
    
    private ArrayList<String> rsp = new ArrayList<String>();
    
    
    /**
     * @param string
     */
    public CmdrspdataImpl(String anElementText)
    {
        this.setElementText(anElementText);
    }
    
    
    /**
     * @return the elementText
     */
    public String getElementText()
    {
        return this.elementText;
    }
    
    /**
     * @param elementText the elementText to set
     */
    public void setElementText(String aelementText)
    {
        this.elementText = aelementText;
    }
    
    
    /**
     * @return the rsp
     */
    public ArrayList<String> getRsp()
    {
        return this.rsp;
    }
    
    /**
     * @param rsp the rsp to set
     */
    public void setRsp(ArrayList<String> rsp)
    {
        this.rsp = rsp;
    }
    
    
    /**
     * @return the rsp
     */
    public String getRspElement(int anIndex)
    {
        return this.rsp.get(anIndex);
    }
    
    /**
     * @param aRspElement the rsp element to set
     */
    public void addRspElement(String aRspElement)
    {
        this.rsp.add(aRspElement);
    }
    
    /**
     * Changes the current value of the last element of rsp to a new value
     * @param aRspElementPlusContinuation the new value of the rsp element to set
     */
    public void SetLastRspElement(String aRspElementPlusContinuation)
    {
        int indexOfLastElement = this.rsp.size() - 1;
        this.rsp.set(indexOfLastElement, aRspElementPlusContinuation);
    }
}