package com.ibm.ims.db.cci;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.cci.ConnectionSpec;

/**
* This class implements the <code>javax.resource.cci.ConnectionSpec</code> interface for 
* the IMS Universal Database Resource Adapter 
* 
*/
public class IMSConnectionSpec implements ConnectionSpec {
    private static final Logger logger = Logger.getLogger("com.ibm.ims.db.opendb.cci");

    String user;
    String password;
    String datastoreName;
    String metadataURL;
    
    //TODO Consider adding a client Id field that can be used by various applications for
    //charge back, debug, or any other logging purposes.
    
    /**
     * The default constructor.
     * 
     */
    public IMSConnectionSpec() {
        if(logger.isLoggable(Level.FINER)){
            logger.entering(this.getClass().getName(), "IMSConnectionSpec()");
        }
        
        if(logger.isLoggable(Level.FINER)){
            logger.exiting(this.getClass().getName(), "IMSConnectionSpec()");
        }
    }
    
    /**
     * Sets the user name for this connection.
     *
     * @param user User name.
     */
    public void setUser(String user) {
        if(logger.isLoggable(Level.FINER)){
            logger.entering(this.getClass().getName(), "setUser(String)", user);
        }
        
        this.user = user;
        
        if(logger.isLoggable(Level.FINER)){
            logger.exiting(this.getClass().getName(), "setUser(String)");
        }

    }
    
    /**
     * Sets the user password.
     *
     * @param password User password value
     */
    public void setPassword(String password) {
        if(logger.isLoggable(Level.FINER)){
            logger.entering(this.getClass().getName(), "setPassword(String password)");
        }

        this.password = password;
        
        if(logger.isLoggable(Level.FINER)){
            logger.exiting(this.getClass().getName(), "setPassword(String password)");
        }

    }
    
    /**
     * Sets the location of the database metadata representing the target IMS database.  
     * The metadata URL is the fully qualified name of the Java metadata class generated by the IMS Explorer for Development.
     * 
     * The URL must begin with class://
     * 
     * @param metadataURL metadata url
     * 
     * @deprecated {@link #setDatabaseName(String)}
     */
    public void setMetadataURL(String metadataURL) {
        this.metadataURL = metadataURL;
    }
    
    /**
     * Sets the name of the target IMS database to be accessed. 
     * 
     * If the metadata repository is the IMS catalog then the database name is
     * the name of the PSB (program specification block) containing the database(s)
     * to be accessed.
     * 
     * If the metadata repository is the file system then the database name
     * is the fully qualified name of the Java metadata class generated
     * by the IMS Explorer for Development.  In this case the name must begin with class://
     * 
     * @param databaseName
     *            database name
     */
    public void setDatabaseName(String databaseName) {
        this.metadataURL = databaseName;
    }
    
    /**
     * Sets the name of the IMS datastore to access. The datastore parameter must match either the name of the datastore
     * defined to ODBM or be blank.  The datastore name is defined in the ODBM CSLDCxxx PROCLIB member using either the
     * DATASTORE (NAME=name) or ALIAS (NAME=aliasname) parameter.  If the datastore value is left blank (or not supplied), IMS Connect will connect 
     * to any available instance of ODBM as it is assumed all datastores defined to ODBM are data shared.   
     * 
     * @param datastoreName IMS datastore name
     */
    public void setDatastoreName(String datastoreName){
        this.datastoreName = datastoreName;
    }
    
    /**
     * Retrieves the URL of the database metadata representing the target IMS database.
     * 
     * @return the metadata URL
     * 
     * @deprecated {@link #getDatabaseName()}
     */
    public String getMetadataURL() {
        return this.metadataURL;
    }
    
    /**
     * Retrieves the database name this of the target IMS database.
     * 
     * @return the database name
     */
    public String getDatabaseName() {
        return this.metadataURL;
    }
    
    /**
     * Retrieves name of the IMS datastore this ConnectionSpec is configured to access.
     * 
     * @return the datastore name
     */
    public String getDatastoreName(){
        return this.datastoreName;
    }
    
    /**
     * Retrieves the user name.
     *
     * @return the user name for this connection.
     */
    public String getUser() {
        return this.user;
    }
    
    /**
     * Retrieves the user password.
     *
     * @return user password value for this connection
     */
    public String getPassword() {
        return this.password;
    }

}
