package com.ibm.ims.db.cci;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

/**
 * Use this class to access data from an IMS database with the IMS Universal Database Resource Adapter 
 * using SQL queries. <code>SQLInteractionSpec</code> is used by an <code>Interaction</code> 
 * to execute the specified SQL query against an IMS database. 
 * 
 */
public class SQLInteractionSpec extends InteractionSpecImpl {

	private static final long serialVersionUID = 1929673441188202302L;
	private String query;

	/**
	 * Sets the SQL query the interaction will use when executed.  
	 * 
	 * The IMS Universal Database Resource Adapter supports the same SQL statement syntax and usage as 
	 * the IMS Universal JDBC driver and has the same restrictions. In the the SELECT query, you can specify the 
	 * qualification column values in the WHERE clause with a <code>?</code> parameter marker, meaning that 
	 * the values will provided later (similar to a SELECT string for a <code>PreparedStatement</code> in JDBC). 
	 * 
	 * <p>The following code example shows how to specify the SELECT statement without using 
	 * parameter markers, where <varname>iSpec</varname> is an instance of <code>SQLInteractionSpec</code>:
	 * <pre>
	 * iSpec.setQuery("SELECT PATIENT.PATNAME, ILLNESS.ILLNAME "+      
	 *    "FROM pcb01.HOSPITAL,pcb01.PATIENT, pcb01.ILLNESS " +       
	 *    "WHERE HOSPITAL.HOSPNAME='SANTA TERESA'");
	 * </pre>
	 * 
	 *  <p>The following example shows how to perform the SELECT statement with the parameter
	 *  markers, where <varname>iSpec</varname> is an instance of <code>SQLInteractionSpec</code>:
	 * <pre>
	 * iSpec.setQuery("SELECT PATIENT.PatName, WARD.WardName "+      
	 *    "FROM pcb01.HOSPITAL, pcb01.PATIENT, pcb01.WARD " +       
	 *    "WHERE HOSPITAL.HospName=? AND WARD.DocCount>?");
	 * </pre>
	 * 
	 * @param query a SQL query
	 */
	public void setSQL(String query) {
		this.query = query;
	}
	
    /**
     * Retrieves the SQL query the interaction will use when executed.  
     * @return a <code>String</code> representing the SQL query.
     */
	public String getSQL() {
		return this.query;
	}

	/**
	 * Gives the JDBC driver a hint as to the number of rows that should 
	 * be fetched from the database when more rows are needed. The number 
	 * of rows specified affects only result sets created using this interaction. 
	 * If the value specified is zero, then the hint is ignored. The default 
	 * value is zero.
	 * 
	 *  @param rows the number of rows to fetch
	 */
	public void setFetchSize(int rows) {
	    super.setFetchSize(rows);
	}
	
	/**
	 * Retrieves the number of result set rows that is the default 
	 * fetch size for <code>ResultSet</code> objects generated from this interaction.
	 * 
	 * @return the default fetch size for result sets generated from this interaction.
	 */
	public int getFetchSize() {
	    return super.getFetchSize();
	}
}
