package com.ibm.ims.dli;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

/**
 * <p>
 * The <code>DBPCB</code> interface contains all the data attributes of the IMS
 * database program communication block from the most recent DL/I call. The
 * <code>DBPCB</code> contains the two character status code returned by IMS
 * after the last DL/I call. The DBPCB object reference is retrieved using the
 * AIB class.
 * 
 * @see AIB
 */
public interface DBPCB {

	/**
	 * Gets the database name.
	 * 
	 * @return the database name.
	 */
	public String getDBName();

	/**
	 * Returns the key feedback area from the last DLI call.
	 * 
	 * <p>
	 * At the completion of a retrieval or ISRT call, IMS places the
	 * concatenated key of the retrieved segment in this field. A segment's
	 * concatenated key is made up of the keys of each of its parents and its
	 * own key. Keys are positioned left to right, starting with the key of the
	 * root segment and following the hierarchic path.
	 * 
	 * @return the key feedback area
	 */
	public byte[] getKeyFeedback();

	/**
	 * Returns the length of the key feedback area.
	 * 
	 * @return the length of the key feedback area
	 */
	public int getKeyFeedbackLength();

	/**
	 * Returns the number of segment types in the database to which the
	 * application program is sensitive.
	 * 
	 * @return the number of sensitive segments
	 */
	public int getNumberSensitiveSegments();

	/**
	 * Returns the IMS processing options (type of calls this program can
	 * issue).
	 * 
	 * @return the processing options
	 */
	public String getProcessOptions();

	/**
	 * Returns the segment level number of the lowest-level segment retrieved.
	 * If IMS is unable to find the segment that you requested, it returns the
	 * level number of the last segment it encountered that satisfied your call.
	 * 
	 * @return the segment level number
	 */
	public int getSegmentLevelNumber();

	/**
	 * Returns the name of the last segment that satisfied the call.
	 * 
	 * @return the segment name
	 */
	public String getSegmentName();

	/**
	 * Returns the IMS status code of the last DLI call.
	 * 
	 * @return the status code.
	 * @see IMSStatusCodes
	 */
	public short getStatusCode();

	/**
	 * Returns the IMS status code of the last DL/I call as a character string.
	 * 
	 * @return the status code.
	 */
	public String getStatusCodeChars();

}
