package com.ibm.ims.dli;

import com.ibm.ims.dli.DLICall.Function;

/**
 * Object that represents the output from a DL/I call that was issued
 * programatically using the <code>DLICall</code> interface.
 * 
 */
public interface DLICallResult {

	/**
	 * Retrieves the constant that represents the DL/I call function that was
	 * issued.
	 * 
	 * @return the DL/I call function
	 */
	public Function getDLICallFunction();

	/**
	 * Retrieves an <code>AIB</code> instance that contains the return code,
	 * reason code, and other useful information after a DL/I call is issued.
	 * 
	 * @return the <code>AIB</code> object
	 */
	public AIB getAIB();

}
