package com.ibm.ims.dli;

/**
 * Object that represents the output from an Field (FLD) call.
 * 
 */
public interface FLDCallResult extends DLICallResult {

	/**
	 * The constants that represent field search argument (FSA) status codes.
	 * 
	 */
	public enum FLD_STATUSCODE {
		/**
		 * Successful
		 */
		b,

		/**
		 * Invalid operation
		 */
		A,

		/**
		 * Operand length invalid
		 */
		B,

		/**
		 * Invalid call-program tried to change key field
		 */
		C,

		/**
		 * Verify check was unsuccessful
		 */
		D,

		/**
		 * Packed decimal or hexadecimal field is invalid
		 */
		E,

		/**
		 * Program tried to change an unowned segment
		 */
		F,

		/**
		 * Arithmetic overflow
		 */
		G,

		/**
		 * Field not found in segment
		 */
		H
	}

	/**
	 * Retrieves the field search argument status code after a FLD call is
	 * issued.
	 * 
	 * @return the status code value.
	 */
	public FLD_STATUSCODE getStatusCode();

}
