package com.ibm.ims.dli;

/**
 * Object that represents the output from a Get Command (GCMD) call.
 * 
 */
public interface GCMDCallResult extends DLICallResult {

	/**
	 * Retrieves the second and subsequent command response segments after a
	 * Command (CMD) call is issued.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_gcmdcall.htm"
	 * target="_blank">GCMD call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the response segments.
	 */
	public String getResponseSegment();

}
