package com.ibm.ims.dli;

/**
 * Object that represents the output from a Get Message (GMSG) call.
 *
 */
public interface GMSGCallResult extends DLICallResult {

	/**
	 * Retrieves a message associated with an AOI token, after a GMSG call is
	 * issued.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_gmsgcalltm.htm"
	 * target="_blank">GMSG call</a>
	 * 
	 * @return message
	 */
	public String getMessage();
}
