package com.ibm.ims.dli;

/**
 * The GPCB interface contains all the data attributes of the GSAM Database
 * Program Communication Block and the necessary getter and setter methods. IMS
 * describes the results of the GSAM database calls your program issues in the
 * DB PCB that is referenced in the call.
 */
public interface GPCB {

	/**
	 * Returns the database name in this GSAMPCB. The maximum length of this
	 * field is 8 characters.
	 * 
	 * @return The GSAMPCB's database name.
	 */
	public String getDBName();

	/**
	 * Returns the concatenated key in this GSAMPCB from the last DLI call using
	 * this GSAMPCB. Returns null if no concatenated key returned from IMS.
	 * 
	 * @return The GSAMPCB's concatenated key.
	 */
	public byte[] getKeyFeedback();

	/**
	 * Returns the concatenated key length in this GSAMPCB from the last DLI
	 * call using this GSAMPCB.
	 * 
	 * @return The GSAMPCB's concatenated key length.
	 */
	public int getKeyFeedbackLength();

	/**
	 * Returns the IMS processing options in this GSAMPCB.
	 * 
	 * @return The GSAMPCB's IMS processing options.
	 */
	public String getProcessOptions();

	/**
	 * Returns the record search argument (RSA) from GSAM DB PCB. It is 8 bytes
	 * long or null if DB PCB is not GSAM. NOTE: if GSAM, the keyFeedback is 12
	 * bytes long. The first 8 bytes is record search argument which can be used
	 * later on if you want to retrieve that record directly by including it as
	 * one of the parameters on a GU call. The last 4 bytes is the length of the
	 * undefined-length record(RECFM=U)
	 * 
	 * @return GSAM DB PCB record search argument (RSA).
	 */
	public RSA getRSA();

	/**
	 * Returns the status code of the last GSAM database call using this GSAMPCB
	 * 
	 * @return The GSAMPCB's status code.
	 */
	public short getStatusCode();

	/**
	 * Returns the IMS status code of the last DL/I call as a character string.
	 * 
	 * @return the status code.
	 */
	public String getStatusCodeChars();

	/**
	 * Returns the length of the undefined-length record after GSAM GU or GN
	 * call. Return 0 if DB PCB is not GSAM.
	 * 
	 * @return the length of the undefined-length record.
	 */
	public int getUndefinedLengthRecordLength();
}