package com.ibm.ims.dli;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

/**
 * This class defines constants for the IMS status codes. It is a helper class
 * for comparing status codes from DLI calls.
 *
 */
public interface IMSStatusCodes {

	/**
	 * Constant indicating two blanks
	 */
	public final static short BLANKS = (short) 0x4040;
	/**
	 * Constant indicating the IMS status code A1
	 */
	public final static short A1 = (short) 0xC1F1;
	/**
	 * Constant indicating the IMS status code A2
	 */
	public final static short A2 = (short) 0xC1F2;
	/**
	 * Constant indicating the IMS status code A3
	 */
	public final static short A3 = (short) 0xC1F3;
	/**
	 * Constant indicating the IMS status code A4
	 */
	public final static short A4 = (short) 0xC1F4;
	/**
	 * Constant indicating the IMS status code A5
	 */
	public final static short A5 = (short) 0xC1F5;
	/**
	 * Constant indicating the IMS status code A6
	 */
	public final static short A6 = (short) 0xC1F6;
	/**
	 * Constant indicating the IMS status code A7
	 */
	public final static short A7 = (short) 0xC1F7;
	/**
	 * Constant indicating the IMS status code A8
	 */
	public final static short A8 = (short) 0xC1F8;
	/**
	 * Constant indicating the IMS status code A9
	 */
	public final static short A9 = (short) 0xC1F9;
	/**
	 * Constant indicating the IMS status code AA
	 */
	public final static short AA = (short) 0xC1C1;
	/**
	 * Constant indicating the IMS status code AB
	 */
	public final static short AB = (short) 0xC1C2;
	/**
	 * Constant indicating the IMS status code AC
	 */
	public final static short AC = (short) 0xC1C3;
	/**
	 * Constant indicating the IMS status code AD
	 */
	public final static short AD = (short) 0xC1C4;
	/**
	 * Constant indicating the IMS status code AF
	 */
	public final static short AF = (short) 0xC1C6;
	/**
	 * Constant indicating the IMS status code AG
	 */
	public final static short AG = (short) 0xC1C7;
	/**
	 * Constant indicating the IMS status code AH
	 */
	public final static short AH = (short) 0xC1C8;
	/**
	 * Constant indicating the IMS status code AI
	 */
	public final static short AI = (short) 0xC1C9;
	/**
	 * Constant indicating the IMS status code AJ
	 */
	public final static short AJ = (short) 0xC1D1;
	/**
	 * Constant indicating the IMS status code AK
	 */
	public final static short AK = (short) 0xC1D2;
	/**
	 * Constant indicating the IMS status code AL
	 */
	public final static short AL = (short) 0xC1D3;
	/**
	 * Constant indicating the IMS status code AM
	 */
	public final static short AM = (short) 0xC1D4;
	/**
	 * Constant indicating the IMS status code AO
	 */
	public final static short AO = (short) 0xC1D6;
	/**
	 * Constant indicating the IMS status code AP
	 */
	public final static short AP = (short) 0xC1D7;
	/**
	 * Constant indicating the IMS status code AQ
	 */
	public final static short AQ = (short) 0xC1D8;
	/**
	 * Constant indicating the IMS status code AR
	 */
	public final static short AR = (short) 0xC1D9;
	/**
	 * Constant indicating the IMS status code AS
	 */
	public final static short AS = (short) 0xC1E2;
	/**
	 * Constant indicating the IMS status code AT
	 */
	public final static short AT = (short) 0xC1E3;
	/**
	 * Constant indicating the IMS status code AU
	 */
	public final static short AU = (short) 0xC1E4;
	/**
	 * Constant indicating the IMS status code AX
	 */
	public final static short AX = (short) 0xC1E7;
	/**
	 * Constant indicating the IMS status code AY
	 */
	public final static short AY = (short) 0xC1E8;
	/**
	 * Constant indicating the IMS status code AZ
	 */
	public final static short AZ = (short) 0xC1E9;
	/**
	 * Constant indicating the IMS status code BA
	 */
	public final static short BA = (short) 0xC2C1;
	/**
	 * Constant indicating the IMS status code BB
	 */
	public final static short BB = (short) 0xC2C2;
	/**
	 * Constant indicating the IMS status code BC
	 */
	public final static short BC = (short) 0xC2C3;
	/**
	 * Constant indicating the IMS status code BJ
	 */
	public final static short BJ = (short) 0xC2D1;
	/**
	 * Constant indicating the IMS status code BK
	 */
	public final static short BK = (short) 0xC2D2;
	/**
	 * Constant indicating the IMS status code CA
	 */
	public final static short CA = (short) 0xC3C1;
	/**
	 * Constant indicating the IMS status code CB
	 */
	public final static short CB = (short) 0xC3C2;
	/**
	 * Constant indicating the IMS status code CC
	 */
	public final static short CC = (short) 0xC3C3;
	/**
	 * Constant indicating the IMS status code CD
	 */
	public final static short CD = (short) 0xC3C4;
	/**
	 * Constant indicating the IMS status code CE
	 */
	public final static short CE = (short) 0xC3C5;
	/**
	 * Constant indicating the IMS status code CF
	 */
	public final static short CF = (short) 0xC3C6;
	/**
	 * Constant indicating the IMS status code CG
	 */
	public final static short CG = (short) 0xC3C7;
	/**
	 * Constant indicating the IMS status code CH
	 */
	public final static short CH = (short) 0xC3C8;
	/**
	 * Constant indicating the IMS status code CI
	 */
	public final static short CI = (short) 0xC3C9;
	/**
	 * Constant indicating the IMS status code CJ
	 */
	public final static short CJ = (short) 0xC3D1;
	/**
	 * Constant indicating the IMS status code CK
	 */
	public final static short CK = (short) 0xC3D2;
	/**
	 * Constant indicating the IMS status code CL
	 */
	public final static short CL = (short) 0xC3D3;
	/**
	 * Constant indicating the IMS status code CM
	 */
	public final static short CM = (short) 0xC3D4;
	/**
	 * Constant indicating the IMS status code CN
	 */
	public final static short CN = (short) 0xC3D5;
	/**
	 * Constant indicating the IMS status code DA
	 */
	public final static short DA = (short) 0xC4C1;
	/**
	 * Constant indicating the IMS status code DJ
	 */
	public final static short DJ = (short) 0xC4D1;
	/**
	 * Constant indicating the IMS status code DX
	 */
	public final static short DX = (short) 0xC4E7;
	/**
	 * Constant indicating the IMS status code FA
	 */
	public final static short FA = (short) 0xC6C1;
	/**
	 * Constant indicating the IMS status code FC
	 */
	public final static short FC = (short) 0xC6C3;
	/**
	 * Constant indicating the IMS status code FD
	 */
	public final static short FD = (short) 0xC6C4;
	/**
	 * Constant indicating the IMS status code FE
	 */
	public final static short FE = (short) 0xC6C5;
	/**
	 * Constant indicating the IMS status code FF
	 */
	public final static short FF = (short) 0xC6C6;
	/**
	 * Constant indicating the IMS status code FG
	 */
	public final static short FG = (short) 0xC6C7;
	/**
	 * Constant indicating the IMS status code FH
	 */
	public final static short FH = (short) 0xC6C8;
	/**
	 * Constant indicating the IMS status code FI
	 */
	public final static short FI = (short) 0xC6C9;
	/**
	 * Constant indicating the IMS status code FM
	 */
	public final static short FM = (short) 0xC6D4;
	/**
	 * Constant indicating the IMS status code FN
	 */
	public final static short FN = (short) 0xC6D5;
	/**
	 * Constant indicating the IMS status code FP
	 */
	public final static short FP = (short) 0xC6D7;
	/**
	 * Constant indicating the IMS status code FR
	 */
	public final static short FR = (short) 0xC6D9;
	/**
	 * Constant indicating the IMS status code FS
	 */
	public final static short FS = (short) 0xC6E2;
	/**
	 * Constant indicating the IMS status code FT
	 */
	public final static short FT = (short) 0xC6E3;
	/**
	 * Constant indicating the IMS status code FV
	 */
	public final static short FV = (short) 0xC6E5;
	/**
	 * Constant indicating the IMS status code FW
	 */
	public final static short FW = (short) 0xC6E6;
	/**
	 * Constant indicating the IMS status code FY
	 */
	public final static short FY = (short) 0xC6E8;
	/**
	 * Constant indicating the IMS status code GA
	 */
	public final static short GA = (short) 0xC7C1;
	/**
	 * Constant indicating the IMS status code GB
	 */
	public final static short GB = (short) 0xC7C2;
	/**
	 * Constant indicating the IMS status code GC
	 */
	public final static short GC = (short) 0xC7C3;
	/**
	 * Constant indicating the IMS status code GD
	 */
	public final static short GD = (short) 0xC7C4;
	/**
	 * Constant indicating the IMS status code GE
	 */
	public final static short GE = (short) 0xC7C5;
	/**
	 * Constant indicating the IMS status code GG
	 */
	public final static short GG = (short) 0xC7C7;
	/**
	 * Constant indicating the IMS status code GK
	 */
	public final static short GK = (short) 0xC7D2;
	/**
	 * Constant indicating the IMS status code GL
	 */
	public final static short GL = (short) 0xC7D3;
	/**
	 * Constant indicating the IMS status code GP
	 */
	public final static short GP = (short) 0xC7D7;
	/**
	 * Constant indicating the IMS status code II
	 */
	public final static short II = (short) 0xC9C9;
	/**
	 * Constant indicating the IMS status code IX
	 */
	public final static short IX = (short) 0xC9E7;
	/**
	 * Constant indicating the IMS status code LB
	 */
	public final static short LB = (short) 0xD3C2;
	/**
	 * Constant indicating the IMS status code LC
	 */
	public final static short LC = (short) 0xD3C3;
	/**
	 * Constant indicating the IMS status code LD
	 */
	public final static short LD = (short) 0xD3C4;
	/**
	 * Constant indicating the IMS status code LE
	 */
	public final static short LE = (short) 0xD3C5;
	/**
	 * Constant indicating the IMS status code MR
	 */
	public final static short MR = (short) 0xD4D9;
	/**
	 * Constant indicating the IMS status code NA
	 */
	public final static short NA = (short) 0xD5C1;
	/**
	 * Constant indicating the IMS status code NE
	 */
	public final static short NE = (short) 0xD5C5;
	/**
	 * Constant indicating the IMS status code NI
	 */
	public final static short NI = (short) 0xD5C9;
	/**
	 * Constant indicating the IMS status code NL
	 */
	public final static short NL = (short) 0xD5D3;
	/**
	 * Constant indicating the IMS status code NO
	 */
	public final static short NO = (short) 0xD5D6;
	/**
	 * Constant indicating the IMS status code NU
	 */
	public final static short NU = (short) 0xD5E4;
	/**
	 * Constant indicating the IMS status code QC
	 */
	public final static short QC = (short) 0xD8C3;
	/**
	 * Constant indicating the IMS status code QD
	 */
	public final static short QD = (short) 0xD8C4;
	/**
	 * Constant indicating the IMS status code QE
	 */
	public final static short QE = (short) 0xD8C5;
	/**
	 * Constant indicating the IMS status code QF
	 */
	public final static short QF = (short) 0xD8C6;
	/**
	 * Constant indicating the IMS status code QH
	 */
	public final static short QH = (short) 0xD8C8;
	/**
	 * Constant indicating the IMS status code RA
	 */
	public final static short RA = (short) 0xD9C1;
	/**
	 * Constant indicating the IMS status code RC
	 */
	public final static short RC = (short) 0xD9C3;
	/**
	 * Constant indicating the IMS status code RX
	 */
	public final static short RX = (short) 0xD9E7;
	/**
	 * Constant indicating the IMS status code SA
	 */
	public final static short SA = (short) 0xE2C1;
	/**
	 * Constant indicating the IMS status code SB
	 */
	public final static short SB = (short) 0xE2C2;
	/**
	 * Constant indicating the IMS status code SC
	 */
	public final static short SC = (short) 0xE2C3;
	/**
	 * Constant indicating the IMS status code SY
	 */
	public final static short SY = (short) 0xE2E8;
	/**
	 * Constant indicating the IMS status code TA
	 */
	public final static short TA = (short) 0xE3C1;
	/**
	 * Constant indicating the IMS status code TC
	 */
	public final static short TC = (short) 0xE3C3;
	/**
	 * Constant indicating the IMS status code TE
	 */
	public final static short TE = (short) 0xE3C5;
	/**
	 * Constant indicating the IMS status code TG
	 */
	public final static short TG = (short) 0xE3C7;
	/**
	 * Constant indicating the IMS status code TH
	 */
	public final static short TH = (short) 0xE3C8;
	/**
	 * Constant indicating the IMS status code TI
	 */
	public final static short TI = (short) 0xE3C9;
	/**
	 * Constant indicating the IMS status code TJ
	 */
	public final static short TJ = (short) 0xE3D1;
	/**
	 * Constant indicating the IMS status code TL
	 */
	public final static short TL = (short) 0xE3D3;
	/**
	 * Constant indicating the IMS status code TN
	 */
	public final static short TN = (short) 0xE3D5;
	/**
	 * Constant indicating the IMS status code TO
	 */
	public final static short TO = (short) 0xE3D6;
	/**
	 * Constant indicating the IMS status code TP
	 */
	public final static short TP = (short) 0xE3D7;
	/**
	 * Constant indicating the IMS status code TR
	 */
	public final static short TR = (short) 0xE3D9;
	/**
	 * Constant indicating the IMS status code TY
	 */
	public final static short TY = (short) 0xE3E8;
	/**
	 * Constant indicating the IMS status code TZ
	 */
	public final static short TZ = (short) 0xE3E9;
	/**
	 * Constant indicating the IMS status code UC
	 */
	public final static short UC = (short) 0xE4C3;
	/**
	 * Constant indicating the IMS status code UR
	 */
	public final static short UR = (short) 0xE4D9;
	/**
	 * Constant indicating the IMS status code US
	 */
	public final static short US = (short) 0xE4E2;
	/**
	 * Constant indicating the IMS status code UX
	 */
	public final static short UX = (short) 0xE4E7;
	/**
	 * Constant indicating the IMS status code V1
	 */
	public final static short V1 = (short) 0xE5F1;
	/**
	 * Constant indicating the IMS status code V2
	 */
	public final static short V2 = (short) 0xE5F2;
	/**
	 * Constant indicating the IMS status code V3
	 */
	public final static short V3 = (short) 0xE5F3;
	/**
	 * Constant indicating the IMS status code V4
	 */
	public final static short V4 = (short) 0xE5F4;
	/**
	 * Constant indicating the IMS status code V5
	 */
	public final static short V5 = (short) 0xE5F5;
	/**
	 * Constant indicating the IMS status code V6
	 */
	public final static short V6 = (short) 0xE5F6;
	/**
	 * Constant indicating the IMS status code V7
	 */
	public final static short V7 = (short) 0xE5F7;
	/**
	 * Constant indicating the IMS status code X2
	 */
	public final static short X2 = (short) 0xE7F2;
	/**
	 * Constant indicating the IMS status code X3
	 */
	public final static short X3 = (short) 0xE7F3;
	/**
	 * Constant indicating the IMS status code X4
	 */
	public final static short X4 = (short) 0xE7F4;
	/**
	 * Constant indicating the IMS status code X5
	 */
	public final static short X5 = (short) 0xE7F5;
	/**
	 * Constant indicating the IMS status code X6
	 */
	public final static short X6 = (short) 0xE7F6;
	/**
	 * Constant indicating the IMS status code X7
	 */
	public final static short X7 = (short) 0xE7F7;
	/**
	 * Constant indicating the IMS status code X8
	 */
	public final static short X8 = (short) 0xE7F8;
	/**
	 * Constant indicating the IMS status code XA
	 */
	public final static short XA = (short) 0xE7C1;
	/**
	 * Constant indicating the IMS status code XB
	 */
	public final static short XB = (short) 0xE7C2;
	/**
	 * Constant indicating the IMS status code XC
	 */
	public final static short XC = (short) 0xE7C3;
	/**
	 * Constant indicating the IMS status code XD
	 */
	public final static short XD = (short) 0xE7C4;
	/**
	 * Constant indicating the IMS status code XE
	 */
	public final static short XE = (short) 0xE7C5;
	/**
	 * Constant indicating the IMS status code XF
	 */
	public final static short XF = (short) 0xE7C6;
	/**
	 * Constant indicating the IMS status code XG
	 */
	public final static short XG = (short) 0xE7C7;
	/**
	 * Constant indicating the IMS status code XX
	 */
	public final static short XX = (short) 0xE7E7;
	/**
	 * Constant indicating the IMS status code CALLOKWE
	 */
	public final static short CALLOKWE = (short) 0x100;
	/**
	 * Constant indicating the IMS status code CALLOKWI
	 */
	public final static short CALLOKWI = (short) 0x4;
	/**
	 * Constant indicating the IMS status code STAR1
	 */
	public final static short STAR1 = (short) 0x5CF1;
	/**
	 * Constant indicating the IMS status code STAR2
	 */
	public final static short STAR2 = (short) 0x5CF2;
	/**
	 * Constant indicating the IMS status code STAR3
	 */
	public final static short STAR3 = (short) 0x5CF3;
	/**
	 * Constant indicating the IMS status code STAR4
	 */
	public final static short STAR4 = (short) 0x5CF4;
	/**
	 * Constant indicating the IMS status code STAR5
	 */
	public final static short STAR5 = (short) 0x5CF5;
	/**
	 * Constant indicating the IMS status code STAR6
	 */
	public final static short STAR6 = (short) 0x5CF6;

	/**
	 * Constant indicating the IMS status code A1
	 */
	public final static short AUTH_CLASS_CHNG_DESTINATION = A1;
	/**
	 * Constant indicating the IMS status code A2
	 */
	public final static short CHNG_WITH_INVALID_PCB = A2;
	/**
	 * Constant indicating the IMS status code A3
	 */
	public final static short PCB_DESTINATION = A3;
	/**
	 * Constant indicating the IMS status code A4
	 */
	public final static short CONVERSATIONAL_RESPONSE_SECURITY = A4;
	/**
	 * Constant indicating the IMS status code A5
	 */
	public final static short MODNAME_SUBSEQUENT_MESSAGE = A5;
	/**
	 * Constant indicating the IMS status code A6
	 */
	public final static short MESSAGE_SEGMENT_SIZE_EXCEEDED = A6;
	/**
	 * Constant indicating the IMS status code A7
	 */
	public final static short NUMBER_OF_OUTPUT_SEGMENTS_EXCEEDED = A7;
	/**
	 * Constant indicating the IMS status code A8
	 */
	public final static short INSERT_TO_IOPCB_AND_ALTERNATE_PCB = A8;
	/**
	 * Constant indicating the IMS status code A9
	 */
	public final static short ALTERNATE_PCB_PHYSICAL_TERMINAL = A9;
	/**
	 * Constant indicating the IMS status code AA
	 */
	public final static short ALTERNATE_RESPONSE_DESTINATION = AA;
	/**
	 * Constant indicating the IMS status code AB
	 */
	public final static short MISSING_IO_AREA = AB;
	/**
	 * Constant indicating the IMS status code AC
	 */
	public final static short SSA_HIERARCHIC_ERROR = AC;
	/**
	 * Constant indicating the IMS status code AD
	 */
	public final static short INVALID_FUNCTION_FOR_PCB = AD;
	/**
	 * Constant indicating the IMS status code AF
	 */
	public final static short GSAM_INVALID_RECORD_LENGTH = AF;
	/**
	 * Constant indicating the IMS status code AG
	 */
	public final static short INQY_IO_LENGTH = AG;
	/**
	 * Constant indicating the IMS status code AH
	 */
	public final static short REQUIRED_SSA_MISSING = AH;
	/**
	 * Constant indicating the IMS status code AI
	 */
	public final static short DATA_MANAGEMENT_OPEN_ERROR = AI;
	/**
	 * Constant indicating the IMS status code AJ
	 */
	public final static short INVALID_SSA_OR_PARAMETER = AJ;
	/**
	 * Constant indicating the IMS status code AK
	 */
	public final static short SSA_FIELDNAME_ERROR = AK;
	/**
	 * Constant indicating the IMS status code AL
	 */
	public final static short IOPCB_IN_BATCH = AL;
	/**
	 * Constant indicating the IMS status code AM
	 */
	public final static short INCOMPATIBLE_CALL_FUNCTION = AM;
	/**
	 * Constant indicating the IMS status code AO
	 */
	public final static short PHYSICAL_IO_ERROR = AO;
	/**
	 * Constant indicating the IMS status code AP
	 */
	public final static short PARAMETER_LIMIT = AP;
	/**
	 * Constant indicating the IMS status code AQ
	 */
	public final static short INVALID_SUB_FUNCTION = AQ;
	/**
	 * Constant indicating the IMS status code AR
	 */
	public final static short OPTIONS_LIST_ERROR = AR;
	/**
	 * Constant indicating the IMS status code AS
	 */
	public final static short IAFP_ERROR = AS;
	/**
	 * Constant indicating the IMS status code AT
	 */
	public final static short IO_AREA_LENGTH = AT;
	/**
	 * Constant indicating the IMS status code AU
	 */
	public final static short SSA_TOTAL_LENGTH = AU;
	/**
	 * Constant indicating the IMS status code AX
	 */
	public final static short SYSTEM_ERROR = AX;
	/**
	 * Constant indicating the IMS status code AY
	 */
	public final static short MULTIPLE_PHYSICAL_TERMINAL = AY;
	/**
	 * Constant indicating the IMS status code AZ
	 */
	public final static short PURG_IGNORED = AZ;
	/**
	 * Constant indicating the IMS status code BA
	 */
	public final static short UNAVAILABLE_DATA = BA;
	/**
	 * Constant indicating the IMS status code BB
	 */
	public final static short UNAVAILABLE_DATA_WITH_BACKOUT = BB;
	/**
	 * Constant indicating the IMS status code BC
	 */
	public final static short DEADLOCK_WITH_BACKOUT = BC;
	/**
	 * Constant indicating the IMS status code BJ
	 */
	public final static short ALL_DATABASES_UNAVAILABLE = BJ;
	/**
	 * Constant indicating the IMS status code BK
	 */
	public final static short DATABASE_IN_PCB_UNAVAILABLE = BK;
	/**
	 * Constant indicating the IMS status code CA
	 */
	public final static short INVALID_COMMAND = CA;
	/**
	 * Constant indicating the IMS status code CB
	 */
	public final static short AOI_COMMAND = CB;
	/**
	 * Constant indicating the IMS status code CC
	 */
	public final static short COMMAND_RESPONSE_RETURNED = CC;
	/**
	 * Constant indicating the IMS status code CD
	 */
	public final static short COMMAND_SECURITY = CD;
	/**
	 * Constant indicating the IMS status code CE
	 */
	public final static short MESSAGE_RESCHEDULED = CE;
	/**
	 * Constant indicating the IMS status code CF
	 */
	public final static short MESSAGE_QUEUED_PRIOR_TO_LAST_START = CF;
	/**
	 * Constant indicating the IMS status code CG
	 */
	public final static short MESSAGE_ORIGINATED_FROM_AOI_EXIT = CG;
	/**
	 * Constant indicating the IMS status code CH
	 */
	public final static short AOI_COMMAND_IGNORED = CH;
	/**
	 * Constant indicating the IMS status code CI
	 */
	public final static short MESSAGE_QUEUED_PRIOR_RESCHEDULED = CI;
	/**
	 * Constant indicating the IMS status code CJ
	 */
	public final static short MESSAGE_FROM_AOI_EXIT_RESCHEDULED = CJ;
	/**
	 * Constant indicating the IMS status code CK
	 */
	public final static short MESSAGE_QUEUED_PRIOR_FROM_AOI_EXIT = CK;
	/**
	 * Constant indicating the IMS status code CL
	 */
	public final static short AOI_EXIT_MESSAGE_QUEUED_PRIOR_RESCHEDULED = CL;
	/**
	 * Constant indicating the IMS status code CM
	 */
	public final static short WKAP_INSUFFICIENT = CM;
	/**
	 * Constant indicating the IMS status code CN
	 */
	public final static short IOASIZE_TOO_SMALL = CN;
	/**
	 * Constant indicating the IMS status code DA
	 */
	public final static short KEY_MODIFICATION = DA;
	/**
	 * Constant indicating the IMS status code DJ
	 */
	public final static short SEGMENT_NOT_HELD = DJ;
	/**
	 * Constant indicating the IMS status code DX
	 */
	public final static short SEGMENT_DELETE_RULE = DX;
	/**
	 * Constant indicating the IMS status code FA
	 */
	public final static short DATABASE_ARITHMETIC_OVERFLOW = FA;
	/**
	 * Constant indicating the IMS status code FC
	 */
	public final static short INVALID_REQUEST_FOR_SEGMENT = FC;
	/**
	 * Constant indicating the IMS status code FD
	 */
	public final static short BMP_DEADLOCK = FD;
	/**
	 * Constant indicating the IMS status code FE
	 */
	public final static short FLD_CALL = FE;
	/**
	 * Constant indicating the IMS status code FF
	 */
	public final static short MSDB_FREE_SPACE = FF;
	/**
	 * Constant indicating the IMS status code FG
	 */
	public final static short FLD_CALL_BUFFER_SPACE = FG;
	/**
	 * Constant indicating the IMS status code FH
	 */
	public final static short DEDB_AREA_INACCESSIBLE = FH;
	/**
	 * Constant indicating the IMS status code FI
	 */
	public final static short IO_AREA_INACCESSIBLE = FI;
	/**
	 * Constant indicating the IMS status code FM
	 */
	public final static short RANDOMIZING_ROUTINE_REQUEST = FM;
	/**
	 * Constant indicating the IMS status code FN
	 */
	public final static short FLD_FIELD_NAME = FN;
	/**
	 * Constant indicating the IMS status code FP
	 */
	public final static short INVALID_HEXADECIMAL_OR_DECIMAL_DATA = FP;
	/**
	 * Constant indicating the IMS status code FR
	 */
	public final static short TOTAL_BUFFER_ALLOCATION_EXCEEDED = FR;
	/**
	 * Constant indicating the IMS status code FS
	 */
	public final static short DEDB_AREAS_FULL = FS;
	/**
	 * Constant indicating the IMS status code FT
	 */
	public final static short SSA_LIMIT_EXCEEDED = FT;
	/**
	 * Constant indicating the IMS status code FV
	 */
	public final static short VERIFY_OPERATION = FV;
	/**
	 * Constant indicating the IMS status code FW
	 */
	public final static short BMP_BUFFER_SPACE = FW;
	/**
	 * Constant indicating the IMS status code FY
	 */
	public final static short BACKWARD_ACCESS_VIOLATION = FY;
	/**
	 * Constant indicating the IMS status code GA
	 */
	public final static short HIERARCHIC_BOUNDARY = GA;
	/**
	 * Constant indicating the IMS status code GB
	 */
	public final static short END_OF_DATA = GB;
	/**
	 * Constant indicating the IMS status code GC
	 */
	public final static short CROSSING_UOW_BOUNDARY = GC;
	/**
	 * Constant indicating the IMS status code GD
	 */
	public final static short UNQUALIFIED_INSERT = GD;
	/**
	 * Constant indicating the IMS status code GE
	 */
	public final static short SEGMENT_NOT_FOUND = GE;
	/**
	 * Constant indicating the IMS status code GG
	 */
	public final static short INVALID_SEGMENT_POINTER = GG;
	/**
	 * Constant indicating the IMS status code GK
	 */
	public final static short DIFFERENT_SEGMENT_TYPE = GK;
	/**
	 * Constant indicating the IMS status code GL
	 */
	public final static short INVALID_LOG_CODE = GL;
	/**
	 * Constant indicating the IMS status code GP
	 */
	public final static short PARENTAGE_NOT_ESTABLISHED = GP;
	/**
	 * Constant indicating the IMS status code II
	 */
	public final static short DUPLICATE_SEGMENT = II;
	/**
	 * Constant indicating the IMS status code IX
	 */
	public final static short SEGMENT_INSERT_RULE = IX;
	/**
	 * Constant indicating the IMS status code LB
	 */
	public final static short DUPLICATE_SEGMENT_LOAD = LB;
	/**
	 * Constant indicating the IMS status code LC
	 */
	public final static short KEY_SEQUENCE = LC;
	/**
	 * Constant indicating the IMS status code LD
	 */
	public final static short PARENT_NOT_LOADED = LD;
	/**
	 * Constant indicating the IMS status code LE
	 */
	public final static short SIBLING_SEQUENCE = LE;
	/**
	 * Constant indicating the IMS status code MR
	 */
	public final static short RESERVED = MR;
	/**
	 * Constant indicating the IMS status code NA
	 */
	public final static short DATABASE_UNAVAILABLE = NA;
	/**
	 * Constant indicating the IMS status code NE
	 */
	public final static short SEGMENT_NOT_FOUND_BY_INDEX_MAINTENACE = NE;
	/**
	 * Constant indicating the IMS status code NI
	 */
	public final static short DUPLICATE_SEGMENT_SECONDARY_INDEX = NI;
	/**
	 * Constant indicating the IMS status code NL
	 */
	public final static short LOG_DATASET_DD_MISSING = NL;
	/**
	 * Constant indicating the IMS status code NO
	 */
	public final static short INDEX_MAINTENANCE_IO_ERROR = NO;
	/**
	 * Constant indicating the IMS status code NU
	 */
	public final static short DATABASE_UNAVAILABLE_FOR_UPDATE = NU;
	/**
	 * Constant indicating the IMS status code QD
	 */
	public final static short END_OF_MESSAGES = QC;
	/**
	 * Constant indicating the IMS status code QD
	 */
	public final static short END_OF_MESSAGE_SEGMENTS = QD;
	/**
	 * Constant indicating the IMS status code QE
	 */
	public final static short CALL_SEQUENCE = QE;
	/**
	 * Constant indicating the IMS status code QF
	 */
	public final static short SEGMENT_LENGTH = QF;
	/**
	 * Constant indicating the IMS status code QH
	 */
	public final static short TERMINAL_SYMBOLIC_ERROR = QH;
	/**
	 * Constant indicating the IMS status code RA
	 */
	public final static short UNMATCHED_TOKEN = RA;
	/**
	 * Constant indicating the IMS status code RC
	 */
	public final static short ROLS_UNSUPPORTED_PCB = RC;
	/**
	 * Constant indicating the IMS status code RX
	 */
	public final static short SEGMENT_REPLACE_RULE = RX;
	/**
	 * Constant indicating the IMS status code SA
	 */
	public final static short SETS_REQUEST_STORAGE_EXCEEDED = SA;
	/**
	 * Constant indicating the IMS status code SB
	 */
	public final static short SETS_LEVELS_EXCEEDED = SB;
	/**
	 * Constant indicating the IMS status code SC
	 */
	public final static short SETS_UNSUPPORTED_PCB = SC;
	/**
	 * Constant indicating the IMS status code SY
	 */
	public final static short SYNC_FAILURE = SY;
	/**
	 * Constant indicating the IMS status code TA
	 */
	public final static short PSB_DIRECTORY = TA;
	/**
	 * Constant indicating the IMS status code TC
	 */
	public final static short PSB_ALREADY_SCHEDULED = TC;
	/**
	 * Constant indicating the IMS status code TG
	 */
	public final static short PSB_INITIALIZATION_ERROR = TE;
	/**
	 * Constant indicating the IMS status code TG
	 */
	public final static short TERMINATE_UNSCHEDULED_PSB = TG;
	/**
	 * Constant indicating the IMS status code TH
	 */
	public final static short DATABASE_ACCESS_WITH_UNSCHEDULED_PSB = TH;
	/**
	 * Constant indicating the IMS status code TI
	 */
	public final static short INVALID_PATH_TO_SEGMENT = TI;
	/**
	 * Constant indicating the IMS status code TJ
	 */
	public final static short DLI_NOT_ACTIVE = TJ;
	/**
	 * Constant indicating the IMS status code TL
	 */
	public final static short SCHEDULING_INTENT_CONFLICT = TL;
	/**
	 * Constant indicating the IMS status code TN
	 */
	public final static short INVALID_SDIB = TN;
	/**
	 * Constant indicating the IMS status code TO
	 */
	public final static short PATH_REPLACE_ERROR = TO;
	/**
	 * Constant indicating the IMS status code TP
	 */
	public final static short INVALID_PCB_NUMBER_OR_PROC_OPTIONS = TP;
	/**
	 * Constant indicating the IMS status code TR
	 */
	public final static short XDLIPRE = TR;
	/**
	 * Constant indicating the IMS status code TY
	 */
	public final static short DATABASE_NOT_OPEN = TY;
	/**
	 * Constant indicating the IMS status code TZ
	 */
	public final static short SEGMENT_EXCEEDS_64K = TZ;
	/**
	 * Constant indicating the IMS status code UC
	 */
	public final static short CHECKPOINT_WRITTEN_TO_UCF = UC;
	/**
	 * Constant indicating the IMS status code UR
	 */
	public final static short PROGRAM_RESTARTED_UNDER_UCF = UR;
	/**
	 * Constant indicating the IMS status code US
	 */
	public final static short UCF_STOP = US;
	/**
	 * Constant indicating the IMS status code UX
	 */
	public final static short CHECKPOINT_AND_STOP = UX;
	/**
	 * Constant indicating the IMS status code V1
	 */
	public final static short VARIABLE_SEGMENT_LENGTH = V1;
	/**
	 * Constant indicating the IMS status code V2
	 */
	public final static short INVALID_SEGMENT_LENGTH = V2;
	/**
	 * Constant indicating the IMS status code V3
	 */
	public final static short INVALID_FIELD_LENGTH = V3;
	/**
	 * Constant indicating the IMS status code V4
	 */
	public final static short INVALID_VARIABLE_SEGMENTLENGTH = V4;
	/**
	 * Constant indicating the IMS status code V5
	 */
	public final static short INVALID_OFFSET = V5;
	/**
	 * Constant indicating the IMS status code V6
	 */
	public final static short INVALID_CONCATENATED_KEY_LENGTH = V6;
	/**
	 * Constant indicating the IMS status code V7
	 */
	public final static short INVALID_STATISTICS_AREA_LENGTH = V7;
	/**
	 * Constant indicating the IMS status code X2
	 */
	public final static short FIRST_INSERT_TO_ALTERNATE_PCB_NOT_SPA = X2;
	/**
	 * Constant indicating the IMS status code X3
	 */
	public final static short INVALID_SPA = X3;
	/**
	 * Constant indicating the IMS status code X4
	 */
	public final static short INVALID_SPA_DESTINATION = X4;
	/**
	 * Constant indicating the IMS status code X5
	 */
	public final static short MULTIPLE_SPAS_PERMESSAGE = X5;
	/**
	 * Constant indicating the IMS status code X6
	 */
	public final static short INVALID_SPA_TRANSACTION_CODE = X6;
	/**
	 * Constant indicating the IMS status code X7
	 */
	public final static short INVALID_SPA_LENGTH = X7;
	/**
	 * Constant indicating the IMS status code X8
	 */
	public final static short SPA_IO_ERROR = X8;
	/**
	 * Constant indicating the IMS status code XA
	 */
	public final static short INVALID_SPA_PASS = XA;
	/**
	 * Constant indicating the IMS status code XB
	 */
	public final static short INVALID_SPA_RESPOND = XB;
	/**
	 * Constant indicating the IMS status code XC
	 */
	public final static short INVALID_Z1_FIELD = XC;
	/**
	 * Constant indicating the IMS status code XD
	 */
	public final static short IMS_TERMINATING = XD;
	/**
	 * Constant indicating the IMS status code XE
	 */
	public final static short INSERT_SPA_TO_EXPRESS_PCB = XE;
	/**
	 * Constant indicating the IMS status code XF
	 */
	public final static short INSERT_TO_SPA_NOT_ALTRESP = XF;
	/**
	 * Constant indicating the IMS status code XG
	 */
	public final static short FIXED_LENGTH_SPA_ERROR = XG;
	/**
	 * Constant indicating the IMS status code XX
	 */
	public final static short GSAM_ERROR = XX;

}
