package com.ibm.ims.dli;

import java.util.Vector;

/**
 * Object that represents the output from an Initialize (INIT) call.
 * 
 */
public interface INITCallResult extends DLICallResult {
	/**
	 * Retrieves a collection of one or more database PCB (DB PCB) objects. You
	 * can process each DB PCB object to determine its status code.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_initcalltm.htm"
	 * target="_blank">INIT call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the collection of <code>DBPCB</code> objects that represent all
	 *         the database PCBs in the PSB.
	 * @throws DLIException
	 *             if unable to retrieve the DB PCB information
	 */
	public Vector<DBPCB> getDBPCBs() throws DLIException;
}
