package com.ibm.ims.dli;

import java.util.Vector;

/**
 * Object that represents the output from an Inquiry (INQY) call.
 * <p>
 * For more details about the values returned by the <code>INQYCallResult</code>
 * methods, see the topic <a href=
 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_inqycall.htm"
 * target="_blank">INQY call</a> in the IMS Application Programming APIs
 * reference documentation.
 * 
 */
public interface INQYCallResult extends DLICallResult {

	/**
	 * Retrieves the <code>DBPCB</code> objects corresponding to all the
	 * database PCBs in the PSB.
	 * 
	 * @return the <code>DBPCB</code> objects.
	 * @throws DLIException
	 *             if unable to get the DB PCB information
	 */
	public Vector<DBPCB> getDBPCBs() throws DLIException;

	/**
	 * Retrieves the <code>IOPCB</code> object corresponding to the IMS IOPCB.
	 * 
	 * @return the <code>IOPCB</code> object.
	 */
	public IOPCB getIOPCB();

	/**
	 * Retrieves the subfunction code used in the INQY call.
	 * 
	 * @return the subfunction code.
	 */
	public String getSubfunction();

	/**
	 * Retrieves information regarding the current execution environment, after
	 * an INQY call is issued with the ENVIRON subfunction.
	 * 
	 * @return the <code>EnvironInfo</code> object containing the call output.
	 * @throws DLIException
	 *             if EBCDIC encoding (Cp1047) is not supported
	 * @see EnvironInfo
	 */
	public EnvironInfo getEnvironInfo() throws DLIException;

	// public void setPSB(PSBImpl psb);

	/**
	 * Retrieves information regarding the current input message, after an INQY
	 * call is issued with the MSGINFO subfunction.
	 * 
	 * @return the <code>MessageInfo</code> object containing the call output.
	 * @throws DLIException
	 *             if EBCDIC encoding (Cp1047) is not supported
	 * @see MessageInfo
	 */
	public MessageInfo getMessageInfo() throws DLIException;

	/**
	 * Retrieves the application program name, after an INQY call is issued with
	 * the PROGRAM subfunction.
	 * 
	 * @return the application program name.
	 * @throws DLIException
	 *             if EBCDIC encoding (Cp1047) is not supported
	 */
	public String getProgramName() throws DLIException;
}
