package com.ibm.ims.dli;

/**
 * Object that represents the output from a Retrieve Command (RCMD) call.
 *
 */
public interface RCMDCallResult extends DLICallResult {
	/**
	 * Retrieves the second and subsequent command response segments after an
	 * Issue Command (ICMD) call is issued.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_rcmdcall.htm"
	 * target="_blank">RCMD call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the response segments.
	 */
	public String getResponseSegment();
}
