package com.ibm.ims.dli.converters;

import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

/**
 * The <code>StringTypeConverter</code> interface is a converter for the Java
 * String data type.
 */
public interface StringTypeConverter {

	/**
	 * Retrieves the designated string value from the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param length
	 *            The number of bytes that will be read from the input/output
	 *            byte array
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the string value associated to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a string
	 */
	public String getString(byte[] ioArea, int start, int length, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated string value into the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param length
	 *            The number of bytes that will be written in the input/output
	 *            byte array
	 * @param object
	 *            The value of the string
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the string value could not be converted to bytes
	 */
	public void setString(byte[] ioArea, int start, int length, String object, Collection<String> warningStrings)
			throws ConversionException;
}
