package com.ibm.ims.dli.converters;

import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

public interface UIntegerTypeConverter {

	/**
	 * Retrieves the designated unsigned integer value from the input/output
	 * byte array as a long.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the long value representing the unsigned integer value associated
	 *         to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a long
	 */
	public Long getLongFromUInteger(byte[] ioArea, int start, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated signed integer value into the input/output byte array
	 * as an unsigned integer.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the integer
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the integer value could not be converted to bytes or if
	 *                there are data integrity issues
	 */
	public void setUInteger(byte[] ioArea, int start, Integer object, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated signed long value into the input/output byte array as
	 * an unsigned integer.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the long
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the integer value could not be converted to bytes or if
	 *                there are data integrity issues
	 */
	public void setUInteger(byte[] ioArea, int start, Long object, Collection<String> warningStrings)
			throws ConversionException;
}
