package com.ibm.ims.dli.converters;

import java.math.BigInteger;
import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

public interface ULongTypeConverter {

	/**
	 * Retrieves the designated unsigned long value from the input/output byte
	 * array as a BigInteger.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the BigInteger value representing the unsigned long value
	 *         associated to the bytes in the input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a BigInteger
	 */
	public BigInteger getBigIntegerFromULong(byte[] ioArea, int start, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated signed long value into the input/output byte array as
	 * an unsigned long.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the long
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the long value could not be converted to bytes or if
	 *                there are data integrity issues
	 */
	public void setULong(byte[] ioArea, int start, Long object, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated BigInteger value into the input/output byte array as
	 * an unsigned long.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param object
	 *            The value of the BigInteger
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the long value could not be converted to bytes or if
	 *                there are data integrity issues
	 */
	public void setULong(byte[] ioArea, int start, BigInteger object, Collection<String> warningStrings)
			throws ConversionException;
}
