package com.ibm.ims.dli.converters;

import java.math.BigDecimal;
import java.util.Collection;

import com.ibm.ims.dli.types.ConversionException;

/**
 * The <code>ZonedDecimalTypeConverter</code> interface is a converter for the
 * Java BigDecimal data type.
 *
 */
public interface ZonedDecimalTypeConverter {

	/**
	 * Retrieves the designated zoned decimal value from the input/output byte
	 * array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be read from
	 * @param start
	 *            The starting offset in the input/output byte array to read
	 *            from
	 * @param length
	 *            The number of bytes that will be read from the input/output
	 *            byte array
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @return the zoned decimal value associated to the bytes in the
	 *         input/output area
	 * @exception ConversionException
	 *                if the bytes could not be converted to a zoned decimal
	 */
	public BigDecimal getBigDecimal(byte[] ioArea, int start, int length, Collection<String> warningStrings)
			throws ConversionException;

	/**
	 * Sets the designated zoned decimal value into the input/output byte array.
	 * 
	 * @param ioArea
	 *            The input/output byte array to be written to
	 * @param start
	 *            The starting offset in the input/output byte array to write to
	 * @param length
	 *            The number of bytes that will be written in the input/output
	 *            byte array
	 * @param object
	 *            The value of the zoned decimal
	 * @param warningStrings
	 *            The associated warnings for the conversion
	 * 
	 * @exception ConversionException
	 *                if the zoned decimal value could not be converted to bytes
	 */
	public void setBigDecimal(byte[] ioArea, int start, int length, BigDecimal object,
			Collection<String> warningStrings) throws ConversionException;
}
