package com.ibm.ims.dli.tm;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.ibm.ims.opendb.BuildNumberForJDRRA;

/**
 * This class implements the factory pattern to create <code>Application</code> objects.
 * <p>The following code example shows how to create an instance of <code>Application</code>:
 * <blockquote>
 * <pre>
 *    Application app = ApplicationFactory.createApplication();
 * </pre>
 * </blockquote>
 * 
 * @see Application
 * @see Application#getTransaction()
 * @see Application#getMessageQueue()
 * @see Application#getIOMessage(String)
 */
public class ApplicationFactory {

	private static final Logger logger = Logger.getLogger("com.ibm.ims.db.opendb.dli.tm");
	
	private static AtomicBoolean alreadyLogged = new AtomicBoolean(false);

	/**
	 * Creates an <code>Application</code> object.
	 * 
	 * @return the <code>Application</code> object
	 */
	public static Application createApplication() {
		if (logger.isLoggable(Level.FINER)) {
			logger.entering("ApplicationFactory", "createApplication()");
		}

        if (alreadyLogged.compareAndSet(false, true)){
            Object[] inserts = {BuildNumberForJDRRA.BUILD_NUMBER};
            logger.info(TMErrorMessages.getIMSBundle().getString("LOG_BUILD_NUMBER", inserts));
        }

        // Add environment detection here... if not IMS then throw exception
		
		Application app = new ApplicationImpl();

		if (logger.isLoggable(Level.FINER)) {
			logger.exiting("ApplicationFactory", "createApplication()");
		}
		
		return app;
	}
}
