package com.ibm.ims.dli.tm;

/* (c) Copyright International Business Machines Corporation 2010. All rights reserved. */

/**
 * This class defines constants for the IMS status codes. It is a helper class 
 * for comparing status codes from DLI calls.
 *
 */
public interface StatusCodes {
    public final static short BLANKS = (short)0x4040;

    public final static short A1   = (short)0xC1F1;
    public final static short A2   = (short)0xC1F2;
    public final static short A3   = (short)0xC1F3;
    public final static short A4   = (short)0xC1F4;
    public final static short A5   = (short)0xC1F5;
    public final static short A6   = (short)0xC1F6;
    public final static short A7   = (short)0xC1F7;
    public final static short A8   = (short)0xC1F8;
    public final static short A9   = (short)0xC1F9;
    public final static short AA   = (short)0xC1C1;
    public final static short AB   = (short)0xC1C2;
    public final static short AC   = (short)0xC1C3;
    public final static short AD   = (short)0xC1C4;
    public final static short AF   = (short)0xC1C6;
    public final static short AG   = (short)0xC1C7;
    public final static short AH   = (short)0xC1C8;
    public final static short AI   = (short)0xC1C9;
    public final static short AJ   = (short)0xC1D1;
    public final static short AK   = (short)0xC1D2;
    public final static short AL   = (short)0xC1D3;
    public final static short AM   = (short)0xC1D4;
    public final static short AO   = (short)0xC1D6;
    public final static short AP   = (short)0xC1D7;
    public final static short AQ   = (short)0xC1D8;
    public final static short AR   = (short)0xC1D9;
    public final static short AS   = (short)0xC1E2;
    public final static short AT   = (short)0xC1E3;
    public final static short AU   = (short)0xC1E4;
    public final static short AX   = (short)0xC1E7;
    public final static short AY   = (short)0xC1E8;
    public final static short AZ   = (short)0xC1E9;
    public final static short BA   = (short)0xC2C1;
    public final static short BB   = (short)0xC2C2;
    public final static short BC   = (short)0xC2C3;
    public final static short BJ   = (short)0xC2D1;
    public final static short BK   = (short)0xC2D2;
    public final static short CA   = (short)0xC3C1;
    public final static short CB   = (short)0xC3C2;
    public final static short CC   = (short)0xC3C3;
    public final static short CD   = (short)0xC3C4;
    public final static short CE   = (short)0xC3C5;
    public final static short CF   = (short)0xC3C6;
    public final static short CG   = (short)0xC3C7;
    public final static short CH   = (short)0xC3C8;
    public final static short CI   = (short)0xC3C9;
    public final static short CJ   = (short)0xC3D1;
    public final static short CK   = (short)0xC3D2;
    public final static short CL   = (short)0xC3D3;
    public final static short CM   = (short)0xC3D4;
    public final static short CN   = (short)0xC3D5;
    public final static short DA   = (short)0xC4C1;
    public final static short DJ   = (short)0xC4D1;
    public final static short DX   = (short)0xC4E7;
    public final static short FA   = (short)0xC6C1;
    public final static short FC   = (short)0xC6C3;
    public final static short FD   = (short)0xC6C4;
    public final static short FE   = (short)0xC6C5;
    public final static short FF   = (short)0xC6C6;
    public final static short FG   = (short)0xC6C7;
    public final static short FH   = (short)0xC6C8;
    public final static short FI   = (short)0xC6C9;
    public final static short FM   = (short)0xC6D4;
    public final static short FN   = (short)0xC6D5;
    public final static short FP   = (short)0xC6D7;
    public final static short FR   = (short)0xC6D9;
    public final static short FS   = (short)0xC6E2;
    public final static short FT   = (short)0xC6E3;
    public final static short FV   = (short)0xC6E5;
    public final static short FW   = (short)0xC6E6;
    public final static short FY   = (short)0xC6E8;
    public final static short GA   = (short)0xC7C1;
    public final static short GB   = (short)0xC7C2;
    public final static short GC   = (short)0xC7C3;
    public final static short GD   = (short)0xC7C4;
    public final static short GE   = (short)0xC7C5;
    public final static short GG   = (short)0xC7C7;
    public final static short GK   = (short)0xC7D2;
    public final static short GL   = (short)0xC7D3;
    public final static short GP   = (short)0xC7D7;
    public final static short II   = (short)0xC9C9;
    public final static short IX   = (short)0xC9E7;
    public final static short LB   = (short)0xD3C2;
    public final static short LC   = (short)0xD3C3;
    public final static short LD   = (short)0xD3C4;
    public final static short LE   = (short)0xD3C5;
    public final static short MR   = (short)0xD4D9;
    public final static short NA   = (short)0xD5C1;
    public final static short NE   = (short)0xD5C5;
    public final static short NI   = (short)0xD5C9;
    public final static short NL   = (short)0xD5D3;
    public final static short NO   = (short)0xD5D6;
    public final static short NU   = (short)0xD5E4;
    public final static short QC   = (short)0xD8C3;
    public final static short QD   = (short)0xD8C4;
    public final static short QE   = (short)0xD8C5;
    public final static short QF   = (short)0xD8C6;
    public final static short QH   = (short)0xD8C8;
    public final static short RA   = (short)0xD9C1;
    public final static short RC   = (short)0xD9C3;
    public final static short RX   = (short)0xD9E7;
    public final static short SA   = (short)0xE2C1;
    public final static short SB   = (short)0xE2C2;
    public final static short SC   = (short)0xE2C3;
    public final static short SY   = (short)0xE2E8;
    public final static short TA   = (short)0xE3C1;
    public final static short TC   = (short)0xE3C3;
    public final static short TE   = (short)0xE3C5;
    public final static short TG   = (short)0xE3C7;
    public final static short TH   = (short)0xE3C8;
    public final static short TI   = (short)0xE3C9;
    public final static short TJ   = (short)0xE3D1;
    public final static short TL   = (short)0xE3D3;
    public final static short TN   = (short)0xE3D5;
    public final static short TO   = (short)0xE3D6;
    public final static short TP   = (short)0xE3D7;
    public final static short TR   = (short)0xE3D9;
    public final static short TY   = (short)0xE3E8;
    public final static short TZ   = (short)0xE3E9;
    public final static short UC   = (short)0xE4C3;
    public final static short UR   = (short)0xE4D9;
    public final static short US   = (short)0xE4E2;
    public final static short UX   = (short)0xE4E7;
    public final static short V1   = (short)0xE5F1;
    public final static short V2   = (short)0xE5F2;
    public final static short V3   = (short)0xE5F3;
    public final static short V4   = (short)0xE5F4;
    public final static short V5   = (short)0xE5F5;
    public final static short V6   = (short)0xE5F6;
    public final static short V7   = (short)0xE5F7;
    public final static short X2   = (short)0xE7F2;
    public final static short X3   = (short)0xE7F3;
    public final static short X4   = (short)0xE7F4;
    public final static short X5   = (short)0xE7F5;
    public final static short X6   = (short)0xE7F6;
    public final static short X7   = (short)0xE7F7;
    public final static short X8   = (short)0xE7F8;
    public final static short XA   = (short)0xE7C1;
    public final static short XB   = (short)0xE7C2;
    public final static short XC   = (short)0xE7C3;
    public final static short XD   = (short)0xE7C4;
    public final static short XE   = (short)0xE7C5;
    public final static short XF   = (short)0xE7C6;
    public final static short XG   = (short)0xE7C7;
    public final static short XX   = (short)0xE7E7;
    public final static short JNI1 = (short)0x5CF1;
    public final static short JNI2 = (short)0x5CF2;
    public final static short JNI3 = (short)0x5CF3;
    public final static short JNI4 = (short)0x5CF4;
    public final static short JNI5 = (short)0x5CF5;

    public final static short AUTH_CLASS_CHNG_DESTINATION           = A1;
    public final static short CHNG_WITH_INVALID_PCB                 = A2;
    public final static short PCB_DESTINATION                       = A3;
    public final static short CONVERSATIONAL_RESPONSE_SECURITY      = A4;
    public final static short MODNAME_SUBSEQUENT_MESSAGE            = A5;
    public final static short MESSAGE_SEGMENT_SIZE_EXCEEDED         = A6;
    public final static short NUMBER_OF_OUTPUT_SEGMENTS_EXCEEDED    = A7;
    public final static short INSERT_TO_IOPCB_AND_ALTERNATE_PCB     = A8;
    public final static short ALTERNATE_PCB_PHYSICAL_TERMINAL       = A9;
    public final static short ALTERNATE_RESPONSE_DESTINATION        = AA;
    public final static short MISSING_IO_AREA                       = AB;
    public final static short SSA_HIERARCHIC_ERROR                  = AC;
    public final static short INVALID_FUNCTION_FOR_PCB              = AD;
    public final static short GSAM_INVALID_RECORD_LENGTH            = AF;
    public final static short INQY_IO_LENGTH                        = AG;
    public final static short REQUIRED_SSA_MISSING                  = AH;
    public final static short DATA_MANAGEMENT_OPEN_ERROR            = AI;
    public final static short INVALID_SSA_OR_PARAMETER              = AJ;
    public final static short SSA_FIELDNAME_ERROR                   = AK;
    public final static short IOPCB_IN_BATCH                        = AL;
    public final static short INCOMPATIBLE_CALL_FUNCTION            = AM;
    public final static short PHYSICAL_IO_ERROR                     = AO;
    public final static short PARAMETER_LIMIT                       = AP;
    public final static short INVALID_SUB_FUNCTION                  = AQ;
    public final static short OPTIONS_LIST_ERROR                    = AR;
    public final static short IAFP_ERROR                            = AS;
    public final static short IO_AREA_LENGTH                        = AT;
    public final static short SSA_TOTAL_LENGTH                      = AU;
    public final static short SYSTEM_ERROR                          = AX;
    public final static short MULTIPLE_PHYSICAL_TERMINAL            = AY;
    public final static short PURG_IGNORED                          = AZ;
    public final static short UNAVAILABLE_DATA                      = BA;
    public final static short UNAVAILABLE_DATA_WITH_BACKOUT         = BB;
    public final static short DEADLOCK_WITH_BACKOUT                 = BC;
    public final static short ALL_DATABASES_UNAVAILABLE             = BJ;
    public final static short DATABASE_IN_PCB_UNAVAILABLE           = BK;
    public final static short INVALID_COMMAND                       = CA;
    public final static short AOI_COMMAND                           = CB;
    public final static short COMMAND_RESPONSE_RETURNED             = CC;
    public final static short COMMAND_SECURITY                      = CD;
    public final static short MESSAGE_RESCHEDULED                   = CE;
    public final static short MESSAGE_QUEUED_PRIOR_TO_LAST_START    = CF;
    public final static short MESSAGE_ORIGINATED_FROM_AOI_EXIT      = CG;
    public final static short AOI_COMMAND_IGNORED                   = CH;
    public final static short MESSAGE_QUEUED_PRIOR_RESCHEDULED      = CI;
    public final static short MESSAGE_FROM_AOI_EXIT_RESCHEDULED     = CJ;
    public final static short MESSAGE_QUEUED_PRIOR_FROM_AOI_EXIT    = CK;
    public final static short AOI_EXIT_MESSAGE_QUEUED_PRIOR_RESCHEDULED = CL;
    public final static short WKAP_INSUFFICIENT                     = CM;
    public final static short IOASIZE_TOO_SMALL                     = CN;
    public final static short KEY_MODIFICATION                      = DA;
    public final static short SEGMENT_NOT_HELD                      = DJ;
    public final static short SEGMENT_DELETE_RULE                   = DX;
    public final static short DATABASE_ARITHMETIC_OVERFLOW          = FA;
    public final static short INVALID_REQUEST_FOR_SEGMENT           = FC;
    public final static short BMP_DEADLOCK                          = FD;
    public final static short FLD_CALL                              = FE;
    public final static short MSDB_FREE_SPACE                       = FF;
    public final static short FLD_CALL_BUFFER_SPACE                 = FG;
    public final static short DEDB_AREA_INACCESSIBLE                = FH;
    public final static short IO_AREA_INACCESSIBLE                  = FI;
    public final static short RANDOMIZING_ROUTINE_REQUEST           = FM;
    public final static short FLD_FIELD_NAME                        = FN;
    public final static short INVALID_HEXADECIMAL_OR_DECIMAL_DATA   = FP;
    public final static short TOTAL_BUFFER_ALLOCATION_EXCEEDED      = FR;
    public final static short DEDB_AREAS_FULL                       = FS;
    public final static short SSA_LIMIT_EXCEEDED                    = FT;
    public final static short VERIFY_OPERATION                      = FV;
    public final static short BMP_BUFFER_SPACE                      = FW;
    public final static short BACKWARD_ACCESS_VIOLATION             = FY;
    public final static short HIERARCHIC_BOUNDARY                   = GA;
    public final static short END_OF_DATA                           = GB;
    public final static short CROSSING_UOW_BOUNDARY                 = GC;
    public final static short UNQUALIFIED_INSERT                    = GD;
    public final static short SEGMENT_NOT_FOUND                     = GE;
    public final static short INVALID_SEGMENT_POINTER               = GG;
    public final static short DIFFERENT_SEGMENT_TYPE                = GK;
    public final static short INVALID_LOG_CODE                      = GL;
    public final static short PARENTAGE_NOT_ESTABLISHED             = GP;
    public final static short DUPLICATE_SEGMENT                     = II;
    public final static short SEGMENT_INSERT_RULE                   = IX;
    public final static short DUPLICATE_SEGMENT_LOAD                = LB;
    public final static short KEY_SEQUENCE                          = LC;
    public final static short PARENT_NOT_LOADED                     = LD;
    public final static short SIBLING_SEQUENCE                      = LE;
    public final static short RESERVED                              = MR;
    public final static short DATABASE_UNAVAILABLE                  = NA;
    public final static short SEGMENT_NOT_FOUND_BY_INDEX_MAINTENACE = NE;
    public final static short DUPLICATE_SEGMENT_SECONDARY_INDEX     = NI;
    public final static short LOG_DATASET_DD_MISSING                = NL;
    public final static short INDEX_MAINTENANCE_IO_ERROR            = NO;
    public final static short DATABASE_UNAVAILABLE_FOR_UPDATE       = NU;
    public final static short END_OF_MESSAGES                       = QC;
    public final static short END_OF_MESSAGE_SEGMENTS               = QD;
    public final static short CALL_SEQUENCE                         = QE;
    public final static short SEGMENT_LENGTH                        = QF;
    public final static short TERMINAL_SYMBOLIC_ERROR               = QH;
    public final static short UNMATCHED_TOKEN                       = RA;
    public final static short ROLS_UNSUPPORTED_PCB                  = RC;
    public final static short SEGMENT_REPLACE_RULE                  = RX;
    public final static short SETS_REQUEST_STORAGE_EXCEEDED         = SA;
    public final static short SETS_LEVELS_EXCEEDED                  = SB;
    public final static short SETS_UNSUPPORTED_PCB                  = SC;
    public final static short SYNC_FAILURE                          = SY;
    public final static short PSB_DIRECTORY                         = TA;
    public final static short PSB_ALREADY_SCHEDULED                 = TC;
    public final static short PSB_INITIALIZATION_ERROR              = TE;
    public final static short TERMINATE_UNSCHEDULED_PSB             = TG;
    public final static short DATABASE_ACCESS_WITH_UNSCHEDULED_PSB  = TH;
    public final static short INVALID_PATH_TO_SEGMENT               = TI;
    public final static short DLI_NOT_ACTIVE                        = TJ;
    public final static short SCHEDULING_INTENT_CONFLICT            = TL;
    public final static short INVALID_SDIB                          = TN;
    public final static short PATH_REPLACE_ERROR                    = TO;
    public final static short INVALID_PCB_NUMBER_OR_PROC_OPTIONS    = TP;
    public final static short XDLIPRE                               = TR;
    public final static short DATABASE_NOT_OPEN                     = TY;
    public final static short SEGMENT_EXCEEDS_64K                   = TZ;
    public final static short CHECKPOINT_WRITTEN_TO_UCF             = UC;
    public final static short PROGRAM_RESTARTED_UNDER_UCF           = UR;
    public final static short UCF_STOP                              = US;
    public final static short CHECKPOINT_AND_STOP                   = UX;
    public final static short VARIABLE_SEGMENT_LENGTH               = V1;
    public final static short INVALID_SEGMENT_LENGTH                = V2;
    public final static short INVALID_FIELD_LENGTH                  = V3;
    public final static short INVALID_VARIABLE_SEGMENTLENGTH        = V4;
    public final static short INVALID_OFFSET                        = V5;
    public final static short INVALID_CONCATENATED_KEY_LENGTH       = V6;
    public final static short INVALID_STATISTICS_AREA_LENGTH        = V7;
    public final static short FIRST_INSERT_TO_ALTERNATE_PCB_NOT_SPA = X2;
    public final static short INVALID_SPA                           = X3;
    public final static short INVALID_SPA_DESTINATION               = X4;
    public final static short MULTIPLE_SPAS_PERMESSAGE              = X5;
    public final static short INVALID_SPA_TRANSACTION_CODE          = X6;
    public final static short INVALID_SPA_LENGTH                    = X7;
    public final static short SPA_IO_ERROR                          = X8;
    public final static short INVALID_SPA_PASS                      = XA;
    public final static short INVALID_SPA_RESPOND                   = XB;
    public final static short INVALID_Z1_FIELD                      = XC;
    public final static short IMS_TERMINATING                       = XD;
    public final static short INSERT_SPA_TO_EXPRESS_PCB             = XE;
    public final static short INSERT_TO_SPA_NOT_ALTRESP             = XF;
    public final static short FIXED_LENGTH_SPA_ERROR                = XG;
    public final static short GSAM_ERROR                            = XX;

}
