package com.ibm.ims.dli;

/**
 * The <code>AIB</code> contains all the data attributes of the IMS application
 * interface block. The <code>AIB</code> contains useful information returned by
 * IMS after every DL/I call.
 * <p>
 * If the most recent DL/I call is a database call, the {@link AIB#getDBPCB()}
 * method returns the <code>DBPCB</code> object for that call and the
 * {@link AIB#getIOPCB()} method returns <code>null</code>.
 * <p>
 * If the most recent DL/I call is an IMS message queue call, the
 * {@link AIB#getIOPCB()} method returns the <code>IOPCB</code> object for that
 * call and the {@link AIB#getDBPCB()} method returns <code>null</code>.
 * 
 * @see DBPCB
 * 
 */
public interface AIB {

	/***************************************************************************
	 * Sub function code 8 bytes Resource name 8 Resource name2 8 Maximum output
	 * area length 4 Output area length used 4 Return code 4 Reason code 4 Error
	 * code Extension 4
	 **************************************************************************/

	/**
	 * Gets the subfunction code in the AIB
	 * 
	 * @return the subfunction code
	 */
	public String getSubFunctionCode();

	/**
	 * Sets the subfunction code in this AIB. This parameter should be a maximum
	 * of eight characters. If greater, it will be truncated to eight
	 * characters.
	 * 
	 * @param subFunctionCode
	 *            the subfunction code.
	 */
	public void setSubFunctionCode(String subFunctionCode);

	/**
	 * Gets the resource name (PCB name) in this AIB.
	 * 
	 * @return the resource name.
	 */
	public String getResourceName();

	/**
	 * Sets the resource name (PCB name) in this AIB. This parameter should be a
	 * maximum of eight characters. If greater, it will be truncated to eight
	 * characters.
	 * 
	 * @param resourceName
	 *            the resource name.
	 */
	public void setResourceName(String resourceName);

	/**
	 * Gets the four-character ID of ODBA startup table DFSxxxx0, where xxxx is
	 * the four-character ID.
	 * 
	 * @return the four-character ID
	 */
	public String getResourceName2();

	/**
	 * Sets the four-character ID of ODBA startup table DFSxxxx0, where xxxx is
	 * the four-character ID. If a paramter value of less than four characters
	 * is given, it will be blank padded.
	 * 
	 * @param resourceName
	 *            the four-character ID
	 */
	public void setResourceName2(String resourceName);

	/**
	 * Gets the maximum output area length in this AIB.
	 * 
	 * @return the output area length used.
	 */
	public int getOALength();

	/**
	 * Sets the maximum output area length in this AIB.
	 * 
	 * @param maxLength
	 *            the maximum output area length
	 */
	public void setOALength(int maxLength);

	/**
	 * Gets the output area length used in this AIB.
	 * 
	 * @return the output area length used.
	 */
	public int getOAUse();

	/**
	 * Gets the return code produced by the last DLI call using this AIB.
	 * 
	 * @return the return code of the last DLI call
	 */
	public int getReturnCode();

	/**
	 * Gets the return code produced by the last DLI call using this AIB as a
	 * hexadecimal string.
	 * 
	 * @return the return code of the last DLI call
	 */
	public String getReturnCodeHex();

	/**
	 * Gets the reason code produced by the last DLI call using this AIB.
	 * 
	 * @return the reason code of the last DLI call.
	 */
	public int getReasonCode();

	/**
	 * Gets the reason code produced by the last DLI call using this AIB as a
	 * hexadecimal string.
	 * 
	 * @return the reason code of the last DLI call
	 */
	public String getReasonCodeHex();

	/**
	 * Gets the error code extension produced by the last DLI call through this
	 * AIB.
	 * 
	 * @return the error code extension of the last DLI call
	 */
	public int getErrorCodeExtension();

	/**
	 * Gets the DB PCB (database PCB) referenced by this AIB
	 * 
	 * @return the DBPCB
	 */
	public DBPCB getDBPCB();

	/**
	 * Gets the IO PCB referenced by this AIB
	 * 
	 * @return the IOPCB object
	 */
	public IOPCB getIOPCB();

	/**
	 * Gets the GSAM PCB (GSAM database PCB) referenced by this AIB
	 * 
	 * @return the GPCB
	 */
	public GPCB getGPCB();
	
	/**
	 * Gets the Resource Address 1 produced by the last DLI call using this AIB.
	 * 
	 * @return the Resource Address 1 in the AIB.
	 */
	public int getResourceAddress1();
}
