package com.ibm.ims.dli;

/**
 * Object that represents the output from an Authorization (AUTH) call.
 * 
 */
public interface AUTHCallResult extends DLICallResult {

	/**
	 * Retrieves a 2-byte field that contains the RACF return codes. This value
	 * is stored in the FEEDBACK field in the I/O area.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_authcall.htm"
	 * target="_blank">AUTH call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the RACF return codes.
	 */
	public short getFeedback();

	/**
	 * Retrieves a 2-byte field that contains the return code from the user
	 * exits if they were used. This value is stored in the EXITRC field in the
	 * I/O area.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_authcall.htm"
	 * target="_blank">AUTH call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the return code from the user exits.
	 */
	public short getExitReturnCode();

	/**
	 * Retrieves a 2-byte field that contains the hexadecimal status code
	 * indicating installation data status. This value is stored in the STATUS
	 * field in the I/O area.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_authcall.htm"
	 * target="_blank">AUTH call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the status code indicating installation data status.
	 */
	public short getStatusCode();

	/**
	 * Retrieves a <code>String</code> that contains installation data from ACEE
	 * or a user security exit.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_authcall.htm"
	 * target="_blank">AUTH call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return installation data from the RACF Accessor Environment Element
	 *         (ACEE) or a user security exit. null if no user data returned by
	 *         IMS.
	 * @throws DLIException
	 *             if EBCDIC encoding (Cp1047) is not supported
	 */
	public String getUserData() throws DLIException;

}
