package com.ibm.ims.dli;

/**
 * A <code>DBArray</code> object contains a value for each element of the
 * structured type that it represents. The Array structured type is used when a
 * database description (DBD) contains a field with <code>DATATYPE=ARRAY</code>.
 *
 * @see DBStruct
 */
public interface DBArray {

	/**
	 * Retrieves the contents of the ARRAY value designated by this
	 * <code>DBArray</code> object in the form of an array in the Java
	 * programming language.
	 * 
	 * @return an array in the Java programming language that contains the
	 *         ordered elements of the ARRAY value designated by this
	 *         <code>DBArray</code> object
	 * @throws DLIException
	 *             if an error occurs processing
	 */
	public Object getArray() throws DLIException;

	/**
	 * Retrieves a slice of the ARRAY value designated by this
	 * <code>DBArray</code> object, beginning with the specified
	 * <code>index</code> and containing up to <code>count</code> successive
	 * elements of the array.
	 * 
	 * @param index
	 *            the array index of the first element to retrieve; the first
	 *            element is at index 1
	 * @param count
	 *            the number of successive SQL array elements to retrieve
	 * @return an array containing up to <code>count</code> consecutive elements
	 *         of the array, beginning with element <code>index</code>
	 * @throws DLIException
	 *             if an error occurs processing
	 */
	public Object getArray(long index, int count) throws DLIException;

	/**
	 * Retrieves the type name of the array type that this <code>DBArray</code>
	 * object represents.
	 * 
	 * @return the fully-qualified type name in the format pcbName.
	 *         segmentName.arrayName
	 * @throws DLIException
	 *             if an error occurs
	 */
	public String getBaseTypeName() throws DLIException;

	/**
	 * Retrieves the elements of the array encapsulated in a
	 * <code>DBArrayElementSet</code> object.
	 * 
	 * @return the elements of the array
	 * @throws DLIException
	 *             if an error occurs
	 * @see DBArrayElementSet
	 */
	public DBArrayElementSet getElements() throws DLIException;

	// /**
	// * Sets the elements of this array with the specified
	// <code>DBArrayElementSet</code> object.
	// *
	// * @param elements the elements to set
	// * @throws DLIException if an error occurs
	// */
	// public void setElements(DBArrayElementSet elements) throws DLIException;

	/**
	 * This method frees the <code>DBArray</code> object and releases the
	 * resources that it holds. The object is invalid once the free method is
	 * called.
	 * 
	 * After free has been called, any attempt to invoke a method other than
	 * free will result in a <code>DLIException</code> being thrown. If
	 * <code>free</code> is called multiple times, the subsequent calls to free
	 * are treated as a no-op.
	 * 
	 * @throws DLIException
	 *             if an error occurs
	 */
	public void free() throws DLIException;
}
