package com.ibm.ims.dli;

/**
 * This exception is thrown to indicate an error has occurred during DL/I call
 * processing.
 */
public class DLIException extends Exception {

	private AIB aib = null;

	private static final long serialVersionUID = 2952030920615524072L;

	public DLIException() {
		super();
	}

	/**
	 * Creates an exception with the specified error message.
	 *
	 * @param message
	 *            the error message
	 */
	public DLIException(String message) {
		super(message);
	}

	/**
	 * Creates an exception with the specified error message, and a causing
	 * exception.
	 *
	 * @param message
	 *            the error message
	 * @param cause
	 *            The causing message
	 */
	public DLIException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates an exception with a causing exception.
	 *
	 * @param cause
	 *            The causing message
	 */
	public DLIException(Throwable cause) {
		super(cause);
	}

	/**
	 * Retrieves the AIB information that was returned when the failing DL/I
	 * call was processed. A <code>null</code> return value means that there is
	 * no relevant AIB information for the type of error that occurred.
	 * 
	 * @return a AIB object.
	 */
	public AIB getAib() {
		return aib;
	}

	protected void setAib(AIB aib) {
		this.aib = aib;
	}

}
