package com.ibm.ims.dli;

/**
 * The DLIWarning class provides information when data was lost due to a type
 * conversion. For example, a field in an input message or database segment is
 * defined as a <code>DLITypeInfo.DOUBLE</code> and retrieved as a Java short.
 * Warnings are silently chained to the object whose method caused it to be
 * reported.
 */
public class DLIWarning extends Exception {

	private static final long serialVersionUID = 1L;
	private DLIWarning next = null;

	/**
	 * Constructs a DLIWarning.
	 * 
	 * @param message
	 *            The message for the warning
	 */
	public DLIWarning(String message) {
		super(message);
	}

	/**
	 * Get the warning chained to this one.
	 *
	 * @return the next DLIWarning in the chain, null if none
	 */
	public DLIWarning getNextWarning() {
		return this.next;
	}

	/**
	 * Sets the next warning in the chain
	 * 
	 * @param warning
	 *            The warning to be put in the chain
	 */
	public void setNextWarning(DLIWarning warning) {

		DLIWarning theEnd = this;
		while (theEnd.next != null) {
			theEnd = theEnd.next;
		}

		theEnd.next = warning;
	}
}
