package com.ibm.ims.dli;

/**
 * Object that represents the output from an Issue Command (ICMD) call.
 *
 */
public interface ICMDCallResult extends DLICallResult {

	/**
	 * Retrieves the first command response segment after an ICMD call is
	 * issued.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_icmdcalltm.htm"
	 * target="_blank">ICMD call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return the command response segment.
	 */
	public String getResponseSegment();
}
