package com.ibm.ims.dli;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

/**
 * <code>IMSConnectionSpec</code> is used by an application to pass connection
 * request specific properties to the <code>PSBFactory</code>. For a code
 * example of how to create IMSConnectionSpec, see {@link PSB}.
 * 
 * @see IMSConnectionSpecFactory#createIMSConnectionSpec()
 */
public interface IMSConnectionSpec {

	/***************************************************************************
	 * Constant indicating the driver is pure Java and implements the network
	 * protocol for the data source.
	 * 
	 */
	public static final int DRIVER_TYPE_4 = 4;

	/**
	 * Constant indicating the driver is local.
	 */
	public static final int DRIVER_TYPE_2 = 2;

	/**
	 * Sets the name of the IMS datastore to access.
	 * <p>
	 * For Type-4 connectivity: The datastore parameter must match either the
	 * name of the datastore defined to ODBM or be blank. The datastore name is
	 * defined in the ODBM CSLDCxxx PROCLIB member using either the DATASTORE
	 * (NAME=name) or ALIAS (NAME=aliasname) parameter. If the datastore value
	 * is left blank (or not supplied), IMS Connect will connect to any
	 * available instance of ODBM as it is assumed all datastores defined to
	 * ODBM are data shared.
	 * <p>
	 * For Type-2 connectivity: The datastore parameter refers to the 1 to 4
	 * character identifier of the DRA startup table member. The member name
	 * structure is DFSxxxx0 where xxxx is the member identifier. Example:
	 * datastore parameter = SYS1 refers to DRA startup table member DFSSYS10
	 * The ODBA startup table is a user created member that contains the IMS
	 * subsystem connection properties which includes the IMS subsystem id. This
	 * is not required to be set for the Java Dependent Region runtime.
	 * 
	 * @param datastore
	 *            IMS datastore name
	 */
	public void setDatastoreName(String datastore);

	/**
	 * Sets the name or IP address of the datastore server (IMS Connect). You
	 * can provide either the host name (for example, dev123.svl.ibm.com) or the
	 * IP address (for example, 192.166.0.2).
	 * <p>
	 * NOTE: Only used for Type-4 connectivity. Do not apply for Type-2.
	 * 
	 * @param datastoreServer
	 *            name or IP address of the datastore server (IMS Connect)
	 */
	public void setDatastoreServer(String datastoreServer);

	/**
	 * Sets the port number to be used to communicate with IMS Connect. The port
	 * number is defined using the DRDAPORT parameter on the ODACCESS statement
	 * in the integrated IMS Connect configuration PROCLIB member.
	 * 
	 * <p>
	 * By default, the port number is 8888.
	 * 
	 * <p>
	 * NOTE: Only used for Type-4 connectivity. Do not apply for Type-2.
	 * 
	 * @param portNumber
	 *            port number
	 */
	public void setPortNumber(int portNumber);

	/**
	 * Sets the loginTimeout. This value represents the number of seconds to
	 * wait for TCP/IP socket creation or server response before timing out.
	 * <p>
	 * By default, the value is 0, which means the driver will wait indefinitely
	 * for a socket connection creation or server response.
	 * <p>
	 * NOTE: Only used for Type-4 connectivity
	 * 
	 * @param loginTimeout
	 */
	public void setLoginTimeout(int loginTimeout);

	/**
	 * Sets the location of the database metadata representing the target IMS
	 * database. The metadata URL is the fully qualified name of the Java
	 * metadata class generated by the IMS Explorer for Development.
	 * 
	 * The URL must begin with class://
	 * 
	 * @param metadataURL
	 *            metadata url
	 * 
	 * @deprecated {@link #setDatabaseName(String)}
	 */
	public void setMetadataURL(String metadataURL);

	/**
	 * Sets the user name
	 * 
	 * @param user
	 *            User name.
	 */
	public void setUser(String user);

	/**
	 * Sets the user password.
	 * 
	 * @param password
	 *            User password value
	 */
	public void setPassword(String password);

	/**
	 * Sets SSL encryption on or off.
	 * 
	 * @param sslConnection
	 *            Set to <code>true</code> to turn SSL encryption on.
	 */
	public void setSSLConnection(boolean sslConnection);

	/**
	 * Sets SSL trust store path.
	 * 
	 * @param trustStoreLocation
	 *            Fully qualified path to the key store file containing the
	 *            trusted certificate from IMS Connect.
	 */
	public void setSSLTrustStoreLocation(String trustStoreLocation);

	/**
	 * Sets SSL trust store password.
	 * 
	 * @param trustStorePassword
	 *            Password set for the key store file using keytool.
	 */
	public void setSSLTrustStorePassword(String trustStorePassword);
	
	/**
	 * Sets SSL trust manager algorithm.
	 * 
	 * @param trustMgrAlgorithm
	 */
	public void setSSLTrustMgrAlgorithm(String trustMgrAlgorithm);

	/**
	 * Sets SSL key store path.
	 * 
	 * @param keyStoreLocation
	 *            Fully qualified path to the key store file containing the
	 *            client's certificate and private key.
	 */
	public void setSSLKeyStoreLocation(String keyStoreLocation);

	/**
	 * Sets SSL key store password.
	 * 
	 * @param keyStorePassword
	 *            Password set for the key store file using keytool.
	 */
	public void setSSLKeyStorePassword(String keyStorePassword);

	/**
	 * Sets SSL key manager algorithm.
	 * 
	 * @param keyMgrAlgorithm
	 */
	public void setSSLKeyMgrAlgorithm(String keyMgrAlgorithm);

	/**
	 * Sets SSL key store type.
	 * 
	 * @param keyStoreType
	 *            Valid values include "JKS" or "PKCS12".
	 */
	public void setKeyStoreType(String keyStoreType);

	/**
	 * Sets secure socket protocol type.
	 * 
	 * @param secureSocketProtocol
	 *            Valid values include "SSL", "SSLv3", "TLSv1.1", "TLSv1.2",
	 *            etc.
	 */
	public void setSecureSocketProtocol(String secureSocketProtocol);

	/**
	 * Sets the type of driver to use to connect to the database. Type-4:
	 * Distributed access over TCP/IP. Type-2: Local access (no TCP/IP).
	 * 
	 * @param driverType
	 *            Supported values are
	 *            <code>IMSConnectionSpec.DRIVER_TYPE_4</code> and
	 *            <code>IMSConnectionSpec.DRIVER_TYPE_2</code>
	 */
	public void setDriverType(int driverType);

	/**
	 * Sets the name of the target IMS database to be accessed.
	 * 
	 * If the metadata repository is the IMS catalog then the database name is
	 * the name of the PSB (program specification block) containing the
	 * database(s) to be accessed.
	 * 
	 * If the metadata repository is the file system then the database name is
	 * the fully qualified name of the Java metadata class generated by the IMS
	 * Explorer for Development. In this case the name must begin with class://
	 * 
	 * @param databaseName
	 *            database name
	 */
	public void setDatabaseName(String databaseName);

	/**
	 * Sets a transient PSB name that will replace the PSB name in the database
	 * view class.
	 * 
	 * @param transientPSBName
	 *            PSB name to override the database view's PSB
	 */
	public void setTransientPSBName(String transientPSBName);
    /**
     * When a PSB is allocated, this property will indicate that the driver should automatically 
     * issue an INIT STATUS GROUPA or INIT STATUS GROUPB if a value of 'A' or 'B' is provided. The default will not  
     * issue an INIT STATUS GROUP call.
     * 
     * @param initStatusGroup
     */
	
	public void setInitStatusGroup(String initStatusGroup);
	
	/**
	 * Sets the option to handle and process data if data was returned when a GE
	 * status code is encountered. This property only applies to batchRetrieve or
	 * JDBC SELECT operations. 
	 * 
	 * When set to true, a retrieve call's Path or ResultSet will receive the data returned from a GE status code. 
	 * When set to false (default), no data will be returned when a call receives a GE status code.
	 * 
	 * @param returnResultOnStatusCodeGE
	 */
	public void setReturnResultOnStatusCodeGE(boolean returnResultOnStatusCodeGE);
	
	/**
	 * Sets the option to treat incomplete field data as null. Incomplete field data
	 * is defined as a field's full length extending past the length of the segment.
	 * When set to true, incomplete field data is treated as a null. When set to
	 * false, the fields incomplete data will be returned. True is the default
	 * option. This property only applies to Binary and String datatypes.
	 * 
	 *  @param treatIncompleteFieldAsNull
	 */
	public void setTreatIncompleteFieldAsNull(boolean treatIncompleteFieldAsNull);
}
