package com.ibm.ims.dli;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

/**
 * <code>IMSConnectionSpecFactory</code> is used by the application component to
 * create an <code>IMSConnectionSpec</code> instance. <blockquote>
 * 
 * <pre>
 * IMSConnectionSpec connSpec = IMSConnectionSpecFactory.createIMSConnectionSpec();
 * </pre>
 * 
 * </blockquote>
 */
public class IMSConnectionSpecFactory {

	/**
	 * Creates an <code>IMSConnectionSpec</code> object that is used to pass
	 * connection related properties to the <code>PSBFactory</code>.
	 * 
	 * @return <code>IMSConnectionSpec</code> object
	 * 
	 */
	public static IMSConnectionSpec createIMSConnectionSpec() {
		return new IMSConnectionSpecImpl();
	}
}
