package com.ibm.ims.dli;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */

/**
 * <p>
 * The <code>IOPCB</code> interface contains all the data attributes of the
 * IOPCB communication block from the most recent DL/I call. The
 * <code>IOPCB</code> contains the two character status code returned by IMS
 * after the last DL/I call. The <code>IOPCB</code> object reference is
 * retrieved using the AIB class.
 * 
 * @see AIB
 */
public interface IOPCB {
	static final int IOPCB_SIZE = 60;

	/**
	 * Gets the logical terminal name.
	 * 
	 * @return the logical terminal name.
	 */
	public String getLogicalTerminalName();

	/**
	 * Returns the IMS status code of the last DLI call.
	 * 
	 * @return the status code.
	 * @see IMSStatusCodes
	 */
	public short getStatusCode();

	/**
	 * Returns the IMS status code of the last DL/I call as a character string.
	 * 
	 * @return the status code.
	 */
	public String getStatusCodeChars();

	/**
	 * Returns the local date from the last DLI call using this IOPCB. The local
	 * date is in the format yyddd.
	 * 
	 * @return The IOPCB's local date.
	 */
	public String getLocalDate();

	/**
	 * Returns the local time from the last DLI call using this IOPCB. The local
	 * time is in the format hhmmsst.
	 * 
	 * @return The IOPCB's local time.
	 */
	public String getLocalTime();

	public String getCurrentDate();

	public String getCurrentTime();

	public byte[] getUTCOffset();

	public byte getUserIDIndicator();

	/**
	 * Returns the input message sequence number from the last DL/I call using
	 * this IOPCB.
	 * 
	 * @return The IOPCB's input message sequence number.
	 */
	public int getInputMessageSequenceNumber();

	/**
	 * Returns the message output descriptor (MOD) name from the last DL/I call
	 * using this IOPCB. The maximum length is 8 characters.
	 * 
	 * @return The IOPCB's message output descriptor (MOD) name.
	 */
	public String getMODName();

	/**
	 * Returns the userid from the last DL/I call using this IOPCB. The maximum
	 * length is 8 characters.
	 * 
	 * @return The IOPCB's userid.
	 */
	public String getUserid();

	/**
	 * Returns the group name from the last DL/I call using this IOPCB. The
	 * maximum length is 8 characters.
	 * 
	 * @return The IOPCB's group name.
	 */
	public String getGroupName();
}
