package com.ibm.ims.dli;

/**
 * The <code>LocalTransaction</code> interface provides support for transactions
 * that are managed internal to IMS, and do not require an external transaction
 * manager. A <code>LocalTransaction</code> is used if an application wants to
 * manage its own transaction semantics or have local transaction semantics.
 * <P>
 * A <code>LocalTransaction</code> is scoped to a particular <code>PSB</code>
 * instance.
 * 
 */
public interface LocalTransaction {

	/**
	 * Begin a local transaction
	 * 
	 * @exception NotSupportedException
	 *                if the operation is not supported
	 * @exception DLIException
	 *                generic exception if the operation fails
	 */
	public void begin() throws NotSupportedException, DLIException;

	/**
	 * Commit a local transaction
	 * 
	 * @exception NotSupportedException
	 *                if the operation is not supported
	 * @exception DLIException
	 *                generic exception if the operation fails
	 */
	public void commit() throws NotSupportedException, DLIException;

	/**
	 * Rollback a local transaction
	 * 
	 * @exception NotSupportedException
	 *                if the operation is not supported
	 * @exception DLIException
	 *                generic exception if the operation fails
	 */
	public void rollback() throws NotSupportedException, DLIException;
}
