package com.ibm.ims.dli;

/**
 * Object that represents the output from a qualified Position (POS) call.
 * <p>
 * For more details about the fields returned by the <code>POSCallReturn</code>
 * methods, see the topic <a href=
 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_poscall.htm"
 * target="_blank">POS call</a> in the IMS Application Programming APIs
 * reference documentation.
 *
 */
public interface POSCallReturn extends DLICallResult {

	/**
	 * Retrieves the area name field.
	 * 
	 * @return the field value.
	 */
	public String getField1();

	/**
	 * Retrieves the sequential dependent next to allocate CI field.
	 * 
	 * @return the field value.
	 */
	public String getField2();

	/**
	 * Retrieves the local sequential dependent next segment field.
	 * 
	 * @return the field value.
	 */
	public String getField3();

	/**
	 * Retrieves the unused CIs in sequential dependent part field.
	 * 
	 * @return the field value.
	 */
	public String getField4();

	/**
	 * Retrieves the unused CIs in independent overflow part field.
	 * 
	 * @return the field value.
	 */
	public String getField5();

	/**
	 * Retrieves the sequential dependent segment time stamp field.
	 * 
	 * @return the field value.
	 */
	public String getField6();

	/**
	 * Retrieves the sequential dependent High Water Mark (HWM) field.
	 * 
	 * @return the field value.
	 */
	public String getField7();

	/**
	 * Retrieves the highest committed SDEP segment field.
	 * 
	 * @return the field value.
	 */
	public String getField8();

	/**
	 * Retrieves the logical begin time stamp field.
	 * 
	 * @return the field value.
	 */
	public String getField9();
}
