package com.ibm.ims.dli;

/* (c) Copyright International Business Machines Corporation 2008. All rights reserved. */
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class is a factory for creating <code>PSB</code> objects.
 * <code>PSB</code> objects are used to obtain a handle to a particular
 * <code>PCB</code>. The <code>PCB</code> is then used to access the database
 * represented by the <code>PCB</code>. <blockquote>
 * 
 * <pre>
 * PSB psb = PSBFactory.createPSB(imsConnectionSpec);
 * </pre>
 * 
 * </blockquote>
 * 
 * @see PCB
 * @see PSB#getPCB(String)
 * @see IMSConnectionSpec
 */
public class PSBFactory {

	private static final Logger logger = Logger.getLogger("com.ibm.ims.db.opendb.dli");

	/**
	 * Creates a <code>PSB</code> object that contains a collection of database
	 * <code>PCB</code> objects.
	 * 
	 * @see IMSConnectionSpec
	 * @param imsConnSpec
	 *            the <code>IMSConnectionSpec</code> containing the connection
	 *            properties
	 * @return the <code>PSB</code> object
	 * @throws DLIException
	 *             if an error occurs during processing
	 * @throws CloneNotSupportedException
	 */
	public static PSB createPSB(IMSConnectionSpec imsConnSpec) throws DLIException {
		if (logger.isLoggable(Level.FINER)) {
			logger.entering("PSBFactory", "createPSB(IMSConnectionSpec)");
		}

		// Pass in false for isManaged (third) argument because the createPSB
		// method above
		// will never be driven from a managed runtime like WAS
		PSB psb = PSBInternalFactory.createPSB(imsConnSpec, true, false, null);

		if (logger.isLoggable(Level.FINER)) {
			logger.exiting("PSBFactory", "createPSB(IMSConnectionSpec)");
		}

		return psb;
	}

}
