package com.ibm.ims.dli;

/**
 * An object that can be used to get information about the types and properties
 * of the fields in a <code>Path</code> object.
 *
 */
public interface PathMetaData {

	/**
	 * Returns the number of fields in this <code>Path</code> object.
	 * 
	 * @return the number of fields
	 */
	public int getFieldCount();

	/**
	 * Gets the name of the specified field.
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return field name
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public String getFieldName(int field) throws DLIException;

	/**
	 * Gets the DLI type of the specified field.
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return DLI type from com.ibm.ims.dli.types.Types
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public int getFieldType(int field) throws DLIException;

	/**
	 * Gets the specified field size of the designated field. For numeric data,
	 * this is the maximum precision. For character data, this is the length in
	 * characters. For date and time datatypes, this is the length in characters
	 * of the String representation of the field (assuming the maximum allowed
	 * precision of the fractional seconds component).
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return precision
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public int getPrecision(int field) throws DLIException;

	/**
	 * Gets the number of digits to the right of the decimal point in the
	 * specified field. For data types where the scale is not applicable, this
	 * method returns zero.
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return scale
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public int getScale(int field) throws DLIException;

	/**
	 * Gets the segment name of the specified field.
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return segment name
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public String getSegmentName(int field) throws DLIException;

	/**
	 * Indicates whether the designated field can be used in a segment search
	 * argument (SSA).
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return <code>true</code> if so; <code>false</code> otherwise
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public boolean isSearchable(int field) throws DLIException;

	/**
	 * Indicates whether values in the designated field are signed numbers.
	 * 
	 * @param field
	 *            the first field is 1, the second is 2, ...
	 * @return <code>true</code> if so; <code>false</code> otherwise
	 * @throws DLIException
	 *             if a processing error occurs
	 */
	public boolean isSigned(int field) throws DLIException;

}
