package com.ibm.ims.dli;

/**
 * A <code>PathSet</code> is only used for batch retrieval and represents a
 * collection of <code>Path</code> objects, each containing the segment data
 * returned from a database retrieve call.
 * <p>
 * A <code>PathSet</code> is typically used when the application expects more
 * than one record to be retrieved in the IMS DL/I database call.
 * <p>
 * For a code example of how to use this interface, refer to the related
 * <code>PCB</code> method in the Javadoc.
 * 
 * @see PCB#batchRetrieve(SSAList)
 */
public interface PathSet {

	/**
	 * Returns <code>true</code> if the set has more <code>Path</code> elements.
	 * 
	 * @return <code>true</code> if the set has more <code>Path</code> elements.
	 * @throws DLIException
	 *             if an error occurs during processing
	 */
	public boolean hasNext() throws DLIException;

	/**
	 * Returns the next <code>Path</code> element in the set. Calling this
	 * method repeatedly until the {@link #hasNext()} method returns
	 * <code>false</code> will return each element in the underlying set exactly
	 * once.
	 * 
	 * @return the next <code>Path</code> element in the set
	 * @throws DLIException
	 *             if an error occurs during processing
	 */
	public Path next() throws DLIException;

	/**
	 * Copies the next <code>Path</code> element in the set into the
	 * <code>Path</code> object passed in.
	 * 
	 * @param path
	 *            the element into which the next <code>Path</code> element in
	 *            the set is copied
	 * @throws DLIException
	 *             if an error occurs during processing
	 */
	public void next(Path path) throws DLIException;

	/**
	 * Returns <code>true</code> if the next call is a DLI call.
	 * 
	 * @return <code>true</code> if the next call is a DLI call.
	 */
	public boolean nextCallDLI();

}
