package com.ibm.ims.dli;

import java.util.Hashtable;

import com.ibm.ims.dli.DLICallProperty.Property;

/**
 * Object that represents the output from a SET Options (SETO) call.
 * 
 */
public interface SETOCallResult extends DLICallResult {

	/**
	 * Retrieves error information about the options list used in the SETO call.
	 * The error information is stored in the feedback_area output parameter.
	 * The feedback data includes the option keyword found to be in error and a
	 * 4-byte EBCDIC code in parentheses that indicates the reason for the
	 * error. Multiple errors are separated by commas.
	 * <p>
	 * For more details about the values returned by this method, see the topic
	 * <a href=
	 * "http://www.ibm.com/support/knowledgecenter/SSEPH2_14.1.0/com.ibm.ims14.doc.apr/ims_setocall.htm"
	 * target="_blank">SETO call</a> in the IMS Application Programming APIs
	 * reference documentation.
	 * 
	 * @return error information about the options list.
	 */
	public Hashtable<Property, String> getFeedback();
}
